/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.mkgmap.combiners;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import uk.me.parabola.imgfmt.Utils;
import uk.me.parabola.mkgmap.CommandArgs;
import uk.me.parabola.mkgmap.Version;
import uk.me.parabola.mkgmap.combiners.Combiner;
import uk.me.parabola.mkgmap.combiners.FileInfo;

public class NsisBuilder
implements Combiner {
    private String baseFilename;
    private String nsisFilename;
    private String licenseFilename;
    private String outputDir;
    private String familyName;
    private String id;
    private int productId;
    private boolean hasIndex;
    private boolean hasTyp;
    private final List<String> mapList = new ArrayList<String>();
    private String typName;

    @Override
    public void init(CommandArgs args) {
        int familyId = args.get("family-id", 6324);
        this.productId = args.get("product-id", 1);
        this.baseFilename = args.get("overview-mapname", "osmmap");
        this.familyName = args.get("family-name", "OSM map");
        String tmpId = Integer.toHexString(0x10000 | familyId);
        this.id = tmpId.substring(3, 5) + tmpId.substring(1, 3);
        this.nsisFilename = this.baseFilename + ".nsi";
        this.licenseFilename = this.baseFilename + "_license.txt";
        this.outputDir = args.getOutputDir();
        this.hasIndex = args.exists("index");
    }

    @Override
    public void onMapEnd(FileInfo info) {
        switch (info.getKind()) {
            case IMG_KIND: {
                this.mapList.add(info.getMapname());
                break;
            }
            case TYP_KIND: {
                this.hasTyp = true;
                File typFile = new File(info.getFilename());
                this.typName = typFile.getName();
                break;
            }
            case MDR_KIND: {
                this.hasIndex = true;
                break;
            }
        }
    }

    @Override
    public void onFinish() {
        this.writeNsisFile();
        this.writeLicenceFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeNsisFile() {
        InputStream inStream;
        try {
            inStream = new FileInputStream("resources/installer_template.nsi");
        }
        catch (Exception ex) {
            inStream = null;
        }
        if (inStream == null) {
            inStream = this.getClass().getResourceAsStream("/installer/installer_template.nsi");
        }
        if (inStream == null) {
            System.err.println("Could not find the installer template.");
            return;
        }
        FileWriter w = null;
        try {
            String strLine;
            BufferedReader br = new BufferedReader(new InputStreamReader(inStream));
            w = new FileWriter(Utils.joinPath(this.outputDir, this.nsisFilename));
            PrintWriter pw = new PrintWriter(w);
            while ((strLine = br.readLine()) != null) {
                if (strLine.contains("INSERT_DEFINES_HERE")) {
                    this.writeDefines(pw);
                    continue;
                }
                if (strLine.contains("INSERT_REGBIN_HERE")) {
                    this.writeRegBin(pw);
                    continue;
                }
                if (strLine.contains("INSERT_ADDED_FILES_HERE")) {
                    this.writeAddedFiles(pw);
                    continue;
                }
                if (strLine.contains("INSERT_REMOVED_FILES_HERE")) {
                    this.writeRemovedFiles(pw);
                    continue;
                }
                pw.format(Locale.ROOT, strLine + "\n", new Object[0]);
            }
            Utils.closeFile(w);
        }
        catch (IOException e) {
            System.err.println("Could not write NSIS file");
        }
        finally {
            Utils.closeFile(w);
        }
    }

    private void writeDefines(PrintWriter pw) {
        pw.format(Locale.ROOT, "!define DEFAULT_DIR \"C:\\Garmin\\Maps\\%s\"\n", this.familyName);
        pw.format(Locale.ROOT, "!define INSTALLER_DESCRIPTION \"%s\"\n", this.familyName);
        pw.format(Locale.ROOT, "!define INSTALLER_NAME \"%s\"\n", this.familyName);
        pw.format(Locale.ROOT, "!define MAPNAME \"%s\"\n", this.baseFilename);
        pw.format(Locale.ROOT, "!define PRODUCT_ID \"%s\"\n", this.productId);
        pw.format(Locale.ROOT, "!define REG_KEY \"%s\"\n", this.familyName);
        if (this.hasIndex) {
            pw.format(Locale.ROOT, "!define INDEX\n", new Object[0]);
        }
        if (this.hasTyp) {
            pw.format(Locale.ROOT, "!define TYPNAME \"%s\"\n", this.typName);
        }
    }

    private void writeRegBin(PrintWriter pw) {
        pw.format(Locale.ROOT, "  WriteRegBin HKLM \"SOFTWARE\\Garmin\\MapSource\\Families\\${REG_KEY}\" \"ID\" %s\n", this.id);
    }

    private void writeAddedFiles(PrintWriter pw) {
        pw.format(Locale.ROOT, "  File \"${MAPNAME}.img\"\n", new Object[0]);
        if (this.hasIndex) {
            pw.format(Locale.ROOT, "  File \"${MAPNAME}_mdr.img\"\n", new Object[0]);
            pw.format(Locale.ROOT, "  File \"${MAPNAME}.mdx\"\n", new Object[0]);
        }
        if (this.hasTyp) {
            pw.format(Locale.ROOT, "  File \"%s\"\n", this.typName);
        }
        pw.format(Locale.ROOT, "  File \"${MAPNAME}.tdb\"\n", new Object[0]);
        for (String file : this.mapList) {
            pw.format(Locale.ROOT, "  File \"%s.img\"\n", file);
        }
    }

    private void writeRemovedFiles(PrintWriter pw) {
        pw.format(Locale.ROOT, "  Delete \"$INSTDIR\\${MAPNAME}.img\"\n", new Object[0]);
        if (this.hasIndex) {
            pw.format(Locale.ROOT, "  Delete \"$INSTDIR\\${MAPNAME}_mdr.img\"\n", new Object[0]);
            pw.format(Locale.ROOT, "  Delete \"$INSTDIR\\${MAPNAME}.mdx\"\n", new Object[0]);
        }
        if (this.hasTyp) {
            pw.format(Locale.ROOT, "  Delete \"$INSTDIR\\%s\"\n", this.typName);
        }
        pw.format(Locale.ROOT, "  Delete \"$INSTDIR\\${MAPNAME}.tdb\"\n", new Object[0]);
        for (String file : this.mapList) {
            pw.format(Locale.ROOT, "  Delete \"$INSTDIR\\%s.img\"\n", file);
        }
        pw.format(Locale.ROOT, "  Delete \"$INSTDIR\\Uninstall.exe\"\n", new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeLicenceFile() {
        InputStream inStream;
        try {
            inStream = new FileInputStream("resources/license_template.txt");
        }
        catch (Exception ex) {
            inStream = null;
        }
        if (inStream == null) {
            inStream = this.getClass().getResourceAsStream("/installer/license_template.txt");
        }
        if (inStream == null) {
            System.err.println("Could not find the license template.");
            return;
        }
        FileWriter w = null;
        try {
            String strLine;
            BufferedReader br = new BufferedReader(new InputStreamReader(inStream));
            w = new FileWriter(Utils.joinPath(this.outputDir, this.licenseFilename));
            PrintWriter pw = new PrintWriter(w);
            while ((strLine = br.readLine()) != null) {
                pw.format(Locale.ROOT, strLine + "\n", new Object[0]);
            }
            pw.format(Locale.ROOT, "Map created with mkgmap-r" + Version.VERSION + "\n", new Object[0]);
            Utils.closeFile(w);
        }
        catch (IOException e) {
            System.err.println("Could not write license file");
        }
        finally {
            Utils.closeFile(w);
        }
    }
}

