/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.mkgmap.filters;

import java.util.ArrayList;
import java.util.List;
import uk.me.parabola.imgfmt.app.Coord;
import uk.me.parabola.log.Logger;
import uk.me.parabola.mkgmap.filters.FilterConfig;
import uk.me.parabola.mkgmap.filters.MapFilter;
import uk.me.parabola.mkgmap.filters.MapFilterChain;
import uk.me.parabola.mkgmap.general.MapElement;
import uk.me.parabola.mkgmap.general.MapLine;
import uk.me.parabola.mkgmap.general.MapRoad;
import uk.me.parabola.mkgmap.general.MapShape;

public class LineSizeSplitterFilter
implements MapFilter {
    private static final Logger log = Logger.getLogger(LineSizeSplitterFilter.class);
    private static final int MAX_SIZE = Short.MAX_VALUE;
    private int maxSize;

    @Override
    public void init(FilterConfig config) {
        int shift = config.getShift();
        if (shift > 15) {
            shift = 16;
        }
        this.maxSize = Math.min(0xFFFFFF, Math.max(Short.MAX_VALUE << shift, 32768));
    }

    public static double testDims(int height, int width) {
        return (double)Math.max(Math.abs(height), Math.abs(width)) / 32767.0;
    }

    @Override
    public void doFilter(MapElement element, MapFilterChain next) {
        assert (!(element instanceof MapShape) && element instanceof MapLine);
        MapLine line = (MapLine)element;
        if (line.getBounds().getMaxDimension() < this.maxSize) {
            next.doFilter(element);
            return;
        }
        if (line instanceof MapRoad) {
            MapRoad road = (MapRoad)line;
            log.error((Object)("Way " + road.getRoadDef() + " has a max dimension of " + line.getBounds().getMaxDimension() + " and is about to be split (routing will be broken)"));
        }
        List<Coord> points = LineSizeSplitterFilter.splitLinesToMaxSize(line.getPoints(), this.maxSize - 10);
        log.debug((Object)"line bbox too big, splitting");
        MapLine l = line.copy();
        ArrayList<Coord> coords = new ArrayList<Coord>();
        boolean first = true;
        class Dim {
            private int minLat;
            private int minLong;
            private int maxLat;
            private int maxLong;

            Dim() {
                this.reset();
            }

            private void reset() {
                this.minLat = Integer.MAX_VALUE;
                this.minLong = Integer.MAX_VALUE;
                this.maxLat = Integer.MIN_VALUE;
                this.maxLong = Integer.MIN_VALUE;
            }

            private void addToBounds(Coord co) {
                int lon;
                int lat = co.getLatitude();
                if (lat < this.minLat) {
                    this.minLat = lat;
                }
                if (lat > this.maxLat) {
                    this.maxLat = lat;
                }
                if ((lon = co.getLongitude()) < this.minLong) {
                    this.minLong = lon;
                }
                if (lon > this.maxLong) {
                    this.maxLong = lon;
                }
            }

            private int getMaxDim() {
                int dx = this.maxLong - this.minLong;
                int dy = this.maxLat - this.minLat;
                return Math.max(dx, dy);
            }
        }
        Dim dim = new Dim();
        Coord prev = null;
        for (Coord co : points) {
            dim.addToBounds(co);
            if (dim.getMaxDim() > this.maxSize) {
                if (first) {
                    log.debug((Object)"bigness saving first part");
                } else {
                    log.debug((Object)"bigness saving next part");
                }
                l.setPoints(coords);
                next.doFilter(l);
                l = line.copy();
                first = false;
                dim.reset();
                coords = new ArrayList();
                coords.add(prev);
                dim.addToBounds(prev);
                dim.addToBounds(co);
            }
            coords.add(co);
            prev = co;
        }
        assert (coords.size() > 1);
        if (coords.size() > 1) {
            log.debug((Object)"bigness saving a final part");
            l.setPoints(coords);
            next.doFilter(l);
        }
    }

    private static List<Coord> splitLinesToMaxSize(List<Coord> coords, int maxSize) {
        ArrayList<Coord> testedCoords = new ArrayList<Coord>(coords);
        int posToTest = coords.size() - 2;
        while (posToTest >= 0) {
            Coord p1 = (Coord)testedCoords.get(posToTest);
            Coord p2 = (Coord)testedCoords.get(posToTest + 1);
            int width = Math.abs(p1.getLongitude() - p2.getLongitude());
            int height = Math.abs(p1.getLatitude() - p2.getLatitude());
            if (width > maxSize || height > maxSize) {
                testedCoords.add(posToTest + 1, p1.makeBetweenPoint(p2, 0.5));
                ++posToTest;
                continue;
            }
            --posToTest;
        }
        return testedCoords;
    }
}

