/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.mkgmap.general;

import java.util.ArrayList;
import java.util.List;
import uk.me.parabola.imgfmt.app.Area;
import uk.me.parabola.imgfmt.app.Coord;

public class LineClipper {
    public static List<List<Coord>> clip(Area a, List<Coord> coords) {
        if (a == null || a.allInsideBoundary(coords)) {
            return null;
        }
        class LineCollector {
            private final List<List<Coord>> ret = new ArrayList<List<Coord>>(4);
            private List<Coord> currentLine;
            private Coord last;

            LineCollector() {
            }

            public void add(Coord[] segment) {
                if (segment == null) {
                    this.currentLine = null;
                } else {
                    if (this.currentLine == null || !segment[0].equals(this.last)) {
                        this.currentLine = new ArrayList<Coord>(5);
                        this.currentLine.add(segment[0]);
                        this.currentLine.add(segment[1]);
                        this.ret.add(this.currentLine);
                    } else {
                        this.currentLine.add(segment[1]);
                    }
                    this.last = segment[1];
                }
            }
        }
        LineCollector seg = new LineCollector();
        for (int i = 0; i <= coords.size() - 2; ++i) {
            Coord[] pair = new Coord[]{coords.get(i), coords.get(i + 1)};
            if (pair[0].highPrecEquals(pair[1])) continue;
            Coord[] clippedPair = LineClipper.clip(a, pair);
            seg.add(clippedPair);
        }
        if (seg.ret.size() >= 2 && coords.get(0) == coords.get(coords.size() - 1)) {
            List firstSeg = (List)seg.ret.get(0);
            List lastSeg = (List)seg.ret.get(seg.ret.size() - 1);
            if (((Coord)firstSeg.get(0)).equals(lastSeg.get(lastSeg.size() - 1))) {
                lastSeg.addAll(firstSeg.subList(1, firstSeg.size()));
                seg.ret.remove(0);
            }
        }
        return seg.ret;
    }

    public static Coord[] clip(Area a, Coord[] ends) {
        return LineClipper.clip(a, ends, false);
    }

    public static Coord[] clip(Area a, Coord[] ends, boolean nullIfInside) {
        assert (ends.length == 2);
        if (a.insideBoundary(ends[0]) && a.insideBoundary(ends[1])) {
            return nullIfInside ? null : ends;
        }
        Coord lowerLeft = new Coord(a.getMinLat(), a.getMinLong());
        Coord upperRight = new Coord(a.getMaxLat(), a.getMaxLong());
        int x0 = ends[0].getHighPrecLon();
        int y0 = ends[0].getHighPrecLat();
        int x1 = ends[1].getHighPrecLon();
        int y1 = ends[1].getHighPrecLat();
        int dx = x1 - x0;
        int dy = y1 - y0;
        double[] t = new double[]{0.0, 1.0};
        int p = -dx;
        int q = -(lowerLeft.getHighPrecLon() - x0);
        boolean scrap = LineClipper.checkSide(t, p, q);
        if (scrap) {
            return null;
        }
        p = dx;
        q = upperRight.getHighPrecLon() - x0;
        scrap = LineClipper.checkSide(t, p, q);
        if (scrap) {
            return null;
        }
        p = -dy;
        q = -(lowerLeft.getHighPrecLat() - y0);
        scrap = LineClipper.checkSide(t, p, q);
        if (scrap) {
            return null;
        }
        p = dy;
        q = upperRight.getHighPrecLat() - y0;
        scrap = LineClipper.checkSide(t, p, q);
        if (scrap) {
            return null;
        }
        assert (t[0] >= 0.0);
        assert (t[1] <= 1.0);
        Coord orig0 = ends[0];
        Coord orig1 = ends[1];
        if (ends[0].getOnBoundary()) {
            assert (a.onBoundary(ends[0])) : "Point marked as boundary node at " + ends[0].toString() + " not on boundary of [" + a.getMinLat() + ", " + a.getMinLong() + ", " + a.getMaxLat() + ", " + a.getMaxLong() + "]";
        } else if (t[0] > 0.0) {
            Coord new0 = Coord.makeHighPrecCoord(LineClipper.calcCoord(y0, dy, t[0]), LineClipper.calcCoord(x0, dx, t[0]));
            assert (a.onBoundary(new0)) : "New boundary point at " + new0.toString() + " not on boundary of [" + a.getMinLat() + ", " + a.getMinLong() + ", " + a.getMaxLat() + ", " + a.getMaxLong() + "]";
            if (!new0.highPrecEquals(orig0)) {
                ends[0] = new0;
            }
            ends[0].setOnBoundary(true);
        } else if (a.onBoundary(ends[0])) {
            ends[0].setOnBoundary(true);
        }
        if (ends[1].getOnBoundary()) {
            assert (a.onBoundary(ends[1])) : "Point marked as boundary node at " + ends[1].toString() + " not on boundary of [" + a.getMinLat() + ", " + a.getMinLong() + ", " + a.getMaxLat() + ", " + a.getMaxLong() + "]";
        } else if (t[1] < 1.0) {
            Coord new1 = Coord.makeHighPrecCoord(LineClipper.calcCoord(y0, dy, t[1]), LineClipper.calcCoord(x0, dx, t[1]));
            assert (a.onBoundary(new1)) : "New boundary point at " + new1.toString() + " not on boundary of [" + a.getMinLat() + ", " + a.getMinLong() + ", " + a.getMaxLat() + ", " + a.getMaxLong() + "]";
            if (!new1.highPrecEquals(orig1)) {
                ends[1] = new1;
            }
            ends[1].setOnBoundary(true);
        } else if (a.onBoundary(ends[1])) {
            ends[1].setOnBoundary(true);
        }
        if (t[0] >= t[1] || ends[0].highPrecEquals(ends[1])) {
            return null;
        }
        return ends;
    }

    private static int calcCoord(int base, int delta, double t) {
        double d = 0.5;
        double y = (double)base + t * (double)delta;
        return (int)(y >= 0.0 ? y + d : y - d);
    }

    private static boolean checkSide(double[] t, double p, double q) {
        double r = q / p;
        if (p == 0.0) {
            if (q < 0.0) {
                return true;
            }
        } else if (p < 0.0) {
            if (r > t[1]) {
                return true;
            }
            if (r > t[0]) {
                t[0] = r;
            }
        } else {
            if (r < t[0]) {
                return true;
            }
            if (r < t[1]) {
                t[1] = r;
            }
        }
        return false;
    }
}

