/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.mkgmap.osmstyle.actions;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import uk.me.parabola.imgfmt.app.net.AccessTagsAndBits;
import uk.me.parabola.mkgmap.osmstyle.actions.Action;
import uk.me.parabola.mkgmap.osmstyle.actions.ActionList;
import uk.me.parabola.mkgmap.osmstyle.actions.AddAccessAction;
import uk.me.parabola.mkgmap.osmstyle.actions.AddLabelAction;
import uk.me.parabola.mkgmap.osmstyle.actions.AddTagAction;
import uk.me.parabola.mkgmap.osmstyle.actions.DeleteAction;
import uk.me.parabola.mkgmap.osmstyle.actions.DeleteAllTagsAction;
import uk.me.parabola.mkgmap.osmstyle.actions.EchoAction;
import uk.me.parabola.mkgmap.osmstyle.actions.EchoTagsAction;
import uk.me.parabola.mkgmap.osmstyle.actions.NameAction;
import uk.me.parabola.mkgmap.osmstyle.actions.RenameAction;
import uk.me.parabola.mkgmap.osmstyle.actions.SubAction;
import uk.me.parabola.mkgmap.osmstyle.actions.ValueBuildedAction;
import uk.me.parabola.mkgmap.scan.SyntaxException;
import uk.me.parabola.mkgmap.scan.Token;
import uk.me.parabola.mkgmap.scan.TokenScanner;

public class ActionReader {
    private final TokenScanner scanner;
    private final Set<String> usedTags = new HashSet<String>();

    public ActionReader(TokenScanner scanner) {
        this.scanner = scanner;
    }

    public ActionList readActions() {
        ArrayList<Action> actions = new ArrayList<Action>();
        HashSet<String> changeableTags = new HashSet<String>();
        this.scanner.skipSpace();
        if (!this.scanner.checkToken("{")) {
            return new ActionList(actions, changeableTags);
        }
        this.scanner.nextToken();
        while (this.inAction()) {
            Token tok = this.scanner.nextToken();
            if (tok.isValue(";")) continue;
            String cmd = tok.getValue();
            if ("set".equals(cmd)) {
                actions.add(this.readTagValue(true, changeableTags));
            } else if ("add".equals(cmd)) {
                actions.add(this.readTagValue(false, changeableTags));
            } else if ("setaccess".equals(cmd)) {
                actions.add(this.readAccessValue(true, changeableTags));
            } else if ("addaccess".equals(cmd)) {
                actions.add(this.readAccessValue(false, changeableTags));
            } else if ("apply".equals(cmd)) {
                actions.add(this.readAllCmd(false));
            } else if ("apply_once".equals(cmd)) {
                actions.add(this.readAllCmd(true));
            } else if ("name".equals(cmd)) {
                actions.add(this.readValueBuilder(new NameAction()));
                changeableTags.add("mkgmap:label:1");
            } else if ("addlabel".equals(cmd)) {
                actions.add(this.readValueBuilder(new AddLabelAction()));
                for (int labelNo = 1; labelNo <= 4; ++labelNo) {
                    changeableTags.add("mkgmap:label:" + labelNo);
                }
            } else if ("delete".equals(cmd)) {
                String tag = this.scanner.nextWord();
                actions.add(new DeleteAction(tag));
            } else if ("deletealltags".equals(cmd)) {
                actions.add(new DeleteAllTagsAction());
            } else if ("rename".equals(cmd)) {
                String from = this.scanner.nextWord();
                String to = this.scanner.nextWord();
                RenameAction act = new RenameAction(from, to);
                actions.add(act);
                changeableTags.add(to);
                this.usedTags.add(from);
            } else if ("echo".equals(cmd)) {
                String str = this.scanner.nextWord();
                actions.add(new EchoAction(str));
            } else if ("echotags".equals(cmd)) {
                String str = this.scanner.nextWord();
                actions.add(new EchoTagsAction(str));
            } else {
                throw new SyntaxException(this.scanner, "Unrecognised command '" + cmd + '\'');
            }
            this.scanner.skipSpace();
        }
        if (this.scanner.checkToken("}")) {
            this.scanner.nextToken();
        }
        this.scanner.skipSpace();
        return new ActionList(actions, changeableTags);
    }

    private Action readAllCmd(boolean once) {
        String role = null;
        if (this.scanner.checkToken("role")) {
            this.scanner.nextToken();
            String eq = this.scanner.nextValue();
            if (!"=".equals(eq)) {
                throw new SyntaxException(this.scanner, "Expecting '=' after role keyword");
            }
            role = this.scanner.nextWord();
        }
        SubAction subAction = new SubAction(role, once);
        List<Action> actionList = this.readActions().getList();
        for (Action a : actionList) {
            subAction.add(a);
        }
        return subAction;
    }

    private Action readValueBuilder(ValueBuildedAction action) {
        while (this.inActionCmd()) {
            if (this.scanner.checkToken("|")) {
                this.scanner.nextToken();
                continue;
            }
            String val = this.scanner.nextWord();
            action.add(val);
        }
        this.usedTags.addAll(action.getUsedTags());
        return action;
    }

    private AddTagAction readTagValue(boolean modify, Set<String> changeableTags) {
        String key = this.scanner.nextWord();
        if (!this.scanner.checkToken("=")) {
            throw new SyntaxException(this.scanner, "Expecting tag=value");
        }
        this.scanner.nextToken();
        ValueBuildedAction action = null;
        while (this.inActionCmd()) {
            String val = this.scanner.nextWord();
            if (action == null) {
                action = new AddTagAction(key, val, modify);
            } else {
                action.add(val);
            }
            if (val.contains("$")) {
                changeableTags.add(key);
            } else {
                changeableTags.add(key + "=" + val);
            }
            if (!this.scanner.checkToken("|")) continue;
            this.scanner.nextToken();
        }
        if (action != null) {
            this.usedTags.addAll(action.getUsedTags());
        }
        return action;
    }

    private AddAccessAction readAccessValue(boolean modify, Set<String> changeableTags) {
        ValueBuildedAction action = null;
        while (this.inActionCmd()) {
            String val = this.scanner.nextWord();
            if (action == null) {
                action = new AddAccessAction(val, modify);
            } else {
                action.add(val);
            }
            if (val.contains("$")) {
                for (String accessTag : AccessTagsAndBits.ACCESS_TAGS.keySet()) {
                    changeableTags.add(accessTag);
                }
            } else {
                for (String accessTag : AccessTagsAndBits.ACCESS_TAGS.keySet()) {
                    changeableTags.add(accessTag + "=" + val);
                }
            }
            if (!this.scanner.checkToken("|")) continue;
            this.scanner.nextToken();
        }
        if (action != null) {
            this.usedTags.addAll(action.getUsedTags());
        }
        return action;
    }

    private boolean inActionCmd() {
        boolean end = this.scanner.checkToken(";");
        return this.inAction() && !end;
    }

    private boolean inAction() {
        return !this.scanner.isEndOfFile() && !this.scanner.checkToken("}");
    }

    public Set<String> getUsedTags() {
        return this.usedTags;
    }
}

