/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.mkgmap.osmstyle.eval;

import uk.me.parabola.imgfmt.ExitException;
import uk.me.parabola.mkgmap.osmstyle.eval.AndOp;
import uk.me.parabola.mkgmap.osmstyle.eval.CloseOp;
import uk.me.parabola.mkgmap.osmstyle.eval.EqualsOp;
import uk.me.parabola.mkgmap.osmstyle.eval.GTEOp;
import uk.me.parabola.mkgmap.osmstyle.eval.GTOp;
import uk.me.parabola.mkgmap.osmstyle.eval.LTEOp;
import uk.me.parabola.mkgmap.osmstyle.eval.LTOp;
import uk.me.parabola.mkgmap.osmstyle.eval.NodeType;
import uk.me.parabola.mkgmap.osmstyle.eval.NotEqualOp;
import uk.me.parabola.mkgmap.osmstyle.eval.NotOp;
import uk.me.parabola.mkgmap.osmstyle.eval.Op;
import uk.me.parabola.mkgmap.osmstyle.eval.OpenOp;
import uk.me.parabola.mkgmap.osmstyle.eval.OrOp;
import uk.me.parabola.mkgmap.osmstyle.eval.RegexOp;
import uk.me.parabola.mkgmap.reader.osm.Element;
import uk.me.parabola.mkgmap.scan.SyntaxException;

public abstract class AbstractOp
implements Op {
    protected Op first;
    private NodeType type;
    protected boolean lastRes;
    protected int lastCachedId = -1;

    public static Op createOp(String value) {
        AbstractOp op;
        char c = value.charAt(0);
        switch (c) {
            case '=': {
                op = new EqualsOp();
                break;
            }
            case '&': {
                if (value.length() > 1) {
                    throw new SyntaxException(String.format("Use '&' instead of '%s'", value));
                }
                op = new AndOp();
                break;
            }
            case '|': {
                if (value.length() > 1) {
                    throw new SyntaxException(String.format("Use '|' instead of '%s'", value));
                }
                op = new OrOp();
                break;
            }
            case '~': {
                op = new RegexOp();
                break;
            }
            case '(': {
                op = new OpenOp();
                break;
            }
            case ')': {
                op = new CloseOp();
                break;
            }
            case '>': {
                if (value.equals(">=")) {
                    op = new GTEOp();
                    break;
                }
                op = new GTOp();
                break;
            }
            case '<': {
                if (value.equals("<=")) {
                    op = new LTEOp();
                    break;
                }
                op = new LTOp();
                break;
            }
            case '!': {
                if (value.equals("!=")) {
                    op = new NotEqualOp();
                    break;
                }
                op = new NotOp();
                break;
            }
            default: {
                throw new SyntaxException("Unrecognised operation " + c);
            }
        }
        return op;
    }

    @Override
    public boolean eval(int cacheId, Element el) {
        if (this.lastCachedId != cacheId) {
            if (this.lastCachedId > cacheId) {
                throw new ExitException("fatal error: cache id invalid");
            }
            this.lastRes = this.eval(el);
            this.lastCachedId = cacheId;
        }
        return this.lastRes;
    }

    @Override
    public boolean hasHigherPriority(Op other) {
        return this.priority() > other.priority();
    }

    @Override
    public Op getFirst() {
        return this.first;
    }

    @Override
    public void setFirst(Op first) {
        this.first = first;
        this.lastCachedId = -1;
    }

    @Override
    public Op getSecond() {
        return null;
    }

    @Override
    public NodeType getType() {
        return this.type;
    }

    protected void setType(NodeType type) {
        this.type = type;
    }

    @Override
    public String value(Element el) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getKeyValue() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isType(NodeType value) {
        return this.type == value;
    }

    public void resetCache() {
        this.lastCachedId = -1;
    }
}

