/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.mkgmap.osmstyle.eval;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import uk.me.parabola.mkgmap.scan.SyntaxException;

public class UnitConversions {
    private static final Pattern CODE_RE = Pattern.compile("(.*)=>(.*)");
    private static final Map<UnitType, Map<String, Double>> CONVERSIONS = new HashMap<UnitType, Map<String, Double>>();
    private static final Map<String, Double> LENGTH_FACTORS = new HashMap<String, Double>();
    private static final Map<String, Double> SPEED_FACTORS = new HashMap<String, Double>();
    private final UnitType unitType;
    private final String target;
    private final double defaultFactor;

    public static UnitConversions createConversion(String code) {
        Matcher matcher = CODE_RE.matcher(code);
        if (!matcher.matches()) {
            throw new SyntaxException(String.format("Unrecognised unit conversion: '%s'", code));
        }
        String source = matcher.group(1);
        String target = matcher.group(2);
        return new UnitConversions(source, target);
    }

    private UnitConversions(String source, String target) {
        this.target = target;
        UnitType type = UnitConversions.getType(source);
        if (type != null && type == UnitConversions.getType(target)) {
            this.unitType = type;
            this.defaultFactor = this.getConversion(source);
        } else {
            this.unitType = null;
            this.defaultFactor = 1.0;
        }
    }

    public Double convertFactor(String source) {
        if (source == null) {
            return this.defaultFactor;
        }
        if (this.unitType == null) {
            return null;
        }
        return this.getConversion(source);
    }

    public double convertFrom(String source) {
        assert (source != null && this.unitType != null);
        if (CONVERSIONS.get((Object)this.unitType).containsKey(source)) {
            return this.getConversion(source);
        }
        return 0.0;
    }

    public boolean isValid() {
        return this.unitType != null;
    }

    private static UnitType getType(String source) {
        for (UnitType t : UnitType.values()) {
            Map<String, Double> map = CONVERSIONS.get((Object)t);
            for (String unit : map.keySet()) {
                if (!unit.equals(source)) continue;
                return t;
            }
        }
        return null;
    }

    private double getFactor(String unit) {
        assert (this.isValid());
        Double d = CONVERSIONS.get((Object)this.unitType).get(unit);
        return d == null ? 0.0 : d;
    }

    private Double getConversion(String source) {
        Double in = UnitConversions.getInFactor(this.unitType, source);
        if (in == null) {
            return null;
        }
        double out = UnitConversions.getOutFactor(this.unitType, this.target);
        return in * out;
    }

    private static Double getInFactor(UnitType type, String source) {
        if (source.isEmpty()) {
            return 1.0;
        }
        Map<String, Double> map = CONVERSIONS.get((Object)type);
        assert (map != null);
        return map.get(source);
    }

    private static double getOutFactor(UnitType type, String target) {
        return 1.0 / UnitConversions.getInFactor(type, target);
    }

    public double getDefaultFactor() {
        return this.defaultFactor;
    }

    static {
        Map<String, Double> m = LENGTH_FACTORS;
        m.put("m", 1.0);
        m.put("km", 1000.0);
        m.put("ft", 0.3048);
        m.put("mi", 1609.344);
        CONVERSIONS.put(UnitType.LENGTH, LENGTH_FACTORS);
        m = SPEED_FACTORS;
        m.put("kmh", 1.0);
        m.put("km/h", 1.0);
        m.put("kmph", 1.0);
        m.put("mph", 1.60934);
        m.put("knots", 1.852);
        CONVERSIONS.put(UnitType.SPEED, SPEED_FACTORS);
    }

    public static enum UnitType {
        LENGTH,
        SPEED;

    }
}

