/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.mkgmap.osmstyle.function;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import java.util.Map;
import uk.me.parabola.imgfmt.app.Coord;
import uk.me.parabola.log.Logger;
import uk.me.parabola.mkgmap.osmstyle.function.CachedFunction;
import uk.me.parabola.mkgmap.reader.osm.Element;
import uk.me.parabola.mkgmap.reader.osm.Relation;
import uk.me.parabola.mkgmap.reader.osm.Way;
import uk.me.parabola.mkgmap.scan.SyntaxException;

public class LengthFunction
extends CachedFunction {
    private static final Logger log = Logger.getLogger(LengthFunction.class);
    private final DecimalFormat nf = new DecimalFormat("0.0#####################", DecimalFormatSymbols.getInstance(Locale.US));

    public LengthFunction() {
        super(null);
    }

    @Override
    protected String calcImpl(Element el) {
        double length = this.calcLength(el);
        return this.nf.format(length);
    }

    private double calcLength(Element el) {
        if (el instanceof Way) {
            Way w = (Way)el;
            double length = 0.0;
            Coord prevC = null;
            for (Coord c : w.getPoints()) {
                if (prevC != null) {
                    length += prevC.distance(c);
                }
                prevC = c;
            }
            return length;
        }
        if (el instanceof Relation) {
            Relation rel = (Relation)el;
            double length = 0.0;
            for (Map.Entry<String, Element> relElem : rel.getElements()) {
                if (!(relElem.getValue() instanceof Way) && !(relElem.getValue() instanceof Relation)) continue;
                if (rel == relElem.getValue()) {
                    log.error((Object)("Relation " + rel.getId() + " contains itself as element. This is not supported."));
                    continue;
                }
                length += this.calcLength(relElem.getValue());
            }
            return length;
        }
        throw new SyntaxException("length() cannot calculate elements of type " + el.getClass().getName());
    }

    @Override
    public String getName() {
        return "length";
    }

    @Override
    public boolean supportsWay() {
        return true;
    }

    @Override
    public boolean supportsRelation() {
        return true;
    }
}

