/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.mkgmap.reader;

import java.util.ArrayList;
import java.util.List;
import uk.me.parabola.imgfmt.app.Area;
import uk.me.parabola.imgfmt.app.Coord;
import uk.me.parabola.imgfmt.app.net.RoadNetwork;
import uk.me.parabola.imgfmt.app.trergn.Overview;
import uk.me.parabola.mkgmap.general.LoadableMapDataSource;
import uk.me.parabola.mkgmap.general.MapDataSource;
import uk.me.parabola.mkgmap.general.MapDetails;
import uk.me.parabola.mkgmap.general.MapLine;
import uk.me.parabola.mkgmap.general.MapPoint;
import uk.me.parabola.mkgmap.general.MapShape;
import uk.me.parabola.mkgmap.reader.dem.DEM;
import uk.me.parabola.util.Configurable;
import uk.me.parabola.util.EnhancedProperties;

public abstract class MapperBasedMapDataSource
implements MapDataSource,
Configurable {
    protected final MapDetails mapper = new MapDetails();
    private EnhancedProperties configProps;
    private boolean driveOnLeft;

    @Override
    public Area getBounds() {
        return this.mapper.getBounds();
    }

    @Override
    public List<MapLine> getLines() {
        return this.mapper.getLines();
    }

    @Override
    public List<MapShape> getShapes() {
        return this.mapper.getShapes();
    }

    @Override
    public RoadNetwork getRoadNetwork() {
        return this.mapper.getRoadNetwork();
    }

    @Override
    public List<Overview> getOverviews() {
        return this.mapper.getOverviews();
    }

    @Override
    public List<MapPoint> getPoints() {
        return this.mapper.getPoints();
    }

    @Override
    public void config(EnhancedProperties props) {
        this.configProps = props;
        this.mapper.config(props);
    }

    protected EnhancedProperties getConfig() {
        return this.configProps;
    }

    public MapDetails getMapper() {
        return this.mapper;
    }

    protected void addBackground() {
        this.addBackground(false);
    }

    protected void addBackground(boolean mapHasPolygon4B) {
        if (!mapHasPolygon4B && !this.getConfig().getProperty("transparent", false)) {
            MapShape background = new MapShape();
            background.setPoints(this.mapper.getBounds().toCoords());
            background.setType(75);
            background.setMinResolution(0);
            this.mapper.addShape(background);
        }
        if (this.getConfig().getProperty("contours", false)) {
            DEM.createContours((LoadableMapDataSource)((Object)this), this.getConfig());
        }
    }

    public void addBoundaryLine(Area area, int type, String name) {
        ArrayList<Coord> coords = new ArrayList<Coord>();
        coords.add(new Coord(area.getMinLat(), area.getMinLong()));
        coords.add(new Coord(area.getMinLat(), area.getMaxLong()));
        coords.add(new Coord(area.getMaxLat(), area.getMaxLong()));
        coords.add(new Coord(area.getMaxLat(), area.getMinLong()));
        coords.add(new Coord(area.getMinLat() + 1, area.getMinLong()));
        MapLine boundary = new MapLine();
        boundary.setType(type);
        if (name != null) {
            boundary.setName(name);
        }
        boundary.setMinResolution(0);
        boundary.setPoints(coords);
        this.mapper.addLine(boundary);
    }

    public Boolean getDriveOnLeft() {
        return this.driveOnLeft;
    }

    protected void setDriveOnLeft(boolean b) {
        this.driveOnLeft = b;
    }
}

