/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.mkgmap.reader.dem;

import java.io.File;
import java.io.FileNotFoundException;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import uk.me.parabola.imgfmt.ExitException;
import uk.me.parabola.imgfmt.FileSystemParam;
import uk.me.parabola.imgfmt.FormatException;
import uk.me.parabola.imgfmt.Utils;
import uk.me.parabola.imgfmt.app.Area;
import uk.me.parabola.imgfmt.app.Coord;
import uk.me.parabola.imgfmt.app.map.Map;
import uk.me.parabola.log.Logger;
import uk.me.parabola.mkgmap.build.MapBuilder;
import uk.me.parabola.mkgmap.general.LevelInfo;
import uk.me.parabola.mkgmap.general.LoadableMapDataSource;
import uk.me.parabola.mkgmap.osmstyle.StyleImpl;
import uk.me.parabola.mkgmap.osmstyle.StyledConverter;
import uk.me.parabola.mkgmap.reader.MapperBasedMapDataSource;
import uk.me.parabola.mkgmap.reader.dem.Brent;
import uk.me.parabola.mkgmap.reader.osm.Style;
import uk.me.parabola.mkgmap.reader.osm.Way;
import uk.me.parabola.mkgmap.srt.SrtTextReader;
import uk.me.parabola.util.EnhancedProperties;

public abstract class DEM {
    private static final Logger log = Logger.getLogger(DEM.class);
    private static final double epsilon = 1.0E-9;
    protected static final double delta = 1.5;
    private static final int maxPoints = 200000;
    private static final double minDist = 15.0;
    private static final double maxDist = 21.0;
    protected static int M;
    protected static int N;
    protected static double res;
    private static int id;
    protected int lat;
    protected int lon;
    private int lastXi = -1;
    private int lastYi = -1;
    private static final int[][] bcInv;
    private static int lastId;
    private static double lastX;
    private static double lastY;
    private static final int[][] off0;
    private static final int[][] off1;
    private static final int[] brd;
    private static final int[] rev;
    private static final int[][] mov;
    private final double[][] bc = new double[4][4];
    private final double[] bc_y = new double[4];
    private final double[] bc_y1 = new double[4];
    private final double[] bc_y2 = new double[4];
    private final double[] bc_y12 = new double[4];
    private final double[] bc_Coeff = new double[16];
    private final double[] bc_x = new double[16];

    protected abstract double ele(int var1, int var2);

    protected abstract void read(int var1, int var2, int var3, int var4);

    public static void createContours(LoadableMapDataSource mapData, EnhancedProperties config) {
        DEM data;
        Area bounds = mapData.getBounds();
        double minLat = Utils.toDegrees(bounds.getMinLat());
        double minLon = Utils.toDegrees(bounds.getMinLong());
        double maxLat = Utils.toDegrees(bounds.getMaxLat());
        double maxLon = Utils.toDegrees(bounds.getMaxLong());
        System.out.printf("bounds: %f %f %f %f\n", minLat, minLon, maxLat, maxLon);
        String demType = config.getProperty("dem-type", "SRTM");
        try {
            Class<?> demClass;
            String dataPath;
            switch (demType) {
                case "ASTER": {
                    dataPath = config.getProperty("dem-path", "ASTER");
                    demClass = Class.forName("uk.me.parabola.mkgmap.reader.dem.optional.GeoTiffDEM$ASTER");
                    break;
                }
                case "CGIAR": {
                    dataPath = config.getProperty("dem-path", "CGIAR");
                    demClass = Class.forName("uk.me.parabola.mkgmap.reader.dem.optional.GeoTiffDEM$CGIAR");
                    break;
                }
                default: {
                    dataPath = config.getProperty("dem-path", "SRTM");
                    demClass = Class.forName("uk.me.parabola.mkgmap.reader.dem.HGTDEM");
                }
            }
            Constructor<?> constructor = demClass.getConstructor(String.class, Double.TYPE, Double.TYPE, Double.TYPE, Double.TYPE);
            data = (DEM)constructor.newInstance(dataPath, minLat, minLon, maxLat, maxLon);
        }
        catch (Exception ex) {
            throw new ExitException("failed to create DEM", ex);
        }
        DEM dEM = data;
        dEM.getClass();
        Isolines lines = dEM.new Isolines(data, minLat, minLon, maxLat, maxLon);
        int increment = config.getProperty("dem-increment", 10);
        double minHeight = lines.getMinHeight();
        double maxHeight = lines.getMaxHeight();
        int maxLevels = config.getProperty("dem-maxlevels", 100);
        while ((maxHeight - minHeight) / (double)increment > (double)maxLevels) {
            increment *= 2;
        }
        Style style = StyleImpl.readStyle(config);
        LoadableMapDataSource dest = mapData;
        if (config.getProperty("dem-separate-img", false)) {
            dest = new DEMMapDataSource(mapData, config);
        }
        StyledConverter converter = new StyledConverter(style, ((MapperBasedMapDataSource)((Object)dest)).getMapper(), config);
        int level = 0;
        while ((double)level < maxHeight) {
            if (!((double)level < minHeight)) {
                lines.addLevel(level);
                for (Isolines.Isoline line : lines.isolines) {
                    Way way = new Way(id--, line.points);
                    way.addTag("contour", "elevation");
                    way.addTag("ele", String.format("%d", (int)line.level));
                    converter.convertWay(way);
                }
                lines.isolines.clear();
            }
            level += increment;
        }
        if (config.getProperty("dem-separate-img", false)) {
            MapBuilder builder = new MapBuilder();
            builder.config(config);
            String DEFAULT_DIR = ".";
            String fileOutputDir = config.getProperty("output-dir", DEFAULT_DIR);
            File outputDir = new File(fileOutputDir);
            if (!outputDir.exists()) {
                System.out.println("Output directory not found. Creating directory '" + fileOutputDir + "'");
                if (!outputDir.mkdirs()) {
                    System.err.println("Unable to create output directory! Using default directory instead");
                    fileOutputDir = DEFAULT_DIR;
                }
            } else if (!outputDir.isDirectory()) {
                System.err.println("The --output-dir parameter must specify a directory. The parameter is being ignored, writing to default directory instead.");
                fileOutputDir = DEFAULT_DIR;
            }
            FileSystemParam params = new FileSystemParam();
            params.setMapDescription("contour lines");
            long mapName = Integer.valueOf(config.getProperty("mapname", "63240000")).intValue();
            try {
                String mapname = String.format("%08d", mapName + 10000000L);
                Map map = Map.createMap(mapname, fileOutputDir, params, mapname, SrtTextReader.sortForCodepage(1252));
                builder.makeMap(map, dest);
                map.close();
            }
            catch (Exception ex) {
                throw new ExitException("could not open " + mapName, ex);
            }
        }
    }

    private void recalculateCoefficients(int xi, int yi) {
        int i;
        double v00 = this.ele(xi, yi);
        double v0p = this.ele(xi, yi + 1);
        double vpp = this.ele(xi + 1, yi + 1);
        double vp0 = this.ele(xi + 1, yi);
        double vm0 = this.ele(xi - 1, yi);
        double v0m = this.ele(xi, yi - 1);
        double vmp = this.ele(xi - 1, yi + 1);
        double vpm = this.ele(xi + 1, yi - 1);
        double vmm = this.ele(xi - 1, yi - 1);
        double vmP = this.ele(xi + 2, yi - 1);
        double vPm = this.ele(xi - 1, yi + 2);
        double vP0 = this.ele(xi + 2, yi);
        double v0P = this.ele(xi, yi + 2);
        double vPp = this.ele(xi + 2, yi + 1);
        double vpP = this.ele(xi + 1, yi + 2);
        double vPP = this.ele(xi + 2, yi + 2);
        this.bc_y[0] = v00;
        this.bc_y[1] = vp0;
        this.bc_y[2] = vpp;
        this.bc_y[3] = v0p;
        this.bc_y1[0] = (vp0 - vm0) / 2.0;
        this.bc_y1[1] = (vP0 - v00) / 2.0;
        this.bc_y1[2] = (vPp - v0p) / 2.0;
        this.bc_y1[3] = (vpp - vmp) / 2.0;
        this.bc_y2[0] = (v0p - v0m) / 2.0;
        this.bc_y2[1] = (vpp - vpm) / 2.0;
        this.bc_y2[2] = (vpP - vp0) / 2.0;
        this.bc_y2[3] = (v0P - v00) / 2.0;
        this.bc_y12[0] = (vpp - vpm - vmp + vmm) / 4.0;
        this.bc_y12[0] = (vPp - vPm - v0p + v0m) / 4.0;
        this.bc_y12[2] = (vPP - vP0 - v0P + v00) / 4.0;
        this.bc_y12[0] = (vpP - vp0 - vmP + vm0) / 4.0;
        for (i = 0; i < 4; ++i) {
            this.bc_x[i] = this.bc_y[i];
            this.bc_x[i + 4] = this.bc_y1[i];
            this.bc_x[i + 8] = this.bc_y2[i];
            this.bc_x[i + 12] = this.bc_y12[i];
        }
        for (i = 0; i < 16; ++i) {
            double s = 0.0;
            for (int k = 0; k < 16; ++k) {
                s += (double)bcInv[i][k] * this.bc_x[k];
            }
            this.bc_Coeff[i] = s;
        }
        int l = 0;
        for (i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                this.bc[i][j] = this.bc_Coeff[l++];
            }
        }
    }

    protected double gradient(double lat, double lon, double[] grad) {
        grad[0] = 0.0;
        grad[1] = 0.0;
        double x = (lon - (double)this.lon) / res;
        double y = (lat - (double)this.lat) / res;
        int xi = (int)x;
        int yi = (int)y;
        if (this.lastXi != xi || this.lastYi != yi) {
            log.debug("new Cell for interpolation: %d %d", xi, yi);
            this.recalculateCoefficients(xi, yi);
            this.lastXi = xi;
            this.lastYi = yi;
        }
        double t = x - (double)xi;
        double u = y - (double)yi;
        if (xi < 0 || xi > N + 1 || yi < 0 || yi > N + 1) {
            throw new IndexOutOfBoundsException(String.format("(%f, %f)->(%d, %d)", lat, lon, xi, yi));
        }
        double val = 0.0;
        for (int i = 3; i >= 0; --i) {
            val = t * val + ((this.bc[i][3] * u + this.bc[i][2]) * u + this.bc[i][1]) * u + this.bc[i][0];
            grad[0] = u * grad[0] + (3.0 * this.bc[3][i] * t + 2.0 * this.bc[2][i]) * t + this.bc[1][i];
            grad[1] = t * grad[1] + (3.0 * this.bc[i][3] * t + 2.0 * this.bc[i][2]) * t + this.bc[i][1];
        }
        return val;
    }

    protected double elevation(double lat, double lon) {
        double x = (lon - (double)this.lon) / res;
        double y = (lat - (double)this.lat) / res;
        int xi = (int)x;
        int yi = (int)y;
        if (this.lastXi != xi || this.lastYi != yi) {
            log.debug("new Cell for interpolation: %d %d", xi, yi);
            this.recalculateCoefficients(xi, yi);
            this.lastXi = xi;
            this.lastYi = yi;
        }
        double t = x - (double)xi;
        double u = y - (double)yi;
        if (xi < 0 || xi > N + 1 || yi < 0 || yi > N + 1) {
            throw new IndexOutOfBoundsException(String.format("(%f, %f)->(%d, %d)", lat, lon, xi, yi));
        }
        double val = 0.0;
        for (int i = 3; i >= 0; --i) {
            val = t * val + ((this.bc[i][3] * u + this.bc[i][2]) * u + this.bc[i][1]) * u + this.bc[i][0];
        }
        return val;
    }

    protected double elevation(int x, int y) {
        if (x < 0 || x > N || y < 0 || y > N) {
            throw new IndexOutOfBoundsException(String.format("elevation: %d %d", x, y));
        }
        return this.ele(x, y);
    }

    private static double quickDistance(double long1, double lat1, double long2, double lat2) {
        double longDiff;
        double latDiff = lat1 < lat2 ? lat2 - lat1 : lat1 - lat2;
        if (latDiff > 90.0) {
            latDiff -= 180.0;
        }
        if ((longDiff = long1 < long2 ? long2 - long1 : long1 - long2) > 180.0) {
            longDiff -= 360.0;
        }
        double distDegSq = latDiff * latDiff + (longDiff *= Math.cos(Math.PI / 180 * Math.abs((lat1 + lat2) / 2.0))) * longDiff;
        return 4.0075E7 * Math.sqrt(distDegSq) / 360.0;
    }

    static {
        N = M = 1200;
        res = 1.0 / (double)N;
        id = -1;
        bcInv = new int[][]{{1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0}, {-3, 0, 0, 3, 0, 0, 0, 0, -2, 0, 0, -1, 0, 0, 0, 0}, {2, 0, 0, -2, 0, 0, 0, 0, 1, 0, 0, 1, 0, 0, 0, 0}, {0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0}, {0, 0, 0, 0, -3, 0, 0, 3, 0, 0, 0, 0, -2, 0, 0, -1}, {0, 0, 0, 0, 2, 0, 0, -2, 0, 0, 0, 0, 1, 0, 0, 1}, {-3, 3, 0, 0, -2, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, -3, 3, 0, 0, -2, -1, 0, 0}, {9, -9, 9, -9, 6, 3, -3, -6, 6, -6, -3, 3, 4, 2, 1, 2}, {-6, 6, -6, 6, -4, -2, 2, 4, -3, 3, 3, -3, -2, -1, -1, -2}, {2, -2, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 2, -2, 0, 0, 1, 1, 0, 0}, {-6, 6, -6, 6, -3, -3, 3, 3, -4, 4, 2, -2, -2, -2, -1, -1}, {4, -4, 4, -4, 2, 2, -2, -2, 2, -2, -2, 2, 1, 1, 1, 1}};
        lastId = 1000000000;
        off0 = new int[][]{{0, 0}, {0, 0}, {0, 1}, {1, 1}};
        off1 = new int[][]{{1, 0}, {0, 1}, {1, 1}, {1, 0}};
        brd = new int[]{1, 2, 4, 8};
        rev = new int[]{2, 3, 0, 1};
        mov = new int[][]{{0, -1}, {-1, 0}, {0, 1}, {1, 0}};
    }

    private static class DEMMapDataSource
    extends MapperBasedMapDataSource
    implements LoadableMapDataSource {
        final LoadableMapDataSource parent;
        final List<String> copyright = new ArrayList<String>();

        DEMMapDataSource(LoadableMapDataSource parent, EnhancedProperties props) {
            this.parent = parent;
            this.config(props);
        }

        @Override
        public boolean isFileSupported(String name) {
            return false;
        }

        @Override
        public void load(String name) throws FileNotFoundException, FormatException {
            throw new FormatException("load not supported");
        }

        @Override
        public LevelInfo[] mapLevels() {
            return this.parent.mapLevels();
        }

        @Override
        public LevelInfo[] overviewMapLevels() {
            return this.parent.overviewMapLevels();
        }

        @Override
        public String[] copyrightMessages() {
            return this.copyright.toArray(new String[1]);
        }
    }

    class Isolines {
        final DEM data;
        final int minX;
        final int maxX;
        final int minY;
        final int maxY;
        double min;
        double max;
        final ArrayList<Isoline> isolines = new ArrayList();
        final byte[] visited = new byte[(N + 1) * (N + 1)];

        public Isolines(DEM data, double minLat, double minLon, double maxLat, double maxLon) {
            System.out.printf("init: %f %f %f %f\n", minLat, minLon, maxLat, maxLon);
            this.data = data;
            this.minX = (int)((minLon - (double)data.lon) / res);
            this.minY = (int)((minLat - (double)data.lat) / res);
            this.maxX = (int)((maxLon - (double)data.lon) / res);
            this.maxY = (int)((maxLat - (double)data.lat) / res);
            this.init();
        }

        private void init() {
            System.out.printf("init: %d %d %d %d\n", this.minX, this.minY, this.maxX, this.maxY);
            this.data.read(this.minX - 2, this.minY - 2, this.maxX + 2, this.maxY + 2);
            this.max = -1000.0;
            this.min = 10000.0;
            for (int i = this.minX; i < this.maxX; ++i) {
                for (int j = this.minY; j < this.maxY; ++j) {
                    if (this.data.elevation(i, j) < this.min) {
                        this.min = this.data.elevation(i, j);
                    }
                    if (!(this.data.elevation(i, j) > this.max)) continue;
                    this.max = this.data.elevation(i, j);
                }
            }
            log.debug("min: %f, max: %f\n", this.min, this.max);
        }

        double getMinHeight() {
            return this.min;
        }

        double getMaxHeight() {
            return this.max;
        }

        public void addLevel(double level) {
            if (level < this.min || level > this.max) {
                return;
            }
            System.out.printf("addLevel: %f\n", level);
            Arrays.fill(this.visited, (byte)0);
            for (int y = this.minY; y < this.maxY; ++y) {
                for (int x = this.minX; x < this.maxX; ++x) {
                    int direction;
                    byte v = 0;
                    if (this.data.elevation(x, y) >= level) {
                        if (this.data.elevation(x + 1, y) < level) {
                            v = (byte)(v | 1);
                        }
                        if (this.data.elevation(x, y + 1) < level) {
                            v = (byte)(v | 2);
                        }
                        direction = 1;
                    } else {
                        if (this.data.elevation(x + 1, y) > level) {
                            v = (byte)(v | 1);
                        }
                        if (this.data.elevation(x, y + 1) > level) {
                            v = (byte)(v | 2);
                        }
                        direction = -1;
                    }
                    int k = -1;
                    if ((v & 1) > 0 && (this.visited[y * (N + 1) + x] & 1) == 0) {
                        k = 0;
                    } else if ((v & 2) > 0 && (this.visited[y * (N + 1) + x] & 2) == 0) {
                        k = 1;
                    }
                    if (k < 0) continue;
                    int x0 = x + off0[k][0];
                    int y0 = y + off0[k][1];
                    int x1 = x + off1[k][0];
                    int y1 = y + off1[k][1];
                    try {
                        double delta;
                        Edge f = new Edge((double)this.data.lat + (double)y0 * res, (double)this.data.lon + (double)x0 * res, (double)this.data.lat + (double)y1 * res, (double)this.data.lon + (double)x1 * res, level);
                        double f0 = DEM.this.elevation(x0, y0) - level;
                        double f1 = DEM.this.elevation(x1, y1) - level;
                        if (Math.abs(f0) < 1.0E-9) {
                            delta = 0.0;
                        } else {
                            if (Math.abs(f1) < 1.0E-9) continue;
                            delta = Brent.zero(f, 0.0, 0.999999999);
                        }
                        Position p = new Position(x, y, (double)this.data.lon + ((double)x0 + delta * (double)(x1 - x0)) * res, (double)this.data.lat + ((double)y0 + delta * (double)(y1 - y0)) * res, k);
                        p.markEdge();
                        this.isolines.add(this.traceByStepping(level, p, direction));
                        continue;
                    }
                    catch (RuntimeException ex) {
                        log.debug("error: %s", ex.toString());
                        ex.printStackTrace();
                        return;
                    }
                }
            }
        }

        private Isoline traceByStepping(double level, Position p, int direction) {
            Isoline line;
            block4: {
                log.debug("traceByStepping: starting contour %f %d %d %f %f %d", level, p.ix, p.iy, p.x, p.y, p.edge);
                int n = 0;
                Position startP = new Position(p);
                boolean foundEnd = false;
                line = new Isoline(level);
                while (true) {
                    log.debug("traceByStepping: %f %d %d %f %f %d", level, p.ix, p.iy, p.x, p.y, p.edge);
                    int n2 = p.iy * (N + 1) + p.ix;
                    this.visited[n2] = (byte)(this.visited[n2] | brd[p.edge]);
                    if (n > 0 && p.ix == startP.ix && p.iy == startP.iy && DEM.quickDistance(p.x, p.y, startP.x, startP.y) < 5.0) {
                        log.debug((Object)"closed curve!");
                        line.close();
                        break block4;
                    }
                    if (p.ix < this.minX || p.iy < this.minY || p.ix >= this.maxX || p.iy >= this.maxY) {
                        if (foundEnd) {
                            log.debug((Object)"second border reached!");
                            break block4;
                        }
                        log.debug((Object)"border reached!");
                        foundEnd = true;
                        n = 0;
                        direction *= -1;
                        p = new Position(startP);
                        p.moveCell();
                        continue;
                    }
                    ++n;
                    if (!line.addCell(p, direction) || line.points.size() > 200000) break;
                }
                log.debug((Object)"ending contour");
                this.isolines.add(line);
                return line;
            }
            return line;
        }

        private class Position {
            int ix;
            int iy;
            double x;
            double y;
            int edge;

            Position(int ix, int iy, double x, double y, int edge) {
                this.ix = ix;
                this.iy = iy;
                this.x = x;
                this.y = y;
                this.edge = edge;
            }

            Position(Position p) {
                this.ix = p.ix;
                this.iy = p.iy;
                this.x = p.x;
                this.y = p.y;
                this.edge = p.edge;
            }

            void markEdge() {
                log.debug("marking edge: %d %d %d %d", this.ix, this.iy, this.edge, brd[this.edge]);
                int n = this.iy * (N + 1) + this.ix;
                Isolines.this.visited[n] = (byte)(Isolines.this.visited[n] | brd[this.edge]);
            }

            void moveCell() {
                this.markEdge();
                this.ix += mov[this.edge][0];
                this.iy += mov[this.edge][1];
                this.edge = rev[this.edge];
                this.markEdge();
            }
        }

        private class Edge
        implements Brent.Function {
            final double x0;
            final double y0;
            final double x1;
            final double y1;
            final double level;

            Edge(double x0, double y0, double x1, double y1, double level) {
                this.x0 = x0;
                this.y0 = y0;
                this.x1 = x1;
                this.y1 = y1;
                this.level = level;
            }

            @Override
            public double eval(double d) {
                return Isolines.this.data.elevation(this.x0 + d * (this.x1 - this.x0), this.y0 + d * (this.y1 - this.y0)) - this.level;
            }
        }

        class Isoline {
            final int id;
            final ArrayList<Coord> points;
            final double level;
            private final FN fn = new FN();
            final double[] grad = new double[2];
            final double[] px = new double[4];
            final double[] py = new double[4];
            final int[] edges = new int[4];

            private Isoline(double level) {
                this.level = level;
                this.id = lastId++;
                this.points = new ArrayList();
            }

            boolean addCell(Position p, int direction) {
                log.debug("addCell: %f %d %d %d %d", this.level, p.ix, p.iy, p.edge, direction);
                int c = 0;
                for (int k = 0; k < 4; ++k) {
                    double delta;
                    if (k == p.edge) continue;
                    int x0 = p.ix + off0[k][0];
                    int y0 = p.iy + off0[k][1];
                    int x1 = p.ix + off1[k][0];
                    int y1 = p.iy + off1[k][1];
                    double l0 = DEM.this.elevation(x0, y0) - this.level;
                    double l1 = DEM.this.elevation(x1, y1) - this.level;
                    if (!(Math.abs(l1) < 1.0E-9) && !(l0 * l1 < 0.0)) continue;
                    this.edges[c] = k;
                    Edge f = new Edge((double)Isolines.this.data.lat + (double)y0 * res, (double)Isolines.this.data.lon + (double)x0 * res, (double)Isolines.this.data.lat + (double)y1 * res, (double)Isolines.this.data.lon + (double)x1 * res);
                    double f0 = DEM.this.elevation(x0, y0) - this.level;
                    if ((double)Math.abs(1) < 1.0E-9) {
                        delta = 1.0;
                    } else {
                        if (Math.abs(f0) < 1.0E-9) {
                            throw new ExitException("implementation error!");
                        }
                        delta = Brent.zero(f, 1.0E-9, 0.999999999);
                    }
                    this.px[c] = (double)Isolines.this.data.lon + ((double)x0 + delta * (double)(x1 - x0)) * res;
                    this.py[c] = (double)Isolines.this.data.lat + ((double)y0 + delta * (double)(y1 - y0)) * res;
                    ++c;
                }
                if (c == 1) {
                    p.edge = this.edges[0];
                    double px0 = p.x;
                    double py0 = p.y;
                    p.x = this.px[0];
                    p.y = this.py[0];
                    double px1 = p.x;
                    double py1 = p.y;
                    double xMin = (double)Isolines.this.data.lon + (double)p.ix * res;
                    double xMax = xMin + res;
                    double yMin = (double)Isolines.this.data.lat + (double)p.iy * res;
                    double yMax = yMin + res;
                    this.refineAdaptively(xMin, yMin, xMax, yMax, px0, py0, px1, py1, direction, 21.0);
                    this.addPoint(p.x, p.y, direction);
                    p.moveCell();
                    return true;
                }
                log.debug("addCellByStepping: %d", c);
                return this.addCellByStepping(p, direction, c, this.edges, this.px, this.py);
            }

            private void refineAdaptively(double xMin, double yMin, double xMax, double yMax, double x0, double y0, double x1, double y1, int direction, double maxDist) {
                double dist = DEM.quickDistance(x0, y0, x1, y1);
                if (dist > maxDist) {
                    double dx = x1 - x0;
                    double dy = y1 - y0;
                    double xm = x0 + 0.5 * dx;
                    double ym = y0 + 0.5 * dy;
                    double n = Math.sqrt(dx * dx + dy * dy);
                    this.fn.setParameter(xm, ym, -dy / n, dx / n);
                    FN f = this.fn;
                    double t0 = -0.05 * res;
                    double t1 = 0.05 * res;
                    double f0 = f.eval(t0);
                    double f1 = f.eval(t1);
                    int count = 0;
                    while (f0 * f1 > 0.0 && count++ < 20) {
                        if ((count & 1) > 0) {
                            t0 -= 0.05 * res;
                        } else {
                            t1 += 0.05 * res;
                        }
                        f0 = f.eval(t0);
                        f1 = f.eval(t1);
                        log.debug("refine: %f %f %f %f", t0, t1, f0, f1);
                    }
                    if (f0 * f1 < 0.0) {
                        double t = Brent.zero(f, t0, t1);
                        xm -= t * dy;
                        ym += t * dx;
                    } else {
                        log.debug("refine failed: %f %f %f %f", t0, t1, f0, f1);
                        return;
                    }
                    if (xm > xMin && xm < xMax && ym > yMin && ym < yMax) {
                        this.refineAdaptively(xMin, yMin, xMax, yMax, x0, y0, xm, ym, direction, maxDist * 1.1);
                    }
                    this.addPoint(xm, ym, direction);
                    if (xm > xMin && xm < xMax && ym > yMin && ym < yMax) {
                        this.refineAdaptively(xMin, yMin, xMax, yMax, xm, ym, x1, y1, direction, maxDist * 1.1);
                    }
                }
            }

            boolean addCellByStepping(Position p, int direction, int numEdges, int[] edges, double[] px, double[] py) {
                log.debug("addCellByStepping: %f %d %d %d %d", this.level, p.ix, p.iy, p.edge, direction);
                int iMin = -1;
                double md = 5000.0;
                for (int i = 0; i < numEdges; ++i) {
                    DEM.this.gradient(p.y, p.x, this.grad);
                    double dist = DEM.quickDistance(p.x, p.y, px[i], py[i]);
                    log.debug("distance %d: %f", i, dist);
                    if (!(dist < md) || (Isolines.this.visited[p.iy * (N + 1) + p.ix] & brd[edges[i]]) != 0) continue;
                    md = dist;
                    iMin = i;
                }
                p.edge = edges[iMin];
                double px0 = p.x;
                double py0 = p.y;
                p.x = px[iMin];
                p.y = py[iMin];
                double px1 = p.x;
                double py1 = p.y;
                double xMin = (double)Isolines.this.data.lon + (double)p.ix * res;
                double xMax = xMin + res;
                double yMin = (double)Isolines.this.data.lat + (double)p.iy * res;
                double yMax = yMin + res;
                this.refineAdaptively(xMin, yMin, xMax, yMax, px0, py0, px1, py1, direction, 21.0);
                this.addPoint(p.x, p.y, direction);
                p.moveCell();
                return true;
            }

            private void addPoint(double x, double y, int direction) {
                double dist = DEM.quickDistance(x, y, lastX, lastY);
                log.debug("addPoint: %f %f %f", x, y, dist);
                if (dist > 15.0) {
                    if (direction > 0) {
                        this.points.add(0, new Coord(y, x));
                    } else {
                        this.points.add(this.points.size(), new Coord(y, x));
                    }
                    lastX = x;
                    lastY = y;
                }
            }

            private void close() {
                this.points.add(this.points.size(), this.points.get(0));
            }

            private class FN
            implements Brent.Function {
                double x0;
                double y0;
                double dx;
                double dy;

                private FN() {
                }

                public void setParameter(double x0, double y0, double dx, double dy) {
                    this.x0 = x0;
                    this.y0 = y0;
                    this.dx = dx;
                    this.dy = dy;
                }

                @Override
                public double eval(double t) {
                    return Isolines.this.data.elevation(this.y0 + t * this.dy, this.x0 + t * this.dx) - Isoline.this.level;
                }
            }

            private class Edge
            implements Brent.Function {
                final double x0;
                final double y0;
                final double x1;
                final double y1;

                Edge(double x0, double y0, double x1, double y1) {
                    this.x0 = x0;
                    this.y0 = y0;
                    this.x1 = x1;
                    this.y1 = y1;
                }

                @Override
                public double eval(double d) {
                    return Isolines.this.data.elevation(this.x0 + d * (this.x1 - this.x0), this.y0 + d * (this.y1 - this.y0)) - Isoline.this.level;
                }
            }
        }
    }
}

