/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.mkgmap.reader.osm.boundary;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import uk.me.parabola.mkgmap.reader.osm.boundary.BoundaryQuadTree;
import uk.me.parabola.mkgmap.reader.osm.boundary.BoundarySaver;
import uk.me.parabola.mkgmap.reader.osm.boundary.BoundaryUtil;

public class BoundaryMerger {
    private void copy(File file, File to) {
        String filename = file.getName();
        try {
            FileChannel in = new FileInputStream(file).getChannel();
            FileChannel out = new FileOutputStream(new File(to, filename)).getChannel();
            in.transferTo(0L, file.length(), out);
            in.close();
            out.close();
        }
        catch (IOException exp) {
            System.err.println(exp);
        }
    }

    public void merge(File dir1, File dir2, File targetDir) throws IOException {
        List<String> fl1 = BoundaryUtil.getBoundaryDirContent(dir1.getAbsolutePath());
        List<String> fl2 = BoundaryUtil.getBoundaryDirContent(dir2.getAbsolutePath());
        Collections.sort(fl1);
        Collections.sort(fl2);
        ListIterator<String> fl1Iter = fl1.listIterator();
        ListIterator<String> fl2Iter = fl2.listIterator();
        BoundarySaver bSave = new BoundarySaver(targetDir, "QUADTREE");
        bSave.setCreateEmptyFiles(false);
        ArrayList<File> copy = new ArrayList<File>();
        int processed = 0;
        int all = fl1.size() + fl2.size();
        while (fl1Iter.hasNext() || fl2Iter.hasNext()) {
            BoundaryQuadTree bqt2;
            String f2;
            String f1 = fl1Iter.hasNext() ? fl1Iter.next() : null;
            String string = f2 = fl2Iter.hasNext() ? fl2Iter.next() : null;
            if (f1 == null) {
                copy.add(new File(dir2, f2));
                continue;
            }
            if (f2 == null) {
                copy.add(new File(dir1, f1));
                continue;
            }
            int cmp = f1.compareTo(f2);
            if (cmp < 0) {
                copy.add(new File(dir1, f1));
                fl2Iter.previous();
                continue;
            }
            if (cmp > 0) {
                copy.add(new File(dir2, f2));
                fl1Iter.previous();
                continue;
            }
            BoundaryQuadTree bqt1 = BoundaryUtil.loadQuadTree(dir1.getAbsolutePath(), f1);
            if (bqt1 == null) {
                System.err.println("Failed to load quadtree for " + dir1.getAbsolutePath() + f1);
                System.exit(-1);
            }
            if ((bqt2 = BoundaryUtil.loadQuadTree(dir2.getAbsolutePath(), f2)) == null) {
                System.err.println("Failed to load quadtree for " + dir2.getAbsolutePath() + f2);
                System.exit(-1);
            }
            bqt1.merge(bqt2);
            bSave.saveQuadTree(bqt1, f1);
            System.out.println((processed += 2) + "/" + all + " processed");
        }
        bSave.end();
        for (File f : copy) {
            this.copy(f, targetDir);
            System.out.println(++processed + "/" + all + " processed");
        }
    }

    public static void main(String[] args) throws IOException {
        if (args.length != 3) {
            System.err.println("java uk.me.parabola.mkgmap.reader.osm.boundary.BoundaryMerger <bounds1> <bounds2> <merge>");
            System.err.println("<bounds1> <bounds2> : directories with *.bnd files to merge");
            System.err.println("<merge> target directory, is created if it doesn't exist");
            return;
        }
        File b1 = new File(args[0]);
        File b2 = new File(args[1]);
        File merge = new File(args[2]);
        if (!b1.exists() || !b1.isDirectory()) {
            System.err.println(b1 + " does not exist or is not a directory");
            return;
        }
        if (!b2.exists() || !b2.isDirectory()) {
            System.err.println(b2 + " does not exist or is not a directory");
            return;
        }
        if (merge.exists() && !merge.isDirectory()) {
            System.err.println(merge + " is not a directory");
        }
        if (!merge.exists()) {
            merge.mkdirs();
        }
        BoundaryMerger merger = new BoundaryMerger();
        merger.merge(b1, b2, merge);
    }
}

