/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.tdbfmt;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.CRC32;
import java.util.zip.CheckedOutputStream;
import uk.me.parabola.imgfmt.app.Area;
import uk.me.parabola.io.EndOfFileException;
import uk.me.parabola.io.StructuredInputStream;
import uk.me.parabola.log.Logger;
import uk.me.parabola.tdbfmt.Block;
import uk.me.parabola.tdbfmt.CopyrightBlock;
import uk.me.parabola.tdbfmt.CopyrightSegment;
import uk.me.parabola.tdbfmt.DetailMapBlock;
import uk.me.parabola.tdbfmt.HeaderBlock;
import uk.me.parabola.tdbfmt.OverviewMapBlock;
import uk.me.parabola.tdbfmt.RBlock;
import uk.me.parabola.tdbfmt.TBlock;

public class TdbFile {
    private static final Logger log = Logger.getLogger(TdbFile.class);
    public static final int TDB_V407 = 407;
    private static final int BLOCK_OVERVIEW = 66;
    private static final int BLOCK_HEADER = 80;
    private static final int BLOCK_COPYRIGHT = 68;
    private static final int BLOCK_DETAIL = 76;
    private static final int BLOCK_R = 82;
    private static final int BLOCK_T = 84;
    private int tdbVersion;
    private HeaderBlock headerBlock;
    private CopyrightBlock copyrightBlock = new CopyrightBlock();
    private OverviewMapBlock overviewMapBlock;
    private final List<DetailMapBlock> detailBlocks = new ArrayList<DetailMapBlock>();
    private final RBlock rblock = new RBlock();
    private final TBlock tblock = new TBlock();
    private String overviewDescription;

    public TdbFile() {
    }

    public TdbFile(int tdbVersion) {
        this.tdbVersion = tdbVersion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TdbFile read(String name) throws IOException {
        TdbFile tdb = new TdbFile();
        try (BufferedInputStream is = new BufferedInputStream(new FileInputStream(name));){
            StructuredInputStream ds = new StructuredInputStream(is);
            tdb.load(ds);
        }
        return tdb;
    }

    public void setProductInfo(int familyId, int productId, short productVersion, String seriesName, String familyName, String overviewDescription, byte enableProfile) {
        this.headerBlock = new HeaderBlock(this.tdbVersion);
        this.headerBlock.setFamilyId((short)familyId);
        this.headerBlock.setProductId((short)productId);
        this.headerBlock.setProductVersion(productVersion);
        this.headerBlock.setSeriesName(seriesName);
        this.headerBlock.setFamilyName(familyName);
        this.headerBlock.setEnableProfile(enableProfile);
        this.overviewDescription = overviewDescription;
    }

    public void setCodePage(int codePage) {
        this.headerBlock.setCodePage(codePage);
    }

    public void addCopyright(String msg) {
        CopyrightSegment seg = new CopyrightSegment(6, 3, msg);
        this.copyrightBlock.addSegment(seg);
    }

    public void setOverview(Area bounds, String number) {
        this.overviewMapBlock = new OverviewMapBlock();
        this.overviewMapBlock.setArea(bounds);
        this.overviewMapBlock.setMapName(number);
        this.overviewMapBlock.setDescription(this.overviewDescription);
    }

    public void addDetail(DetailMapBlock detail) {
        this.detailBlocks.add(detail);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(String name) throws IOException {
        CheckedOutputStream stream = new CheckedOutputStream(new BufferedOutputStream(new FileOutputStream(name)), new CRC32());
        if (this.headerBlock == null || this.overviewMapBlock == null) {
            throw new IOException("Attempting to write file without being fully set up");
        }
        try {
            Block block = new Block(80);
            this.headerBlock.write(block);
            block.write(stream);
            block = new Block(68);
            this.copyrightBlock.write(block);
            block.write(stream);
            if (this.tdbVersion >= 407) {
                block = new Block(82);
                this.rblock.write(block);
                block.write(stream);
            }
            block = new Block(66);
            this.overviewMapBlock.write(block);
            block.write(stream);
            for (DetailMapBlock detail : this.detailBlocks) {
                block = new Block(76);
                detail.write(block);
                block.write(stream);
            }
            if (this.tdbVersion >= 407) {
                this.tblock.setSum(stream.getChecksum().getValue());
                block = new Block(84);
                this.tblock.write(block);
                block.write(stream);
            }
        }
        finally {
            stream.close();
        }
    }

    private void load(StructuredInputStream ds) throws IOException {
        block6: while (!ds.testEof()) {
            Block block = this.readBlock(ds);
            switch (block.getBlockId()) {
                case 80: {
                    this.headerBlock = new HeaderBlock(block);
                    log.info("header block seen", this.headerBlock);
                    continue block6;
                }
                case 68: {
                    log.info((Object)"copyright block");
                    this.copyrightBlock = new CopyrightBlock(block);
                    continue block6;
                }
                case 66: {
                    this.overviewMapBlock = new OverviewMapBlock(block);
                    log.info("overview block", this.overviewMapBlock);
                    continue block6;
                }
                case 76: {
                    DetailMapBlock db = new DetailMapBlock(block);
                    log.info("detail block", db);
                    this.detailBlocks.add(db);
                    continue block6;
                }
            }
            log.warn((Object)"Unknown block in tdb file");
        }
    }

    private Block readBlock(StructuredInputStream is) throws IOException {
        int blockType = is.read();
        if (blockType == -1) {
            throw new EndOfFileException();
        }
        int blockLength = is.read2();
        byte[] body = new byte[blockLength];
        int n = is.read(body);
        if (n < 0) {
            throw new IOException("failed to read block");
        }
        return new Block(blockType, body);
    }

    public int getTdbVersion() {
        return this.headerBlock.getTdbVersion();
    }
}

