/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.imgfmt;

import uk.me.parabola.log.Logger;

public class MapFailedException
extends RuntimeException {
    private static final Logger log = Logger.getLogger(MapFailedException.class);

    public MapFailedException(String message) {
        super(message);
        MapFailedException.log(message);
    }

    public MapFailedException(String message, Throwable cause) {
        super(message, cause);
        MapFailedException.log(message);
    }

    private static void log(String message) {
        String thrownBy = "";
        try {
            StackTraceElement[] stackTraceElements = Thread.currentThread().getStackTrace();
            int callerPosInStack = 3;
            String[] caller = stackTraceElements[callerPosInStack].getClassName().split("\\.");
            thrownBy = "(thrown in " + caller[caller.length - 1] + "." + stackTraceElements[callerPosInStack].getMethodName() + "()) ";
        }
        catch (Exception e) {
            log.info((Object)e);
        }
        log.error((Object)(thrownBy + message));
    }
}

