/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.imgfmt.app.lbl;

import uk.me.parabola.imgfmt.app.ImgFileWriter;
import uk.me.parabola.imgfmt.app.Label;
import uk.me.parabola.imgfmt.app.lbl.Country;
import uk.me.parabola.imgfmt.app.lbl.Region;
import uk.me.parabola.imgfmt.app.trergn.Subdivision;

public class City {
    private static final int POINT_REF = 32768;
    private static final int REGION_IS_COUNTRY = 16384;
    private int index = -1;
    private final Region region;
    private final Country country;
    private boolean pointRef;
    private Subdivision subdivision;
    private byte pointIndex;
    private Label label;

    public City(Region region) {
        this.region = region;
        this.country = null;
    }

    public City(Country country) {
        this.country = country;
        this.region = null;
    }

    void write(ImgFileWriter writer) {
        if (this.pointRef) {
            writer.put(this.pointIndex);
            writer.putChar((char)this.subdivision.getNumber());
        } else {
            writer.put3(this.label.getOffset());
        }
        char info = this.region != null ? (char)(this.region.getIndex() & 0x3FFF) : (char)(0x4000 | this.country.getIndex() & 0x3FFF);
        if (this.pointRef) {
            info = (char)(info | 0x8000);
        }
        writer.putChar(info);
    }

    public int getIndex() {
        if (this.index == -1) {
            throw new IllegalStateException("Offset not known yet.");
        }
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public void setLabel(Label label) {
        this.pointRef = false;
        this.label = label;
    }

    public void setPointIndex(byte pointIndex) {
        this.pointRef = true;
        this.pointIndex = pointIndex;
    }

    public void setSubdivision(Subdivision subdivision) {
        this.pointRef = true;
        this.subdivision = subdivision;
    }

    public String getName() {
        if (this.label == null) {
            return "";
        }
        return this.label.getText();
    }

    public int getLblOffset() {
        if (this.label == null) {
            return 0;
        }
        return this.label.getOffset();
    }

    public String toString() {
        String result = "";
        if (this.label != null) {
            result = result + this.label.getText();
        }
        if (this.subdivision != null) {
            result = result + " " + this.subdivision.getNumber() + "/" + this.pointIndex;
        }
        if (this.country != null) {
            result = result + " in country " + ('\u0000' + this.country.getIndex());
        }
        if (this.region != null) {
            result = result + " in region " + ('\u0000' + this.region.getIndex());
        }
        return result;
    }

    public int getSubdivNumber() {
        return this.subdivision.getNumber();
    }

    public int getPointIndex() {
        return this.pointIndex;
    }

    public int getRegionCountryNumber() {
        if (this.region == null) {
            if (this.country != null) {
                return this.country.getIndex() | 0x4000;
            }
        } else {
            return this.region.getIndex();
        }
        return 0;
    }

    public int getRegionNumber() {
        return this.region == null ? 0 : (int)this.region.getIndex();
    }

    public int getCountryNumber() {
        return this.country != null ? (int)this.country.getIndex() : 0;
    }

    public Label getLabel() {
        return this.label;
    }
}

