/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.imgfmt.app.mdr;

import java.util.ArrayList;
import java.util.List;
import uk.me.parabola.imgfmt.app.ImgFileWriter;
import uk.me.parabola.imgfmt.app.mdr.HasHeaderFlags;
import uk.me.parabola.imgfmt.app.mdr.Mdr1;
import uk.me.parabola.imgfmt.app.mdr.Mdr7Record;
import uk.me.parabola.imgfmt.app.mdr.MdrMapSection;

public abstract class Mdr2x
extends MdrMapSection
implements HasHeaderFlags {
    protected List<Mdr7Record> streets = new ArrayList<Mdr7Record>();

    @Override
    public void writeSectData(ImgFileWriter writer) {
        String lastName = null;
        Mdr7Record prev = null;
        int size = this.getSizes().getStreetSizeFlagged();
        boolean hasLabel = this.hasFlag(2);
        String lastPartial = null;
        int recordNumber = 0;
        for (Mdr7Record street : this.streets) {
            assert (street.getMapIndex() == street.getCity().getMapIndex()) : street.getMapIndex() + "/" + street.getCity().getMapIndex();
            this.addIndexPointer(street.getMapIndex(), ++recordNumber);
            int index = street.getIndex();
            String name = street.getName();
            int repeat = 1;
            if (name.equals(lastName) && this.sameGroup(street, prev)) {
                repeat = 0;
            }
            if (hasLabel) {
                this.putMapIndex(writer, street.getMapIndex());
                int offset = street.getLabelOffset();
                if (repeat != 0) {
                    offset |= 0x800000;
                }
                boolean trailing = false;
                String partialName = street.getPartialName();
                if (!partialName.equals(lastPartial)) {
                    trailing |= true;
                    offset |= 0x800000;
                }
                writer.put3(offset);
                writer.put(street.getOutNameOffset());
                writer.put((byte)(trailing ? 1 : 0));
                lastPartial = partialName;
            } else {
                this.putN(writer, size, index << 1 | repeat);
            }
            lastName = name;
            prev = street;
        }
    }

    @Override
    public int getItemSize() {
        int size = this.isForDevice() ? this.getSizes().getMapSize() + 3 + 1 + 1 : this.getSizes().getStreetSizeFlagged();
        return size;
    }

    @Override
    protected int numberOfItems() {
        return this.streets.size();
    }

    @Override
    protected void releaseMemory() {
        this.streets = null;
    }

    protected abstract boolean sameGroup(Mdr7Record var1, Mdr7Record var2);

    @Override
    public void relabelMaps(Mdr1 maps) {
    }
}

