/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.imgfmt.app.mdr;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import uk.me.parabola.imgfmt.app.ImgFileWriter;
import uk.me.parabola.imgfmt.app.mdr.HasHeaderFlags;
import uk.me.parabola.imgfmt.app.mdr.Mdr4Record;
import uk.me.parabola.imgfmt.app.mdr.MdrConfig;
import uk.me.parabola.imgfmt.app.mdr.MdrSection;

public class Mdr4
extends MdrSection
implements HasHeaderFlags {
    private final Set<Mdr4Record> poiTypes = new HashSet<Mdr4Record>();

    public Mdr4(MdrConfig config) {
        this.setConfig(config);
    }

    @Override
    public void writeSectData(ImgFileWriter writer) {
        ArrayList<Mdr4Record> list = new ArrayList<Mdr4Record>(this.poiTypes);
        Collections.sort(list);
        for (Mdr4Record r : list) {
            writer.put((byte)r.getType());
            writer.put((byte)r.getUnknown());
            writer.put((byte)r.getSubtype());
        }
    }

    @Override
    public int getItemSize() {
        return 3;
    }

    public void addType(int type) {
        Mdr4Record r = new Mdr4Record();
        if (type <= 255) {
            r.setType(type);
        } else {
            r.setType(type >> 8 & 0xFF);
            r.setSubtype(type & 0xFF);
        }
        r.setUnknown(0);
        this.poiTypes.add(r);
    }

    @Override
    protected int numberOfItems() {
        return this.poiTypes.size();
    }

    @Override
    public int getExtraValue() {
        return 0;
    }
}

