/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.imgfmt.app.mdr;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import uk.me.parabola.imgfmt.MapFailedException;
import uk.me.parabola.imgfmt.app.ImgFileWriter;
import uk.me.parabola.imgfmt.app.mdr.Mdr1;
import uk.me.parabola.imgfmt.app.mdr.Mdr5Record;
import uk.me.parabola.imgfmt.app.mdr.Mdr7Record;
import uk.me.parabola.imgfmt.app.mdr.Mdr8Record;
import uk.me.parabola.imgfmt.app.mdr.MdrConfig;
import uk.me.parabola.imgfmt.app.mdr.MdrMapSection;
import uk.me.parabola.imgfmt.app.mdr.MdrSection;
import uk.me.parabola.imgfmt.app.srt.MultiSortKey;
import uk.me.parabola.imgfmt.app.srt.Sort;
import uk.me.parabola.imgfmt.app.srt.SortKey;

public class Mdr7
extends MdrMapSection {
    public static final int MDR7_HAS_STRING = 1;
    public static final int MDR7_HAS_NAME_OFFSET = 32;
    public static final int MDR7_PARTIAL_SHIFT = 6;
    public static final int MDR7_U1 = 2;
    public static final int MDR7_U2 = 4;
    private static final int MAX_NAME_OFFSET = 127;
    private final int codepage;
    private final boolean isMulti;
    private final boolean splitName;
    private List<Mdr7Record> allStreets = new ArrayList<Mdr7Record>();
    private List<Mdr7Record> streets = new ArrayList<Mdr7Record>();
    private final int u2size = 1;

    public Mdr7(MdrConfig config) {
        this.setConfig(config);
        Sort sort = config.getSort();
        this.splitName = config.isSplitName();
        this.codepage = sort.getCodepage();
        this.isMulti = sort.isMulti();
    }

    public void addStreet(int mapId, String name, int lblOffset, int strOff, Mdr5Record mdrCity) {
        int c;
        int sep;
        if (name.isEmpty()) {
            return;
        }
        int prefix = 0;
        if (name.charAt(0) < '\u0007') {
            prefix = 1;
        }
        if ((sep = name.indexOf(30)) > 0) {
            prefix = sep + 1;
        }
        sep = name.indexOf(31);
        int suffix = 0;
        if (sep > 0) {
            suffix = sep;
        }
        if (prefix >= 127 || suffix >= 127) {
            return;
        }
        Mdr7Record st = new Mdr7Record();
        st.setMapIndex(mapId);
        st.setLabelOffset(lblOffset);
        st.setStringOffset(strOff);
        st.setName(name);
        st.setCity(mdrCity);
        st.setPrefixOffset((byte)prefix);
        st.setSuffixOffset((byte)suffix);
        this.allStreets.add(st);
        if (!this.splitName) {
            return;
        }
        boolean start = false;
        boolean inWord = false;
        int outOffset = 0;
        int end = Math.min(suffix > 0 ? suffix : name.length() - prefix - 1, 127);
        for (int nameOffset = 0; nameOffset < end && (c = name.codePointAt(prefix + nameOffset)) != 40; nameOffset += Character.charCount(c)) {
            if (!Character.isLetterOrDigit(c)) {
                start = true;
                inWord = false;
            } else if (start && Character.isLetterOrDigit(c)) {
                inWord = true;
            }
            if (start && inWord && outOffset > 0) {
                st = new Mdr7Record();
                st.setMapIndex(mapId);
                st.setLabelOffset(lblOffset);
                st.setStringOffset(strOff);
                st.setName(name);
                st.setCity(mdrCity);
                st.setNameOffset((byte)nameOffset);
                st.setOutNameOffset((byte)outOffset);
                st.setPrefixOffset((byte)prefix);
                st.setSuffixOffset((byte)suffix);
                this.allStreets.add(st);
                start = false;
            }
            if ((outOffset += this.outSize(c)) > 127) break;
        }
    }

    private int outSize(int c) {
        if (this.codepage == 65001) {
            if (c < 128) {
                return 1;
            }
            if (c <= 2047) {
                return 2;
            }
            if (c <= 65535) {
                return 3;
            }
            if (c <= 0x10FFFF) {
                return 4;
            }
            throw new MapFailedException(String.format("Invalid code point: 0x%x", c));
        }
        if (!this.isMulti) {
            return 1;
        }
        return 0;
    }

    @Override
    protected void preWriteImpl() {
        Sort sort = this.getConfig().getSort();
        ArrayList<MultiSortKey<Mdr7Record>> sortedStreets = new ArrayList<MultiSortKey<Mdr7Record>>(this.allStreets.size());
        for (Mdr7Record m : this.allStreets) {
            sortedStreets.add(new MultiSortKey<Mdr7Record>(sort.createSortKey(m, m.getPartialName()), sort.createSortKey(m, m.getInitialPart(), m.getMapIndex()), null));
        }
        Collections.sort(sortedStreets);
        int recordNumber = 0;
        Mdr7Record last = new Mdr7Record();
        for (int i = 0; i < sortedStreets.size(); ++i) {
            SortKey sk = (SortKey)sortedStreets.get(i);
            Mdr7Record r = (Mdr7Record)sk.getObject();
            if (r.getMapIndex() == last.getMapIndex() && r.getName().equals(last.getName()) && r.getPartialName().equals(last.getPartialName())) {
                r.setIndex(recordNumber);
            } else {
                last = r;
                r.setIndex(++recordNumber);
                this.streets.add(r);
            }
            sortedStreets.set(i, null);
        }
    }

    @Override
    public void writeSectData(ImgFileWriter writer) {
        String lastName = null;
        String lastPartial = null;
        boolean hasStrings = this.hasFlag(1);
        boolean hasNameOffset = this.hasFlag(32);
        for (Mdr7Record s : this.streets) {
            this.addIndexPointer(s.getMapIndex(), s.getIndex());
            this.putMapIndex(writer, s.getMapIndex());
            int lab = s.getLabelOffset();
            String name = s.getName();
            if (!name.equals(lastName)) {
                lab |= 0x800000;
                lastName = name;
            }
            String partialName = s.getPartialName();
            int trailingFlags = 0;
            if (!partialName.equals(lastPartial)) {
                trailingFlags |= 1;
                lab |= 0x800000;
            }
            lastPartial = partialName;
            writer.put3(lab);
            if (hasStrings) {
                this.putStringOffset(writer, s.getStringOffset());
            }
            if (hasNameOffset) {
                writer.put(s.getOutNameOffset());
            }
            this.putN(writer, 1, trailingFlags);
        }
    }

    @Override
    public int getItemSize() {
        MdrSection.PointerSizes sizes = this.getSizes();
        int size = sizes.getMapSize() + 3 + 1;
        if (!this.isForDevice()) {
            size += sizes.getStrOffSize();
        }
        if ((this.getExtraValue() & 0x20) != 0) {
            ++size;
        }
        return size;
    }

    @Override
    protected int numberOfItems() {
        return this.streets.size();
    }

    @Override
    public int getExtraValue() {
        int magic = 98;
        magic = this.isForDevice() ? (magic |= 4) : (magic |= 1);
        return magic;
    }

    @Override
    protected void releaseMemory() {
        this.allStreets = null;
        this.streets = null;
    }

    public List<Mdr8Record> getIndex() {
        ArrayList<Mdr8Record> list = new ArrayList<Mdr8Record>();
        for (int number = 1; number <= this.streets.size(); number += 10240) {
            int rec;
            String prefix = this.getPrefixForRecord(number);
            for (rec = number; rec > 1; --rec) {
                String p = this.getPrefixForRecord(rec);
                if (p.equals(prefix)) continue;
                ++rec;
                break;
            }
            Mdr8Record indexRecord = new Mdr8Record();
            indexRecord.setPrefix(prefix);
            indexRecord.setRecordNumber(rec);
            list.add(indexRecord);
        }
        return list;
    }

    private String getPrefixForRecord(int number) {
        int endIndex = 4;
        Mdr7Record record = this.streets.get(number - 1);
        String name = record.getName();
        if (endIndex > name.length()) {
            StringBuilder sb = new StringBuilder(name);
            while (sb.length() < endIndex) {
                sb.append('\u0000');
            }
            name = sb.toString();
        }
        return name.substring(0, endIndex);
    }

    public List<Mdr7Record> getStreets() {
        return Collections.unmodifiableList(this.allStreets);
    }

    public List<Mdr7Record> getSortedStreets() {
        return Collections.unmodifiableList(this.streets);
    }

    @Override
    public void relabelMaps(Mdr1 maps) {
        this.relabel(maps, this.allStreets);
    }
}

