/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.imgfmt.app.net;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import uk.me.parabola.imgfmt.app.net.RoadDef;
import uk.me.parabola.imgfmt.app.net.RouteArc;
import uk.me.parabola.imgfmt.app.net.RouteNode;
import uk.me.parabola.log.Logger;
import uk.me.parabola.util.EnhancedProperties;

public class AngleChecker {
    private static final Logger log = Logger.getLogger(AngleChecker.class);
    private boolean ignoreSharpAngles;
    private boolean cycleMap;
    private final int MIN_ANGLE = 16;
    private final int MIN_LOW_SPEED_ANGLE = 32;
    private int mask;

    public void config(EnhancedProperties props) {
        this.ignoreSharpAngles = props.getProperty("ignore-sharp-angles", false);
        this.cycleMap = props.getProperty("cycle-map", false);
    }

    public void check(Map<Integer, RouteNode> nodes) {
        if (!this.ignoreSharpAngles) {
            byte sharpAnglesCheckMask = this.cycleMap ? (byte)-2 : 2;
            for (RouteNode node : nodes.values()) {
                this.mask = 240;
                this.fixSharpAngles(node, sharpAnglesCheckMask);
            }
        }
    }

    public void fixSharpAngles(RouteNode node, byte sharpAnglesCheckMask) {
        int i;
        List<ArcGroup> arcGroups = this.buildArcGroups(node);
        int n = arcGroups.size();
        if (n <= 1) {
            return;
        }
        Collections.sort(arcGroups, new Comparator<ArcGroup>(){

            @Override
            public int compare(ArcGroup ag1, ArcGroup ag2) {
                if (ag1.initialHeading < ag2.initialHeading) {
                    return -1;
                }
                if (ag1.initialHeading > ag2.initialHeading) {
                    return 1;
                }
                return 0;
            }
        });
        class AngleAttr {
            int angle;
            int maskedAngle;
            int maskedMinAngle = 16;
            boolean noAccess;

            AngleAttr() {
            }

            int maskedDeltaToMin() {
                return this.maskedAngle - this.maskedMinAngle;
            }

            void setMaskedMinAngle(int maskedMinAngle) {
                this.maskedMinAngle = maskedMinAngle;
            }

            public String toString() {
                return this.angle + "\u00b0 " + this.maskedAngle + " " + this.maskedMinAngle + " " + this.noAccess;
            }
        }
        AngleAttr[] angles = new AngleAttr[n];
        for (i = 0; i < n; ++i) {
            AngleAttr angleAttr;
            ArcGroup ag1 = arcGroups.get(i);
            ArcGroup ag2 = arcGroups.get(i + 1 < n ? i + 1 : 0);
            angles[i] = angleAttr = new AngleAttr();
            angleAttr.angle = Math.round(ag2.getInitialHeading() - ag1.getInitialHeading());
            angleAttr.maskedAngle = ag2.imgHeading - ag1.imgHeading;
            if (i + 1 >= n) {
                angleAttr.angle += 360;
            }
            if (angleAttr.maskedAngle < 0) {
                angleAttr.maskedAngle += 256;
            }
            if (ag1.isOneway() && ag1.isForward()) {
                angleAttr.noAccess = true;
            } else if (ag2.isOneway() && !ag2.isForward()) {
                angleAttr.noAccess = true;
            }
            int sumSpeeds = ag1.maxRoadSpeed + ag2.maxRoadSpeed;
            if (sumSpeeds <= 1) continue;
            byte pathAccessMask = (byte)(ag1.orAccessMask & ag2.orAccessMask);
            if (pathAccessMask == 0) {
                angleAttr.noAccess = true;
            }
            if (angleAttr.noAccess) continue;
            int maskedMinAngle = 32;
            angleAttr.setMaskedMinAngle(maskedMinAngle);
            if (angleAttr.maskedDeltaToMin() >= 0) continue;
            String ignoredReason = null;
            if (pathAccessMask == 1) {
                ignoredReason = "because it can only be used by pedestrians";
            } else if ((pathAccessMask & sharpAnglesCheckMask) == 0) {
                ignoredReason = "because it can not be used by bike";
            } else if (ag1.isOneway() && ag2.isOneway()) {
                ignoredReason = "because it seems to be a flare road";
            } else if (ag1.roadDefs.size() == 1 && ag2.roadDefs.size() == 1 && ag1.roadDefs.containsAll(ag2.roadDefs)) {
                ignoredReason = "because both arcs belong to the same road";
            }
            if (ignoredReason == null) continue;
            if (log.isInfoEnabled()) {
                String sharpAngle = "sharp angle " + angleAttr.angle + "\u00b0 at " + node.getCoord().toDegreeString();
                log.info(sharpAngle, "headings", this.getCompassBearing(ag1.getInitialHeading()), this.getCompassBearing(ag2.getInitialHeading()), "speeds", ag1.maxRoadSpeed, ag2.maxRoadSpeed);
                log.info("ignoring", sharpAngle, ignoredReason);
            }
            angleAttr.setMaskedMinAngle(16);
            angleAttr.noAccess = true;
        }
        for (i = 0; i < n; ++i) {
            int modImgAngle;
            int modAngle;
            int modIH;
            float oldIH;
            int usedIncrement;
            AngleAttr aa = angles[i];
            if (aa.maskedAngle >= aa.maskedMinAngle || aa.noAccess) continue;
            int oldAngle = aa.angle;
            ArcGroup ag1 = arcGroups.get(i);
            ArcGroup ag2 = arcGroups.get(i + 1 < n ? i + 1 : 0);
            String sharpAngle = "";
            if (log.isInfoEnabled()) {
                sharpAngle = "sharp angle " + aa.angle + "\u00b0 at " + node.getCoord().toDegreeString();
                log.info(sharpAngle, "headings", this.getCompassBearing(ag1.getInitialHeading()), this.getCompassBearing(ag2.getInitialHeading()), "speeds", ag1.maxRoadSpeed, ag2.maxRoadSpeed);
            }
            boolean fixed = false;
            int wantedIncrement = Math.abs(aa.maskedDeltaToMin());
            AngleAttr predAA = angles[i == 0 ? n - 1 : i - 1];
            AngleAttr nextAA = angles[i >= n - 1 ? 0 : i + 1];
            byte origImgDir1 = ag1.imgHeading;
            byte origImgDir2 = ag2.imgHeading;
            int origImgAngle = this.getImgAngle(ag1.imgHeading, ag2.imgHeading);
            int deltaPred = predAA.maskedDeltaToMin();
            int deltaNext = nextAA.maskedDeltaToMin();
            if (deltaNext > 0 && (deltaNext > deltaPred || deltaPred < wantedIncrement)) {
                usedIncrement = Math.min(wantedIncrement, deltaNext);
                oldIH = ag2.getInitialHeading();
                modIH = ag2.imgHeading + usedIncrement;
                if (modIH > 128) {
                    modIH -= 256;
                }
                ag2.setInitialHeading(modIH * 360 / 256);
                modAngle = Math.round(ag2.getInitialHeading() - ag1.getInitialHeading());
                if (modAngle < 0) {
                    modAngle += 360;
                }
                if ((modImgAngle = this.getImgAngle(ag1.imgHeading, ag2.imgHeading)) >= aa.maskedMinAngle) {
                    fixed = true;
                }
                log.info(sharpAngle, "changing arc with heading", this.getCompassBearing(oldIH), "->", this.getCompassBearing(ag2.getInitialHeading()), "angle is now", modAngle + "\u00b0, in img format:", origImgDir2, "->", ag2.imgHeading, "img angle (0-255)", origImgAngle, "->", modImgAngle);
                aa.angle = modAngle;
                nextAA.angle -= usedIncrement;
            }
            if (!fixed && deltaPred > 0) {
                wantedIncrement = Math.abs(aa.maskedDeltaToMin());
                usedIncrement = Math.min(wantedIncrement, deltaPred);
                oldIH = ag1.getInitialHeading();
                modIH = ag1.imgHeading - usedIncrement;
                if (modIH < -128) {
                    modIH += 256;
                }
                ag1.setInitialHeading(modIH * 360 / 256);
                modAngle = Math.round(ag2.getInitialHeading() - ag1.getInitialHeading());
                if (modAngle < 0) {
                    modAngle += 360;
                }
                if ((modImgAngle = this.getImgAngle(ag1.imgHeading, ag2.imgHeading)) >= aa.maskedMinAngle) {
                    fixed = true;
                }
                log.info(sharpAngle, "changing arc with heading", this.getCompassBearing(oldIH), "->", this.getCompassBearing(ag1.getInitialHeading()), "angle is now", modAngle + "\u00b0, in img format:", origImgDir1, "->", ag1.imgHeading, "img angle (0-255)", origImgAngle, "->", modImgAngle);
                aa.angle = modAngle;
                predAA.angle -= usedIncrement;
            }
            if (fixed) continue;
            if (aa.angle == oldAngle) {
                log.info(sharpAngle, "don't know how to fix it");
                continue;
            }
            log.info(sharpAngle, "don't know how to enlarge it further");
        }
    }

    private List<ArcGroup> buildArcGroups(RouteNode node) {
        ArrayList<ArcGroup> arcGroups = new ArrayList<ArcGroup>();
        ArrayList<RouteArc> directArcs = new ArrayList<RouteArc>();
        for (RouteArc arc : node.getArcs()) {
            if (!arc.isDirect()) continue;
            directArcs.add(arc);
        }
        if (directArcs.size() < 2) {
            return arcGroups;
        }
        Collections.sort(directArcs, new Comparator<RouteArc>(){

            @Override
            public int compare(RouteArc ra1, RouteArc ra2) {
                if (ra1.getInitialHeading() < ra2.getInitialHeading()) {
                    return -1;
                }
                if (ra1.getInitialHeading() > ra2.getInitialHeading()) {
                    return 1;
                }
                int d = Integer.compare(ra1.getPointsHash(), ra2.getPointsHash());
                if (d != 0) {
                    return d;
                }
                d = Long.compare(ra1.getRoadDef().getId(), ra2.getRoadDef().getId());
                if (d != 0) {
                    return d;
                }
                return d;
            }
        });
        ListIterator iter = directArcs.listIterator();
        RouteArc arc1 = (RouteArc)iter.next();
        boolean addArc1 = false;
        block1: while (iter.hasNext() || addArc1) {
            ArcGroup ag = new ArcGroup();
            ag.initialHeading = arc1.getInitialHeading();
            ag.addArc(arc1);
            arcGroups.add(ag);
            addArc1 = false;
            while (iter.hasNext()) {
                RouteArc arc2 = (RouteArc)iter.next();
                if (Math.abs(arc1.getInitialHeading() - arc2.getInitialHeading()) < 1.0f) {
                    if (arc1.getDest() != arc2.getDest() && arc1.getRoadDef().getId() != arc2.getRoadDef().getId()) {
                        log.warn("sharp angle < 1\u00b0 at", node.getCoord().toDegreeString(), ",maybe duplicated OSM way with bearing", this.getCompassBearing(arc1.getInitialHeading()));
                    }
                    ag.addArc(arc2);
                    continue;
                }
                arc1 = arc2;
                if (iter.hasNext()) continue block1;
                addArc1 = true;
                continue block1;
            }
        }
        for (ArcGroup ag : arcGroups) {
            ag.imgHeading = (byte)(RouteArc.directionFromDegrees(ag.initialHeading) & this.mask);
        }
        return arcGroups;
    }

    private String getCompassBearing(float bearing) {
        float cb = (bearing + 360.0f) % 360.0f;
        return Math.round(cb) + "\u00b0";
    }

    private int getImgAngle(byte heading1, byte heading2) {
        int angle = heading2 - heading1;
        if (angle < 0) {
            angle += 256;
        }
        if (angle > 255) {
            angle -= 256;
        }
        return angle;
    }

    private class ArcGroup {
        float initialHeading;
        byte imgHeading;
        int isOneWayTrueCount;
        int isForwardTrueCount;
        int maxRoadSpeed;
        byte orAccessMask;
        HashSet<RoadDef> roadDefs = new HashSet();
        List<RouteArc> arcs = new ArrayList<RouteArc>();

        private ArcGroup() {
        }

        public void addArc(RouteArc arc) {
            this.arcs.add(arc);
            if (arc.getRoadDef().isOneway()) {
                ++this.isOneWayTrueCount;
            }
            if (arc.isForward()) {
                ++this.isForwardTrueCount;
            }
            if (arc.getRoadDef().getRoadSpeed() > this.maxRoadSpeed) {
                this.maxRoadSpeed = arc.getRoadDef().getRoadSpeed();
            }
            this.orAccessMask = (byte)(this.orAccessMask | arc.getRoadDef().getAccess());
            this.roadDefs.add(arc.getRoadDef());
        }

        public float getInitialHeading() {
            return this.initialHeading;
        }

        public boolean isOneway() {
            return this.isOneWayTrueCount == this.arcs.size();
        }

        public boolean isForward() {
            return this.isForwardTrueCount == this.arcs.size();
        }

        public void setInitialHeading(float modIH) {
            while (modIH > 180.0f) {
                modIH -= 360.0f;
            }
            while (modIH < -180.0f) {
                modIH += 360.0f;
            }
            this.initialHeading = modIH;
            this.imgHeading = (byte)(RouteArc.directionFromDegrees(this.initialHeading) & AngleChecker.this.mask);
            for (RouteArc arc : this.arcs) {
                arc.setInitialHeading(modIH);
            }
        }

        public String toString() {
            return this.arcs.get(0).toString();
        }
    }
}

