/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.imgfmt.app.net;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import uk.me.parabola.imgfmt.app.BufferedImgFileReader;
import uk.me.parabola.imgfmt.app.ImgFile;
import uk.me.parabola.imgfmt.app.ImgFileReader;
import uk.me.parabola.imgfmt.app.Label;
import uk.me.parabola.imgfmt.app.lbl.City;
import uk.me.parabola.imgfmt.app.lbl.LBLFileReader;
import uk.me.parabola.imgfmt.app.lbl.Zip;
import uk.me.parabola.imgfmt.app.net.NETHeader;
import uk.me.parabola.imgfmt.app.net.RoadDef;
import uk.me.parabola.imgfmt.fs.ImgChannel;

public class NETFileReader
extends ImgFile {
    private final NETHeader netHeader = new NETHeader();
    private final Map<Integer, Integer> offsetLabelMap = new HashMap<Integer, Integer>();
    private List<Integer> offsets;
    private List<City> cities;
    private int citySize;
    private List<Zip> zips;
    private int zipSize;
    private LBLFileReader labels;

    public NETFileReader(ImgChannel chan) {
        this.setHeader(this.netHeader);
        this.setReader(new BufferedImgFileReader(chan));
        this.netHeader.readHeader(this.getReader());
        this.readLabelOffsets();
    }

    public int getLabelOffset(int netOffset) {
        Integer off = this.offsetLabelMap.get(netOffset);
        if (off == null) {
            return 0;
        }
        return off;
    }

    public List<RoadDef> getRoads() {
        ImgFileReader reader = this.getReader();
        int start = this.netHeader.getRoadDefinitionsStart();
        ArrayList<RoadDef> roads = new ArrayList<RoadDef>();
        int record = 0;
        for (int off : this.offsets) {
            byte nodFlags;
            int nbytes;
            reader.position(start + off);
            RoadDef road = new RoadDef(++record, off, null);
            this.readLabels(reader, road);
            byte netFlags = reader.get();
            reader.getu3();
            int[] counts = new int[24];
            int level = 0;
            while (level < 24) {
                byte n = reader.get();
                counts[level++] = n & 0x7F;
                if ((n & 0x80) == 0) continue;
                break;
            }
            for (int i = 0; i < level; ++i) {
                int c = counts[i];
                for (int j = 0; j < c; ++j) {
                    reader.get();
                    reader.getChar();
                }
            }
            if ((netFlags & 0x10) != 0) {
                int index;
                char flags2 = reader.getChar();
                int zipFlag = flags2 >> 10 & 3;
                int cityFlag = flags2 >> 12 & 3;
                int numberFlag = flags2 >> 14 & 3;
                IntArrayList indexes = new IntArrayList();
                this.fetchZipCityIndexes(reader, zipFlag, this.zipSize, indexes);
                Iterator i$ = indexes.iterator();
                while (i$.hasNext()) {
                    index = (Integer)i$.next();
                    road.addZipIfNotPresent(this.zips.get(index));
                }
                this.fetchZipCityIndexes(reader, cityFlag, this.citySize, indexes);
                i$ = indexes.iterator();
                while (i$.hasNext()) {
                    index = (Integer)i$.next();
                    road.addCityIfNotPresent(this.cities.get(index));
                }
                this.fetchNumber(reader, numberFlag);
            }
            if ((netFlags & 0x40) != 0 && (nbytes = (nodFlags = reader.get()) & 3) > 0) {
                reader.getUint(nbytes + 1);
            }
            roads.add(road);
        }
        return roads;
    }

    private void fetchZipCityIndexes(ImgFileReader reader, int flag, int size, IntArrayList indexes) {
        indexes.clear();
        if (flag == 2) {
            int ind;
            int n = ind = size == 2 ? reader.getChar() : reader.get() & 0xFF;
            if (ind != 0) {
                indexes.add(ind - 1);
            }
        } else if (flag != 3) {
            if (flag == 0) {
                int n = reader.get() & 0xFF;
                this.parseList(reader, n, size, indexes);
            } else if (flag == 1) {
                char n = reader.getChar();
                this.parseList(reader, n, size, indexes);
            } else assert (false) : "flag is " + flag;
        }
    }

    private void parseList(ImgFileReader reader, int n, int size, IntArrayList indexes) {
        long endPos = reader.position() + (long)n;
        int node = 0;
        while (reader.position() < endPos) {
            int initFlag = reader.get() & 0xFF;
            int skip = initFlag & 0x1F;
            if ((initFlag >>= 5) == 7) {
                initFlag = reader.get() & 0xFF;
                skip |= (initFlag & 0x1F) << 5;
                initFlag >>= 5;
            }
            node += skip + 1;
            int right = 0;
            int left = 0;
            if (initFlag == 0) {
                right = left = this.getCityOrZip(reader, size, endPos);
            } else if ((initFlag & 4) != 0) {
                if ((initFlag & 1) == 0) {
                    right = 0;
                }
                if ((initFlag & 2) == 0) {
                    left = 0;
                }
            } else {
                if ((initFlag & 1) != 0) {
                    left = this.getCityOrZip(reader, size, endPos);
                }
                if ((initFlag & 2) != 0) {
                    right = this.getCityOrZip(reader, size, endPos);
                }
            }
            if (left > 0) {
                indexes.add(left - 1);
            }
            if (right <= 0 || left == right) continue;
            indexes.add(right - 1);
        }
    }

    private int getCityOrZip(ImgFileReader reader, int size, long endPos) {
        int cnum;
        if (reader.position() > endPos - (long)size) {
            assert (false) : "ERRROR overflow";
            return 0;
        }
        if (size == 1) {
            cnum = reader.get() & 0xFF;
        } else if (size == 2) {
            cnum = reader.getChar();
        } else {
            assert (false) : "unexpected size value" + size;
            return 0;
        }
        return cnum;
    }

    private void fetchNumber(ImgFileReader reader, int numberFlag) {
        char n = '\u0000';
        if (numberFlag == 0) {
            n = reader.get();
        } else if (numberFlag == 1) {
            n = reader.getChar();
        } else {
            if (numberFlag == 3) {
                return;
            }
            assert (false);
        }
        if (n > '\u0000') {
            reader.get(n);
        }
    }

    private void readLabels(ImgFileReader reader, RoadDef road) {
        for (int i = 0; i < 4; ++i) {
            int lab = reader.getu3();
            Label label = this.labels.fetchLabel(lab & 0x7FFFFF);
            road.addLabel(label);
            if ((lab & 0x800000) != 0) break;
        }
    }

    private void readLabelOffsets() {
        ImgFileReader reader = this.getReader();
        this.offsets = this.readOffsets();
        int start = this.netHeader.getRoadDefinitionsStart();
        for (int off : this.offsets) {
            reader.position(start + off);
            int labelOffset = reader.getu3();
            this.offsetLabelMap.put(off, labelOffset & 0x7FFFFF);
        }
    }

    private List<Integer> readOffsets() {
        int start = this.netHeader.getSortedRoadsStart();
        int end = this.netHeader.getSortedRoadsEnd();
        ImgFileReader reader = this.getReader();
        reader.position(start);
        ArrayList<Integer> offsets = new ArrayList<Integer>();
        while (reader.position() < (long)end) {
            int net1 = reader.getu3();
            int idx = net1 >> 22 & 3;
            if (idx != 0) continue;
            offsets.add((net1 & 0x3FFFFF) << this.netHeader.getRoadShift());
        }
        Collections.sort(offsets);
        return offsets;
    }

    public void setCities(List<City> cities) {
        this.cities = cities;
        this.citySize = cities.size() > 255 ? 2 : 1;
    }

    public void setZips(List<Zip> zips) {
        this.zips = zips;
        this.zipSize = zips.size() > 255 ? 2 : 1;
    }

    public void setLabels(LBLFileReader labels) {
        this.labels = labels;
    }
}

