/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.imgfmt.app.net;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import uk.me.parabola.imgfmt.app.Coord;
import uk.me.parabola.imgfmt.app.CoordNode;
import uk.me.parabola.imgfmt.app.ImgFileWriter;
import uk.me.parabola.imgfmt.app.net.RoadDef;
import uk.me.parabola.imgfmt.app.net.RouteArc;
import uk.me.parabola.imgfmt.app.net.RouteRestriction;
import uk.me.parabola.log.Logger;

public class RouteNode
implements Comparable<RouteNode> {
    private static final Logger log = Logger.getLogger(RouteNode.class);
    private static final int MAX_DEST_CLASS_MASK = 7;
    private static final int F_BOUNDARY = 8;
    private static final int F_RESTRICTIONS = 16;
    private static final int F_LARGE_OFFSETS = 32;
    private static final int F_ARCS = 64;
    private static final int F_DISCARDED = 256;
    private int offsetNod1 = -1;
    private final List<RouteArc> arcs = new ArrayList<RouteArc>(4);
    private final List<RouteRestriction> restrictions = new ArrayList<RouteRestriction>();
    private int flags;
    private final CoordNode coord;
    private char latOff;
    private char lonOff;
    private List<RouteArc[]> throughRoutes;
    private byte nodeClass;
    private byte nodeGroup = (byte)-1;

    public RouteNode(Coord coord) {
        this.coord = (CoordNode)coord;
        this.setBoundary(this.coord.getOnBoundary());
    }

    private boolean haveLargeOffsets() {
        return (this.flags & 0x20) != 0;
    }

    protected void setBoundary(boolean b) {
        this.flags = b ? (this.flags |= 8) : (this.flags &= 0xF7);
    }

    public boolean isBoundary() {
        return (this.flags & 8) != 0;
    }

    public void addArc(RouteArc arc) {
        this.arcs.add(arc);
        byte cl = (byte)arc.getRoadDef().getRoadClass();
        if (log.isDebugEnabled()) {
            log.debug("adding arc", arc.getRoadDef(), cl);
        }
        if (cl > this.nodeClass) {
            this.nodeClass = cl;
        }
        this.flags |= 0x40;
    }

    public void addRestriction(RouteRestriction restr) {
        this.restrictions.add(restr);
        this.flags |= 0x10;
    }

    public List<RouteArc> getDirectArcsTo(RouteNode otherNode, long roadId) {
        ArrayList<RouteArc> result = new ArrayList<RouteArc>();
        for (RouteArc a : this.arcs) {
            if (!a.isDirect() || a.getDest() != otherNode || a.getRoadDef().getId() != roadId) continue;
            result.add(a);
        }
        return result;
    }

    public List<RouteArc> getDirectArcsOnWay(long roadId) {
        ArrayList<RouteArc> result = new ArrayList<RouteArc>();
        for (RouteArc a : this.arcs) {
            if (!a.isDirect() || a.getRoadDef().getId() != roadId) continue;
            result.add(a);
        }
        return result;
    }

    public RouteArc getDirectArcTo(RouteNode otherNode, RoadDef roadDef) {
        for (RouteArc a : this.arcs) {
            if (!a.isDirect() || a.getDest() != otherNode || a.getRoadDef() != roadDef) continue;
            return a;
        }
        return null;
    }

    public int boundSize() {
        return 6 + this.arcsSize() + this.restrSize();
    }

    private int arcsSize() {
        int s = 0;
        for (RouteArc arc : this.arcs) {
            s += arc.boundSize();
        }
        return s;
    }

    private int restrSize() {
        return 2 * this.restrictions.size();
    }

    public void write(ImgFileWriter writer) {
        if (log.isDebugEnabled()) {
            log.debug("writing node, first pass, nod1", this.coord.getId());
        }
        this.offsetNod1 = writer.position();
        assert (this.offsetNod1 < 0x1000000) : "node offset doesn't fit in 3 bytes";
        assert ((this.flags & 0x100) == 0) : "attempt to write discarded node";
        writer.put((byte)0);
        this.flags |= this.nodeClass & 7;
        writer.put((byte)this.flags);
        if (this.haveLargeOffsets()) {
            writer.putInt(this.latOff << 16 | this.lonOff & 0xFFFF);
        } else {
            writer.put3(this.latOff << 12 | this.lonOff & 0xFFF);
        }
        if (!this.arcs.isEmpty()) {
            boolean useCompactDirs = true;
            IntArrayList initialHeadings = new IntArrayList(this.arcs.size() + 1);
            RouteArc lastArc = null;
            for (RouteArc arc : this.arcs) {
                if (lastArc == null || lastArc.getIndexA() != arc.getIndexA() || lastArc.isForward() != arc.isForward()) {
                    int dir = RouteArc.directionFromDegrees(arc.getInitialHeading());
                    if (initialHeadings.contains(dir &= 0xF0)) {
                        useCompactDirs = false;
                        break;
                    }
                    initialHeadings.add(dir);
                }
                lastArc = arc;
            }
            initialHeadings.add(0);
            this.arcs.get(this.arcs.size() - 1).setLast();
            lastArc = null;
            int index = 0;
            for (RouteArc arc : this.arcs) {
                Byte compactedDir = null;
                if (useCompactDirs && (lastArc == null || lastArc.getIndexA() != arc.getIndexA() || lastArc.isForward() != arc.isForward())) {
                    if (index % 2 == 0) {
                        compactedDir = (byte)(initialHeadings.get(index) >> 4 | initialHeadings.getInt(index + 1));
                    }
                    ++index;
                }
                arc.write(writer, lastArc, useCompactDirs, compactedDir);
                lastArc = arc;
            }
        }
        if (!this.restrictions.isEmpty()) {
            this.restrictions.get(this.restrictions.size() - 1).setLast();
            for (RouteRestriction restr : this.restrictions) {
                restr.writeOffset(writer);
            }
        }
    }

    public void writeNod3OrNod4(ImgFileWriter writer) {
        assert (this.isBoundary()) : "trying to write nod3 for non-boundary node";
        writer.put3(this.coord.getLongitude());
        writer.put3(this.coord.getLatitude());
        writer.put3(this.offsetNod1);
    }

    public void discard() {
        this.flags |= 0x100;
    }

    public int getOffsetNod1() {
        if ((this.flags & 0x100) != 0) {
            return 0;
        }
        assert (this.offsetNod1 != -1) : "failed for node " + this.coord.getId() + " at " + this.coord.toDegreeString();
        return this.offsetNod1;
    }

    public void setOffsets(Coord centralPoint) {
        if (log.isDebugEnabled()) {
            log.debug("center", centralPoint, ", coord", this.coord.toDegreeString());
        }
        this.setLatOff(this.coord.getLatitude() - centralPoint.getLatitude());
        this.setLonOff(this.coord.getLongitude() - centralPoint.getLongitude());
    }

    public Coord getCoord() {
        return this.coord;
    }

    private void checkOffSize(int off) {
        if (off > 2047 || off < -2048) {
            this.flags |= 0x20;
        }
        assert (off <= Short.MAX_VALUE && off >= Short.MIN_VALUE);
    }

    private void setLatOff(int latOff) {
        if (log.isDebugEnabled()) {
            log.debug("lat off", Integer.toHexString(latOff));
        }
        this.latOff = (char)latOff;
        this.checkOffSize(latOff);
    }

    private void setLonOff(int lonOff) {
        if (log.isDebugEnabled()) {
            log.debug("long off", Integer.toHexString(lonOff));
        }
        this.lonOff = (char)lonOff;
        this.checkOffSize(lonOff);
    }

    public void writeSecond(ImgFileWriter writer) {
        for (RouteArc arc : this.arcs) {
            arc.writeSecond(writer);
        }
    }

    public int getNodeClass() {
        return this.nodeClass;
    }

    public Iterable<? extends RouteArc> arcsIteration() {
        return new Iterable<RouteArc>(){

            @Override
            public Iterator<RouteArc> iterator() {
                return RouteNode.this.arcs.iterator();
            }
        };
    }

    public List<RouteRestriction> getRestrictions() {
        return this.restrictions;
    }

    public String toString() {
        return String.valueOf(this.coord.getId());
    }

    @Override
    public int compareTo(RouteNode otherNode) {
        return this.coord.compareTo(otherNode.getCoord());
    }

    public void checkRoundabouts() {
        ArrayList<RouteArc> roundaboutArcs = new ArrayList<RouteArc>();
        for (RouteArc a : this.arcs) {
            if (a.getRoadDef().isSynthesised() || !a.isDirect() || !a.getRoadDef().isRoundabout()) continue;
            roundaboutArcs.add(a);
        }
        if (this.arcs.size() > 1 && roundaboutArcs.size() == 1) {
            if (((RouteArc)roundaboutArcs.get(0)).isForward()) {
                log.warn((Object)("Roundabout " + ((RouteArc)roundaboutArcs.get(0)).getRoadDef() + " starts at " + this.coord.toOSMURL()));
            } else {
                log.warn((Object)("Roundabout " + ((RouteArc)roundaboutArcs.get(0)).getRoadDef() + " ends at " + this.coord.toOSMURL()));
            }
        }
        if (roundaboutArcs.size() > 2) {
            for (RouteArc fa : this.arcs) {
                if (!fa.isForward() || !fa.isDirect()) continue;
                RoadDef rd = fa.getRoadDef();
                for (RouteArc fb : this.arcs) {
                    if (fb != fa && fb.isDirect() && fa.getPointsHash() == fb.getPointsHash() && (fb.isForward() && fb.getDest() == fa.getDest() || !fb.isForward() && fb.getSource() == fa.getDest())) {
                        if (rd.messagePreviouslyIssued("roundabout forks/overlaps")) continue;
                        log.warn((Object)("Roundabout " + rd + " overlaps " + fb.getRoadDef() + " at " + this.coord.toOSMURL()));
                        continue;
                    }
                    if (fa == fb || !fb.isForward() || rd.messagePreviouslyIssued("roundabout forks/overlaps")) continue;
                    log.warn((Object)("Roundabout " + rd + " forks at " + this.coord.toOSMURL()));
                }
            }
        }
    }

    private static int roundaboutSegmentLength(RouteNode n1, RouteNode n2) {
        ArrayList<RouteNode> seen = new ArrayList<RouteNode>();
        int len = 0;
        RouteNode n = n1;
        boolean checkMoreLinks = true;
        block0: while (checkMoreLinks && !seen.contains(n)) {
            checkMoreLinks = false;
            seen.add(n);
            for (RouteArc a : n.arcs) {
                if (!a.isForward() || !a.getRoadDef().isRoundabout() || a.getRoadDef().isSynthesised()) continue;
                len += a.getLength();
                n = a.getDest();
                if (n == n2) {
                    return len;
                }
                checkMoreLinks = true;
                continue block0;
            }
        }
        return Integer.MAX_VALUE;
    }

    public void checkRoundaboutFlares(int maxFlareLengthRatio) {
        for (RouteArc r : this.arcs) {
            if (!r.isForward() || !r.isDirect() || !r.getRoadDef().isRoundabout() || r.getRoadDef().isSynthesised()) continue;
            RouteNode nb = r.getDest();
            ArrayList<RouteNode> seen = new ArrayList<RouteNode>();
            seen.add(this);
            while (true) {
                if (seen.contains(nb)) {
                    nb = null;
                    break;
                }
                seen.add(nb);
                boolean connectsToNonRoundaboutSegment = false;
                RouteArc nextRoundaboutArc = null;
                for (RouteArc nba : nb.arcs) {
                    if (!nba.isDirect() || nba.getRoadDef().isSynthesised()) continue;
                    if (nba.getRoadDef().isRoundabout()) {
                        if (!nba.isForward()) continue;
                        nextRoundaboutArc = nba;
                        continue;
                    }
                    connectsToNonRoundaboutSegment = true;
                }
                if (connectsToNonRoundaboutSegment) break;
                if (nextRoundaboutArc == null) {
                    nb = null;
                    break;
                }
                nb = nextRoundaboutArc.getDest();
            }
            if (nb == null) continue;
            for (RouteArc fa : this.arcs) {
                if (!fa.isDirect() || !fa.getRoadDef().doFlareCheck()) continue;
                for (RouteArc fb : nb.arcs) {
                    int maxFlareLength;
                    if (!fb.isDirect() || !fb.getRoadDef().doFlareCheck() || fa.getDest() != fb.getDest() || RouteNode.roundaboutSegmentLength(this, nb) >= RouteNode.roundaboutSegmentLength(nb, this) || maxFlareLengthRatio > 0 && (maxFlareLength = RouteNode.roundaboutSegmentLength(this, nb) * maxFlareLengthRatio) > 0 && fa.getLength() > maxFlareLength && fb.getLength() > maxFlareLength) continue;
                    if (!fa.isForward()) {
                        log.warn((Object)("Outgoing roundabout flare road " + fa.getRoadDef() + " points in wrong direction? " + fa.getSource().coord.toOSMURL()));
                        continue;
                    }
                    if (fb.isForward()) {
                        log.warn((Object)("Incoming roundabout flare road " + fb.getRoadDef() + " points in wrong direction? " + fb.getSource().coord.toOSMURL()));
                        continue;
                    }
                    if (!fa.getRoadDef().isOneway()) {
                        log.warn((Object)("Outgoing roundabout flare road " + fa.getRoadDef() + " is not oneway? " + fa.getSource().coord.toOSMURL()));
                        continue;
                    }
                    if (!fb.getRoadDef().isOneway()) {
                        log.warn((Object)("Incoming roundabout flare road " + fb.getRoadDef() + " is not oneway? " + fb.getDest().coord.toOSMURL()));
                        continue;
                    }
                    for (RouteArc a : fa.getDest().arcs) {
                        if (!a.isDirect() || a.getDest() == this || a.getDest() == nb) continue;
                        if (a.getRoadDef() == fa.getRoadDef()) {
                            log.warn((Object)("Outgoing roundabout flare road " + fb.getRoadDef() + " does not finish at flare? " + fa.getDest().coord.toOSMURL()));
                            continue;
                        }
                        if (a.getRoadDef() != fb.getRoadDef()) continue;
                        log.warn((Object)("Incoming roundabout flare road " + fb.getRoadDef() + " does not start at flare? " + fb.getDest().coord.toOSMURL()));
                    }
                }
            }
        }
    }

    public void reportSimilarArcs() {
        for (int i = 0; i < this.arcs.size(); ++i) {
            RouteArc arci = this.arcs.get(i);
            for (int j = i + 1; j < this.arcs.size(); ++j) {
                RouteArc arcj = this.arcs.get(j);
                if (arci.getDest() != arcj.getDest() || arci.getLength() != arcj.getLength() || arci.getPointsHash() != arcj.getPointsHash()) continue;
                log.warn((Object)("Similar arcs (" + arci.getRoadDef() + " and " + arcj.getRoadDef() + ") from " + this.coord.toOSMURL()));
            }
        }
    }

    public void addThroughRoute(long roadIdA, long roadIdB) {
        if (this.throughRoutes == null) {
            this.throughRoutes = new ArrayList<RouteArc[]>();
        }
        boolean success = false;
        block0: for (RouteArc arc1 : this.arcs) {
            if (arc1.getRoadDef().getId() == roadIdA) {
                for (RouteArc arc2 : this.arcs) {
                    if (arc2.getRoadDef().getId() != roadIdB) continue;
                    this.throughRoutes.add(new RouteArc[]{arc1.getReverseArc(), arc2});
                    success = true;
                    continue block0;
                }
                continue;
            }
            if (arc1.getRoadDef().getId() != roadIdB) continue;
            for (RouteArc arc2 : this.arcs) {
                if (arc2.getRoadDef().getId() != roadIdA) continue;
                this.throughRoutes.add(new RouteArc[]{arc1.getReverseArc(), arc2});
                success = true;
                continue block0;
            }
        }
        if (success) {
            log.info((Object)("Added through route between ways " + roadIdA + " and " + roadIdB + " at " + this.coord.toOSMURL()));
        } else {
            log.warn((Object)("Failed to add through route between ways " + roadIdA + " and " + roadIdB + " at " + this.coord.toOSMURL() + " - perhaps they don't meet here?"));
        }
    }

    public void addArcsToMajorRoads(RoadDef road) {
        assert (road.getNode() == this);
        RouteNode current = this;
        ArrayList<RouteNode> nodes = new ArrayList<RouteNode>();
        ArrayList<RouteArc> forwardArcs = new ArrayList<RouteArc>();
        IntArrayList forwardArcPositions = new IntArrayList();
        ArrayList<RouteArc> reverseArcs = new ArrayList<RouteArc>();
        IntArrayList reverseArcPositions = new IntArrayList();
        nodes.add(current);
        while (current != null) {
            RouteNode next = null;
            for (int i = 0; i < current.arcs.size(); ++i) {
                RouteArc arc = current.arcs.get(i);
                if (arc.getRoadDef() != road || !arc.isDirect()) continue;
                if (arc.isForward()) {
                    next = arc.getDest();
                    nodes.add(next);
                    forwardArcs.add(arc);
                    forwardArcPositions.add(i);
                    continue;
                }
                reverseArcPositions.add(i);
                reverseArcs.add(arc);
            }
            current = next;
        }
        if (nodes.size() < 3) {
            return;
        }
        ArrayList<RouteArc> newArcs = new ArrayList<RouteArc>();
        IntArrayList arcPositions = forwardArcPositions;
        ArrayList<RouteArc> roadArcs = forwardArcs;
        for (int dir = 0; dir < 2; ++dir) {
            int i = 0;
            while (i + 2 < nodes.size()) {
                RouteNode sourceNode = (RouteNode)nodes.get(i);
                RouteNode stepNode = (RouteNode)nodes.get(i + 1);
                RouteArc arcToStepNode = (RouteArc)roadArcs.get(i);
                assert (arcToStepNode.getDest() == stepNode);
                int currentClass = arcToStepNode.getArcDestClass();
                int finalClass = road.getRoadClass();
                if (finalClass > currentClass) {
                    newArcs.clear();
                    double partialArcLength = 0.0;
                    double pathLength = arcToStepNode.getLengthInMeter();
                    for (int j = i + 2; j < nodes.size(); ++j) {
                        RouteArc arcToDest = (RouteArc)roadArcs.get(j - 1);
                        partialArcLength += (double)arcToDest.getLengthInMeter();
                        pathLength += (double)arcToDest.getLengthInMeter();
                        int cl = ((RouteNode)nodes.get(j)).getGroup();
                        if (cl <= currentClass) continue;
                        if (cl > finalClass) {
                            cl = finalClass;
                        }
                        currentClass = cl;
                        RouteNode destNode = (RouteNode)nodes.get(j);
                        Coord c1 = sourceNode.getCoord();
                        Coord c2 = destNode.getCoord();
                        RouteArc newArc = new RouteArc(road, sourceNode, destNode, ((RouteArc)roadArcs.get(i)).getInitialHeading(), c1.bearingTo(c2), partialArcLength, pathLength, c1.distance(c2), c1.hashCode() + c2.hashCode());
                        if (arcToStepNode.isDirect()) {
                            arcToStepNode.setMaxDestClass(0);
                        } else {
                            newArc.setMaxDestClass(cl);
                        }
                        if (dir == 0) {
                            newArc.setForward();
                        }
                        newArc.setIndirect();
                        newArcs.add(newArc);
                        arcToStepNode = newArc;
                        stepNode = destNode;
                        partialArcLength = 0.0;
                        if (cl >= finalClass) break;
                    }
                    if (!newArcs.isEmpty()) {
                        int reverseArcPos;
                        int directArcPos = arcPositions.getInt(i);
                        assert (((RouteNode)nodes.get((int)i)).arcs.get(directArcPos).isDirect());
                        assert (((RouteNode)nodes.get((int)i)).arcs.get(directArcPos).getRoadDef() == ((RouteArc)newArcs.get(0)).getRoadDef());
                        assert (((RouteNode)nodes.get((int)i)).arcs.get(directArcPos).isForward() == ((RouteArc)newArcs.get(0)).isForward());
                        ((RouteNode)nodes.get((int)i)).arcs.addAll(directArcPos + 1, newArcs);
                        if (dir == 0 && i > 0 && directArcPos < (reverseArcPos = reverseArcPositions.get(i - 1).intValue())) {
                            reverseArcPositions.set(i - 1, reverseArcPos + newArcs.size());
                        }
                    }
                }
                ++i;
            }
            if (dir > 0) break;
            Collections.reverse(reverseArcs);
            Collections.reverse(reverseArcPositions);
            Collections.reverse(nodes);
            arcPositions = reverseArcPositions;
            roadArcs = reverseArcs;
        }
    }

    public int getGroup() {
        if (this.nodeGroup < 0) {
            HashSet<RoadDef> roads = new HashSet<RoadDef>();
            for (RouteArc arc : this.arcs) {
                roads.add(arc.getRoadDef());
            }
            int[] classes = new int[5];
            int numClasses = 0;
            for (RoadDef road : roads) {
                int cl;
                int n = cl = road.getRoadClass();
                classes[n] = classes[n] + 1;
                int n2 = classes[n];
                if (n2 == 1) {
                    ++numClasses;
                    continue;
                }
                if (n2 <= 1 || cl <= this.nodeGroup) continue;
                this.nodeGroup = (byte)cl;
            }
            if (this.nodeGroup >= 0) {
                return this.nodeGroup;
            }
            if (numClasses == 1) {
                this.nodeGroup = this.nodeClass;
            } else {
                int n = 0;
                for (int cl = 4; cl >= 0; --cl) {
                    if (classes[cl] <= 0) continue;
                    if (n == 1) {
                        this.nodeGroup = (byte)cl;
                        break;
                    }
                    ++n;
                }
            }
        }
        return this.nodeGroup;
    }

    public List<RouteArc> getArcs() {
        return this.arcs;
    }

    public int hashCode() {
        return this.getCoord().getId();
    }

    public List<RouteArc> getDirectArcsBetween(RouteNode otherNode) {
        ArrayList<RouteArc> result = new ArrayList<RouteArc>();
        for (RouteArc a : this.arcs) {
            if (!a.isDirect() || a.getDest() != otherNode) continue;
            result.add(a);
        }
        return result;
    }
}

