/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.imgfmt.app.trergn;

import java.util.List;
import uk.me.parabola.imgfmt.app.BitWriter;
import uk.me.parabola.imgfmt.app.Coord;
import uk.me.parabola.imgfmt.app.trergn.Polygon;
import uk.me.parabola.imgfmt.app.trergn.Polyline;
import uk.me.parabola.imgfmt.app.trergn.Subdivision;
import uk.me.parabola.log.Logger;

public class LinePreparer {
    private static final Logger log = Logger.getLogger(LinePreparer.class);
    private final Polyline polyline;
    private boolean extraBit;
    private final boolean extTypeLine;
    private boolean xSameSign;
    private boolean xSignNegative;
    private boolean ySameSign;
    private boolean ySignNegative;
    private int xBase;
    private int yBase;
    private int[] deltas;
    private boolean[] nodes;
    private boolean ignoreNumberOnlyNodes;

    LinePreparer(Polyline line) {
        if (line.isRoad() && line.getSubdiv().getZoom().getLevel() == 0 && line.roadHasInternalNodes()) {
            this.extraBit = true;
        }
        if (!line.hasHouseNumbers()) {
            this.ignoreNumberOnlyNodes = true;
        }
        this.extTypeLine = line.hasExtendedType();
        this.polyline = line;
        this.calcLatLong();
        this.calcDeltas();
    }

    public BitWriter makeBitStream(int minPointsRequired) {
        assert (this.xBase >= 0 && this.yBase >= 0);
        int xbits = 2;
        xbits = this.xBase < 10 ? (xbits += this.xBase) : (xbits += 2 * this.xBase - 9);
        int ybits = 2;
        ybits = this.yBase < 10 ? (ybits += this.yBase) : (ybits += 2 * this.yBase - 9);
        if (log.isDebugEnabled()) {
            log.debug("xbits", xbits, ", y=", ybits);
        }
        BitWriter bw = new BitWriter();
        bw.putn(this.xBase, 4);
        bw.putn(this.yBase, 4);
        bw.put1(this.xSameSign);
        if (this.xSameSign) {
            bw.put1(this.xSignNegative);
        }
        bw.put1(this.ySameSign);
        if (this.ySameSign) {
            bw.put1(this.ySignNegative);
        }
        if (log.isDebugEnabled()) {
            log.debug("x same is", this.xSameSign, "sign is", this.xSignNegative);
            log.debug("y same is", this.ySameSign, "sign is", this.ySignNegative);
        }
        if (this.extTypeLine) {
            bw.put1(false);
        }
        if (this.extraBit) {
            bw.put1(false);
        }
        int numPointsEncoded = 1;
        for (int i = 0; i < this.deltas.length; i += 2) {
            int dx = this.deltas[i];
            int dy = this.deltas[i + 1];
            if (dx == 0 && dy == 0 && this.extraBit && !this.nodes[i / 2 + 1] && i + 2 != this.deltas.length) continue;
            ++numPointsEncoded;
            if (log.isDebugEnabled()) {
                log.debug("x delta", dx, "~", xbits);
            }
            assert (dx >> xbits == 0 || dx >> xbits == -1);
            if (this.xSameSign) {
                bw.putn(Math.abs(dx), xbits);
            } else {
                assert (dx >= 0 || (dx & (1 << xbits) - 1) != 0);
                bw.putn(dx, xbits);
                bw.put1(dx < 0);
            }
            if (log.isDebugEnabled()) {
                log.debug("y delta", dy, ybits);
            }
            assert (dy >> ybits == 0 || dy >> ybits == -1);
            if (this.ySameSign) {
                bw.putn(Math.abs(dy), ybits);
            } else {
                assert (dy >= 0 || (dy & (1 << ybits) - 1) != 0);
                bw.putn(dy, ybits);
                bw.put1(dy < 0);
            }
            if (!this.extraBit) continue;
            bw.put1(this.nodes[i / 2 + 1]);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)bw);
        }
        if (numPointsEncoded < minPointsRequired) {
            return null;
        }
        return bw;
    }

    private void calcLatLong() {
        Coord co = this.polyline.getPoints().get(0);
        this.polyline.setLatitude(co.getLatitude());
        this.polyline.setLongitude(co.getLongitude());
    }

    private void calcDeltas() {
        int tmp;
        Subdivision subdiv = this.polyline.getSubdiv();
        if (log.isDebugEnabled()) {
            log.debug("label offset", this.polyline.getLabel().getOffset());
        }
        int shift = subdiv.getShift();
        List<Coord> points = this.polyline.getPoints();
        int numPointsToUse = points.size();
        if (this.polyline instanceof Polygon && points.get(0).equals(points.get(points.size() - 1))) {
            --numPointsToUse;
        }
        this.deltas = new int[2 * (numPointsToUse - 1)];
        if (this.extraBit) {
            this.nodes = new boolean[numPointsToUse];
        }
        boolean first = true;
        int lastLat = 0;
        int lastLong = 0;
        boolean xDiffSign = false;
        boolean yDiffSign = false;
        int xSign = 0;
        int ySign = 0;
        int minDx = Integer.MAX_VALUE;
        int maxDx = 0;
        int minDy = Integer.MAX_VALUE;
        int maxDy = 0;
        int firstsame = 0;
        for (int i = 0; i < numPointsToUse; ++i) {
            int thisSign;
            Coord co = points.get(i);
            int lat = subdiv.roundLatToLocalShifted(co.getLatitude());
            int lon = subdiv.roundLonToLocalShifted(co.getLongitude());
            if (log.isDebugEnabled()) {
                log.debug("shifted pos", lat, lon);
            }
            if (first) {
                lastLat = lat;
                lastLong = lon;
                first = false;
                continue;
            }
            int offset = 8 + shift;
            int dx = lon - lastLong << offset >> offset;
            int dy = lat - lastLat << offset >> offset;
            assert (!(dx == 0 && lon != lastLong)) : "delta lon too large: " + (lon - lastLong);
            assert (!(dy == 0 && lat != lastLat)) : "delta lat too large: " + (lat - lastLat);
            lastLong = lon;
            lastLat = lat;
            boolean isSpecialNode = false;
            if (co.getId() > 0 || co.isNumberNode() && !this.ignoreNumberOnlyNodes) {
                isSpecialNode = true;
            }
            if (dx != 0 || dy != 0 || this.extraBit && isSpecialNode) {
                firstsame = i;
            }
            if (this.extraBit) {
                boolean extra = false;
                if (isSpecialNode) {
                    extra = i < this.nodes.length - 1 ? true : !this.polyline.isLastSegment();
                }
                boolean bl = this.nodes[firstsame] = this.nodes[firstsame] || extra;
            }
            if (!xDiffSign) {
                int n = thisSign = dx >= 0 ? 1 : -1;
                if (xSign == 0) {
                    xSign = thisSign;
                } else if (thisSign != xSign) {
                    xDiffSign = true;
                }
            }
            if (!yDiffSign) {
                int n = thisSign = dy >= 0 ? 1 : -1;
                if (ySign == 0) {
                    ySign = thisSign;
                } else if (thisSign != ySign) {
                    yDiffSign = true;
                }
            }
            if (dx < minDx) {
                minDx = dx;
            }
            if (dx > maxDx) {
                maxDx = dx;
            }
            if (dy < minDy) {
                minDy = dy;
            }
            if (dy > maxDy) {
                maxDy = dy;
            }
            this.deltas[2 * (i - 1)] = dx;
            this.deltas[2 * (i - 1) + 1] = dy;
        }
        int xBits = Math.max(LinePreparer.bitsNeeded(minDx), LinePreparer.bitsNeeded(maxDx));
        int yBits = Math.max(LinePreparer.bitsNeeded(minDy), LinePreparer.bitsNeeded(maxDy));
        if (log.isDebugEnabled()) {
            log.debug("initial xBits, yBits", xBits, yBits);
        }
        if (xBits < 2) {
            xBits = 2;
        }
        if ((tmp = xBits - 2) > 10) {
            if ((tmp & 1) == 0) {
                ++tmp;
            }
            tmp = 9 + (tmp - 9) / 2;
        }
        this.xBase = tmp;
        if (yBits < 2) {
            yBits = 2;
        }
        if ((tmp = yBits - 2) > 10) {
            if ((tmp & 1) == 0) {
                ++tmp;
            }
            tmp = 9 + (tmp - 9) / 2;
        }
        this.yBase = tmp;
        if (log.isDebugEnabled()) {
            log.debug("initial xBase, yBase", this.xBase, this.yBase);
        }
        this.xSameSign = !xDiffSign;
        this.ySameSign = !yDiffSign;
        this.xSignNegative = xSign < 0;
        this.ySignNegative = ySign < 0;
    }

    public static int bitsNeeded(int val) {
        int count;
        int n = Math.abs(val);
        int n2 = count = val < 0 ? 1 : 0;
        while (n != 0) {
            n >>>= 1;
            ++count;
        }
        return count;
    }

    public boolean isExtraBit() {
        return this.extraBit;
    }
}

