/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.imgfmt.app.trergn;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import uk.me.parabola.imgfmt.app.BitWriter;
import uk.me.parabola.imgfmt.app.Coord;
import uk.me.parabola.imgfmt.app.ImgFileWriter;
import uk.me.parabola.imgfmt.app.Label;
import uk.me.parabola.imgfmt.app.net.RoadDef;
import uk.me.parabola.imgfmt.app.trergn.LinePreparer;
import uk.me.parabola.imgfmt.app.trergn.MapObject;
import uk.me.parabola.imgfmt.app.trergn.Polygon;
import uk.me.parabola.imgfmt.app.trergn.Subdivision;
import uk.me.parabola.log.Logger;

public class Polyline
extends MapObject {
    private static final Logger log = Logger.getLogger(Polyline.class);
    private static final int FLAG_NETINFO = 0x800000;
    private static final int FLAG_EXTRABIT = 0x400000;
    private static final int FLAG_DIR = 64;
    private static final int FLAG_2BYTE_LEN = 128;
    private RoadDef roaddef;
    private boolean lastSegment = true;
    private boolean direction;
    private final List<Coord> points = new ArrayList<Coord>();

    public Polyline(Subdivision div) {
        this.setSubdiv(div);
    }

    @Override
    public void write(ImgFileWriter file) {
        LinePreparer w;
        try {
            w = new LinePreparer(this);
        }
        catch (AssertionError ae) {
            log.error((Object)("Problem writing line (" + this.getClass() + ") of type 0x" + Integer.toHexString(this.getType()) + " containing " + this.points.size() + " points and starting at " + this.points.get(0).toOSMURL()));
            log.error((Object)("  Subdivision shift is " + this.getSubdiv().getShift() + " and its centre is at " + this.getSubdiv().getCenter().toOSMURL()));
            log.error((Object)("  " + ((Throwable)((Object)ae)).getMessage()));
            if (this.roaddef != null) {
                log.error((Object)("  Way is " + this.roaddef));
            }
            return;
        }
        int minPointsRequired = this instanceof Polygon ? 3 : 2;
        BitWriter bw = w.makeBitStream(minPointsRequired);
        if (bw == null) {
            log.error((Object)("Level " + this.getSubdiv().getZoom().getLevel() + " " + (this instanceof Polygon ? "polygon" : "polyline") + " has less than " + minPointsRequired + " points, discarding"));
            return;
        }
        byte b1 = (byte)this.getType();
        if (this.direction) {
            b1 = (byte)(b1 | 0x40);
        }
        int blen = bw.getLength() - 1;
        assert (blen > 0) : "zero length bitstream";
        assert (blen < 65536) : "bitstream too long " + blen;
        if (blen >= 256) {
            b1 = (byte)(b1 | 0x80);
        }
        file.put(b1);
        int loff = this.getLabel().getOffset();
        if (w.isExtraBit()) {
            loff |= 0x400000;
        }
        if (this.roaddef != null) {
            this.roaddef.addLabel(this.getLabel());
            this.roaddef.addOffsetTarget(file.position(), 0x800000 | loff & 0x400000);
            List<Label> refLabels = this.getRefLabels();
            if (refLabels != null) {
                for (Label rl : refLabels) {
                    this.roaddef.addLabel(rl);
                }
            }
        }
        file.put3(loff);
        file.putChar((char)this.getDeltaLong());
        file.putChar((char)this.getDeltaLat());
        if (log.isDebugEnabled()) {
            log.debug("out center", this.getDeltaLat(), this.getDeltaLong());
        }
        if (blen < 256) {
            file.put((byte)(blen & 0xFF));
        } else {
            file.putChar((char)(blen & 0xFFFF));
        }
        file.put(bw.getBytes(), 0, blen + 1);
    }

    @Override
    public void write(OutputStream stream) throws IOException {
        LinePreparer w;
        assert (this.hasExtendedType());
        int type = this.getType();
        int labelOff = this.getLabel().getOffset();
        byte[] extraBytes = this.getExtTypeExtraBytes();
        try {
            w = new LinePreparer(this);
        }
        catch (AssertionError ae) {
            log.error((Object)("Problem writing line (" + this.getClass() + ") of type 0x" + Integer.toHexString(this.getType()) + " containing " + this.points.size() + " points and starting at " + this.points.get(0).toOSMURL()));
            log.error((Object)("  Subdivision shift is " + this.getSubdiv().getShift() + " and its centre is at " + this.getSubdiv().getCenter().toOSMURL()));
            log.error((Object)("  " + ((Throwable)((Object)ae)).getMessage()));
            if (this.roaddef != null) {
                log.error((Object)("  Way is " + this.roaddef));
            }
            return;
        }
        int minPointsRequired = this instanceof Polygon ? 3 : 2;
        BitWriter bw = w.makeBitStream(minPointsRequired);
        if (bw == null) {
            log.error((Object)("Level " + this.getSubdiv().getZoom().getLevel() + " " + (this instanceof Polygon ? "polygon" : "polyline") + " has less than " + minPointsRequired + " points, discarding"));
            return;
        }
        int blen = bw.getLength();
        assert (blen > 1) : "zero length bitstream";
        assert (blen < 65536) : "bitstream too long " + blen;
        if (labelOff != 0) {
            type |= 0x20;
        }
        if (extraBytes != null) {
            type |= 0x80;
        }
        stream.write(type >> 8);
        stream.write(type);
        int deltaLong = this.getDeltaLong();
        int deltaLat = this.getDeltaLat();
        stream.write(deltaLong);
        stream.write(deltaLong >> 8);
        stream.write(deltaLat);
        stream.write(deltaLat >> 8);
        if (blen >= 127) {
            stream.write(blen << 2 | 2);
            stream.write(blen << 2 >> 8);
        } else {
            stream.write(blen << 1 | 1);
        }
        stream.write(bw.getBytes(), 0, blen);
        if (labelOff != 0) {
            stream.write(labelOff);
            stream.write(labelOff >> 8);
            stream.write(labelOff >> 16);
        }
        if (extraBytes != null) {
            stream.write(extraBytes);
        }
    }

    public void addCoord(Coord co) {
        this.points.add(co);
    }

    public void addCoords(List<Coord> coords) {
        this.points.addAll(coords);
    }

    public List<Coord> getPoints() {
        return this.points;
    }

    public void setDirection(boolean direction) {
        this.direction = direction;
    }

    public boolean isRoad() {
        return this.roaddef != null;
    }

    public boolean roadHasInternalNodes() {
        return this.roaddef.hasInternalNodes();
    }

    public void setLastSegment(boolean last) {
        this.lastSegment = last;
    }

    public boolean isLastSegment() {
        return this.lastSegment;
    }

    public void setRoadDef(RoadDef rd) {
        this.roaddef = rd;
    }

    public int getOffsetNet1() {
        if (!this.isRoad()) {
            return 0;
        }
        return this.roaddef.getOffsetNet1();
    }

    public boolean sharesNodeWith(Polyline other) {
        for (Coord p1 : this.points) {
            if (p1.getId() == 0) continue;
            for (Coord p2 : other.points) {
                if (p1.getId() != p2.getId()) continue;
                return true;
            }
        }
        return false;
    }

    public int getLat() {
        return this.getSubdiv().getLatitude() + (this.getDeltaLat() << this.getSubdiv().getShift());
    }

    public int getLong() {
        return this.getSubdiv().getLongitude() + (this.getDeltaLong() << this.getSubdiv().getShift());
    }

    public int getNodeCount(boolean countAllNodes) {
        int idx = 0;
        int count = 0;
        for (Coord co : this.points) {
            if (idx++ <= 0 || co.getId() <= 0 && (!countAllNodes || !co.isNumberNode())) continue;
            ++count;
        }
        return count;
    }

    public boolean hasHouseNumbers() {
        if (!this.isRoad()) {
            return false;
        }
        return this.roaddef.hasHouseNumbers();
    }
}

