/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.imgfmt.app.typ;

import uk.me.parabola.imgfmt.app.CommonHeader;
import uk.me.parabola.imgfmt.app.ImgFileReader;
import uk.me.parabola.imgfmt.app.ImgFileWriter;
import uk.me.parabola.imgfmt.app.Section;

public class TYPHeader
extends CommonHeader {
    public static final int HEADER_LEN = 156;
    private char familyId;
    private char productId;
    private char codePage;
    private final Section pointData = new Section();
    private final Section lineData = new Section(this.pointData);
    private final Section polygonData = new Section(this.lineData);
    private final Section pointIndex = new Section(this.polygonData, '\u0002');
    private final Section lineIndex = new Section(this.pointIndex, '\u0002');
    private final Section polygonIndex = new Section(this.lineIndex, '\u0002');
    private final Section shapeStacking = new Section(this.polygonIndex, '\u0005');
    private final Section iconData = new Section(this.polygonIndex);
    private final Section iconIndex = new Section(this.iconData, '\u0003');
    private final Section labels = new Section(this.iconIndex);
    private final Section stringIndex = new Section(this.labels);
    private final Section typeIndex = new Section(this.stringIndex);

    public TYPHeader() {
        super(156, "GARMIN TYP");
    }

    @Override
    protected void readFileHeader(ImgFileReader reader) {
        reader.position(21L);
        this.codePage = reader.getChar();
        this.pointData.setPosition(reader.getInt());
        this.pointData.setSize(reader.getInt());
        this.lineData.setPosition(reader.getInt());
        this.lineData.setSize(reader.getInt());
        this.polygonData.setPosition(reader.getInt());
        this.polygonData.setSize(reader.getInt());
        this.familyId = reader.getChar();
        this.productId = reader.getChar();
        this.pointIndex.setPosition(reader.getInt());
        this.pointIndex.setItemSize(reader.getChar());
        this.pointIndex.setSize(reader.getInt());
        this.lineIndex.setPosition(reader.getInt());
        this.lineIndex.setItemSize(reader.getChar());
        this.lineIndex.setSize(reader.getInt());
        this.polygonIndex.setPosition(reader.getInt());
        this.polygonIndex.setItemSize(reader.getChar());
        this.polygonIndex.setSize(reader.getInt());
        this.shapeStacking.setPosition(reader.getInt());
        this.shapeStacking.setItemSize(reader.getChar());
        this.shapeStacking.setSize(reader.getInt());
    }

    @Override
    protected void writeFileHeader(ImgFileWriter writer) {
        writer.putChar(this.codePage);
        this.pointData.writeSectionInfo(writer);
        this.lineData.writeSectionInfo(writer);
        this.polygonData.writeSectionInfo(writer);
        writer.putChar(this.familyId);
        writer.putChar(this.productId);
        this.writeSectionInfo(writer, this.pointIndex);
        this.writeSectionInfo(writer, this.lineIndex);
        this.writeSectionInfo(writer, this.polygonIndex);
        this.writeSectionInfo(writer, this.shapeStacking);
        if (this.getHeaderLength() > 91) {
            this.writeSectionInfo(writer, this.iconIndex);
            writer.put((byte)19);
            this.iconData.writeSectionInfo(writer);
            writer.putInt(0);
        }
        if (this.getHeaderLength() > 110) {
            this.labels.writeSectionInfo(writer);
            writer.putInt(this.stringIndex.getItemSize());
            writer.putInt(27);
            writer.putInt(this.stringIndex.getPosition());
            writer.putInt(this.stringIndex.getSize());
            writer.putInt(this.typeIndex.getItemSize());
            writer.putInt(27);
            writer.putInt(this.typeIndex.getPosition());
            writer.putInt(this.typeIndex.getSize());
            writer.putChar('\u0000');
        }
    }

    private void writeSectionInfo(ImgFileWriter writer, Section section) {
        writer.putInt(section.getPosition());
        writer.putChar(section.getItemSize());
        writer.putInt(section.getSize());
    }

    void setCodePage(char codePage) {
        this.codePage = codePage;
    }

    Section getPointData() {
        return this.pointData;
    }

    void setFamilyId(char familyId) {
        this.familyId = familyId;
    }

    void setProductId(char productId) {
        this.productId = productId;
    }

    Section getPointIndex() {
        return this.pointIndex;
    }

    Section getShapeStacking() {
        return this.shapeStacking;
    }

    public Section getPolygonData() {
        return this.polygonData;
    }

    public Section getPolygonIndex() {
        return this.polygonIndex;
    }

    public Section getLineData() {
        return this.lineData;
    }

    public Section getLineIndex() {
        return this.lineIndex;
    }

    public Section getIconData() {
        return this.iconData;
    }

    public Section getIconIndex() {
        return this.iconIndex;
    }

    public Section getLabels() {
        return this.labels;
    }

    public Section getStringIndex() {
        return this.stringIndex;
    }

    public Section getTypeIndex() {
        return this.typeIndex;
    }
}

