/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.imgfmt.app.typ;

import java.nio.charset.CharsetEncoder;
import java.util.ArrayList;
import java.util.List;
import uk.me.parabola.imgfmt.app.ImgFileWriter;
import uk.me.parabola.imgfmt.app.typ.ColourInfo;
import uk.me.parabola.imgfmt.app.typ.TypElement;
import uk.me.parabola.imgfmt.app.typ.TypLabel;
import uk.me.parabola.imgfmt.app.typ.Xpm;

public class TypIconSet
extends TypElement {
    private final List<Xpm> icons = new ArrayList<Xpm>();

    @Override
    public void write(ImgFileWriter writer, CharsetEncoder encoder) {
        this.offset = writer.position();
        writer.put((byte)this.icons.size());
        for (Xpm xpm : this.icons) {
            ColourInfo colourInfo = xpm.getColourInfo();
            int nbits = this.calcBits(colourInfo);
            writer.putChar((char)(nbits / 2));
            writer.put((byte)1);
            writer.put((byte)colourInfo.getWidth());
            writer.put((byte)colourInfo.getHeight());
            this.writeImage(writer, xpm);
        }
    }

    private int calcBits(ColourInfo colourInfo) {
        int bits = 0;
        int bpp = colourInfo.getBitsPerPixel();
        bits += colourInfo.getWidth() * colourInfo.getHeight() * bpp;
        bits += colourInfo.getNumberOfSColoursForCM() * 3 * 8;
        if (colourInfo.getNumberOfColours() == 0 && colourInfo.getColourMode() == 16) {
            bits += 24;
        }
        return bits += 44;
    }

    public void addIcon(Xpm xpm) {
        this.icons.add(xpm);
    }

    public String getLabel() {
        if (this.labels.isEmpty()) {
            return null;
        }
        return ((TypLabel)this.labels.get(0)).getText();
    }

    @Override
    public boolean simpleBitmap() {
        return false;
    }
}

