/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.mkgmap.build;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import uk.me.parabola.log.Logger;
import uk.me.parabola.mkgmap.build.LocatorConfig;
import uk.me.parabola.mkgmap.build.LocatorUtil;
import uk.me.parabola.mkgmap.general.MapPoint;
import uk.me.parabola.mkgmap.reader.osm.Tags;
import uk.me.parabola.util.EnhancedProperties;
import uk.me.parabola.util.KdTree;
import uk.me.parabola.util.MultiHashMap;

public class Locator {
    private static final Logger log = Logger.getLogger(Locator.class);
    private final MultiHashMap<String, MapPoint> cityMap = new MultiHashMap();
    private final KdTree<MapPoint> cityFinder = new KdTree();
    private final List<MapPoint> placesMap = new ArrayList<MapPoint>();
    private final List<String> nameTags;
    private final LocatorConfig locConfig = LocatorConfig.get();
    private final Set<String> locationAutofill;
    private static final double MAX_CITY_DIST = 30000.0;
    private static final String[] PREFERRED_NAME_TAGS = new String[]{"name", "name:en", "int_name"};

    public Locator() {
        this(new EnhancedProperties());
    }

    public Locator(EnhancedProperties props) {
        this.nameTags = LocatorUtil.getNameTags(props);
        this.locationAutofill = new HashSet<String>(LocatorUtil.parseAutofillOption(props));
    }

    public void addCityOrPlace(MapPoint p) {
        if (!p.isCity()) {
            log.warn((Object)("MapPoint has no city type id: 0x" + Integer.toHexString(p.getType())));
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("S City 0x" + Integer.toHexString(p.getType()), p.getName(), "|", p.getCity(), "|", p.getRegion(), "|", p.getCountry());
        }
        if (p.getCountry() != null) {
            p.setCountry(this.normalizeCountry(p.getCountry()));
        }
        this.resolveIsInInfo(p);
        if (p.getCity() != null) {
            if (log.isDebugEnabled()) {
                log.debug(p.getCity(), p.getRegion(), p.getCountry());
            }
            this.addCity(p.getName(), p);
        } else {
            this.placesMap.add(p);
        }
        if (log.isDebugEnabled()) {
            log.debug("E City 0x" + Integer.toHexString(p.getType()), p.getName(), "|", p.getCity(), "|", p.getRegion(), "|", p.getCountry());
        }
    }

    public void setDefaultCountry(String country, String abbr) {
        this.locConfig.setDefaultCountry(country, abbr);
    }

    public String normalizeCountry(String country) {
        String normedCountryName;
        if (country == null) {
            return null;
        }
        String iso = this.locConfig.getCountryISOCode(country);
        if (iso != null && (normedCountryName = this.locConfig.getCountryName(iso, this.nameTags)) != null) {
            log.debug("Country:", country, "ISO:", iso, "Norm:", normedCountryName);
            return normedCountryName;
        }
        log.debug("Country:", country, "ISO:", iso, "Norm:", country);
        return country;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String addCountry(Tags tags) {
        LocatorConfig locatorConfig = this.locConfig;
        synchronized (locatorConfig) {
            String iso = this.getCountryISOCode(tags);
            if (iso == null) {
                log.warn("Cannot find iso code for country with tags", tags);
            } else {
                this.locConfig.addCountryWithTags(iso, tags);
            }
            return iso;
        }
    }

    public String getCountryISOCode(Tags countryTags) {
        for (String nameTag : PREFERRED_NAME_TAGS) {
            String nameValue = countryTags.get(nameTag);
            String isoCode = this.getCountryISOCode(nameValue);
            if (isoCode == null) continue;
            return isoCode;
        }
        for (String countryStr : countryTags.getTagsWithPrefix("name:", false).values()) {
            String isoCode = this.getCountryISOCode(countryStr);
            if (isoCode == null) continue;
            return isoCode;
        }
        return null;
    }

    public String getCountryISOCode(String country) {
        return this.locConfig.getCountryISOCode(country);
    }

    public int getPOIDispFlag(String country) {
        return this.locConfig.getPoiDispFlag(this.getCountryISOCode(country));
    }

    private boolean isContinent(String continent) {
        return this.locConfig.isContinent(continent);
    }

    private void resolveIsInInfo(MapPoint p) {
        if (!this.locationAutofill.contains("is_in")) {
            return;
        }
        if (p.getCountry() != null && p.getRegion() != null && p.getCity() == null) {
            p.setCity(p.getName());
            return;
        }
        if (p.getIsIn() != null) {
            String isoCode;
            String[] cityList = p.getIsIn().split(",");
            if (cityList.length > 1 && this.isContinent(cityList[cityList.length - 1])) {
                int offset;
                if (p.getCountry() == null) {
                    p.setCountry(this.normalizeCountry(cityList[cityList.length - 2].trim()));
                }
                if (cityList.length > (offset = this.locConfig.getRegionOffset(this.getCountryISOCode(p.getCountry())) + 1) && p.getRegion() == null) {
                    p.setRegion(cityList[cityList.length - (offset + 1)].trim());
                }
            } else if (cityList.length > 1 && this.isContinent(cityList[0])) {
                int offset;
                if (p.getCountry() == null) {
                    p.setCountry(this.normalizeCountry(cityList[1].trim()));
                }
                if (cityList.length > (offset = this.locConfig.getRegionOffset(this.getCountryISOCode(p.getCountry())) + 1) && p.getRegion() == null) {
                    p.setRegion(cityList[offset].trim());
                }
            } else if (p.getCountry() == null && cityList.length > 0 && (isoCode = this.locConfig.getCountryISOCode(cityList[cityList.length - 1])) != null) {
                p.setCountry(this.normalizeCountry(isoCode));
                int offset = this.locConfig.getRegionOffset(isoCode) + 1;
                if (cityList.length > offset && p.getRegion() == null) {
                    p.setRegion(cityList[cityList.length - (offset + 1)].trim());
                }
            }
        }
        if (p.getCountry() != null && p.getRegion() != null && p.getCity() == null) {
            p.setCity(p.getName());
        }
    }

    public MapPoint findNextPoint(MapPoint p) {
        return this.cityFinder.findNextPoint(p);
    }

    public MapPoint findNearbyCityByName(MapPoint p) {
        if (p.getCity() == null) {
            return null;
        }
        Object nextCityList = this.cityMap.get(p.getCity());
        if (nextCityList.isEmpty()) {
            return null;
        }
        MapPoint near = null;
        double minDist = Double.MAX_VALUE;
        Iterator i$ = nextCityList.iterator();
        while (i$.hasNext()) {
            MapPoint nextCity = (MapPoint)i$.next();
            double dist = p.getLocation().distance(nextCity.getLocation());
            if (!(dist < minDist)) continue;
            minDist = dist;
            near = nextCity;
        }
        if (minDist <= 30000.0) {
            return near;
        }
        return null;
    }

    private MapPoint findCityByIsIn(MapPoint place) {
        if (!this.locationAutofill.contains("is_in")) {
            return null;
        }
        String isIn = place.getIsIn();
        if (isIn == null) {
            return null;
        }
        String[] cityList = isIn.split(",");
        double minDist = Double.MAX_VALUE;
        ArrayList nextCityList = null;
        for (String cityCandidate : cityList) {
            Object candidateCityList = this.cityMap.get(cityCandidate = cityCandidate.trim());
            if (candidateCityList.isEmpty()) continue;
            if (nextCityList == null) {
                nextCityList = new ArrayList(candidateCityList.size());
            }
            nextCityList.addAll(candidateCityList);
        }
        if (nextCityList == null) {
            return null;
        }
        MapPoint nearbyCity = null;
        for (MapPoint nextCity : nextCityList) {
            double dist = place.getLocation().distance(nextCity.getLocation());
            if (!(dist < minDist)) continue;
            minDist = dist;
            nearbyCity = nextCity;
        }
        if (minDist > 30000.0) {
            log.warn("is_in of", place.getName(), "is far away from", nearbyCity.getName(), minDist / 1000.0, "km is_in", place.getIsIn());
            log.warn("Number of cities with this name:", nextCityList.size());
        }
        return nearbyCity;
    }

    public void autofillCities() {
        int unresCount;
        if (!this.locationAutofill.contains("nearest") && !this.locationAutofill.contains("is_in")) {
            return;
        }
        log.info("Locator City   Map contains", this.cityMap.size(), "entries");
        log.info("Locator Places Map contains", this.placesMap.size(), "entries");
        log.info("Locator Finder KdTree contains", this.cityFinder.size(), "entries");
        int runCount = 0;
        int maxRuns = 2;
        do {
            unresCount = 0;
            for (MapPoint place : this.placesMap) {
                if (place == null) continue;
                MapPoint near = this.findCityByIsIn(place);
                if (near == null) {
                    // empty if block
                }
                if (near != null) {
                    if (place.getCity() == null) {
                        place.setCity(near.getCity());
                    }
                    if (place.getZip() == null) {
                        place.setZip(near.getZip());
                    }
                } else if (this.locationAutofill.contains("nearest") && runCount + 1 == maxRuns && (near = this.cityFinder.findNextPoint(place)) != null && near.getCountry() != null && place.getCity() == null) {
                    place.setCity(place.getName());
                }
                if (near != null) {
                    if (place.getRegion() == null) {
                        place.setRegion(near.getRegion());
                    }
                    if (place.getCountry() == null) {
                        place.setCountry(near.getCountry());
                    }
                }
                if (near != null) continue;
                ++unresCount;
            }
            for (int i = 0; i < this.placesMap.size(); ++i) {
                MapPoint place;
                place = this.placesMap.get(i);
                if (place == null) continue;
                if (place.getCity() != null) {
                    this.addCity(place.getName(), place);
                    this.placesMap.set(i, null);
                    continue;
                }
                if (runCount + 1 != maxRuns) continue;
                place.setCity(place.getName());
                this.addCity(place.getName(), place);
            }
            log.info("Locator City   Map contains", this.cityMap.size(), "entries after resolver run", ++runCount, "Still unresolved", unresCount);
        } while (unresCount > 0 && runCount < maxRuns);
    }

    private void addCity(String name, MapPoint p) {
        if (name != null) {
            this.cityMap.add(name, p);
            this.cityFinder.add(p);
        }
    }
}

