/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.mkgmap.build;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Pattern;
import uk.me.parabola.util.EnhancedProperties;

public class LocatorUtil {
    private static final Pattern COMMA_OR_SPACE_PATTERN = Pattern.compile("[,\\s]+");

    public static List<String> getNameTags(Properties props) {
        String nameTagProp = props.getProperty("name-tag-list", "name");
        return Arrays.asList(COMMA_OR_SPACE_PATTERN.split(nameTagProp));
    }

    public static Set<String> parseAutofillOption(EnhancedProperties props) {
        String optionStr = props.getProperty("location-autofill", null);
        if (optionStr == null) {
            return Collections.emptySet();
        }
        HashSet<String> autofillOptions = new HashSet<String>(Arrays.asList(COMMA_OR_SPACE_PATTERN.split(optionStr)));
        if (autofillOptions.contains("0")) {
            autofillOptions.add("is_in");
            autofillOptions.remove("0");
        }
        if (autofillOptions.contains("1")) {
            autofillOptions.add("is_in");
            autofillOptions.remove("1");
        }
        if (autofillOptions.contains("2")) {
            autofillOptions.add("is_in");
            autofillOptions.add("nearest");
            autofillOptions.remove("2");
        }
        if (autofillOptions.contains("3")) {
            autofillOptions.add("is_in");
            autofillOptions.add("nearest");
            autofillOptions.remove("3");
        }
        List<String> knownOptions = Arrays.asList("bounds", "is_in", "nearest");
        for (String s : autofillOptions) {
            if (knownOptions.contains(s)) continue;
            throw new IllegalArgumentException(s + " is not a known sub option for option location-autofill: " + optionStr);
        }
        return autofillOptions;
    }
}

