/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.mkgmap.build;

import java.util.ArrayList;
import java.util.List;
import uk.me.parabola.imgfmt.app.Area;
import uk.me.parabola.imgfmt.app.trergn.Zoom;
import uk.me.parabola.log.Logger;
import uk.me.parabola.mkgmap.build.MapArea;
import uk.me.parabola.mkgmap.general.MapDataSource;

public class MapSplitter {
    private static final Logger log = Logger.getLogger(MapSplitter.class);
    private final MapDataSource mapSource;
    public static final int MAX_DIVISION_SIZE = Short.MAX_VALUE;
    public static final int MAX_RGN_SIZE = 65528;
    public static final int MAX_NUM_LINES = 255;
    public static final int MAX_NUM_POINTS = 255;
    public static final int MAX_XT_POINTS_SIZE = 65280;
    public static final int MAX_XT_LINES_SIZE = 65280;
    public static final int MAX_XT_SHAPES_SIZE = 65280;
    public static final int MIN_DIMENSION = 10;
    private static final int WANTED_MAX_AREA_SIZE = 16383;
    private final Zoom zoom;

    MapSplitter(MapDataSource mapSource, Zoom zoom) {
        this.mapSource = mapSource;
        this.zoom = zoom;
    }

    public MapArea[] split() {
        log.debug("orig area", this.mapSource.getBounds());
        MapArea ma = this.initialArea(this.mapSource);
        MapArea[] areas = this.splitMaxSize(ma);
        ArrayList<MapArea> alist = new ArrayList<MapArea>();
        this.addAreasToList(areas, alist, 0);
        MapArea[] results = new MapArea[alist.size()];
        return alist.toArray(results);
    }

    private void addAreasToList(MapArea[] areas, List<MapArea> alist, int depth) {
        int res = this.zoom.getResolution();
        for (MapArea area : areas) {
            Area bounds = area.getBounds();
            int[] sizes = area.getEstimatedSizes();
            if (!area.hasData()) continue;
            if (log.isInfoEnabled()) {
                String padding = depth + "                                                                      ";
                log.info((Object)(padding.substring(0, (depth + 1) * 2) + bounds.getWidth() + "x" + bounds.getHeight() + ", res = " + res + ", points = " + area.getNumPoints() + "/" + sizes[0] + ", lines = " + area.getNumLines() + "/" + sizes[1] + ", shapes = " + area.getNumShapes() + "/" + sizes[2]));
            }
            boolean doSplit = false;
            if (area.getNumLines() > 255 || area.getNumPoints() > 255 || sizes[0] + sizes[1] + sizes[2] > 65528 || sizes[3] > 65280 || sizes[4] > 65280 || sizes[5] > 65280) {
                doSplit = true;
            } else if (bounds.getMaxDimension() > 10) {
                int sumSize = 0;
                for (int s : sizes) {
                    sumSize += s;
                }
                if (sumSize > 16383 && area.getLines().size() + area.getShapes().size() >= 2) {
                    log.debug((Object)("splitting area because size is larger than wanted: " + sumSize));
                    doSplit = true;
                }
            }
            if (doSplit) {
                if (bounds.getMaxDimension() > 10) {
                    if (log.isDebugEnabled()) {
                        log.debug("splitting area", area);
                    }
                    MapArea[] sublist = bounds.getWidth() > bounds.getHeight() ? area.split(2, 1, res, bounds) : area.split(1, 2, res, bounds);
                    this.addAreasToList(sublist, alist, depth + 1);
                    continue;
                }
                log.error((Object)("Area too small to split at " + area.getBounds().getCenter().toOSMURL() + " (reduce the density of points, length of lines, etc.)"));
            }
            log.debug("adding area unsplit", ",has points" + area.hasPoints());
            alist.add(area);
        }
    }

    private MapArea[] splitMaxSize(MapArea mapArea) {
        Area bounds = mapArea.getFullBounds();
        int shift = this.zoom.getShiftValue();
        int width = bounds.getWidth() >> shift;
        int height = bounds.getHeight() >> shift;
        log.info((Object)("splitMaxSize() bounds = " + bounds + " shift = " + shift + " width = " + width + " height = " + height));
        if (log.isDebugEnabled()) {
            log.debug("shifted width", width, "shifted height", height);
        }
        int xsplit = 1;
        if (width > Short.MAX_VALUE) {
            xsplit = width / Short.MAX_VALUE + 1;
        }
        int ysplit = 1;
        if (height > Short.MAX_VALUE) {
            ysplit = height / Short.MAX_VALUE + 1;
        }
        return mapArea.split(xsplit, ysplit, this.zoom.getResolution(), bounds);
    }

    private MapArea initialArea(MapDataSource src) {
        return new MapArea(src, this.zoom.getResolution());
    }
}

