/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.mkgmap.combiners;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import uk.me.parabola.imgfmt.ExitException;
import uk.me.parabola.imgfmt.FileExistsException;
import uk.me.parabola.imgfmt.FileNotWritableException;
import uk.me.parabola.imgfmt.FileSystemParam;
import uk.me.parabola.imgfmt.MapFailedException;
import uk.me.parabola.imgfmt.Utils;
import uk.me.parabola.imgfmt.app.Area;
import uk.me.parabola.imgfmt.app.Coord;
import uk.me.parabola.imgfmt.app.map.Map;
import uk.me.parabola.imgfmt.app.map.MapReader;
import uk.me.parabola.imgfmt.app.srt.Sort;
import uk.me.parabola.imgfmt.app.trergn.Point;
import uk.me.parabola.imgfmt.app.trergn.Polygon;
import uk.me.parabola.imgfmt.app.trergn.Polyline;
import uk.me.parabola.imgfmt.app.trergn.Zoom;
import uk.me.parabola.log.Logger;
import uk.me.parabola.mkgmap.CommandArgs;
import uk.me.parabola.mkgmap.build.MapBuilder;
import uk.me.parabola.mkgmap.combiners.Combiner;
import uk.me.parabola.mkgmap.combiners.FileInfo;
import uk.me.parabola.mkgmap.combiners.OverviewMap;
import uk.me.parabola.mkgmap.general.LevelInfo;
import uk.me.parabola.mkgmap.general.MapLine;
import uk.me.parabola.mkgmap.general.MapPoint;
import uk.me.parabola.mkgmap.general.MapShape;
import uk.me.parabola.mkgmap.srt.SrtTextReader;

public class OverviewBuilder
implements Combiner {
    Logger log = Logger.getLogger(OverviewBuilder.class);
    public static final String OVERVIEW_PREFIX = "ovm_";
    private final OverviewMap overviewSource;
    private String areaName;
    private String overviewMapname;
    private String overviewMapnumber;
    private Zoom[] levels;
    private String outputDir;
    private Integer codepage;
    private Integer encodingType;
    private List<String[]> copyrightMsgs = new ArrayList<String[]>();
    private List<String[]> licenseInfos = new ArrayList<String[]>();

    public OverviewBuilder(OverviewMap overviewSource) {
        this.overviewSource = overviewSource;
    }

    @Override
    public void init(CommandArgs args) {
        this.areaName = args.get("area-name", "Overview Map");
        this.overviewMapname = args.get("overview-mapname", "osmmap");
        this.overviewMapnumber = args.get("overview-mapnumber", "63240000");
        this.outputDir = args.getOutputDir();
    }

    @Override
    public void onMapEnd(FileInfo finfo) {
        if (!finfo.isImg()) {
            return;
        }
        try {
            this.readFileIntoOverview(finfo);
        }
        catch (FileNotFoundException e) {
            throw new MapFailedException("Could not read detail map " + finfo.getFilename(), e);
        }
    }

    @Override
    public void onFinish() {
        this.addBackground();
        this.writeOverviewMap();
    }

    private void addBackground() {
        MapShape background = new MapShape();
        background.setType(75);
        background.setMinResolution(0);
        background.setPoints(this.overviewSource.getBounds().toCoords());
        this.overviewSource.addShape(background);
    }

    private void writeOverviewMap() {
        if (this.overviewSource.mapLevels() == null) {
            return;
        }
        MapBuilder mb = new MapBuilder();
        mb.setEnableLineCleanFilters(false);
        FileSystemParam params = new FileSystemParam();
        params.setBlockSize(512);
        params.setMapDescription(this.areaName);
        mb.setCopyrights(this.creMsgList(this.copyrightMsgs));
        mb.setMapInfo(this.creMsgList(this.licenseInfos));
        try {
            if (this.codepage == null) {
                this.codepage = 0;
            }
            Sort sort = SrtTextReader.sortForCodepage(this.codepage);
            Map map = Map.createMap(this.overviewMapname, this.outputDir, params, this.overviewMapnumber, sort);
            if (this.encodingType != null) {
                map.getLblFile().setEncoder(this.encodingType, this.codepage);
            }
            mb.makeMap(map, this.overviewSource);
            map.close();
        }
        catch (FileExistsException e) {
            throw new ExitException("Could not create overview map", e);
        }
        catch (FileNotWritableException e) {
            throw new ExitException("Could not write to overview map", e);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void readFileIntoOverview(FileInfo finfo) throws FileNotFoundException {
        this.addMapCoverageArea(finfo);
        MapReader mapReader = null;
        String filename = finfo.getFilename();
        if (this.codepage == null) {
            this.codepage = finfo.getCodePage();
        }
        if (this.codepage.intValue() != finfo.getCodePage()) {
            System.err.println("WARNING: input file " + filename + " has different code page " + finfo.getCodePage());
        }
        try {
            mapReader = new MapReader(filename);
            if (this.encodingType == null) {
                this.encodingType = mapReader.getEncodingType();
            }
            if (this.encodingType.intValue() != mapReader.getEncodingType()) {
                System.err.println("WARNING: input file " + filename + " has different charset type " + this.encodingType);
            }
            Object[] msgs = mapReader.getCopyrights();
            boolean found = false;
            for (Object[] objectArray : this.copyrightMsgs) {
                if (!Arrays.deepEquals(objectArray, msgs)) continue;
                found = true;
                break;
            }
            if (!found) {
                this.copyrightMsgs.add((String[])msgs);
            }
            msgs = finfo.getLicenseInfo();
            found = false;
            for (Object[] objectArray : this.licenseInfos) {
                if (!Arrays.deepEquals(objectArray, msgs)) continue;
                found = true;
                break;
            }
            if (!found) {
                this.licenseInfos.add((String[])msgs);
            }
            this.levels = mapReader.getLevels();
            if (this.overviewSource.mapLevels() == null) {
                LevelInfo[] mapLevels;
                if (OverviewBuilder.isOverviewImg(filename)) {
                    void var7_12;
                    mapLevels = new LevelInfo[this.levels.length - 1];
                    boolean bl = true;
                    while (var7_12 < this.levels.length) {
                        mapLevels[var7_12 - true] = new LevelInfo(this.levels[var7_12].getLevel(), this.levels[var7_12].getResolution());
                        ++var7_12;
                    }
                } else {
                    mapLevels = new LevelInfo[]{new LevelInfo(this.levels[1].getLevel(), this.levels[1].getResolution())};
                }
                this.overviewSource.setMapLevels(mapLevels);
            }
            if (OverviewBuilder.isOverviewImg(filename)) {
                this.readPoints(mapReader);
                this.readLines(mapReader);
                this.readShapes(mapReader);
            }
        }
        catch (FileNotFoundException e) {
            try {
                throw new ExitException("Could not open " + filename + " when creating overview file");
            }
            catch (Throwable throwable) {
                Utils.closeFile(mapReader);
                throw throwable;
            }
        }
        Utils.closeFile(mapReader);
    }

    private void readPoints(MapReader mapReader) {
        Area bounds = this.overviewSource.getBounds();
        for (int l = 1; l < this.levels.length; ++l) {
            int min = this.levels[l].getLevel();
            int res = this.levels[l].getResolution();
            List<Point> pointList = mapReader.pointsForLevel(min, true);
            for (Point point : pointList) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("got point", point);
                }
                if (!bounds.contains(point.getLocation())) {
                    if (!this.log.isDebugEnabled()) continue;
                    this.log.debug(point, "dropped, is outside of tile boundary");
                    continue;
                }
                MapPoint mp = new MapPoint();
                mp.setType(point.getType());
                mp.setName(point.getLabel().getText());
                mp.setMaxResolution(res);
                mp.setMinResolution(res);
                mp.setLocation(point.getLocation());
                this.overviewSource.addPoint(mp);
            }
        }
    }

    private void readLines(MapReader mapReader) {
        for (int l = 1; l < this.levels.length; ++l) {
            int min = this.levels[l].getLevel();
            int res = this.levels[l].getResolution();
            List<Polyline> lineList = mapReader.linesForLevel(min);
            for (Polyline line : lineList) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("got line", line);
                }
                MapLine ml = new MapLine();
                List<Coord> points = line.getPoints();
                if (this.log.isDebugEnabled()) {
                    this.log.debug("line point list", points);
                }
                if (points.size() < 2) continue;
                ml.setType(line.getType());
                if (line.getLabel() != null) {
                    ml.setName(line.getLabel().getText());
                }
                ml.setMaxResolution(res);
                ml.setMinResolution(res);
                ml.setPoints(points);
                this.overviewSource.addLine(ml);
            }
        }
    }

    private void readShapes(MapReader mapReader) {
        for (int l = 1; l < this.levels.length; ++l) {
            int min = this.levels[l].getLevel();
            int res = this.levels[l].getResolution();
            List<Polygon> list = mapReader.shapesForLevel(min);
            for (Polygon shape : list) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("got polygon", shape);
                }
                if (shape.getType() == 75) continue;
                MapShape ms = new MapShape();
                List<Coord> points = shape.getPoints();
                if (this.log.isDebugEnabled()) {
                    this.log.debug("polygon point list", points);
                }
                if (points.size() < 3) continue;
                ms.setType(shape.getType());
                if (shape.getLabel() != null) {
                    ms.setName(shape.getLabel().getText());
                }
                ms.setMaxResolution(res);
                ms.setMinResolution(res);
                ms.setPoints(points);
                this.overviewSource.addShape(ms);
            }
        }
    }

    private void addMapCoverageArea(FileInfo finfo) {
        Area bounds = finfo.getBounds();
        List<Coord> points = bounds.toCoords();
        for (Coord co : points) {
            this.overviewSource.addToBounds(co);
        }
        MapShape bg = new MapShape();
        bg.setType(74);
        bg.setPoints(points);
        bg.setMinResolution(0);
        bg.setName(finfo.getDescription() + '\u001d' + finfo.getMapname());
        this.overviewSource.addShape(bg);
    }

    public Area getBounds() {
        return this.overviewSource.getBounds();
    }

    public static boolean isOverviewImg(String name) {
        return new File(name).getName().startsWith(OVERVIEW_PREFIX);
    }

    public static String getOverviewImgName(String name) {
        File f = new File(name);
        return new File(f.getParent(), OVERVIEW_PREFIX + f.getName()).getAbsolutePath();
    }

    public static String getMapName(String name) {
        String fname = new File(name).getName();
        if (fname.startsWith(OVERVIEW_PREFIX)) {
            return fname.substring(OVERVIEW_PREFIX.length());
        }
        return name;
    }

    private List<String> creMsgList(List<String[]> msgs) {
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < msgs.size(); ++i) {
            String[] block;
            for (String s : block = msgs.get(i)) {
                list.add(s);
            }
            if (i >= msgs.size() - 1) continue;
            list.add("");
        }
        return list;
    }
}

