/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.mkgmap.general;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import uk.me.parabola.imgfmt.Utils;
import uk.me.parabola.imgfmt.app.Area;
import uk.me.parabola.imgfmt.app.Coord;
import uk.me.parabola.imgfmt.app.net.GeneralRouteRestriction;
import uk.me.parabola.imgfmt.app.net.RoadNetwork;
import uk.me.parabola.imgfmt.app.trergn.Overview;
import uk.me.parabola.imgfmt.app.trergn.PointOverview;
import uk.me.parabola.imgfmt.app.trergn.PolygonOverview;
import uk.me.parabola.imgfmt.app.trergn.PolylineOverview;
import uk.me.parabola.log.Logger;
import uk.me.parabola.mkgmap.filters.ShapeMergeFilter;
import uk.me.parabola.mkgmap.general.MapCollector;
import uk.me.parabola.mkgmap.general.MapDataSource;
import uk.me.parabola.mkgmap.general.MapLine;
import uk.me.parabola.mkgmap.general.MapPoint;
import uk.me.parabola.mkgmap.general.MapRoad;
import uk.me.parabola.mkgmap.general.MapShape;
import uk.me.parabola.mkgmap.reader.osm.GType;
import uk.me.parabola.util.EnhancedProperties;

public class MapDetails
implements MapCollector,
MapDataSource {
    private static final Logger log = Logger.getLogger(MapDetails.class);
    private final List<MapLine> lines = new ArrayList<MapLine>();
    private final List<MapShape> shapes = new ArrayList<MapShape>();
    private final List<MapPoint> points = new ArrayList<MapPoint>();
    private int minLat30 = Utils.toMapUnit(180.0) << 6;
    private int minLon30 = Utils.toMapUnit(180.0) << 6;
    private int maxLat30 = Utils.toMapUnit(-180.0) << 6;
    private int maxLon30 = Utils.toMapUnit(-180.0) << 6;
    private final Map<Integer, Integer> pointOverviews = new HashMap<Integer, Integer>();
    private final Map<Integer, Integer> lineOverviews = new HashMap<Integer, Integer>();
    private final Map<Integer, Integer> shapeOverviews = new HashMap<Integer, Integer>();
    private final RoadNetwork roadNetwork = new RoadNetwork();

    public void config(EnhancedProperties props) {
        this.roadNetwork.config(props);
    }

    @Override
    public void addPoint(MapPoint point) {
        MapDetails.updateOverview(this.pointOverviews, point.getType(), point.getMinResolution());
        this.points.add(point);
    }

    @Override
    public void addLine(MapLine line) {
        assert (!(line instanceof MapShape));
        if (line.getPoints().isEmpty()) {
            return;
        }
        int type = line.hasExtendedType() ? line.getType() : line.getType() << 8;
        MapDetails.updateOverview(this.lineOverviews, type, line.getMinResolution());
        this.lines.add(line);
    }

    @Override
    public void addShape(MapShape shape) {
        if (shape.getPoints().size() < 4) {
            return;
        }
        if (ShapeMergeFilter.calcAreaSizeTestVal(shape.getPoints()) == 0L) {
            log.info("ignoring shape with id", shape.getOsmid(), "and type", GType.formatType(shape.getType()) + ", it", shape.wasClipped() ? "was clipped to" : "has", shape.getPoints().size(), "points and has an empty area ");
            return;
        }
        int type = shape.hasExtendedType() ? shape.getType() : shape.getType() << 8;
        MapDetails.updateOverview(this.shapeOverviews, type, shape.getMinResolution());
        this.shapes.add(shape);
    }

    @Override
    public void addRoad(MapRoad road) {
        this.roadNetwork.addRoad(road.getRoadDef(), road.getPoints());
        this.addLine(road);
    }

    @Override
    public int addRestriction(GeneralRouteRestriction grr) {
        return this.roadNetwork.addRestriction(grr);
    }

    @Override
    public void addThroughRoute(int junctionNodeId, long roadIdA, long roadIdB) {
        this.roadNetwork.addThroughRoute(junctionNodeId, roadIdA, roadIdB);
    }

    @Override
    public void addToBounds(Coord p) {
        int lat30 = p.getHighPrecLat();
        int lon30 = p.getHighPrecLon();
        if (lat30 < this.minLat30) {
            this.minLat30 = lat30;
        }
        if (lat30 > this.maxLat30) {
            this.maxLat30 = lat30;
        }
        if (lon30 < this.minLon30) {
            this.minLon30 = lon30;
        }
        if (lon30 > this.maxLon30) {
            this.maxLon30 = lon30;
        }
    }

    @Override
    public Area getBounds() {
        int minLat = this.minLat30 >> 6;
        int maxLat = this.maxLat30 >> 6;
        int minLon = this.minLon30 >> 6;
        int maxLon = this.maxLon30 >> 6;
        if (maxLat << 6 < this.maxLat30) {
            ++maxLat;
        }
        if (maxLon << 6 < this.maxLon30) {
            ++maxLon;
        }
        return new Area(minLat, minLon, maxLat, maxLon);
    }

    @Override
    public List<MapPoint> getPoints() {
        return this.points;
    }

    @Override
    public List<MapLine> getLines() {
        return this.lines;
    }

    @Override
    public List<MapShape> getShapes() {
        return this.shapes;
    }

    @Override
    public RoadNetwork getRoadNetwork() {
        return this.roadNetwork;
    }

    @Override
    public List<Overview> getOverviews() {
        Overview ov;
        ArrayList<Overview> ovlist = new ArrayList<Overview>();
        for (Map.Entry<Integer, Integer> ent : this.pointOverviews.entrySet()) {
            ov = new PointOverview(ent.getKey(), ent.getValue());
            ovlist.add(ov);
        }
        for (Map.Entry<Integer, Integer> ent : this.lineOverviews.entrySet()) {
            ov = new PolylineOverview(ent.getKey(), ent.getValue());
            ovlist.add(ov);
        }
        for (Map.Entry<Integer, Integer> ent : this.shapeOverviews.entrySet()) {
            ov = new PolygonOverview(ent.getKey(), ent.getValue());
            ovlist.add(ov);
        }
        return ovlist;
    }

    private static void updateOverview(Map<Integer, Integer> overviews, int type, int minResolution) {
        Integer prev = overviews.get(type);
        if (prev == null || minResolution < prev) {
            overviews.put(type, minResolution);
        }
    }
}

