/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.mkgmap.main;

import uk.me.parabola.imgfmt.ExitException;
import uk.me.parabola.imgfmt.FileExistsException;
import uk.me.parabola.imgfmt.FileNotWritableException;
import uk.me.parabola.imgfmt.FileSystemParam;
import uk.me.parabola.imgfmt.app.Area;
import uk.me.parabola.imgfmt.app.map.Map;
import uk.me.parabola.imgfmt.app.trergn.Subdivision;
import uk.me.parabola.imgfmt.app.trergn.Zoom;
import uk.me.parabola.log.Logger;
import uk.me.parabola.mkgmap.srt.SrtTextReader;

public abstract class AbstractTestMap {
    private static final Logger log = Logger.getLogger(AbstractTestMap.class);

    protected void makeMap(String[] args) {
        Map map;
        double lat = 51.724;
        double lng = 0.2487;
        if (args.length > 1) {
            lat = Double.valueOf(args[0]);
            lng = Double.valueOf(args[1]);
        }
        log.debug("this is a test make map program. Start", lat, Character.valueOf('/'), lng);
        FileSystemParam params = new FileSystemParam();
        params.setBlockSize(512);
        params.setMapDescription("OSM street map");
        try {
            map = Map.createMap("32860003", ".", params, "32860003", SrtTextReader.sortForCodepage(1252));
        }
        catch (FileExistsException e) {
            throw new ExitException("File exists already", e);
        }
        catch (FileNotWritableException e) {
            throw new ExitException("Could not create or write file", e);
        }
        map.addInfo("Program released under the GPL");
        map.addInfo("This map data is made available under the Open Database License:");
        map.addCopyright("program licenced under GPL v2");
        map.addCopyright("No copyright");
        Area area = new Area(lat, lng, lat + 1.0, lng + 1.0);
        map.setBounds(area);
        log.info((Object)("area " + area));
        log.info((Object)(" or " + lat + '/' + lng));
        Zoom z1 = map.createZoom(1, 24);
        Subdivision topdiv = map.topLevelSubdivision(area, z1);
        Zoom z = map.createZoom(0, 24);
        Subdivision div = map.createSubdivision(topdiv, area, z);
        div.startDivision();
        this.drawTestMap(map, div, lat, lng);
        map.close();
    }

    protected abstract void drawTestMap(Map var1, Subdivision var2, double var3, double var5);
}

