/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.mkgmap.main;

import java.io.File;
import java.io.FileNotFoundException;
import uk.me.parabola.imgfmt.FileExistsException;
import uk.me.parabola.imgfmt.FileNotWritableException;
import uk.me.parabola.imgfmt.FileSystemParam;
import uk.me.parabola.imgfmt.FormatException;
import uk.me.parabola.imgfmt.MapFailedException;
import uk.me.parabola.imgfmt.app.map.Map;
import uk.me.parabola.imgfmt.app.srt.Sort;
import uk.me.parabola.log.Logger;
import uk.me.parabola.mkgmap.CommandArgs;
import uk.me.parabola.mkgmap.build.MapBuilder;
import uk.me.parabola.mkgmap.combiners.OverviewBuilder;
import uk.me.parabola.mkgmap.general.LoadableMapDataSource;
import uk.me.parabola.mkgmap.main.MapProcessor;
import uk.me.parabola.mkgmap.reader.plugin.MapReader;

public class MapMaker
implements MapProcessor {
    private static final Logger log = Logger.getLogger(MapMaker.class);
    private Sort sort;
    private final boolean createOverviewFiles;

    public MapMaker(boolean createOverviewFiles) {
        this.createOverviewFiles = createOverviewFiles;
    }

    @Override
    public String makeMap(CommandArgs args, String filename) {
        try {
            LoadableMapDataSource src = this.loadFromFile(args, filename);
            this.sort = args.getSort();
            if (this.createOverviewFiles) {
                if (src.overviewMapLevels() != null) {
                    this.makeMap(args, src, "ovm_");
                } else {
                    String fname = OverviewBuilder.getOverviewImgName(args.getMapname());
                    File f = new File(fname);
                    if (f.exists() && f.isFile()) {
                        f.delete();
                    }
                }
            }
            return this.makeMap(args, src, "");
        }
        catch (FormatException e) {
            System.err.println("Bad file format: " + filename);
            System.err.println(e.getMessage());
            return filename;
        }
        catch (FileNotFoundException e) {
            System.err.println("Could not open file: " + filename);
            return filename;
        }
    }

    private String makeMap(CommandArgs args, LoadableMapDataSource src, String mapNamePrefix) {
        if (src.getBounds().isEmpty()) {
            return null;
        }
        FileSystemParam params = new FileSystemParam();
        params.setBlockSize(args.getBlockSize());
        params.setMapDescription(args.getDescription());
        log.info("Started making", args.getMapname(), "(" + args.getDescription() + ")");
        try {
            Map map = Map.createMap(mapNamePrefix + args.getMapname(), args.getOutputDir(), params, args.getMapname(), this.sort);
            this.setOptions(map, args);
            MapBuilder builder = new MapBuilder();
            builder.config(args.getProperties());
            if (!"ovm_".equals(mapNamePrefix) && (args.getProperties().containsKey("route") || args.getProperties().containsKey("net"))) {
                builder.setDoRoads(true);
            }
            builder.makeMap(map, src);
            String outName = map.getFilename();
            log.info("finished making map", outName, "closing");
            map.close();
            return outName;
        }
        catch (FileExistsException e) {
            throw new MapFailedException("File exists already", e);
        }
        catch (FileNotWritableException e) {
            throw new MapFailedException("Could not create or write to file", e);
        }
    }

    private void setOptions(Map map, CommandArgs args) {
        map.config(args.getProperties());
        String s = args.getCharset();
        if (s != null) {
            map.setLabelCharset(s, args.isForceUpper());
        }
        Sort sort = args.getSort();
        map.setSort(sort);
    }

    private LoadableMapDataSource loadFromFile(CommandArgs args, String name) throws FileNotFoundException, FormatException {
        LoadableMapDataSource src = MapReader.createMapReader(name);
        src.config(args.getProperties());
        log.info("Started loading", name);
        src.load(name);
        log.info("Finished loading", name);
        return src;
    }
}

