/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.mkgmap.osmstyle.housenumber;

import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import uk.me.parabola.imgfmt.Utils;
import uk.me.parabola.imgfmt.app.Coord;
import uk.me.parabola.log.Logger;
import uk.me.parabola.mkgmap.general.MapRoad;
import uk.me.parabola.mkgmap.osmstyle.housenumber.ExtNumbers;
import uk.me.parabola.mkgmap.osmstyle.housenumber.HousenumberGenerator;
import uk.me.parabola.mkgmap.osmstyle.housenumber.HousenumberMatch;
import uk.me.parabola.mkgmap.osmstyle.housenumber.HousenumberRoad;

public class HousenumberGroup {
    private static final Logger log = Logger.getLogger(HousenumberGroup.class);
    final HousenumberRoad hnr;
    final List<HousenumberMatch> houses = new ArrayList<HousenumberMatch>();
    Int2IntOpenHashMap usedNumbers;
    int minNum;
    int maxNum;
    int minSeg;
    int maxSeg;
    double minFrac;
    double maxFrac;
    HousenumberMatch closestHouseToRoad;
    HousenumberMatch farthestHouseToRoad;
    int odd;
    int even;
    Coord linkNode;
    boolean findSegmentWasCalled;
    private static final double MIN_DISTANCE_TO_EXISTING_POINT = 7.5;
    private static final double CLOSE_HOUSES_DIST = 10.0;

    public HousenumberGroup(HousenumberRoad hnr, List<HousenumberMatch> housesToUse) {
        this.hnr = hnr;
        this.reset();
        for (HousenumberMatch house : housesToUse) {
            this.addHouse(house);
        }
    }

    private void addHouse(HousenumberMatch house) {
        int num = house.getHousenumber();
        if (num % 2 == 0) {
            ++this.even;
        } else {
            ++this.odd;
        }
        int count = this.usedNumbers.get(num);
        this.usedNumbers.put(num, count + 1);
        if (this.houses.isEmpty()) {
            this.minNum = this.maxNum = house.getHousenumber();
            this.minSeg = this.maxSeg = house.getSegment();
            this.minFrac = this.maxFrac = house.getSegmentFrac();
            this.closestHouseToRoad = this.farthestHouseToRoad = house;
        } else {
            if (house.getSegment() < this.minSeg) {
                this.minSeg = house.getSegment();
                this.minFrac = house.getSegmentFrac();
            } else if (house.getSegment() > this.maxSeg) {
                this.maxSeg = house.getSegment();
                this.maxFrac = house.getSegmentFrac();
            } else if (house.getSegment() == this.minSeg) {
                this.minFrac = Math.min(this.minFrac, house.getSegmentFrac());
            } else if (house.getSegment() == this.maxSeg) {
                this.maxFrac = Math.max(this.maxFrac, house.getSegmentFrac());
            }
            this.minNum = Math.min(this.minNum, num);
            this.maxNum = Math.max(this.maxNum, num);
            if (house.getDistance() < this.closestHouseToRoad.getDistance()) {
                this.closestHouseToRoad = house;
            }
            if (house.getDistance() > this.farthestHouseToRoad.getDistance()) {
                this.farthestHouseToRoad = house;
            }
        }
        this.houses.add(house);
    }

    public boolean findSegment(String streetName, List<HousenumberGroup> groups) {
        Coord c2;
        if (this.minSeg < 0 || this.maxSeg < 0) {
            log.error("internal error: group is not valid:", this);
            return false;
        }
        this.findSegmentWasCalled = true;
        this.linkNode = null;
        List<Coord> points = this.getRoad().getPoints();
        Coord pointToUse = null;
        int seg = this.closestHouseToRoad.getSegment();
        Coord c1 = points.get(seg);
        if (c1.highPrecEquals(c2 = points.get(seg + 1))) {
            boolean useExisting = true;
            for (HousenumberGroup hg : groups) {
                if (hg == this || hg.linkNode != c1) continue;
                if (hg.closestHouseToRoad.isLeft() != this.closestHouseToRoad.isLeft()) {
                    this.linkNode = c1;
                    return false;
                }
                log.warn("two groups on same side of road share same point, group 1:", hg, "group 2:", this, "in road", this.getRoad());
                useExisting = false;
                break;
            }
            if (useExisting) {
                c1.setNumberNode(true);
                c2.setNumberNode(true);
                this.linkNode = c1;
                return false;
            }
        }
        int timesToAdd = 1;
        double frac = this.closestHouseToRoad.getSegmentFrac();
        if (frac < 0.0) {
            frac = 0.0;
        }
        if (frac > 1.0) {
            frac = 1.0;
        }
        double segLen = c1.distance(c2);
        pointToUse = c1.makeBetweenPoint(c2, frac);
        double len1 = segLen * frac;
        double len2 = (1.0 - Math.min(1.0, frac)) * segLen;
        if (Math.min(len1, len2) < 7.5) {
            pointToUse = len1 <= len2 ? c1 : c2;
        } else {
            Coord optPoint = ExtNumbers.rasterLineNearPoint(c1, c2, pointToUse, true);
            double opt1Dist = c1.distance(optPoint);
            double opt2Dist = c2.distance(optPoint);
            pointToUse = optPoint;
            if (Math.min(opt1Dist, opt2Dist) <= 7.5) {
                pointToUse = opt1Dist < opt2Dist ? c1 : c2;
            } else {
                timesToAdd = 2;
            }
        }
        if (points.size() + timesToAdd > 250) {
            return false;
        }
        pointToUse.setNumberNode(true);
        if (timesToAdd == 2) {
            points.add(seg + 1, pointToUse);
            pointToUse.setAddedNumberNode(true);
            pointToUse = new Coord(pointToUse);
            pointToUse.setNumberNode(true);
            points.add(seg + 1, pointToUse);
            pointToUse.setAddedNumberNode(true);
            this.linkNode = pointToUse;
        } else {
            pointToUse = new Coord(pointToUse);
            pointToUse.setNumberNode(true);
            points.add(seg + 1, pointToUse);
            pointToUse.setAddedNumberNode(true);
            this.linkNode = pointToUse.highPrecEquals(c1) ? c1 : pointToUse;
        }
        return true;
    }

    public boolean verify() {
        if (this.findSegmentWasCalled) {
            return true;
        }
        if (this.minSeg < 0 || this.maxSeg < 0) {
            return false;
        }
        int step = 1;
        if (this.odd == 0 || this.even == 0) {
            step = 2;
        }
        boolean ok = false;
        if (this.usedNumbers.size() == (this.maxNum - this.minNum) / step + 1) {
            ok = true;
        }
        double deltaDist = Math.abs(this.closestHouseToRoad.getDistance() - this.farthestHouseToRoad.getDistance());
        if (this.houses.size() > 2 && deltaDist < (double)(this.houses.size() * 3)) {
            ok = false;
        }
        for (HousenumberMatch house : this.houses) {
            house.setGroup(ok ? this : null);
        }
        return ok;
    }

    public MapRoad getRoad() {
        return this.hnr.getRoad();
    }

    public static boolean housesFormAGroup(HousenumberMatch house1, HousenumberMatch house2) {
        double distBetweenHouses;
        if (house1.isIgnored() || house2.isIgnored()) {
            return false;
        }
        if (house1.getRoad() != house2.getRoad()) {
            log.error("internal error, group check with houses on different roads?", house1.getElement().getId(), house2.getElement().getId());
            return false;
        }
        if (house1.getSegment() > house2.getSegment()) {
            HousenumberMatch help = house1;
            house1 = house2;
            house2 = help;
        }
        if ((distBetweenHouses = house1.getLocation().distance(house2.getLocation())) == 0.0) {
            return true;
        }
        double minDistToRoad = Math.min(house1.getDistance(), house2.getDistance());
        double maxDistToRoad = Math.max(house1.getDistance(), house2.getDistance());
        double distOnRoad = house2.getDistOnRoad(house1);
        if (house1.getSegment() != house2.getSegment()) {
            double distOnRoadSimple;
            if (minDistToRoad > 40.0 && distBetweenHouses < 10.0) {
                return true;
            }
            Coord c1 = house1.getLocation();
            Coord c2 = house2.getLocation();
            Coord closest1 = house1.getClosestPointOnRoad();
            Coord closest2 = house2.getClosestPointOnRoad();
            double frac1 = HousenumberGenerator.getFrac(closest1, closest2, c1);
            double frac2 = HousenumberGenerator.getFrac(closest1, closest2, c2);
            double segLen = closest1.distance(closest2);
            if (frac1 < 0.0) {
                frac1 = 0.0;
            }
            if (frac2 < 0.0) {
                frac2 = 0.0;
            }
            if (frac1 > 1.0) {
                frac1 = 1.0;
            }
            if (frac2 > 1.0) {
                frac2 = 1.0;
            }
            if ((distOnRoadSimple = (Math.max(frac1, frac2) - Math.min(frac1, frac2)) * segLen) != distOnRoad) {
                distOnRoad = distOnRoadSimple;
            }
        }
        if (distOnRoad <= 0.0) {
            return true;
        }
        double toleranceDistOnRoad = 5.0 + maxDistToRoad / 10.0;
        if (distOnRoad > toleranceDistOnRoad) {
            return false;
        }
        double deltaDistToRoad = maxDistToRoad - minDistToRoad;
        double ratio2 = deltaDistToRoad / distBetweenHouses;
        if (ratio2 > 0.9) {
            return true;
        }
        return !(ratio2 < 0.666);
    }

    public boolean tryAddHouse(HousenumberMatch house) {
        HousenumberMatch first;
        if (house.isInterpolated() || house.getRoad() == null || house.isIgnored()) {
            return false;
        }
        int num = house.getHousenumber();
        int step = 1;
        if (this.odd == 0 || this.even == 0) {
            step = 2;
        }
        if (num - this.maxNum != step) {
            return false;
        }
        HousenumberMatch last = this.houses.get(this.houses.size() - 1);
        if (last.getGroup() != null) {
            if (last.getGroup() == house.getGroup()) {
                this.addHouse(house);
                return true;
            }
            return false;
        }
        if (last.getDistance() + 3.0 < house.getDistance() && last.isDirectlyConnected(house)) {
            this.addHouse(house);
            return true;
        }
        if (!HousenumberGroup.housesFormAGroup(house, last)) {
            return false;
        }
        if (this.houses.size() > 1 && !HousenumberGroup.housesFormAGroup(house, first = this.houses.get(0))) {
            HousenumberMatch preLast = this.houses.get(this.houses.size() - 2);
            double angle = Utils.getAngle(house.getLocation(), last.getLocation(), preLast.getLocation());
            if (Math.abs(angle) > 30.0) {
                return false;
            }
        }
        this.addHouse(house);
        return true;
    }

    public boolean recalcPositions() {
        ArrayList<HousenumberMatch> saveHouses = new ArrayList<HousenumberMatch>(this.houses);
        this.reset();
        for (HousenumberMatch house : saveHouses) {
            this.addHouse(house);
        }
        if (!this.verify()) {
            for (HousenumberMatch house : this.houses) {
                HousenumberGenerator.findClosestRoadSegment(house, this.getRoad());
            }
            return false;
        }
        return true;
    }

    private void reset() {
        this.usedNumbers = new Int2IntOpenHashMap();
        this.minNum = Integer.MAX_VALUE;
        this.maxNum = -1;
        this.minSeg = Integer.MAX_VALUE;
        this.maxSeg = -1;
        this.maxFrac = Double.NaN;
        this.minFrac = Double.NaN;
        this.closestHouseToRoad = null;
        this.farthestHouseToRoad = null;
        this.even = 0;
        this.odd = 0;
        this.houses.clear();
    }

    public String toString() {
        return this.houses.toString();
    }
}

