/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.mkgmap.osmstyle.housenumber;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import uk.me.parabola.imgfmt.Utils;
import uk.me.parabola.imgfmt.app.Coord;
import uk.me.parabola.log.Logger;
import uk.me.parabola.mkgmap.general.CityInfo;
import uk.me.parabola.mkgmap.general.MapRoad;
import uk.me.parabola.mkgmap.general.ZipCodeInfo;
import uk.me.parabola.mkgmap.osmstyle.housenumber.HousenumberElem;
import uk.me.parabola.mkgmap.osmstyle.housenumber.HousenumberGenerator;
import uk.me.parabola.mkgmap.osmstyle.housenumber.HousenumberMatch;
import uk.me.parabola.mkgmap.reader.osm.Node;
import uk.me.parabola.mkgmap.reader.osm.TagDict;
import uk.me.parabola.mkgmap.reader.osm.Way;

public class HousenumberIvl {
    private static final Logger log = Logger.getLogger(HousenumberIvl.class);
    public static final double MAX_INTERPOLATION_DISTANCE_TO_ROAD = 75.0;
    private final String streetName;
    private final Way interpolationWay;
    private MapRoad roadForInterpolatedHouses;
    private final Node n1;
    private final Node n2;
    private List<Coord> points;
    private int step;
    private int start;
    private int end;
    private int steps;
    private HousenumberMatch[] knownHouses = new HousenumberMatch[]{null, null};
    private boolean hasMultipleRoads;
    private boolean foundCluster;
    private int interpolated;
    private boolean ignoreForInterpolation;
    private boolean equalEnds;
    private static final short streetTagKey = TagDict.getInstance().xlate("mkgmap:street");
    private static final short housenumberTagKey = TagDict.getInstance().xlate("mkgmap:housenumber");
    private static final short addrInterpolationTagKey = TagDict.getInstance().xlate("addr:interpolation");

    public HousenumberIvl(String streetName, Way interpolationWay, Node n1, Node n2) {
        this.streetName = streetName;
        this.interpolationWay = interpolationWay;
        this.n1 = n1;
        this.n2 = n2;
    }

    public void setPoints(List<Coord> points) {
        this.points = new ArrayList<Coord>(points);
    }

    public void setStep(int step) {
        this.step = step;
    }

    public int getStep() {
        return this.step;
    }

    public void setStart(int start) {
        this.start = start;
    }

    public int getStart() {
        return this.start;
    }

    public void setEnd(int end) {
        this.end = end;
    }

    public int getEnd() {
        return this.end;
    }

    public void calcSteps() {
        this.steps = this.start < this.end ? (this.end - this.start) / this.step - 1 : (this.start - this.end) / this.step - 1;
    }

    public Node getNode1() {
        return this.n1;
    }

    public Node getNode2() {
        return this.n2;
    }

    public void addHousenumberMatch(HousenumberMatch house) {
        if (house.getElement() == this.n1) {
            this.knownHouses[0] = house;
        } else if (house.getElement() == this.n2) {
            this.knownHouses[1] = house;
        } else {
            log.error("cannot add", house, "to", this);
        }
    }

    public boolean checkRoads() {
        boolean res = this.checkRoads2();
        if (!res || this.equalEnds) {
            this.ignoreNodes();
        }
        return res;
    }

    private boolean checkRoads2() {
        for (int i = 0; i < 2; ++i) {
            if (this.knownHouses[i] == null) {
                log.error("internal error: housenumber matches not properly set", this);
                return false;
            }
            if (this.knownHouses[i].getRoad() != null && !(this.knownHouses[i].getDistance() > 100.0)) continue;
            log.warn("cannot find any reasonable road for both nodes, ignoring them", this.streetName, this);
            return false;
        }
        if (this.knownHouses[0].getRoad().getRoadDef().getId() == this.knownHouses[1].getRoad().getRoadDef().getId()) {
            if (this.knownHouses[0].getRoad() != this.knownHouses[1].getRoad()) {
                this.hasMultipleRoads = true;
                return true;
            }
            for (MapRoad r : this.knownHouses[0].getAlternativeRoads()) {
                if (r.getRoadDef().getId() != this.knownHouses[0].getRoad().getRoadDef().getId()) continue;
                this.hasMultipleRoads = true;
                return true;
            }
        }
        MapRoad bestRoad = null;
        for (int i = 0; i < 2; ++i) {
            while (!this.streetName.equals(this.knownHouses[i].getRoad().getStreet()) && this.knownHouses[i].hasAlternativeRoad()) {
                HousenumberMatch testx = new HousenumberMatch(this.knownHouses[i]);
                MapRoad r = this.knownHouses[i].getAlternativeRoads().remove(0);
                if (!this.streetName.equals(r.getStreet())) continue;
                HousenumberGenerator.findClosestRoadSegment(testx, r);
                if (!(testx.getDistance() < 75.0)) continue;
                this.copyRoadData(testx, this.knownHouses[i]);
            }
        }
        ArrayList<MapRoad> toTest = new ArrayList<MapRoad>();
        toTest.add(this.knownHouses[0].getRoad());
        toTest.add(this.knownHouses[1].getRoad());
        for (MapRoad r : this.knownHouses[0].getAlternativeRoads()) {
            if (!this.knownHouses[1].getAlternativeRoads().contains(r)) continue;
            toTest.add(r);
        }
        HousenumberMatch[] test = new HousenumberMatch[2];
        HousenumberMatch[] closest = new HousenumberMatch[2];
        boolean foundSingleRoad = false;
        for (MapRoad r : toTest) {
            if (!this.streetName.equals(r.getStreet())) continue;
            foundSingleRoad = true;
            for (int i = 0; i < 2; ++i) {
                test[i] = this.knownHouses[i];
                if (test[i].getRoad() != r) {
                    test[i] = new HousenumberMatch(this.knownHouses[i]);
                    HousenumberGenerator.findClosestRoadSegment(test[i], r);
                    test[i].calcRoadSide();
                }
                if (test[i].getRoad() != null && !(test[i].getDistance() > 75.0)) continue;
                foundSingleRoad = false;
                break;
            }
            if (foundSingleRoad) {
                double angle2;
                if (test[0].isLeft() != test[1].isLeft()) {
                    foundSingleRoad = false;
                    continue;
                }
                int s0 = test[0].getSegment();
                int s1 = test[1].getSegment();
                double angle1 = Utils.getAngle(test[0].getClosestPointOnRoad(), this.points.get(0), this.points.get(1));
                if (Math.abs(angle1) < 30.0) {
                    foundSingleRoad = false;
                    HousenumberMatch testx = new HousenumberMatch(test[0]);
                    for (int s = Math.min(s0, s1); s <= Math.max(s0, s1); ++s) {
                        if (s == test[0].getSegment()) continue;
                        HousenumberGenerator.findClosestRoadSegment(testx, r, s, s + 1);
                        angle1 = Utils.getAngle(testx.getClosestPointOnRoad(), this.points.get(0), this.points.get(1));
                        if (!(Math.abs(angle1) >= 30.0) || !(testx.getDistance() < 2.0 * test[0].getDistance())) continue;
                        test[0] = testx;
                        foundSingleRoad = true;
                        break;
                    }
                }
                if (Math.abs(angle2 = Utils.getAngle(this.points.get(this.points.size() - 2), this.points.get(this.points.size() - 1), test[1].getClosestPointOnRoad())) < 30.0) {
                    foundSingleRoad = false;
                    HousenumberMatch testx = new HousenumberMatch(test[1]);
                    for (int s = Math.min(s0, s1); s <= Math.max(s0, s1); ++s) {
                        if (s == test[1].getSegment()) continue;
                        HousenumberGenerator.findClosestRoadSegment(testx, r, s, s + 1);
                        angle2 = Utils.getAngle(this.points.get(this.points.size() - 2), this.points.get(this.points.size() - 1), testx.getClosestPointOnRoad());
                        if (!(Math.abs(angle2) >= 30.0) || !(testx.getDistance() < 2.0 * test[1].getDistance())) continue;
                        test[1] = testx;
                        foundSingleRoad = true;
                        break;
                    }
                }
            }
            if (!foundSingleRoad) continue;
            if (!r.isNamedByHousenumberProcessing()) break;
            if (bestRoad != null) continue;
            bestRoad = r;
            closest[0] = test[0];
            closest[1] = test[1];
        }
        if (!foundSingleRoad && bestRoad != null) {
            foundSingleRoad = true;
            test[0] = closest[0];
            test[1] = closest[1];
        }
        if (!foundSingleRoad) {
            if (!this.streetName.equals(this.knownHouses[0].getRoad().getStreet()) || !this.streetName.equals(this.knownHouses[1].getRoad().getStreet())) {
                log.warn("cannot find reasonable road for both nodes", this.streetName, this);
                return false;
            }
            this.hasMultipleRoads = true;
            return true;
        }
        this.roadForInterpolatedHouses = test[0].getRoad();
        for (int i = 0; i < 2; ++i) {
            if (this.knownHouses[i].getRoad() != test[i].getRoad() || this.knownHouses[i].getSegment() != test[i].getSegment()) {
                this.copyRoadData(test[i], this.knownHouses[i]);
                this.knownHouses[i].forgetAlternativeRoads();
            }
            if (!(this.knownHouses[i].getSegmentFrac() < 0.0) && !(this.knownHouses[i].getSegmentFrac() > 1.0)) continue;
            this.hasMultipleRoads = true;
        }
        if (this.knownHouses[0].isLeft() != this.knownHouses[1].isLeft()) {
            log.warn("addr:interpolation way crosses road", this.streetName, this);
            return false;
        }
        return true;
    }

    private void copyRoadData(HousenumberMatch source, HousenumberMatch dest) {
        if (log.isInfoEnabled()) {
            if (source.getRoad() != dest.getRoad()) {
                log.info("moving", this.streetName, dest.getSign(), dest.toBrowseURL(), "from road", dest.getRoad(), "to road", source.getRoad());
            } else {
                log.info("moving", this.streetName, dest.getSign(), dest.toBrowseURL(), "from segment", dest.getSegment(), "to ", source.getSegment(), "in road", source.getRoad());
            }
        }
        dest.setRoad(source.getRoad());
        dest.setSegment(source.getSegment());
        dest.setSegmentFrac(source.getSegmentFrac());
        dest.setDistance(source.getDistance());
        dest.calcRoadSide();
    }

    public List<HousenumberMatch> getInterpolatedHouses() {
        ArrayList<HousenumberMatch> houses = new ArrayList<HousenumberMatch>();
        if (this.ignoreForInterpolation || this.start == this.end || this.steps <= 0) {
            return houses;
        }
        List<Coord> interpolatedPoints = this.getInterpolatedPoints();
        int usedStep = this.start < this.end ? this.step : -this.step;
        int hn = this.start;
        boolean distanceWarningIssued = false;
        CityInfo ci = this.knownHouses[0].getCityInfo();
        ZipCodeInfo zip = this.knownHouses[0].getZipCode();
        if (ci != null && !ci.equals(this.knownHouses[1].getCityInfo())) {
            log.warn("addr:interpolation way connects houses in different cities", this.streetName, this, "using city", ci, "for all interpolated adresses");
        }
        if (zip != null && !zip.equals(this.knownHouses[1].getZipCode())) {
            log.warn("addr:interpolation way connects houses with differnt zip codes", this.streetName, this, "using zip code", zip, "for all interpolated adresses");
        }
        for (Coord co : interpolatedPoints) {
            Node generated = new Node(this.interpolationWay.getId(), co);
            generated.setFakeId();
            generated.addTag(streetTagKey, this.streetName);
            String number = String.valueOf(hn += usedStep);
            generated.addTag(housenumberTagKey, number);
            HousenumberElem houseElem = new HousenumberElem(generated, ci);
            houseElem.setHousenumber(hn);
            houseElem.setZipCode(zip);
            houseElem.setStreet(this.streetName);
            houseElem.setSign(number);
            HousenumberMatch house = new HousenumberMatch(houseElem);
            if (this.roadForInterpolatedHouses != null) {
                HousenumberGenerator.findClosestRoadSegment(house, this.roadForInterpolatedHouses);
                if (house.getRoad() == null || house.getDistance() > 75.0) {
                    if (distanceWarningIssued) continue;
                    log.warn("interpolated house is not close to expected road", this, house);
                    distanceWarningIssued = true;
                    continue;
                }
                house.calcRoadSide();
            }
            house.setInterpolated(true);
            houses.add(house);
        }
        if (log.isDebugEnabled()) {
            String addrInterpolationMethod = this.interpolationWay.getTag(addrInterpolationTagKey);
            if (!this.hasMultipleRoads) {
                log.debug(this, "generated", addrInterpolationMethod, "interpolated number(s) for", this.knownHouses[0].getRoad());
            } else {
                log.debug(this, "generated", addrInterpolationMethod, "interpolated number(s) for", this.streetName);
            }
        }
        return houses;
    }

    public List<Coord> getInterpolatedPoints() {
        if (this.interpolated > 0) {
            log.debug("interpolating numbers again for", this);
        }
        ++this.interpolated;
        if (this.steps < 1 || this.points.size() < 2) {
            return Collections.emptyList();
        }
        ArrayList<Coord> interpolated = new ArrayList<Coord>(this.steps);
        double wayLen = 0.0;
        int i = 0;
        while (i + 1 < this.points.size()) {
            wayLen += this.points.get(i).distance(this.points.get(i + 1));
            ++i;
        }
        double ivlLen = wayLen / (double)(this.steps + 1);
        if (ivlLen < 0.1) {
            if (log.isInfoEnabled()) {
                log.info("addr:interpolation", this.interpolationWay.toBrowseURL(), "segment ignored, would generate", this.steps, "houses with distance of", ivlLen, "m");
            }
            return interpolated;
        }
        int pos = 0;
        double rest = 0.0;
        while (pos + 1 < this.points.size()) {
            Coord c1 = this.points.get(pos);
            Coord c2 = this.points.get(pos + 1);
            ++pos;
            double neededPartOfSegment = 0.0;
            double segmentLen = c1.distance(c2);
            while ((neededPartOfSegment += ivlLen - rest) <= segmentLen) {
                double fraction = neededPartOfSegment / segmentLen;
                Coord c = c1.makeBetweenPoint(c2, fraction);
                interpolated.add(c);
                if (interpolated.size() >= this.steps) {
                    return interpolated;
                }
                rest = 0.0;
            }
            rest = segmentLen - neededPartOfSegment + ivlLen;
        }
        log.warn("addr:interpolation", this.interpolationWay.toBrowseURL(), "interpolation for segment with nodes", this.n1.getId(), this.n2.getId(), "failed");
        return interpolated;
    }

    public String toString() {
        return this.interpolationWay.toBrowseURL() + " " + this.start + ".." + this.end + ", step=" + this.step;
    }

    public String getDesc() {
        return this.streetName + "_" + this.start + ".." + this.end + "_" + this.step;
    }

    public void ignoreNodes() {
        for (int i = 0; i < 2; ++i) {
            if (this.knownHouses[i] == null) continue;
            this.knownHouses[i].decIntervalInfoRefs();
            if (this.knownHouses[i].getIntervalInfoRefs() != 0) continue;
            this.knownHouses[i].setIgnored(true);
        }
    }

    public long getId() {
        return this.interpolationWay.getId();
    }

    public boolean ignoreForInterpolation() {
        return this.ignoreForInterpolation;
    }

    public void setIgnoreForInterpolation(boolean ignoreForInterpolation) {
        this.ignoreForInterpolation = ignoreForInterpolation;
    }

    public boolean isBad() {
        return false;
    }

    public boolean inCluster(List<HousenumberMatch> housesNearCluster) {
        int count = 0;
        for (HousenumberMatch house : housesNearCluster) {
            if (this.knownHouses[0] == house || this.knownHouses[1] == house) {
                ++count;
            }
            if (count != 2) continue;
            break;
        }
        if (count > 0) {
            this.foundCluster = true;
            return true;
        }
        return false;
    }

    public boolean foundCluster() {
        return this.foundCluster;
    }

    public void setEqualEnds() {
        this.equalEnds = true;
    }

    public boolean setNodeRefs(Map<Long, Integer> interpolationNodes, List<HousenumberElem> houseElems) {
        for (int i = 0; i < 2; ++i) {
            long id = i == 0 ? this.n1.getId() : this.n2.getId();
            Integer elemPos = interpolationNodes.get(id);
            if (elemPos == null || elemPos >= houseElems.size()) {
                return false;
            }
            HousenumberElem he = houseElems.get(elemPos);
            if (!(he instanceof HousenumberMatch)) {
                return false;
            }
            if (he.getElement().getId() != id) {
                return false;
            }
            this.knownHouses[i] = (HousenumberMatch)he;
            this.knownHouses[i].incIntervalInfoRefs();
        }
        return true;
    }

    public HousenumberMatch[] getHouseNodes() {
        return this.knownHouses;
    }

    public HousenumberIvl[] trySplitAt(HousenumberMatch houseToAdd) {
        if (houseToAdd.isInterpolated()) {
            return null;
        }
        if (houseToAdd.getRoad() != this.knownHouses[0].getRoad() && houseToAdd.getRoad() != this.knownHouses[1].getRoad()) {
            return null;
        }
        HousenumberMatch s = this.knownHouses[0];
        HousenumberMatch e = this.knownHouses[1];
        if (s.getSegment() > e.getSegment() || s.getSegment() == e.getSegment() && s.getSegmentFrac() > e.getSegmentFrac()) {
            s = this.knownHouses[1];
            e = this.knownHouses[0];
        }
        if (houseToAdd.getSegment() < s.getSegment() || houseToAdd.getSegment() > e.getSegment()) {
            return null;
        }
        if (houseToAdd.getSegment() == s.getSegment() && houseToAdd.getSegmentFrac() < s.getSegmentFrac()) {
            return null;
        }
        if (houseToAdd.getSegment() == e.getSegment() && houseToAdd.getSegmentFrac() > e.getSegmentFrac()) {
            return null;
        }
        int i = 0;
        while (i + 1 < this.points.size()) {
            Coord c2;
            Coord c1 = this.points.get(i);
            double frac = HousenumberGenerator.getFrac(c1, c2 = this.points.get(i + 1), houseToAdd.getLocation());
            if (!(frac < 0.0) && !(frac > 1.0)) {
                HousenumberIvl[] ivls = new HousenumberIvl[2];
                HousenumberMatch hnm = null;
                if (houseToAdd.element instanceof Node) {
                    hnm = houseToAdd;
                } else {
                    Node toAdd = new Node(houseToAdd.getElement().getId(), houseToAdd.getLocation());
                    toAdd.setFakeId();
                    toAdd.copyTags(houseToAdd.element);
                    HousenumberElem hnElem = new HousenumberElem(toAdd, houseToAdd.getCityInfo());
                    hnm = new HousenumberMatch(hnElem);
                    hnm.setZipCode(houseToAdd.getZipCode());
                    HousenumberGenerator.findClosestRoadSegment(hnm, houseToAdd.getRoad(), houseToAdd.getSegment(), houseToAdd.getSegment());
                }
                ArrayList<Coord> points1 = new ArrayList<Coord>();
                ArrayList<Coord> points2 = new ArrayList<Coord>();
                points1.addAll(this.points.subList(0, i + 1));
                points1.add(houseToAdd.getLocation());
                points2.add(houseToAdd.getLocation());
                points2.addAll(this.points.subList(i + 1, this.points.size()));
                ivls[0] = new HousenumberIvl(this.streetName, this.interpolationWay, this.n1, (Node)hnm.element);
                ivls[0].setStart(this.knownHouses[0].getHousenumber());
                ivls[0].setEnd(houseToAdd.getHousenumber());
                ivls[0].setStep(this.step);
                ivls[0].calcSteps();
                ivls[0].setPoints(points1);
                ivls[0].addHousenumberMatch(this.knownHouses[0]);
                ivls[0].addHousenumberMatch(hnm);
                ivls[1] = new HousenumberIvl(this.streetName, this.interpolationWay, (Node)hnm.element, this.n2);
                ivls[1].setStart(houseToAdd.getHousenumber());
                ivls[1].setEnd(this.knownHouses[1].getHousenumber());
                ivls[1].setStep(this.step);
                ivls[1].calcSteps();
                ivls[1].setPoints(points2);
                ivls[1].addHousenumberMatch(this.knownHouses[1]);
                ivls[1].addHousenumberMatch(hnm);
                return ivls;
            }
            ++i;
        }
        return null;
    }
}

