/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.mkgmap.osmstyle.housenumber;

import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import uk.me.parabola.imgfmt.app.Coord;
import uk.me.parabola.imgfmt.app.CoordNode;
import uk.me.parabola.log.Logger;
import uk.me.parabola.mkgmap.general.CityInfo;
import uk.me.parabola.mkgmap.general.MapRoad;
import uk.me.parabola.mkgmap.general.ZipCodeInfo;
import uk.me.parabola.mkgmap.osmstyle.housenumber.ExtNumbers;
import uk.me.parabola.mkgmap.osmstyle.housenumber.HousenumberGenerator;
import uk.me.parabola.mkgmap.osmstyle.housenumber.HousenumberGroup;
import uk.me.parabola.mkgmap.osmstyle.housenumber.HousenumberMatch;

public class HousenumberRoad {
    private static final Logger log = Logger.getLogger(HousenumberRoad.class);
    private String streetName;
    private final MapRoad road;
    private CityInfo roadCityInfo;
    private ZipCodeInfo roadZipCode;
    private ExtNumbers extNumbersHead;
    private final List<HousenumberMatch> houseNumbers;
    private boolean changed;
    private boolean isRandom;
    private boolean removeGaps;
    private LinkedHashSet<String> furtherNames;

    public HousenumberRoad(MapRoad r, CityInfo ci, List<HousenumberMatch> potentialNumbersThisRoad) {
        this.streetName = r.getStreet();
        this.road = r;
        this.roadCityInfo = ci;
        this.houseNumbers = new ArrayList<HousenumberMatch>(potentialNumbersThisRoad);
        for (HousenumberMatch house : this.houseNumbers) {
            house.setHousenumberRoad(this);
        }
    }

    public void addPlaceName(String name) {
        if (this.furtherNames == null) {
            this.furtherNames = new LinkedHashSet();
        }
        this.furtherNames.add(name);
    }

    public String getName() {
        return this.streetName;
    }

    public void buildIntervals() {
        Collections.sort(this.houseNumbers, new HousenumberGenerator.HousenumberMatchByNumComparator());
        if (log.isInfoEnabled()) {
            log.info("Initial housenumbers for", this.road, "in", this.road.getCity(), this.houseNumbers);
        }
        this.filterRealDuplicates();
        this.filterGroups();
        if (this.houseNumbers.isEmpty()) {
            return;
        }
        ArrayList<HousenumberMatch> leftNumbers = new ArrayList<HousenumberMatch>();
        ArrayList<HousenumberMatch> rightNumbers = new ArrayList<HousenumberMatch>();
        for (HousenumberMatch house : this.houseNumbers) {
            if (house.getRoad() == null || house.isIgnored()) continue;
            if (house.getHousenumberRoad() != this || house.getHousenumberRoad().getRoad() != house.getRoad()) {
                log.error("internal error, road links are not correct", house.toBrowseURL());
            }
            if (house.isLeft()) {
                leftNumbers.add(house);
                continue;
            }
            rightNumbers.add(house);
        }
        this.detectGroups(leftNumbers, rightNumbers);
        Collections.sort(leftNumbers, new HousenumberGenerator.HousenumberMatchByPosComparator());
        Collections.sort(rightNumbers, new HousenumberGenerator.HousenumberMatchByPosComparator());
        int currNodePos = 0;
        int nodeIndex = 0;
        int prevNumberNodeIndex = 0;
        int prevNodePos = 0;
        this.extNumbersHead = null;
        ExtNumbers currNumbers = null;
        for (Coord p : this.road.getPoints()) {
            if (currNodePos == 0 && !this.road.skipAddToNOD()) assert (p instanceof CoordNode);
            if (!p.isNumberNode()) {
                ++currNodePos;
                continue;
            }
            if (currNodePos == 0) {
                ++nodeIndex;
                ++currNodePos;
                continue;
            }
            ExtNumbers numbers = new ExtNumbers(this);
            numbers.setNodeIndex(prevNumberNodeIndex);
            int leftUsed = numbers.setNumbers(leftNumbers, prevNodePos, currNodePos, true);
            int rightUsed = numbers.setNumbers(rightNumbers, prevNodePos, currNodePos, false);
            prevNodePos = currNodePos;
            numbers.prev = currNumbers;
            if (currNumbers != null) {
                currNumbers.next = numbers;
            } else {
                this.extNumbersHead = numbers;
            }
            currNumbers = numbers;
            leftNumbers.subList(0, leftUsed).clear();
            rightNumbers.subList(0, rightUsed).clear();
            prevNumberNodeIndex = nodeIndex++;
            ++currNodePos;
        }
    }

    private void detectGroups(List<HousenumberMatch> leftNumbers, List<HousenumberMatch> rightNumbers) {
        ArrayList<HousenumberGroup> groups = new ArrayList<HousenumberGroup>();
        for (int side = 0; side < 2; ++side) {
            boolean left = side == 0;
            List<HousenumberMatch> houses = left ? leftNumbers : rightNumbers;
            HousenumberGroup group = null;
            for (int j = 1; j < houses.size(); ++j) {
                HousenumberMatch house = houses.get(j);
                if (group == null) {
                    HousenumberMatch predHouse;
                    int deltaNum;
                    if (house.isInterpolated() || Math.abs(deltaNum = (predHouse = houses.get(j - 1)).getHousenumber() - house.getHousenumber()) > 2 || !HousenumberGroup.housesFormAGroup(predHouse, house)) continue;
                    group = new HousenumberGroup(this, houses.subList(j - 1, j + 1));
                    continue;
                }
                if (group.tryAddHouse(house)) continue;
                if (group.verify()) {
                    groups.add(group);
                }
                group = null;
            }
            if (group == null || !group.verify()) continue;
            groups.add(group);
        }
        if (groups.isEmpty()) {
            return;
        }
        boolean nodesAdded = false;
        for (HousenumberGroup group : groups) {
            int oldNumPoints = this.getRoad().getPoints().size();
            if (nodesAdded && !group.recalcPositions()) continue;
            if (group.findSegment(this.streetName, groups)) {
                nodesAdded = true;
                if (log.isDebugEnabled()) {
                    log.debug("added", this.getRoad().getPoints().size() - oldNumPoints, "number node(s) at", group.linkNode.toDegreeString(), "for group", group, "in road", this.getRoad());
                }
                oldNumPoints = this.getRoad().getPoints().size();
                int minSeg = group.minSeg;
                for (HousenumberMatch house : this.houseNumbers) {
                    if (house.getSegment() < minSeg) continue;
                    HousenumberGenerator.findClosestRoadSegment(house, this.getRoad());
                }
                group.recalcPositions();
                continue;
            }
            if (group.linkNode == null || !log.isDebugEnabled()) continue;
            log.debug("used existing zero-length-segment at", group.linkNode.toDegreeString(), "for group", group, "in road", this.getRoad());
        }
    }

    public void checkIntervals() {
        if (this.extNumbersHead == null) {
            return;
        }
        boolean anyChanges = false;
        this.extNumbersHead.detectRandom();
        for (int loop = 0; loop < 10; ++loop) {
            if (loop > 4) {
                this.setRandom(true);
            }
            this.setChanged(false);
            this.extNumbersHead = this.extNumbersHead.checkSingleChainSegments(this.streetName, this.removeGaps);
            this.extNumbersHead = this.extNumbersHead.checkChainPlausibility(this.streetName, this.houseNumbers);
            if (!this.isChanged()) break;
            anyChanges = true;
        }
        this.setChanged(anyChanges);
    }

    private void filterRealDuplicates() {
        ArrayList<HousenumberMatch> toIgnore = new ArrayList<HousenumberMatch>();
        int TO_SEARCH = 6;
        int oddLeft = 0;
        int oddRight = 0;
        int evenLeft = 0;
        int evenRight = 0;
        for (HousenumberMatch house : this.houseNumbers) {
            if (house.isIgnored()) continue;
            if (house.isLeft()) {
                if (house.getHousenumber() % 2 == 0) {
                    ++evenLeft;
                    continue;
                }
                ++oddLeft;
                continue;
            }
            if (house.getHousenumber() % 2 == 0) {
                ++evenRight;
                continue;
            }
            ++oddRight;
        }
        HousenumberMatch usedForCalc = null;
        for (int i = 1; i < this.houseNumbers.size(); ++i) {
            boolean sameSide;
            double distToUsed;
            HousenumberMatch house1 = this.houseNumbers.get(i - 1);
            HousenumberMatch house2 = this.houseNumbers.get(i);
            if (!house1.getSign().equals(house2.getSign())) {
                usedForCalc = null;
                continue;
            }
            if (!house1.isEqualAddress(house2)) continue;
            double distBetweenHouses = house2.getLocation().distance(house1.getLocation());
            double d = distToUsed = usedForCalc == null ? distBetweenHouses : house2.getLocation().distance(usedForCalc.getLocation());
            if (usedForCalc == null) {
                usedForCalc = house1.getDistance() < house2.getDistance() ? house1 : house2;
            } else {
                house1 = usedForCalc;
            }
            boolean bl = sameSide = house2.isLeft() == house1.isLeft();
            if (log.isDebugEnabled()) {
                log.debug("analysing duplicate address", this.streetName, house1.getSign(), "for road with id", this.getRoad().getRoadDef().getId());
            }
            if (sameSide && (distBetweenHouses < 100.0 || distToUsed < 100.0)) {
                HousenumberMatch obsolete;
                HousenumberMatch housenumberMatch = obsolete = house1 == usedForCalc ? house2 : house1;
                if (log.isDebugEnabled()) {
                    log.debug("house", obsolete, obsolete.toBrowseURL(), "is close to other element and on the same road side, is ignored");
                }
                toIgnore.add(obsolete);
                continue;
            }
            if (!sameSide) {
                if (log.isDebugEnabled()) {
                    log.debug("oddLeft, oddRight, evenLeft, evenRight:", oddLeft, oddRight, evenLeft, evenRight);
                }
                HousenumberMatch wrongSide = null;
                if (house2.getHousenumber() % 2 == 0) {
                    if (evenLeft == 1 && (oddLeft > 1 || evenRight > 0 && oddRight == 0)) {
                        HousenumberMatch housenumberMatch = wrongSide = house2.isLeft() ? house2 : house1;
                    }
                    if (evenRight == 1 && (oddRight > 1 || evenLeft > 0 && oddLeft == 0)) {
                        wrongSide = !house2.isLeft() ? house2 : house1;
                    }
                } else {
                    if (oddLeft == 1 && (evenLeft > 1 || oddRight > 0 && evenRight == 0)) {
                        HousenumberMatch housenumberMatch = wrongSide = house2.isLeft() ? house2 : house1;
                    }
                    if (oddRight == 1 && (evenRight > 1 || oddLeft > 0 && evenLeft == 0)) {
                        HousenumberMatch housenumberMatch = wrongSide = !house2.isLeft() ? house2 : house1;
                    }
                }
                if (wrongSide != null) {
                    if (log.isDebugEnabled()) {
                        log.debug("house", this.streetName, wrongSide.getSign(), "from", wrongSide.toBrowseURL(), "seems to be wrong, is ignored");
                    }
                    toIgnore.add(wrongSide);
                    continue;
                }
            }
            double[] sumDist = new double[2];
            double[] sumDistSameSide = new double[2];
            int[] confirmed = new int[2];
            int[] falsified = new int[2];
            int[] found = new int[2];
            List<HousenumberMatch> dups = Arrays.asList(house2, house1);
            for (int k = 0; k < dups.size(); ++k) {
                HousenumberMatch other;
                HousenumberMatch curr;
                if (k == 0) {
                    curr = dups.get(0);
                    other = dups.get(1);
                } else {
                    curr = dups.get(1);
                    other = dups.get(0);
                }
                int pos = this.houseNumbers.indexOf(curr);
                int left = pos - 1;
                int right = pos + 1;
                int stillToFind = 6;
                while (stillToFind > 0) {
                    double dist;
                    HousenumberMatch nearHouse;
                    int oldDone = stillToFind;
                    if (left >= 0) {
                        nearHouse = this.houseNumbers.get(left);
                        if (nearHouse != other) {
                            dist = curr.getLocation().distance(nearHouse.getLocation());
                            int n = k;
                            sumDist[n] = sumDist[n] + dist;
                            if (nearHouse.isLeft() == curr.isLeft()) {
                                int n2 = k;
                                sumDistSameSide[n2] = sumDistSameSide[n2] + dist;
                            }
                            if (curr.getHousenumber() == nearHouse.getHousenumber()) {
                                if (dist < 20.0) {
                                    int n3 = k;
                                    confirmed[n3] = confirmed[n3] + 1;
                                }
                            } else if (dist < 10.0) {
                                int n4 = k;
                                falsified[n4] = falsified[n4] + 1;
                            }
                        }
                        --left;
                        if (--stillToFind == 0) break;
                    }
                    if (right < this.houseNumbers.size()) {
                        nearHouse = this.houseNumbers.get(right);
                        if (nearHouse != other) {
                            dist = curr.getLocation().distance(nearHouse.getLocation());
                            int n = k;
                            sumDist[n] = sumDist[n] + dist;
                            if (nearHouse.isLeft() == curr.isLeft()) {
                                int n5 = k;
                                sumDistSameSide[n5] = sumDistSameSide[n5] + dist;
                            }
                            if (curr.getHousenumber() == nearHouse.getHousenumber()) {
                                if (dist < 40.0) {
                                    int n6 = k;
                                    confirmed[n6] = confirmed[n6] + 1;
                                }
                            } else if (dist < 10.0) {
                                int n7 = k;
                                falsified[n7] = falsified[n7] + 1;
                            }
                        }
                        --stillToFind;
                        ++right;
                    }
                    if (oldDone != stillToFind) continue;
                    break;
                }
                found[k] = 5 - stillToFind;
            }
            if (log.isDebugEnabled()) {
                log.debug("dup check 1:", this.streetName, house1, house1.toBrowseURL());
                log.debug("dup check 2:", this.streetName, house2, house2.toBrowseURL());
                log.debug("confirmed", Arrays.toString(confirmed), "falsified", Arrays.toString(falsified), "sum-dist", Arrays.toString(sumDist), "sum-dist-same-side", Arrays.toString(sumDistSameSide));
            }
            HousenumberMatch bad = null;
            if (confirmed[1] > 0 && confirmed[0] == 0 && falsified[1] == 0) {
                bad = dups.get(0);
            } else if (confirmed[0] > 0 && confirmed[1] == 0 && falsified[0] == 0) {
                bad = dups.get(1);
            } else if (found[0] > 3 && sumDist[0] > sumDist[1] && sumDistSameSide[0] > sumDistSameSide[1]) {
                bad = dups.get(0);
            } else if (found[1] > 3 && sumDist[1] > sumDist[0] && sumDistSameSide[1] > sumDistSameSide[0]) {
                bad = dups.get(1);
            }
            if (bad != null) {
                toIgnore.add(bad);
                continue;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)"duplicate house number, don't know which one to use, ignoring both");
            }
            toIgnore.add(house1);
            toIgnore.add(house2);
            house2.setIgnored(true);
            house1.setIgnored(true);
        }
        for (HousenumberMatch house : toIgnore) {
            if (log.isInfoEnabled()) {
                log.info("duplicate housenumber", this.streetName, house.getSign(), "is ignored for road with id", house.getRoad().getRoadDef().getId(), ",house:", house.toBrowseURL());
            }
            this.houseNumbers.remove(house);
        }
    }

    private void filterGroups() {
        if (this.houseNumbers.size() <= 1) {
            return;
        }
        HousenumberMatch prev = this.houseNumbers.get(0);
        HousenumberMatch used = null;
        for (int i = 1; i < this.houseNumbers.size(); ++i) {
            HousenumberMatch house = this.houseNumbers.get(i);
            if (house.getHousenumber() != prev.getHousenumber()) {
                used = null;
            } else {
                if (used == null) {
                    used = prev;
                }
                if (!prev.getSign().equals(house.getSign()) || prev.isEqualAddress(house)) {
                    house.setIgnored(true);
                    if (log.isInfoEnabled()) {
                        log.info("using", this.streetName, used.getSign(), "in favor of", house.getSign(), "as target for address search");
                    }
                }
            }
            prev = house;
        }
    }

    public void checkWrongRoadAssignmments(HousenumberRoad other) {
        if (this.extNumbersHead == null || other.extNumbersHead == null) {
            return;
        }
        for (int loop = 0; loop < 10; ++loop) {
            ExtNumbers head1;
            boolean changed = false;
            ExtNumbers en1 = head1 = this.extNumbersHead;
            while (en1 != null && !changed) {
                if (en1.hasNumbers()) {
                    ExtNumbers head2;
                    ExtNumbers en2 = head2 = other.extNumbersHead;
                    while (en2 != null && !changed) {
                        if (en2.hasNumbers()) {
                            int res = ExtNumbers.checkIntervals(this.streetName, en1, en2);
                            switch (res) {
                                case 0: 
                                case 3: {
                                    break;
                                }
                                case 1: {
                                    changed = true;
                                    this.setChanged(true);
                                    other.setChanged(true);
                                    break;
                                }
                                case 2: {
                                    ExtNumbers test;
                                    if (en1.needsSplit() && (test = en1.tryChange(0)) != en1) {
                                        changed = true;
                                        if (test.prev == null) {
                                            this.extNumbersHead = test;
                                        }
                                    }
                                    if (!en2.needsSplit() || (test = en2.tryChange(0)) == en2) break;
                                    changed = true;
                                    if (test.prev != null) break;
                                    other.extNumbersHead = test;
                                    break;
                                }
                                case 4: {
                                    return;
                                }
                                default: {
                                    log.error("can't fix", en1, en2);
                                }
                            }
                        }
                        en2 = en2.next;
                    }
                }
                en1 = en1.next;
            }
            if (!changed) break;
        }
    }

    public void setNumbers() {
        if (this.extNumbersHead == null) {
            return;
        }
        if (this.houseNumbers.isEmpty()) {
            return;
        }
        if (this.streetName == null) {
            log.error("found no name for road with housenumbers, implement a move to the next named road ?", this.road);
            return;
        }
        Object[] labels = this.road.getLabels();
        boolean found = false;
        for (String string : labels) {
            if (string == null) break;
            if (!this.streetName.equals(string)) continue;
            found = true;
        }
        if (!found) {
            if (labels[0] == null) {
                labels[0] = "";
            }
            for (int i = 1; i < labels.length; ++i) {
                if (labels[i] != null) continue;
                labels[i] = this.streetName;
                log.info("added label", this.streetName, "for", this.road, "Labels are now:", Arrays.toString(labels));
                found = true;
                break;
            }
        }
        if (!found) {
            int last = labels.length - 1;
            String droppedLabel = labels[last];
            labels[last] = this.streetName;
            if (droppedLabel != null && log.isInfoEnabled()) {
                log.info("dropped label", droppedLabel, "for", this.road, "in preference to correct address search. Labels are now:", Arrays.toString(labels));
            }
        }
        if (this.furtherNames != null) {
            boolean changed = false;
            for (String furtherName : this.furtherNames) {
                if (!this.road.addLabel(furtherName)) continue;
                changed = true;
            }
            if (changed) {
                log.info("added further labels for", this.road, "Labels are now:", Arrays.toString(labels));
            }
        }
        if (this.road.getZip() == null && this.roadZipCode != null) {
            this.road.setZip(this.roadZipCode.getZipCode());
        }
        this.road.setNumbers(this.extNumbersHead.getNumberList());
    }

    public MapRoad getRoad() {
        return this.road;
    }

    public CityInfo getRoadCityInfo() {
        return this.roadCityInfo;
    }

    public ZipCodeInfo getRoadZipCode() {
        return this.roadZipCode;
    }

    public boolean isChanged() {
        return this.changed;
    }

    public void setChanged(boolean changed) {
        this.changed = changed;
    }

    public boolean isRandom() {
        return this.isRandom;
    }

    public void setRandom(boolean isRandom) {
        if (!this.isRandom && log.isDebugEnabled()) {
            log.debug("detected random case", this);
        }
        this.isRandom = isRandom;
    }

    public void setRemoveGaps(boolean b) {
        this.removeGaps = true;
    }

    public boolean getRemoveGaps() {
        return this.removeGaps;
    }

    public void improveSearchResults() {
        ExtNumbers curr = this.extNumbersHead;
        while (curr != null) {
            ExtNumbers en = curr.splitLargeGaps();
            if (en != curr) {
                if (en.hasNumbers() && en.next != null && en.next.hasNumbers()) {
                    this.setChanged(true);
                } else {
                    ExtNumbers test;
                    ExtNumbers extNumbers = test = en.hasNumbers() ? en : en.next;
                    if (!test.getNumbers().isSimilar(curr.getNumbers())) {
                        this.setChanged(true);
                    }
                }
                if (curr.prev == null) {
                    this.extNumbersHead = en;
                }
                curr = en;
                continue;
            }
            curr = curr.next;
        }
    }

    public String toString() {
        return this.getRoad().toString() + " " + this.houseNumbers;
    }

    public List<HousenumberMatch> checkStreetName(Map<MapRoad, HousenumberRoad> road2HousenumberRoadMap, Int2ObjectOpenHashMap<HashSet<MapRoad>> nodeId2RoadLists) {
        List<HousenumberMatch> noWrongHouses = Collections.emptyList();
        List<HousenumberMatch> wrongHouses = Collections.emptyList();
        double minDist = Double.MAX_VALUE;
        double maxDist = 0.0;
        if (!this.houseNumbers.isEmpty()) {
            Iterator<Object> iter;
            HashMap<String, Integer> possibleStreetNamesFromHouses = new HashMap<String, Integer>();
            HashMap<String, Integer> possiblePlaceNamesFromHouses = new HashMap<String, Integer>();
            for (HousenumberMatch house : this.houseNumbers) {
                Integer oldCount;
                String placeName;
                Integer oldCount2;
                String potentialName;
                if (house.getDistance() > maxDist) {
                    maxDist = house.getDistance();
                }
                if (house.getDistance() < minDist) {
                    minDist = house.getDistance();
                }
                if ((potentialName = house.getStreet()) != null && (oldCount2 = possibleStreetNamesFromHouses.put(potentialName, 1)) != null) {
                    possibleStreetNamesFromHouses.put(potentialName, oldCount2 + 1);
                }
                if ((placeName = house.getPlace()) == null || (oldCount = possiblePlaceNamesFromHouses.put(placeName, 1)) == null) continue;
                possiblePlaceNamesFromHouses.put(placeName, oldCount + 1);
            }
            HashSet<String> connectedRoadNames = new HashSet<String>();
            for (Coord co : this.road.getPoints()) {
                if (co.getId() == 0) continue;
                HashSet<MapRoad> connectedRoads = nodeId2RoadLists.get(co.getId());
                for (MapRoad r : connectedRoads) {
                    if (r.getStreet() == null) continue;
                    connectedRoadNames.add(r.getStreet());
                }
            }
            if (this.streetName != null) {
                if (possibleStreetNamesFromHouses.isEmpty()) {
                    return noWrongHouses;
                }
                if (possibleStreetNamesFromHouses.size() == 1 && possibleStreetNamesFromHouses.containsKey(this.streetName)) {
                    return noWrongHouses;
                }
            }
            if (possibleStreetNamesFromHouses.isEmpty()) {
                if (this.furtherNames != null && this.furtherNames.size() > 0) {
                    iter = this.furtherNames.iterator();
                    this.streetName = (String)iter.next();
                    iter.remove();
                    if (this.furtherNames.isEmpty()) {
                        this.furtherNames = null;
                    }
                }
                return noWrongHouses;
            }
            if (this.streetName == null) {
                if (possibleStreetNamesFromHouses.size() == 1) {
                    String potentialName = (String)possibleStreetNamesFromHouses.keySet().iterator().next();
                    boolean nameOK = false;
                    if (connectedRoadNames.contains(potentialName)) {
                        nameOK = true;
                    } else if (this.houseNumbers.size() > 1) {
                        nameOK = true;
                    } else if (maxDist <= 10.0) {
                        nameOK = true;
                    }
                    if (nameOK) {
                        this.streetName = potentialName;
                        return noWrongHouses;
                    }
                } else {
                    ArrayList<String> matchingNames = new ArrayList<String>();
                    for (Map.Entry entry : possibleStreetNamesFromHouses.entrySet()) {
                        String name = (String)entry.getKey();
                        if (!connectedRoadNames.contains(name)) continue;
                        matchingNames.add(name);
                    }
                    if (matchingNames.size() == 1) {
                        this.streetName = (String)matchingNames.get(0);
                    }
                }
            }
            wrongHouses = new ArrayList<HousenumberMatch>();
            iter = this.houseNumbers.iterator();
            while (iter.hasNext()) {
                HousenumberMatch house = (HousenumberMatch)iter.next();
                if (this.streetName != null ? house.getStreet() == null || this.streetName.equalsIgnoreCase(house.getStreet()) : house.getPlace() != null) continue;
                double bestDist = Double.MAX_VALUE;
                HousenumberMatch best = null;
                for (MapRoad altRoad : house.getAlternativeRoads()) {
                    if (house.getStreet() == null || !house.getStreet().equals(altRoad.getStreet())) continue;
                    HousenumberMatch test = new HousenumberMatch(house);
                    HousenumberGenerator.findClosestRoadSegment(test, altRoad);
                    if (!(test.getDistance() < bestDist)) continue;
                    best = test;
                    bestDist = test.getDistance();
                }
                iter.remove();
                if (best != null) {
                    best.calcRoadSide();
                    wrongHouses.add(best);
                    continue;
                }
                log.warn("found no plausible road for address", house.getStreet(), house, house.toBrowseURL());
            }
        }
        return wrongHouses;
    }

    public void addHouse(HousenumberMatch house) {
        if (this.extNumbersHead != null) {
            log.error("internal error: trying to add house to road that was already processed", this.getRoad(), house);
        }
        house.setHousenumberRoad(this);
        this.houseNumbers.add(house);
    }

    public List<HousenumberMatch> getHouses() {
        return this.houseNumbers;
    }

    public void setZipCodeInfo(ZipCodeInfo zipInfo) {
        this.roadZipCode = zipInfo;
    }
}

