/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.mkgmap.reader.osm;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import uk.me.parabola.imgfmt.Utils;
import uk.me.parabola.imgfmt.app.Area;
import uk.me.parabola.imgfmt.app.Coord;
import uk.me.parabola.log.Logger;
import uk.me.parabola.mkgmap.general.LineClipper;
import uk.me.parabola.mkgmap.reader.osm.MultiPolygonRelation;
import uk.me.parabola.mkgmap.reader.osm.Node;
import uk.me.parabola.mkgmap.reader.osm.OSMId2ObjectMap;
import uk.me.parabola.mkgmap.reader.osm.OsmConverter;
import uk.me.parabola.mkgmap.reader.osm.Relation;
import uk.me.parabola.mkgmap.reader.osm.RestrictionRelation;
import uk.me.parabola.mkgmap.reader.osm.SeaPolygonRelation;
import uk.me.parabola.mkgmap.reader.osm.TagDict;
import uk.me.parabola.mkgmap.reader.osm.Way;
import uk.me.parabola.util.EnhancedProperties;

public class ElementSaver {
    private static final Logger log = Logger.getLogger(ElementSaver.class);
    protected OSMId2ObjectMap<Coord> coordMap = new OSMId2ObjectMap();
    protected Map<Long, Node> nodeMap;
    protected Map<Long, Way> wayMap;
    protected Map<Long, Relation> relationMap;
    protected final Map<Long, List<Map.Entry<String, Relation>>> deferredRelationMap = new HashMap<Long, List<Map.Entry<String, Relation>>>();
    private Area boundingBox;
    private int minLat = Utils.toMapUnit(180.0);
    private int minLon = Utils.toMapUnit(180.0);
    private int maxLat = Utils.toMapUnit(-180.0);
    private int maxLon = Utils.toMapUnit(-180.0);
    private final boolean ignoreTurnRestrictions;
    public static final String MKGMAP_REMOVE_TAG = "mkgmap:removetags";
    public static final String MKGMAP_REMOVE_TAG_ALL_KEY = "mkgmap:ALL";

    public ElementSaver(EnhancedProperties args) {
        if (args.getProperty("preserve-element-order", false)) {
            this.nodeMap = new LinkedHashMap<Long, Node>(5000);
            this.wayMap = new LinkedHashMap<Long, Way>(5000);
            this.relationMap = new LinkedHashMap<Long, Relation>();
        } else {
            this.nodeMap = new HashMap<Long, Node>();
            this.wayMap = new HashMap<Long, Way>();
            this.relationMap = new HashMap<Long, Relation>();
        }
        this.ignoreTurnRestrictions = args.getProperty("ignore-turn-restrictions", false);
    }

    public void addPoint(long id, Coord co) {
        this.coordMap.put(id, co);
        if (this.boundingBox == null) {
            if (co.getLatitude() < this.minLat) {
                this.minLat = co.getLatitude();
            }
            if (co.getLatitude() > this.maxLat) {
                this.maxLat = co.getLatitude();
            }
            if (co.getLongitude() < this.minLon) {
                this.minLon = co.getLongitude();
            }
            if (co.getLongitude() > this.maxLon) {
                this.maxLon = co.getLongitude();
            }
        }
    }

    public void addNode(Node node) {
        this.nodeMap.put(node.getId(), node);
    }

    public void addWay(Way way) {
        this.wayMap.put(way.getId(), way);
    }

    public void addRelation(Relation rel) {
        String type = rel.getTag("type");
        if (type != null) {
            if ("multipolygon".equals(type) || "boundary".equals(type)) {
                rel = this.createMultiPolyRelation(rel);
            } else if ("restriction".equals(type) || type.startsWith("restriction:")) {
                if (this.ignoreTurnRestrictions) {
                    rel = null;
                } else if (rel.getTag("restriction") == null && rel.getTagsWithPrefix("restriction:", false).isEmpty()) {
                    log.warn((Object)("ignoring unspecified/unsupported restriction " + rel.toBrowseURL()));
                } else {
                    rel = new RestrictionRelation(rel);
                }
            }
        }
        if (rel != null) {
            long id = rel.getId();
            this.relationMap.put(rel.getId(), rel);
            rel.processElements();
            List<Map.Entry<String, Relation>> entries = this.deferredRelationMap.remove(id);
            if (entries != null) {
                for (Map.Entry<String, Relation> entry : entries) {
                    entry.getValue().addElement(entry.getKey(), rel);
                }
            }
        }
    }

    public Relation createMultiPolyRelation(Relation rel) {
        return new MultiPolygonRelation(rel, this.wayMap, this.getBoundingBox());
    }

    public SeaPolygonRelation createSeaPolyRelation(Relation rel) {
        return new SeaPolygonRelation(rel, this.wayMap, this.getBoundingBox());
    }

    public void setBoundingBox(Area bbox) {
        this.boundingBox = bbox;
    }

    public Coord getCoord(long id) {
        return this.coordMap.get(id);
    }

    public Node getNode(long id) {
        return this.nodeMap.get(id);
    }

    public Way getWay(long id) {
        return this.wayMap.get(id);
    }

    public Relation getRelation(long id) {
        return this.relationMap.get(id);
    }

    public void finishLoading() {
        this.coordMap = null;
    }

    public void convert(OsmConverter converter) {
        if (this.boundingBox != null) {
            this.makeBoundaryNodes();
        }
        converter.setBoundingBox(this.getBoundingBox());
        for (Relation r : this.relationMap.values()) {
            converter.convertRelation(r);
        }
        short fixmeTagKey = TagDict.getInstance().xlate("fixme");
        short fixmeTagKey2 = TagDict.getInstance().xlate("FIXME");
        for (Node n : this.nodeMap.values()) {
            converter.convertNode(n);
            if (n.getTag(fixmeTagKey) == null && n.getTag(fixmeTagKey2) == null) continue;
            n.getLocation().setFixme(true);
        }
        this.nodeMap = null;
        Iterator<Way> wayIter = this.wayMap.values().iterator();
        while (wayIter.hasNext()) {
            Way way = wayIter.next();
            converter.convertWay(way);
            wayIter.remove();
        }
        this.wayMap = null;
        converter.end();
        this.relationMap = null;
        this.deferredRelationMap.clear();
    }

    private void makeBoundaryNodes() {
        log.info((Object)"Making boundary nodes");
        int numBoundaryNodesDetected = 0;
        int numBoundaryNodesAdded = 0;
        for (Way way : this.wayMap.values()) {
            List<Coord> points = way.getPoints();
            for (int i = points.size() - 1; i >= 1; --i) {
                Coord[] pair = new Coord[]{points.get(i - 1), points.get(i)};
                Coord[] clippedPair = LineClipper.clip(this.getBoundingBox(), pair, true);
                if (clippedPair == null) continue;
                if (clippedPair[1] != points.get(i)) {
                    assert (clippedPair[1].getOnBoundary());
                    points.add(i, clippedPair[1]);
                    ++numBoundaryNodesAdded;
                } else if (clippedPair[1].getOnBoundary()) {
                    ++numBoundaryNodesDetected;
                }
                if (clippedPair[0] != points.get(i - 1)) {
                    assert (clippedPair[0].getOnBoundary());
                    points.add(i, clippedPair[0]);
                    ++numBoundaryNodesAdded;
                    continue;
                }
                if (!clippedPair[0].getOnBoundary()) continue;
                ++numBoundaryNodesDetected;
            }
        }
        log.info((Object)("Making boundary nodes - finished (" + numBoundaryNodesAdded + " added, " + numBoundaryNodesDetected + " detected)"));
    }

    public Map<Long, Node> getNodes() {
        return this.nodeMap;
    }

    public Map<Long, Way> getWays() {
        return this.wayMap;
    }

    public Map<Long, Relation> getRelations() {
        return this.relationMap;
    }

    public Area getBoundingBox() {
        if (this.boundingBox != null) {
            return this.boundingBox;
        }
        if (this.minLat == Utils.toMapUnit(180.0) && this.maxLat == Utils.toMapUnit(-180.0)) {
            return new Area(0, 0, 0, 0);
        }
        return new Area(Math.max(Utils.toMapUnit(-90.0), this.minLat - 1), Math.max(Utils.toMapUnit(-180.0), this.minLon - 1), Math.min(Utils.toMapUnit(90.0), this.maxLat + 1), Math.min(Utils.toMapUnit(180.0), this.maxLon + 1));
    }

    public void deferRelation(long id, Relation rel, String role) {
        AbstractMap.SimpleEntry<String, Relation> entry = new AbstractMap.SimpleEntry<String, Relation>(role, rel);
        List<Map.Entry<String, Relation>> entries = this.deferredRelationMap.get(id);
        if (entries == null) {
            entries = new ArrayList<Map.Entry<String, Relation>>();
            this.deferredRelationMap.put(id, entries);
        }
        entries.add(entry);
    }
}

