/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.mkgmap.reader.osm;

import java.util.AbstractMap;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import uk.me.parabola.imgfmt.app.Coord;
import uk.me.parabola.log.Logger;
import uk.me.parabola.mkgmap.build.LocatorUtil;
import uk.me.parabola.mkgmap.osmstyle.function.LengthFunction;
import uk.me.parabola.mkgmap.reader.osm.Element;
import uk.me.parabola.mkgmap.reader.osm.ElementSaver;
import uk.me.parabola.mkgmap.reader.osm.Node;
import uk.me.parabola.mkgmap.reader.osm.OsmReadingHooksAdaptor;
import uk.me.parabola.mkgmap.reader.osm.Relation;
import uk.me.parabola.mkgmap.reader.osm.RestrictionRelation;
import uk.me.parabola.mkgmap.reader.osm.Way;
import uk.me.parabola.util.EnhancedProperties;
import uk.me.parabola.util.MultiHashMap;

public class LinkDestinationHook
extends OsmReadingHooksAdaptor {
    private static final Logger log = Logger.getLogger(LinkDestinationHook.class);
    private ElementSaver saver;
    private IdentityHashMap<Coord, Set<Way>> adjacentWays = new IdentityHashMap();
    private Map<Long, Way> destinationLinkWays = new HashMap<Long, Way>();
    private static final Set<String> highwayTypes = new LinkedHashSet<String>(Arrays.asList("motorway", "trunk", "primary", "motorway_link", "trunk_link", "primary_link"));
    private HashSet<String> linkTypes = new HashSet<String>(Arrays.asList("motorway_link", "trunk_link", "primary_link"));
    private MultiHashMap<Long, RestrictionRelation> restrictions = new MultiHashMap();
    private List<String> nameTags;
    private IdentityHashMap<Coord, Set<Way>> wayNodes = new IdentityHashMap();
    private boolean processDestinations;
    private boolean processExits;
    private LengthFunction length = new LengthFunction(){

        @Override
        public boolean isCached() {
            return false;
        }
    };

    @Override
    public boolean init(ElementSaver saver, EnhancedProperties props) {
        this.saver = saver;
        this.nameTags = LocatorUtil.getNameTags(props);
        this.processDestinations = props.containsKey("process-destination");
        this.processExits = props.containsKey("process-exits");
        return this.processDestinations || this.processExits;
    }

    private void retrieveWays() {
        for (Way w : this.saver.getWays().values()) {
            String destLanesTag;
            List<Coord> points;
            String highwayTag;
            if (w.getPoints().size() < 2 || (highwayTag = w.getTag("highway")) == null || !highwayTypes.contains(highwayTag)) continue;
            String directedDestination = null;
            if (this.isOnewayInDirection(w)) {
                points = w.getPoints().subList(0, w.getPoints().size() - 1);
                directedDestination = w.getTag("destination:forward");
            } else if (this.isOnewayOppositeDirection(w)) {
                points = w.getPoints().subList(1, w.getPoints().size());
                directedDestination = w.getTag("destination:backward");
            } else {
                points = w.getPoints();
            }
            for (Coord c : points) {
                Set<Way> ways = this.adjacentWays.get(c);
                if (ways == null) {
                    ways = new HashSet<Way>(4);
                    this.adjacentWays.put(c, ways);
                }
                ways.add(w);
            }
            this.registerPointsOfWay(w);
            if (!this.linkTypes.contains(highwayTag)) continue;
            String destinationTag = w.getTag("destination");
            if (destinationTag == null && (destLanesTag = w.getTag("destination:lanes")) != null && !destLanesTag.contains("|")) {
                w.addTag("destination", destLanesTag);
                destinationTag = destLanesTag;
                if (log.isDebugEnabled()) {
                    log.debug("Use destination:lanes tag as destination tag because there is one lane information only. Way ", w.getId(), w.toTagString());
                }
            }
            if (destinationTag == null && directedDestination != null) {
                destinationTag = directedDestination;
                w.addTag("destination", destinationTag);
            }
            if (destinationTag == null) continue;
            this.destinationLinkWays.put(w.getId(), w);
        }
        for (Relation rel : this.saver.getRelations().values()) {
            if (!(rel instanceof RestrictionRelation)) continue;
            RestrictionRelation rrel = (RestrictionRelation)rel;
            for (Long wayId : rrel.getWayIds()) {
                this.restrictions.add(wayId, rrel);
            }
        }
    }

    private void registerPointsOfWay(Way w) {
        for (Coord c : w.getPoints()) {
            Set<Way> ways = this.wayNodes.get(c);
            if (ways == null) {
                ways = new HashSet<Way>(4);
                this.wayNodes.put(c, ways);
            }
            ways.add(w);
        }
    }

    private void removePointsFromWay(Way w, int from, int to) {
        for (Coord c : w.getPoints().subList(from, to)) {
            this.wayNodes.get(c).remove(w);
        }
        w.getPoints().subList(from, to).clear();
    }

    private String getName(Element e) {
        if (e.getName() != null) {
            return e.getName();
        }
        for (String nameTag : this.nameTags) {
            String nameTagVal = e.getTag(nameTag);
            if (nameTagVal == null) continue;
            return nameTagVal;
        }
        return null;
    }

    private void changeWayIdInRelations(Way oldWay, Way newWay) {
        Object wayRestrictions = this.restrictions.get(oldWay.getId());
        if (wayRestrictions.isEmpty()) {
            return;
        }
        if (oldWay.isViaWay()) {
            newWay.setViaWay(true);
        }
        for (RestrictionRelation rr : new ArrayList(wayRestrictions)) {
            Coord lastPointNewWay = newWay.getPoints().get(0);
            List<Coord> viaCoords = rr.getViaCoords();
            for (Coord via : viaCoords) {
                if (via != lastPointNewWay) continue;
                if (rr.isToWay(oldWay.getId())) {
                    log.debug("Change to-way", oldWay.getId(), "to", newWay.getId(), "for relation", rr.getId(), "at", lastPointNewWay.toOSMURL());
                    rr.replaceWay(oldWay.getId(), newWay.getId());
                    this.restrictions.removeMapping(oldWay.getId(), rr);
                    this.restrictions.add(newWay.getId(), rr);
                    continue;
                }
                if (!rr.isFromWay(oldWay.getId())) continue;
                log.debug("Change from-way", oldWay.getId(), "to", newWay.getId(), "for relation", rr.getId(), "at", lastPointNewWay.toOSMURL());
                rr.replaceWay(oldWay.getId(), newWay.getId());
                this.restrictions.removeMapping(oldWay.getId(), rr);
                this.restrictions.add(newWay.getId(), rr);
            }
        }
    }

    private Way cutoffWay(Way w, double cutLength, double maxLength, Coord c1, Coord c2) {
        if (w.getPoints().size() < 2) {
            return null;
        }
        if (w.getPoints().size() >= 3) {
            Coord cutPoint;
            Coord firstPoint = w.getPoints().get(0);
            double dist = firstPoint.distance(cutPoint = w.getPoints().get(1));
            if (dist <= maxLength) {
                Way precedingWay = new Way(w.getOriginalId(), w.getPoints().subList(0, 2));
                precedingWay.setFakeId();
                precedingWay.copyTags(w);
                this.saver.addWay(precedingWay);
                this.removePointsFromWay(w, 0, 1);
                this.registerPointsOfWay(precedingWay);
                this.changeWayIdInRelations(w, precedingWay);
                log.debug("Cut way", w, "at existing point 1. New way:", precedingWay);
                return precedingWay;
            }
            log.debug("Cannot cut way", w, "on existing nodes because the first distance is too big:", dist);
        }
        double startSegmentLength = 0.0;
        Coord lastC = w.getPoints().get(0);
        for (int i = 1; i < w.getPoints().size(); ++i) {
            Coord c = w.getPoints().get(i);
            double segmentLength = lastC.distance(c);
            if (startSegmentLength + segmentLength >= cutLength) {
                double frac = (cutLength - startSegmentLength) / segmentLength;
                Coord cConnection = lastC.makeBetweenPoint(c, frac);
                if (c1 != null && c2 != null && cConnection != null) {
                    double oldAngle = this.getAngle(c1, c2, c);
                    double newAngle = this.getAngle(c1, c2, cConnection);
                    if (Math.signum(oldAngle) != Math.signum(newAngle)) {
                        double bestAngleDiff = 180.0;
                        Coord bestCoord = cConnection;
                        for (Coord cNeighbour : this.getDirectNeighbours(cConnection)) {
                            double neighbourAngle = this.getAngle(c1, c2, cNeighbour);
                            if (Math.signum(oldAngle) != Math.signum(neighbourAngle) || !(Math.abs(oldAngle - neighbourAngle) < bestAngleDiff)) continue;
                            bestAngleDiff = Math.abs(oldAngle - neighbourAngle);
                            bestCoord = cNeighbour;
                        }
                        if (log.isDebugEnabled()) {
                            log.debug("Changed orientation:", oldAngle, "to", newAngle);
                            log.debug("on Link", w);
                            log.debug("Corrected coord ", cConnection, "to", bestCoord);
                        }
                        cConnection = bestCoord;
                    }
                }
                w.getPoints().add(i, cConnection);
                Way precedingWay = new Way(w.getOriginalId(), new ArrayList<Coord>(w.getPoints().subList(0, i + 1)));
                precedingWay.setFakeId();
                precedingWay.copyTags(w);
                this.saver.addWay(precedingWay);
                this.removePointsFromWay(w, 0, i);
                this.registerPointsOfWay(precedingWay);
                this.changeWayIdInRelations(w, precedingWay);
                return precedingWay;
            }
            lastC = c;
        }
        return null;
    }

    private List<Coord> getDirectNeighbours(Coord c) {
        ArrayList<Coord> neighbours = new ArrayList<Coord>(8);
        for (int dLat = -1; dLat < 2; ++dLat) {
            for (int dLon = -1; dLon < 2; ++dLon) {
                if (dLat == 0 && dLon == 0) continue;
                neighbours.add(new Coord(c.getLatitude() + dLat, c.getLongitude() + dLon));
            }
        }
        return neighbours;
    }

    private boolean isTaggedAsExit(Node node) {
        if (!"motorway_junction".equals(node.getTag("highway"))) {
            return false;
        }
        return node.getTag("ref") != null || this.getName(node) != null || node.getTag("exit_to") != null;
    }

    private List<Map.Entry<Coord, Way>> getNextNodes(Coord node, boolean drivingDirection) {
        ArrayList<Map.Entry<Coord, Way>> nextNodes = new ArrayList<Map.Entry<Coord, Way>>();
        Set<Way> connectedWays = this.wayNodes.get(node);
        for (Way w : connectedWays) {
            boolean oneWayDirection;
            int index = w.getPoints().indexOf(node);
            if (index < 0) {
                log.error((Object)("Cannot find node " + node + " in way " + w));
                continue;
            }
            if ((index += (drivingDirection ? 1 : -1) * ((oneWayDirection = this.isOnewayInDirection(w)) ? 1 : -1)) < 0 || index >= w.getPoints().size()) continue;
            nextNodes.add(new AbstractMap.SimpleEntry<Coord, Way>(w.getPoints().get(index), w));
        }
        return nextNodes;
    }

    /*
     * WARNING - void declaration
     */
    private void processWays() {
        ArrayDeque<Way> linksWithDestination = new ArrayDeque<Way>();
        linksWithDestination.addAll(this.destinationLinkWays.values());
        log.debug(this.destinationLinkWays.size(), "links with destination tag");
        while (!linksWithDestination.isEmpty()) {
            Set<Way> nextWays;
            Way linkWay = (Way)linksWithDestination.poll();
            String destination = linkWay.getTag("destination");
            if (log.isDebugEnabled()) {
                log.debug("Check way", linkWay.getId(), linkWay.toTagString());
            }
            Coord c = linkWay.getPoints().get(linkWay.getPoints().size() - 1);
            if (this.isOnewayOppositeDirection(linkWay)) {
                c = linkWay.getPoints().get(0);
            }
            if ((nextWays = this.adjacentWays.get(c)) == null) continue;
            for (Way way : nextWays) {
                boolean startEndConnection;
                String nextDest = way.getTag("destination");
                if (log.isDebugEnabled()) {
                    log.debug("Followed by", way.getId(), way.toTagString());
                }
                if (!(startEndConnection = !way.getPoints().isEmpty() && way.getPoints().get(0).equals(c)) || way.equals(linkWay) || !way.getTag("highway").endsWith("_link") || !destination.equals(nextDest)) continue;
                this.destinationLinkWays.remove(way.getId());
                if (!log.isDebugEnabled()) continue;
                log.debug("Removed", way.getId(), way.toTagString());
            }
        }
        log.debug(this.destinationLinkWays.size(), "links with destination tag after cleanup");
        if (this.processExits) {
            LinkedHashMap highwayCoords = new LinkedHashMap();
            for (String type : highwayTypes) {
                highwayCoords.put(type, new HashSet());
            }
            for (Way w : this.saver.getWays().values()) {
                String highwayTag = w.getTag("highway");
                if (highwayTag == null || !highwayTypes.contains(highwayTag)) continue;
                Set set = (Set)highwayCoords.get(highwayTag);
                set.addAll(w.getPoints());
            }
            for (Node exitNode : this.saver.getNodes().values()) {
                if (!this.isTaggedAsExit(exitNode) || !this.saver.getBoundingBox().contains(exitNode.getLocation())) continue;
                String expectedHighwayTag = null;
                for (Map.Entry entry : highwayCoords.entrySet()) {
                    if (!((Set)entry.getValue()).contains(exitNode.getLocation())) continue;
                    expectedHighwayTag = (String)entry.getKey();
                    break;
                }
                if (expectedHighwayTag == null) {
                    if (!log.isDebugEnabled()) continue;
                    log.debug("Skip non highway exit:", exitNode.toBrowseURL(), exitNode.toTagString());
                    continue;
                }
                Set<Way> exitWays = this.adjacentWays.get(exitNode.getLocation());
                if (exitWays == null) {
                    log.debug("Exit node", exitNode, "has no connected ways. Skip it.");
                    continue;
                }
                List<Map.Entry<Coord, Way>> list = this.getNextNodes(exitNode.getLocation(), true);
                Coord nextHighwayNode = null;
                int countMatches = 0;
                for (Map.Entry<Coord, Way> nextNode : list) {
                    if (!expectedHighwayTag.equals(nextNode.getValue().getTag("highway"))) continue;
                    nextHighwayNode = nextNode.getKey();
                    ++countMatches;
                }
                if (countMatches > 1) {
                    nextHighwayNode = null;
                }
                for (Way w : exitWays) {
                    double cut2;
                    this.destinationLinkWays.remove(w.getId());
                    if (this.isNotOneway(w)) {
                        log.warn("Ignore way", w, "because it is not oneway");
                        continue;
                    }
                    if (w.isViaWay()) {
                        log.warn("Ignore way", w, "because it is a via way in a restriction  relation");
                        continue;
                    }
                    String highwayLinkTag = w.getTag("highway");
                    if (!highwayLinkTag.endsWith("_link")) continue;
                    log.debug("Try to cut", highwayLinkTag, w, "into three parts for giving hint to exit", exitNode);
                    double wayLength = this.getLength(w);
                    if (wayLength < 10.0 && w.getPoints().size() < 3) {
                        log.info("Way", w, "is too short (", wayLength, " m) to cut it into several pieces. Cannot place exit hint.");
                        continue;
                    }
                    double cut1 = Math.min(wayLength / 2.0, 20.0);
                    Way wayPart1 = this.cutoffWay(w, cut1, cut2 = Math.min(wayLength, 100.0), exitNode.getLocation(), nextHighwayNode);
                    if (wayPart1 == null) {
                        log.info("Way", w, "is too short to cut at least ", cut1, "m from it. Cannot create exit hint.");
                        continue;
                    }
                    if (log.isDebugEnabled()) {
                        log.debug("Cut off way", wayPart1, wayPart1.toTagString());
                    }
                    Way hintWay = w;
                    if (wayLength > 50.0) {
                        hintWay = this.cutoffWay(w, 10.0, 50.0, exitNode.getLocation(), nextHighwayNode);
                    }
                    if (hintWay == null) {
                        log.info("Way", w, "is too short to cut at least 20m from it. Cannot create exit hint.");
                        continue;
                    }
                    hintWay.addTag("mkgmap:exit_hint", "true");
                    if (this.processDestinations && hintWay.getTag("destination") != null) {
                        hintWay.addTag("mkgmap:dest_hint", "true");
                    }
                    if (exitNode.getTag("ref") != null) {
                        hintWay.addTag("mkgmap:exit_hint_ref", exitNode.getTag("ref"));
                    }
                    if (countMatches == 1 && exitNode.getTag("exit_to") != null) {
                        hintWay.addTag("mkgmap:exit_hint_exit_to", exitNode.getTag("exit_to"));
                    }
                    if (this.getName(exitNode) != null) {
                        hintWay.addTag("mkgmap:exit_hint_name", this.getName(exitNode));
                    }
                    if (!log.isInfoEnabled()) continue;
                    log.info("Cut off exit hint way", hintWay, hintWay.toTagString());
                }
            }
        }
        if (this.processDestinations) {
            while (!this.destinationLinkWays.isEmpty()) {
                void var7_13;
                double cut2;
                Way w = this.destinationLinkWays.values().iterator().next();
                this.destinationLinkWays.remove(w.getId());
                if (this.isNotOneway(w)) {
                    log.warn("Ignore way", w, "because it is not oneway");
                    continue;
                }
                if (w.isViaWay()) {
                    log.warn("Ignore way", w, "because it is a via way in a restriction  relation");
                    continue;
                }
                String highwayLinkTag = w.getTag("highway");
                if (!highwayLinkTag.endsWith("_link")) continue;
                log.debug("Try to cut", highwayLinkTag, w, "into three parts for giving hint");
                Coord firstNode = w.getPoints().get(0);
                Coord secondNode = w.getPoints().get(1);
                List<Map.Entry<Coord, Way>> nextNodes = this.getNextNodes(firstNode, true);
                Object var7_12 = null;
                double angle = Double.MAX_VALUE;
                for (Map.Entry<Coord, Way> nextNode : nextNodes) {
                    double thisAngle;
                    if (nextNode.getValue().equals(w) || !(Math.abs(thisAngle = this.getAngle(firstNode, secondNode, nextNode.getKey())) < angle)) continue;
                    angle = Math.abs(thisAngle);
                    Coord coord = nextNode.getKey();
                }
                double wayLength = this.getLength(w);
                if (wayLength < 10.0) {
                    log.info("Way", w, "is too short (", wayLength, " m) to cut it into several pieces. Cannot place destination hint.");
                    continue;
                }
                double cut1 = Math.min(wayLength / 2.0, 20.0);
                Way wayPart1 = this.cutoffWay(w, cut1, cut2 = Math.min(wayLength, 100.0), firstNode, (Coord)var7_13);
                if (wayPart1 == null) {
                    log.info("Way", w, "is too short to cut at least 10m from it. Cannot create destination hint.");
                    continue;
                }
                if (log.isDebugEnabled()) {
                    log.debug("Cut off way", wayPart1, wayPart1.toTagString());
                }
                Way hintWay = w;
                if (wayLength > 50.0) {
                    hintWay = this.cutoffWay(w, 10.0, 50.0, firstNode, (Coord)var7_13);
                }
                if (hintWay == null) {
                    log.info("Way", w, "is too short to cut at least 20m from it. Cannot create destination hint.");
                    continue;
                }
                hintWay.addTag("mkgmap:dest_hint", "true");
                if (!log.isInfoEnabled()) continue;
                log.info("Cut off exit hint way", hintWay, hintWay.toTagString());
            }
        }
    }

    private double getAngle(Coord cCenter, Coord c1, Coord c2) {
        double dx1 = c1.getLongitude() - cCenter.getLongitude();
        double dy1 = -(c1.getLatitude() - cCenter.getLatitude());
        double dx2 = c2.getLongitude() - cCenter.getLongitude();
        double dy2 = -(c2.getLatitude() - cCenter.getLatitude());
        double inRads1 = Math.atan2(dy1, dx1);
        double inRads2 = Math.atan2(dy2, dx2);
        return Math.toDegrees(inRads2) - Math.toDegrees(inRads1);
    }

    private void cleanup() {
        this.adjacentWays = null;
        this.wayNodes = null;
        this.destinationLinkWays = null;
        this.linkTypes = null;
        this.saver = null;
        this.nameTags = null;
    }

    @Override
    public Set<String> getUsedTags() {
        if (!this.processDestinations && !this.processExits) {
            return Collections.emptySet();
        }
        HashSet<String> tags = new HashSet<String>();
        tags.add("highway");
        tags.add("destination:lanes");
        tags.add("destination:forward");
        tags.add("destination:backward");
        if (this.processExits) {
            tags.add("exit_to");
            tags.add("ref");
        }
        return tags;
    }

    @Override
    public void end() {
        log.info((Object)"LinkDestinationHook started");
        this.retrieveWays();
        if (this.processExits || this.processDestinations) {
            this.processWays();
        }
        this.cleanup();
        log.info((Object)"LinkDestinationHook finished");
    }

    private boolean isOnewayInDirection(Way w) {
        if (w.tagIsLikeYes("oneway")) {
            return true;
        }
        String onewayTag = w.getTag("oneway");
        String highwayTag = w.getTag("highway");
        return onewayTag == null && highwayTag != null && (highwayTag.equals("motorway") || highwayTag.equals("motorway_link"));
    }

    private boolean isOnewayOppositeDirection(Way w) {
        return "-1".equals(w.getTag("oneway"));
    }

    private boolean isNotOneway(Way w) {
        return "no".equals(w.getTag("oneway")) || !this.isOnewayInDirection(w) && !this.isOnewayOppositeDirection(w);
    }

    private double getLength(Way w) {
        String lengthValue = this.length.value(w);
        try {
            return Math.round(Double.valueOf(lengthValue));
        }
        catch (Exception exp) {
            return 0.0;
        }
    }
}

