/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.mkgmap.reader.osm;

import java.util.Arrays;
import uk.me.parabola.log.Logger;
import uk.me.parabola.mkgmap.reader.osm.ElementSaver;
import uk.me.parabola.mkgmap.reader.osm.OsmReadingHooksAdaptor;
import uk.me.parabola.mkgmap.reader.osm.Way;
import uk.me.parabola.util.EnhancedProperties;

public class MultiPolygonFinishHook
extends OsmReadingHooksAdaptor {
    private static final Logger log = Logger.getLogger(MultiPolygonFinishHook.class);
    private ElementSaver saver;

    @Override
    public boolean init(ElementSaver saver, EnhancedProperties props) {
        this.saver = saver;
        return true;
    }

    @Override
    public void end() {
        long t1 = System.currentTimeMillis();
        log.info((Object)"Finishing multipolygons");
        for (Way way : this.saver.getWays().values()) {
            String removeTag = way.getTag("mkgmap:removetags");
            if (removeTag == null) continue;
            if ("mkgmap:ALL".equals(removeTag)) {
                if (log.isDebugEnabled()) {
                    log.debug("Remove all tags from way", way.getId(), way.toTagString());
                }
                way.removeAllTags();
                continue;
            }
            Object[] tagsToRemove = removeTag.split(";");
            if (log.isDebugEnabled()) {
                log.debug("Remove tags", Arrays.toString(tagsToRemove), "from way", way.getId(), way.toTagString());
            }
            for (Object rTag : tagsToRemove) {
                way.deleteTag((String)rTag);
            }
            way.deleteTag("mkgmap:removetags");
        }
        log.info((Object)("Multipolygon hook finished in " + (System.currentTimeMillis() - t1) + " ms"));
    }
}

