/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.mkgmap.reader.osm;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import uk.me.parabola.imgfmt.app.Coord;
import uk.me.parabola.log.Logger;
import uk.me.parabola.mkgmap.build.LocatorUtil;
import uk.me.parabola.mkgmap.reader.osm.Element;
import uk.me.parabola.mkgmap.reader.osm.ElementSaver;
import uk.me.parabola.mkgmap.reader.osm.MultiPolygonRelation;
import uk.me.parabola.mkgmap.reader.osm.Node;
import uk.me.parabola.mkgmap.reader.osm.OsmReadingHooksAdaptor;
import uk.me.parabola.mkgmap.reader.osm.Relation;
import uk.me.parabola.mkgmap.reader.osm.TagDict;
import uk.me.parabola.mkgmap.reader.osm.Way;
import uk.me.parabola.util.EnhancedProperties;

public class POIGeneratorHook
extends OsmReadingHooksAdaptor {
    private static final Logger log = Logger.getLogger(POIGeneratorHook.class);
    private List<Map.Entry<String, String>> poiPlacementTags;
    private ElementSaver saver;
    private boolean poisToAreas = false;
    private boolean poisToLines = false;
    private List<String> nameTags;
    public static final short AREA2POI_TAG = TagDict.getInstance().xlate("mkgmap:area2poi");
    public static final short LINE2POI_TAG = TagDict.getInstance().xlate("mkgmap:line2poi");
    public static final short LINE2POI_TYPE_TAG = TagDict.getInstance().xlate("mkgmap:line2poitype");

    @Override
    public boolean init(ElementSaver saver, EnhancedProperties props) {
        this.poisToAreas = props.containsKey("add-pois-to-areas");
        this.poisToLines = props.containsKey("add-pois-to-lines");
        if (!(this.poisToAreas || this.poisToLines)) {
            log.info((Object)"Disable Areas2POIHook because add-pois-to-areas and add-pois-to-lines option is not set.");
            return false;
        }
        this.nameTags = LocatorUtil.getNameTags(props);
        this.poiPlacementTags = POIGeneratorHook.getPoiPlacementTags(props);
        this.saver = saver;
        return true;
    }

    public static List<Map.Entry<String, String>> getPoiPlacementTags(EnhancedProperties props) {
        String[] placementDefsParts;
        if (!props.containsKey("add-pois-to-areas")) {
            return Collections.emptyList();
        }
        ArrayList<Map.Entry<String, String>> tagList = new ArrayList<Map.Entry<String, String>>();
        String placementDefs = props.getProperty("pois-to-areas-placement", "entrance=main;entrance=yes;building=entrance");
        if ((placementDefs = placementDefs.trim()).length() == 0) {
            return tagList;
        }
        for (String placementDef : placementDefsParts = placementDefs.split(";")) {
            int ind = placementDef.indexOf(61);
            String tagName = null;
            String tagValue = null;
            if (ind < 0) {
                tagName = placementDef;
                tagValue = null;
            } else if (ind > 0) {
                tagName = placementDef.substring(0, ind);
                tagValue = placementDef.substring(ind + 1);
            } else {
                log.error((Object)"Option pois-to-areas-placement contains a tag that starts with '='. This is not allowed. Ignoring it.");
                continue;
            }
            tagName = tagName.trim();
            if (tagName.length() == 0) {
                log.error((Object)"Option pois-to-areas-placement contains a whitespace tag  '='. This is not allowed. Ignoring it.");
                continue;
            }
            if (tagValue != null && ((tagValue = tagValue.trim()).length() == 0 || "*".equals(tagValue))) {
                tagValue = null;
            }
            AbstractMap.SimpleImmutableEntry<String, String> tag = new AbstractMap.SimpleImmutableEntry<String, String>(tagName, tagValue);
            tagList.add(tag);
        }
        return tagList;
    }

    @Override
    public Set<String> getUsedTags() {
        HashSet<String> tags = new HashSet<String>();
        for (Map.Entry<String, String> poiTag : this.poiPlacementTags) {
            tags.add(poiTag.getKey());
        }
        return tags;
    }

    @Override
    public void end() {
        log.info((Object)"Areas2POIHook started");
        this.addPOIsToWays();
        this.addPOIsToMPs();
        log.info((Object)"Areas2POIHook finished");
    }

    private int getPlacementOrder(Element elem) {
        for (int order = 0; order < this.poiPlacementTags.size(); ++order) {
            Map.Entry<String, String> poiTagDef = this.poiPlacementTags.get(order);
            String tagValue = elem.getTag(poiTagDef.getKey());
            if (tagValue == null || poiTagDef.getValue() != null && !poiTagDef.getValue().equals(tagValue)) continue;
            return order;
        }
        return -1;
    }

    private void addPOIsToWays() {
        IdentityHashMap<Coord, Integer> labelCoords = new IdentityHashMap<Coord, Integer>();
        if (!this.poiPlacementTags.isEmpty() && this.poisToAreas) {
            for (Node n : this.saver.getNodes().values()) {
                Integer prevOrder;
                int order = this.getPlacementOrder(n);
                if (order < 0 || (prevOrder = (Integer)labelCoords.get(n.getLocation())) != null && order >= prevOrder) continue;
                labelCoords.put(n.getLocation(), order);
            }
        }
        log.debug("Found", labelCoords.size(), "label coords");
        int ways2POI = 0;
        int lines2POI = 0;
        for (Way w : this.saver.getWays().values()) {
            if (w.getTagCount() == 0) continue;
            if (w.tagIsLikeYes("mkgmap:mp_created")) {
                if (!log.isDebugEnabled()) continue;
                log.debug("MP processed: Do not create POI for", w.toTagString());
                continue;
            }
            if (w.hasIdenticalEndPoints()) {
                if (!this.poisToAreas) continue;
                this.addPOItoPolygon(w, labelCoords);
                ++ways2POI;
                continue;
            }
            if (!this.poisToLines) continue;
            lines2POI += this.addPOItoLine(w);
        }
        if (this.poisToAreas) {
            log.info(ways2POI, "POIs from single areas created");
        }
        if (this.poisToLines) {
            log.info(lines2POI, "POIs from lines created");
        }
    }

    private void addPOItoPolygon(Way polygon, Map<Coord, Integer> labelCoords) {
        if (!this.poisToAreas) {
            return;
        }
        Coord poiCoord = null;
        if (labelCoords.size() > 0) {
            int poiOrder = Integer.MAX_VALUE;
            for (Coord c : polygon.getPoints()) {
                Integer cOrder = labelCoords.get(c);
                if (cOrder == null || cOrder >= poiOrder) continue;
                poiCoord = c;
                poiOrder = cOrder;
                if (poiOrder != 0) continue;
                break;
            }
        }
        if (poiCoord == null) {
            poiCoord = polygon.getCofG();
        }
        Node poi = POIGeneratorHook.createPOI(polygon, poiCoord, AREA2POI_TAG);
        this.saver.addNode(poi);
    }

    private int addPOItoLine(Way line) {
        Node startNode = POIGeneratorHook.createPOI(line, line.getPoints().get(0), LINE2POI_TAG);
        startNode.addTag(LINE2POI_TYPE_TAG, "start");
        this.saver.addNode(startNode);
        Node endNode = POIGeneratorHook.createPOI(line, line.getPoints().get(line.getPoints().size() - 1), LINE2POI_TAG);
        endNode.addTag(LINE2POI_TYPE_TAG, "end");
        this.saver.addNode(endNode);
        int noPOIs = 2;
        Coord lastPoint = line.getPoints().get(0);
        if (line.getPoints().size() > 2) {
            for (Coord inPoint : line.getPoints().subList(1, line.getPoints().size() - 1)) {
                if (inPoint.equals(lastPoint)) continue;
                lastPoint = inPoint;
                Node innerNode = POIGeneratorHook.createPOI(line, inPoint, LINE2POI_TAG);
                innerNode.addTag(LINE2POI_TYPE_TAG, "inner");
                this.saver.addNode(innerNode);
                ++noPOIs;
            }
        }
        Coord prevC = null;
        double sumDist = 0.0;
        ArrayList<Double> dists = new ArrayList<Double>(line.getPoints().size() - 1);
        for (Coord c : line.getPoints()) {
            if (prevC != null) {
                double dist = prevC.distance(c);
                dists.add(dist);
                sumDist += dist;
            }
            prevC = c;
        }
        Coord midPoint = null;
        double remMidDist = sumDist / 2.0;
        for (int midPos = 0; midPos < dists.size(); ++midPos) {
            double nextDist = (Double)dists.get(midPos);
            if (remMidDist <= nextDist) {
                double frac = remMidDist / nextDist;
                midPoint = line.getPoints().get(midPos).makeBetweenPoint(line.getPoints().get(midPos + 1), frac);
                break;
            }
            remMidDist -= nextDist;
        }
        if (midPoint != null) {
            Node midNode = POIGeneratorHook.createPOI(line, midPoint, LINE2POI_TAG);
            midNode.addTag(LINE2POI_TYPE_TAG, "mid");
            this.saver.addNode(midNode);
            ++noPOIs;
        }
        return noPOIs;
    }

    private static Node createPOI(Element source, Coord poiCoord, short poiTypeTagKey) {
        Node poi = new Node(source.getOriginalId(), poiCoord);
        poi.setFakeId();
        poi.copyTags(source);
        poi.deleteTag("mkgmap:stylefilter");
        poi.addTag(poiTypeTagKey, "true");
        if (log.isDebugEnabled()) {
            log.debug("Create POI", poi.toTagString(), "from", source.getId(), source.toTagString());
        }
        return poi;
    }

    private String getName(Element e) {
        for (String nameTag : this.nameTags) {
            String nameTagVal = e.getTag(nameTag);
            if (nameTagVal == null) continue;
            return nameTagVal;
        }
        return null;
    }

    private void addPOIsToMPs() {
        int mps2POI = 0;
        for (Relation r : this.saver.getRelations().values()) {
            if (!(r instanceof MultiPolygonRelation)) continue;
            Node admin_centre = null;
            Node labelPOI = null;
            String relName = this.getName(r);
            if (relName != null) {
                for (Map.Entry<String, Element> pair : r.getElements()) {
                    String role = pair.getKey();
                    Element el = pair.getValue();
                    if (!(el instanceof Node)) continue;
                    if ("admin_centre".equals(role)) {
                        String pName;
                        if (!"boundary".equals(r.getTag("type")) || !"administrative".equals(r.getTag("boundary")) || !relName.equals(pName = this.getName(el))) continue;
                        admin_centre = (Node)el;
                        if (!log.isDebugEnabled()) continue;
                        log.debug("using admin_centre node as location for POI for rel", r.getId(), relName, "at", ((Node)el).getLocation().toDegreeString());
                        continue;
                    }
                    if (!"label".equals(role)) continue;
                    String label = this.getName(el);
                    if (relName.equals(label)) {
                        labelPOI = (Node)el;
                        log.debug("using label node as location for POI for rel", r.getId(), relName, "at", ((Node)el).getLocation().toDegreeString());
                        break;
                    }
                    log.warn("rel", r.toBrowseURL(), ",node with role label is ignored because it has a different name");
                }
            }
            Coord point = null;
            point = admin_centre == null && labelPOI == null ? ((MultiPolygonRelation)r).getCofG() : (labelPOI != null ? labelPOI.getLocation() : admin_centre.getLocation());
            if (point == null) continue;
            Node poi = POIGeneratorHook.createPOI(r, point, AREA2POI_TAG);
            poi.deleteTag("type");
            this.saver.addNode(poi);
            ++mps2POI;
        }
        log.info(mps2POI, "POIs from multipolygons created");
    }
}

