/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.mkgmap.reader.osm;

import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import uk.me.parabola.imgfmt.app.Area;
import uk.me.parabola.imgfmt.app.Coord;
import uk.me.parabola.log.Logger;
import uk.me.parabola.mkgmap.reader.osm.Element;
import uk.me.parabola.mkgmap.reader.osm.ElementSaver;
import uk.me.parabola.mkgmap.reader.osm.Node;
import uk.me.parabola.mkgmap.reader.osm.OsmReadingHooksAdaptor;
import uk.me.parabola.mkgmap.reader.osm.POIGeneratorHook;
import uk.me.parabola.mkgmap.reader.osm.Relation;
import uk.me.parabola.mkgmap.reader.osm.Way;
import uk.me.parabola.util.EnhancedProperties;

public class UnusedElementsRemoverHook
extends OsmReadingHooksAdaptor {
    private static final Logger log = Logger.getLogger(UnusedElementsRemoverHook.class);
    private ElementSaver saver;
    private Collection<String> nodeTagBlacklist;

    @Override
    public boolean init(ElementSaver saver, EnhancedProperties props) {
        this.saver = saver;
        this.nodeTagBlacklist = new HashSet<String>();
        List<Map.Entry<String, String>> areasToPoiNodeTags = POIGeneratorHook.getPoiPlacementTags(props);
        for (Map.Entry<String, String> nodeTags : areasToPoiNodeTags) {
            this.nodeTagBlacklist.add(nodeTags.getKey());
        }
        return true;
    }

    @Override
    public void end() {
        long t1 = System.currentTimeMillis();
        log.info((Object)"Removing unused elements");
        Area bbox = this.saver.getBoundingBox();
        long nodes = this.saver.getNodes().size();
        for (Node node : new ArrayList<Node>(this.saver.getNodes().values())) {
            if (node.getTagCount() == 0) {
                this.saver.getNodes().remove(node.getId());
                continue;
            }
            if (bbox.contains(node.getLocation())) continue;
            boolean removeNode = true;
            if (!this.nodeTagBlacklist.isEmpty()) {
                for (String tag : this.nodeTagBlacklist) {
                    if (node.getTag(tag) == null) continue;
                    removeNode = false;
                    break;
                }
            }
            if (removeNode) {
                this.saver.getNodes().remove(node.getId());
                continue;
            }
            log.debug("Keep node", node, "because it contains a tag which might be required for the area-to-poi function.");
        }
        long tr1 = System.currentTimeMillis();
        HashSet<Long> relationWays = new HashSet<Long>();
        for (Relation rel : this.saver.getRelations().values()) {
            for (Map.Entry<String, Element> relEntry : rel.getElements()) {
                if (!(relEntry.getValue() instanceof Way)) continue;
                relationWays.add(relEntry.getValue().getId());
            }
        }
        log.debug("Collecting way ids from relations took", System.currentTimeMillis() - tr1, "ms");
        Rectangle bboxRect = new Rectangle(bbox.getMinLong(), bbox.getMinLat(), bbox.getWidth(), bbox.getHeight());
        long relWays = 0L;
        long ways = this.saver.getWays().size();
        for (Way way : new ArrayList<Way>(this.saver.getWays().values())) {
            if (way.getPoints().isEmpty()) {
                this.saver.getWays().remove(way.getId());
                continue;
            }
            if (way.getTagCount() == 0) {
                if (relationWays.contains(way.getId())) {
                    ++relWays;
                } else {
                    this.saver.getWays().remove(way.getId());
                    continue;
                }
            }
            boolean coordInBbox = false;
            Coord prevC = null;
            Coord firstC = way.getPoints().get(0);
            int minLat = firstC.getLatitude();
            int maxLat = firstC.getLatitude();
            int minLong = firstC.getLongitude();
            int maxLong = firstC.getLongitude();
            for (Coord c : way.getPoints()) {
                if (bbox.contains(c)) {
                    coordInBbox = true;
                    break;
                }
                if (prevC != null && bboxRect.intersectsLine(prevC.getLongitude(), prevC.getLatitude(), c.getLongitude(), c.getLatitude())) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Intersection!");
                        log.debug("Bbox:", bbox);
                        log.debug("Way coords:", prevC, c);
                    }
                    coordInBbox = true;
                    break;
                }
                if (minLat > c.getLatitude()) {
                    minLat = c.getLatitude();
                } else if (maxLat < c.getLatitude()) {
                    maxLat = c.getLatitude();
                }
                if (minLong > c.getLongitude()) {
                    minLong = c.getLongitude();
                } else if (maxLong < c.getLongitude()) {
                    maxLong = c.getLongitude();
                }
                prevC = c;
            }
            if (coordInBbox) continue;
            Area wayBbox = new Area(minLat, minLong, maxLat, maxLong);
            if (wayBbox.intersects(this.saver.getBoundingBox())) {
                log.debug(way, "possibly covers the bbox completely. Keep it.", way.toTagString());
                continue;
            }
            this.saver.getWays().remove(way.getId());
        }
        log.info("Relation referenced ways:", relationWays.size(), "Used:", relWays);
        log.info("Nodes: before:", nodes, "after:", this.saver.getNodes().size());
        log.info("Ways: before:", ways, "after:", this.saver.getWays().size());
        log.info("Removing unused elements took", System.currentTimeMillis() - t1, "ms");
    }
}

