/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.mkgmap.reader.polish;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import uk.me.parabola.imgfmt.app.Coord;
import uk.me.parabola.imgfmt.app.CoordNode;
import uk.me.parabola.imgfmt.app.net.NumberStyle;
import uk.me.parabola.imgfmt.app.net.Numbers;
import uk.me.parabola.log.Logger;
import uk.me.parabola.mkgmap.general.MapLine;
import uk.me.parabola.mkgmap.general.MapRoad;

class RoadHelper {
    private static final Logger log = Logger.getLogger(RoadHelper.class);
    private final Map<Long, CoordNode> nodeCoords = new HashMap<Long, CoordNode>();
    private int roadId;
    private final List<NodeIndex> nodes = new ArrayList<NodeIndex>();
    private int speed;
    private int roadClass;
    private boolean oneway;
    private boolean toll;
    private byte mkgmapAccess;
    private List<Numbers> numbers;

    public RoadHelper() {
        this.clear();
    }

    public void clear() {
        this.roadId = 0;
        this.nodes.clear();
        this.speed = 0;
        this.roadClass = 0;
        this.oneway = false;
        this.toll = false;
        this.numbers = null;
    }

    public void setRoadId(int roadId) {
        this.roadId = roadId;
    }

    public void addNode(String value) {
        String[] f = value.split(",");
        this.nodes.add(new NodeIndex(f));
    }

    public void setParam(String param) {
        String[] f = param.split(",");
        this.speed = Integer.parseInt(f[0]);
        if (this.speed < 0) {
            this.speed = 0;
        }
        if (this.speed > 7) {
            this.speed = 7;
        }
        this.roadClass = Integer.parseInt(f[1]);
        if (this.roadClass < 0) {
            this.roadClass = 0;
        }
        if (this.roadClass > 4) {
            this.roadClass = 4;
        }
        boolean bl = f.length > 2 ? Integer.parseInt(f[2]) > 0 : (this.oneway = false);
        this.toll = f.length > 3 ? Integer.parseInt(f[3]) > 0 : false;
        int noAccess = 0;
        block10: for (int j = 0; j < f.length - 4; ++j) {
            if (Integer.parseInt(f[4 + j]) == 0) continue;
            switch (j) {
                case 0: {
                    noAccess = (byte)(noAccess | 0xFFFFFF80);
                    continue block10;
                }
                case 1: {
                    noAccess = (byte)(noAccess | 8);
                    continue block10;
                }
                case 2: {
                    noAccess = (byte)(noAccess | 4);
                    continue block10;
                }
                case 3: {
                    noAccess = (byte)(noAccess | 0x20);
                    continue block10;
                }
                case 4: {
                    noAccess = (byte)(noAccess | 0x40);
                    continue block10;
                }
                case 5: {
                    noAccess = (byte)(noAccess | 1);
                    continue block10;
                }
                case 6: {
                    noAccess = (byte)(noAccess | 2);
                    continue block10;
                }
                case 7: {
                    noAccess = (byte)(noAccess | 0x10);
                }
            }
        }
        this.mkgmapAccess = (byte)(~noAccess);
    }

    public MapRoad makeRoad(MapLine l) {
        assert (this.roadId != 0);
        if (log.isDebugEnabled()) {
            log.debug((Object)("finishing road id " + this.roadId));
        }
        MapRoad road = new MapRoad(this.roadId, this.roadId, l);
        road.setRoadClass(this.roadClass);
        road.setSpeed(this.speed);
        if (this.oneway) {
            road.setOneway();
        }
        if (this.toll) {
            road.setToll();
        }
        road.setAccess(this.mkgmapAccess);
        if (this.numbers != null && !this.numbers.isEmpty()) {
            this.convertNodesForHouseNumbers(road);
            road.setNumbers(this.numbers);
        }
        List<Coord> points = road.getPoints();
        for (NodeIndex ni : this.nodes) {
            Coord coord;
            long id;
            int n = ni.index;
            if (log.isDebugEnabled()) {
                log.debug((Object)("road has " + points.size() + " points"));
            }
            if ((id = (long)(coord = points.get(n)).getId()) == 0L) {
                CoordNode node = this.nodeCoords.get(ni.nodeId);
                if (node == null) {
                    node = new CoordNode(coord, ni.nodeId, ni.boundary);
                    this.nodeCoords.put(Long.valueOf(ni.nodeId), node);
                }
                points.set(n, node);
                continue;
            }
            if (id == (long)ni.nodeId) continue;
            log.warn((Object)"Inconsistant node ids");
        }
        return road;
    }

    private void convertNodesForHouseNumbers(MapRoad road) {
        int rNodNumber = 0;
        for (Numbers n : this.numbers) {
            int node = n.getNodeNumber();
            n.setIndex(rNodNumber++);
            road.getPoints().get(node).setNumberNode(true);
        }
    }

    public boolean isRoad() {
        return this.roadId != 0;
    }

    public Map<Long, CoordNode> getNodeCoords() {
        return this.nodeCoords;
    }

    public void addNumbers(String value) {
        Numbers num;
        if (this.numbers == null) {
            this.numbers = new ArrayList<Numbers>();
        }
        if ((num = new Numbers(value)).getLeftNumberStyle() != NumberStyle.NONE || num.getRightNumberStyle() != NumberStyle.NONE) {
            this.numbers.add(num);
        }
    }

    private static class NodeIndex {
        private final int index;
        private final int nodeId;
        private boolean boundary;

        private NodeIndex(String[] f) {
            this.index = Integer.parseInt(f[0]);
            this.nodeId = Integer.parseInt(f[1]);
            if (f.length > 2) {
                boolean bl = this.boundary = Integer.parseInt(f[2]) > 0;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("ind=" + this.index + "node=" + this.nodeId + "bound=" + this.boundary));
            }
        }

        public String toString() {
            return String.format("%d,%d,%b", this.index, this.nodeId, this.boundary);
        }
    }
}

