/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.mkgmap.reader.test;

import java.util.ArrayList;
import java.util.Properties;
import uk.me.parabola.imgfmt.app.Coord;
import uk.me.parabola.mkgmap.general.MapCollector;
import uk.me.parabola.mkgmap.general.MapLine;
import uk.me.parabola.mkgmap.general.MapPoint;
import uk.me.parabola.mkgmap.general.MapShape;
import uk.me.parabola.mkgmap.reader.osm.GType;

class AllElements {
    private static final double ELEMENT_SPACING = 0.002;
    private static final double ELEMENT_SIZE = 0.001;
    private static final int MAX_POINT_TYPE = 127;
    private static final int MAX_POINT_SUB_TYPE = 31;
    private static final int MAX_LINE_TYPE_X = 4;
    private static final int MAX_LINE_TYPE_Y = 16;
    private static final int MAX_SHAPE_TYPE_X = 8;
    private static final int MAX_SHAPE_TYPE_Y = 16;
    private Properties configProps;

    public AllElements(Properties configProps) {
        this.configProps = configProps;
    }

    public void load(MapCollector mapper) {
        double baseLat = 51.7;
        double baseLong = 0.24;
        String sBaseLat = System.getenv("BASE_LAT");
        String sBaseLong = System.getenv("BASE_LONG");
        if (sBaseLat == null) {
            sBaseLat = this.configProps.getProperty("base-lat");
        }
        if (sBaseLong == null) {
            sBaseLong = this.configProps.getProperty("base-long");
        }
        if (sBaseLat != null) {
            baseLat = Double.valueOf(sBaseLat);
        }
        if (sBaseLong != null) {
            baseLong = Double.valueOf(sBaseLong);
        }
        this.drawTestMap(mapper, baseLat, baseLong);
    }

    private void drawTestMap(MapCollector map, double startLat, double startLong) {
        double lng = startLong;
        this.drawPoints(map, startLat, lng);
        this.drawLines(map, startLat, lng += 0.256);
        this.drawPolygons(map, startLat, lng += 0.008);
    }

    private void drawPoints(MapCollector mapper, double slat, double slon) {
        double lat = slat + 0.004;
        double lon = slon + 0.002;
        for (int maintype = 0; maintype <= 127; ++maintype) {
            for (int subtype = 0; subtype <= 31; ++subtype) {
                int type = (maintype << 8) + subtype;
                MapPoint point = new MapPoint();
                double baseLat = lat + (double)subtype * 0.002;
                double baseLong = lon + (double)maintype * 0.002;
                point.setMinResolution(10);
                point.setName(GType.formatType(type));
                point.setLocation(new Coord(baseLat, baseLong));
                point.setType(type);
                mapper.addPoint(point);
                if (this.configProps.containsKey("verbose")) {
                    System.out.println("Generated POI " + GType.formatType(type) + " at " + point.getLocation().toDegreeString());
                }
                mapper.addToBounds(point.getLocation());
            }
        }
    }

    private void drawLines(MapCollector mapper, double slat, double slon) {
        double lat = slat + 0.004;
        double lon = slon + 0.002;
        int type = 0;
        for (int x = 0; x < 4; ++x) {
            for (int y = 0; y < 16 && ++type < 64; ++y) {
                MapLine line = new MapLine();
                line.setMinResolution(10);
                line.setName(GType.formatType(type));
                double baseLat = lat + (double)y * 0.002;
                double baseLong = lon + (double)x * 0.002;
                ArrayList<Coord> coords = new ArrayList<Coord>();
                Coord co = new Coord(baseLat, baseLong);
                coords.add(co);
                mapper.addToBounds(co);
                if (this.configProps.containsKey("verbose")) {
                    System.out.println("Generated line " + GType.formatType(type) + " at " + co.toDegreeString());
                }
                co = new Coord(baseLat + 0.001, baseLong + 0.001);
                coords.add(co);
                mapper.addToBounds(co);
                co = new Coord(baseLat + 0.001, baseLong + 0.001 + 5.0E-4);
                coords.add(co);
                mapper.addToBounds(co);
                line.setType(type);
                line.setPoints(coords);
                mapper.addLine(line);
            }
        }
    }

    private void drawPolygons(MapCollector mapper, double slat, double slon) {
        double lat = slat + 0.004;
        double lon = slon + 0.002;
        int type = 0;
        for (int x = 0; x < 8; ++x) {
            for (int y = 0; y < 16 && ++type < 128; ++y) {
                MapShape shape = new MapShape();
                shape.setMinResolution(10);
                shape.setName(GType.formatType(type));
                double baseLat = lat + (double)y * 0.002;
                double baseLong = lon + (double)x * 0.002;
                ArrayList<Coord> coords = new ArrayList<Coord>();
                Coord co = new Coord(baseLat, baseLong);
                coords.add(co);
                if (this.configProps.containsKey("verbose")) {
                    System.out.println("Generated polygon " + GType.formatType(type) + " at " + co.toDegreeString());
                }
                co = new Coord(baseLat + 0.001, baseLong);
                coords.add(co);
                mapper.addToBounds(co);
                co = new Coord(baseLat + 0.001, baseLong + 0.001);
                coords.add(co);
                mapper.addToBounds(co);
                co = new Coord(baseLat, baseLong + 0.001);
                coords.add(co);
                mapper.addToBounds(co);
                coords.add((Coord)coords.get(0));
                shape.setType(type);
                shape.setPoints(coords);
                mapper.addShape(shape);
            }
        }
    }
}

