/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.mkgmap.typ;

import uk.me.parabola.imgfmt.app.typ.TypData;
import uk.me.parabola.mkgmap.scan.SyntaxException;
import uk.me.parabola.mkgmap.scan.TokenScanner;
import uk.me.parabola.mkgmap.srt.SrtTextReader;
import uk.me.parabola.mkgmap.typ.ProcessSection;

class IdSection
implements ProcessSection {
    private final TypData data;

    public IdSection(TypData data) {
        this.data = data;
    }

    @Override
    public void processLine(TokenScanner scanner, String name, String value) {
        int ival;
        try {
            ival = Integer.decode(value);
        }
        catch (NumberFormatException e) {
            throw new SyntaxException(scanner, "Bad integer " + value);
        }
        if (name.equalsIgnoreCase("FID")) {
            this.data.setFamilyId(ival);
        } else if (name.equalsIgnoreCase("ProductCode")) {
            this.data.setProductId(ival);
        } else if (name.equalsIgnoreCase("CodePage")) {
            this.data.setSort(SrtTextReader.sortForCodepage(ival));
        } else {
            throw new SyntaxException(scanner, "Unrecognised keyword in id section: " + name);
        }
    }

    @Override
    public void finish(TokenScanner scanner) {
    }
}

