/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.util;

import java.util.LinkedHashSet;
import java.util.Set;
import uk.me.parabola.imgfmt.app.Coord;
import uk.me.parabola.util.Locatable;

public class KdTree<T extends Locatable> {
    private static final boolean ROOT_NODE_USES_LONGITUDE = false;
    private KdNode root = null;
    private int size;
    private T nextPoint;
    private double minDist;
    private double maxDist;
    private Set<T> set;

    public long size() {
        return this.size;
    }

    public void add(T toAdd) {
        ++this.size;
        this.root = this.add(toAdd, this.root, false);
    }

    private boolean isSmaller(boolean longitude, Coord c1, Coord c2) {
        if (longitude) {
            return c1.getLongitude() < c2.getLongitude();
        }
        return c1.getLatitude() < c2.getLatitude();
    }

    private KdNode add(T toAdd, KdNode tree, boolean useLongitude) {
        if (tree == null) {
            tree = new KdNode(this, toAdd);
        } else if (this.isSmaller(useLongitude, toAdd.getLocation(), tree.point.getLocation())) {
            tree.left = this.add(toAdd, tree.left, !useLongitude);
        } else {
            tree.right = this.add(toAdd, tree.right, !useLongitude);
        }
        return tree;
    }

    public T findNextPoint(Locatable p) {
        this.minDist = Double.MAX_VALUE;
        this.maxDist = -1.0;
        this.set = null;
        this.nextPoint = null;
        return this.findNextPoint(p, this.root, false);
    }

    public Set<T> findNextPoint(Locatable p, double maxDist) {
        this.minDist = Double.MAX_VALUE;
        this.maxDist = Math.pow(maxDist * 360.0 / 4.007501668557849E7, 2.0);
        this.nextPoint = null;
        this.set = new LinkedHashSet<T>();
        this.findNextPoint(p, this.root, false);
        return this.set;
    }

    private T findNextPoint(Locatable p, KdNode tree, boolean useLongitude) {
        Coord test;
        boolean continueWithLeft = false;
        if (tree == null) {
            return this.nextPoint;
        }
        if (tree.left == null && tree.right == null) {
            double dist = tree.point.getLocation().distanceInDegreesSquared(p.getLocation());
            if (dist <= this.maxDist && this.set != null) {
                this.set.add(tree.point);
            }
            if (dist < this.minDist) {
                this.nextPoint = tree.point;
                this.minDist = dist < this.maxDist ? this.maxDist : dist;
            }
            return this.nextPoint;
        }
        if (this.isSmaller(useLongitude, p.getLocation(), tree.point.getLocation())) {
            continueWithLeft = false;
            this.nextPoint = this.findNextPoint(p, tree.left, !useLongitude);
        } else {
            continueWithLeft = true;
            this.nextPoint = this.findNextPoint(p, tree.right, !useLongitude);
        }
        double dist = tree.point.getLocation().distanceInDegreesSquared(p.getLocation());
        if (dist <= this.maxDist && this.set != null) {
            this.set.add(tree.point);
        }
        if (dist < this.minDist) {
            this.nextPoint = tree.point;
            this.minDist = dist;
            this.minDist = dist < this.maxDist ? this.maxDist : dist;
        }
        if ((test = useLongitude ? Coord.makeHighPrecCoord(p.getLocation().getHighPrecLat(), tree.point.getLocation().getHighPrecLon()) : Coord.makeHighPrecCoord(tree.point.getLocation().getHighPrecLat(), p.getLocation().getHighPrecLon())).distanceInDegreesSquared(p.getLocation()) < this.minDist) {
            this.nextPoint = continueWithLeft ? this.findNextPoint(p, tree.left, !useLongitude) : this.findNextPoint(p, tree.right, !useLongitude);
        }
        return this.nextPoint;
    }

    private static class KdNode {
        T point;
        KdNode left;
        KdNode right;
        final /* synthetic */ KdTree this$0;

        KdNode(T p) {
            this.this$0 = var1_1;
            this.point = p;
        }
    }
}

