// Helper function that initializes clear text string.
// Translate alphabetic characters to '*'
function InitAnswer( cipher )
{
   var result = "";
   cipher = "" + cipher; // whatever cipher is, make it a string
   var len = cipher.length;
   var pos = 0;
   while( pos < len )
   {
      var chr = cipher.substring( pos, pos + 1 );
      if ( (chr >= "A" && chr <= "Z") || (chr >= "a" && chr <= "z")  )
      {
         result = result + "*";
      }
      else
      {
         result = result + chr;
      }
      pos = pos + 1;
   }
   return result;
}

// Helper function to look through cipher and make character substitutions.
function CipherSubstitute( from, to, cipher, clear )
{
   var result = "";
   var len = cipher.length;
   var pos = 0;
   while( pos < len )
   {
      var cipher_char  = cipher.substring( pos, pos + 1 );
      var clear_char = clear.substring( pos, pos + 1);
      if ( cipher_char == from )
      {
         result = result + to;
      }
      else
      {
         result = result + clear_char;
      }
      pos = pos + 1;
   }
   return result;
}

/* This is a C style comment
with more lines
and more 
and more
*/

// Helper function to mix together lines from two strings.
// Assume both strings are same length and have new lines in identical places.
function CipherMix( src1, src2 )
{
   var result = "";
   var len = src1.length;
   var start = 0;
   while( start < len )
   {
      // Copy 1st string until new line character
      var pos = start;
      var chr = src1.substring( pos, pos + 1 );
      while( chr != "\n" && pos < len )
      {
         result = result + chr;
         pos = pos + 1;
         chr = src1.substring( pos, pos + 1 );
      }

      // Copy new line from 1st string
      result = result + chr;

      // Copy 2nd string until new line character
      pos = start;
      chr = src2.substring( pos, pos + 1 );
      while( chr != "\n" && pos < len )
      {
         result = result + chr;
         pos = pos + 1;
         chr = src2.substring( pos, pos + 1 );
      }

      // Copy new line from 2nd string
      result = result + chr;

      // move past new line in both strings
      start = pos + 1;
   }
   return result;
}
