/*
**  POST
**  Prepare and post an article to a moderated source group.
*/
#include <stdio.h>
#if	!defined(lint) && !defined(SABER)
static char	 RCS[] =
	"$Header: post.c,v 1.17 89/02/09 00:00:40 rsalz Locked $";
#endif	/* .. */

/*
**  Configuration parameters.
*/
#define APPROVED	"rsalz@uunet.UU.NET"	/* The Approved: line	*/
#define EDITOR		"vi"			/* Default editor	*/
#define INEWS		"/usr/lib/news/inews"	/* Where inews lives	*/
#define HASHNEWS	"hashnews"		/* Snefru hash program	*/
#define NEWSGROUP	"comp.sources.unix"	/* Where to post to	*/
#define QUEUE_DIR	"S"		/* .ISSUE and .LOGFILE are here	*/
# undef SENDER		"sources"		/* For inews (optional)	*/
#define SEQFILE		"/usr/lib/news/seq"	/* For the message-id	*/
# undef strchr		index			/* Tomayto Tomahto	*/
# undef strrchr		rindex			/* Tomayto Tomahto	*/
#define TO		"comp-sources-outbound"	/* Where to mail stuff	*/
#define SENDMAIL	"/usr/lib/sendmail"	/* Mailer program	*/
#define CHECKSUMHDR	"X-Checksum-Snefru: "	/* Checksum header line	*/
#define SUBJECTHDR	"Subject: "


/*
**  Handy shorthands.
*/
#define GAG(s)		perror(s), exit(1)
#define PREFIX(a, b)	(strncmp((a), (b), sizeof (b) - 1) == 0)
#define LENGTH		256
#define TEMPFILE	"/tmp/modXXXXXX"
#define TRUE		1
#define FALSE		0


/*
**  Linked in later.
*/
extern int	 optind;
extern char	*optarg;
extern long	 atol();
extern char	*strchr();
extern char	*strrchr();
extern char	*getenv();
extern char	*mktemp();
extern char	*strcpy();



/*
**  Call $EDITOR for last-minute cleanups.
*/
static void
Edit(TMP)
    char		*TMP;
{
    register FILE	*F;
    register char	*p;
    char		 buff[LENGTH];

    if ((p = getenv("EDITOR")) == NULL)
	p = EDITOR;

    for ( ; ; ) {
	(void)sprintf(buff, "exec %s %s", p, TMP);
	(void)system(buff);

	if ((F = fopen(TMP, "r")) == NULL)
	    GAG(TMP);

	while (fgets(buff, sizeof buff, F))
	    if (PREFIX(buff, SUBJECTHDR)) {
		(void)fclose(F);
		return;
	    }
	(void)fclose(F);
	printf("Add subject line...\n");
    }
}


/*
**  Parse the headers, copying relevant ones to output, and storing
**  useful ones like Subject and From.  Returns (hack!) pointer to
**  first non-header line so we can output it after doing our special
**  headers.
*/
static char *
Header(In, Subject, From)
    register FILE	*In;
    char		*Subject;
    char		*From;
{
    static char		 buff[LENGTH];
    register char	*p;
    register char	*q;
    char		 From_[LENGTH];
    char		 FromC[LENGTH];

    /* Mail files have a From_ line. */
    if (fgets(buff, sizeof buff, In) == NULL)
	GAG("Empty file");
    if (p = strchr(buff, '\n'))
	*p = '\0';
    if (PREFIX(buff, "From ")) {
	(void)strcpy(From_, buff);
	if (fgets(buff, sizeof buff, In) == NULL)
	    GAG("Nothing after the From_");
    }
    else
	From_[0] = '\0';

    /* Scan headers, picking out what we want.. */
    FromC[0] = '\0';
    while (strchr(buff, ':') || buff[0] == ' ' || buff[0] == '\t') {
	if (p = strchr(buff, '\n'))
	    *p = '\0';
	if (PREFIX(buff, "From: "))
	    (void)strcpy(FromC, buff + 6);
	else if (PREFIX(buff, SUBJECTHDR))
	    (void)strcpy(Subject, &buff[sizeof SUBJECTHDR - 1]);
	if (fgets(buff, sizeof buff, In) == NULL)
	    GAG("Nothing after the headers");
    }

    /* Get the author. */
    if (FromC[0])
	(void)strcpy(From, FromC);
    else if (q = strchr(From_, ' ')) {
	if (p = strchr(++q, ' '))
	    *p = '\0';
	(void)strcpy(From, q);
    }
    else {
	printf("Who is this from?  ");
	(void)fgets(From, sizeof From, stdin);
    }
    if (p = strchr(From, '\n'))
	*p = '\0';

    /* This is the first non-header line. */
    return buff;
}


/*
**  Scan article for Snefru checksum header.
*/
static int
GetChecksum(Name, buff)
    char	*Name;
    char	*buff;
{
    register FILE	*F;
    char		line[LENGTH];
    char		*p;

    F = fopen(Name, "r");

    /* Read up to the headers. */
    while (fgets(line, sizeof line, F) && line[0] != '\n')
	if (PREFIX(line, CHECKSUMHDR)) {
	    if (p = strchr(line, '\n'))
		*p = '\0';
	    (void)strcpy(buff, &line[sizeof CHECKSUMHDR - 1]);
	    (void)fclose(F);
	    return TRUE;
	}
    (void)fclose(F);
    return FALSE;
}


/*
**  Print usage message and quit.
*/
static void
Usage()
{
    fprintf(stderr, "Usage:\n  post\t%s\n\t%s\n\tinput_file\n",
	"-aArchive -sSubject -pPart# -lLast# -IInfo# -iIssue# -vVol#",
	"-fFile (doesn't post) -b (background) -n (info post) -x (nohash)"
    );
    exit(1);
}


main(ac, av)
    int			 ac;
    char		*av[];
{
    register char	*HOME;
    register char	*p;
    register char	*Q;
    register FILE	*F;
    register FILE	*Out;
    register int	c;
    register int	Normal;
    register int	Part;
    register int	Source;
    char		*File;
    char		*Mysubj;
    char		*Saved;
    char		archbuff[LENGTH];
    char		Archname[LENGTH];
    char		buff[LENGTH];
    char		From[LENGTH];
    char		Subject[LENGTH];
    char		TMP[sizeof TEMPFILE];
    int			Background;
    int			DoHash;
    int			Info;
    int			Issue;
    int			LastPart;
    int			Volume;
#ifdef	SEQFILE
    long		N;
#endif	/* SEQFILE */

    /* Where do we live? */
    if ((HOME = getenv("HOME")) == NULL)
	GAG("No $HOME");
    if ((Q = getenv("POSTQUEUE")) == NULL)
	Q = QUEUE_DIR;

    /* Get stored sequence numbers. */
    if (Q[0] == '/')
	(void)sprintf(buff, "%s/.ISSUE", Q);
    else
	(void)sprintf(buff, "%s/%s/.ISSUE", HOME, Q);
    if ((F = fopen(buff, "r")) == NULL)
	GAG("fopen(ISSUE)");
    if (fgets(buff, sizeof buff, F) == NULL)
	GAG("fgets(ISSUE)");
    if (sscanf(buff, "%d %d %d", &Volume, &Issue, &Info) != 3)
	GAG("sscanf(ISSUE)");
    (void)fclose(F);

    /* Set defaults. */
    Archname[0] = '\0';
    Background = FALSE;
    File = NULL;
    LastPart = 0;
    Mysubj = NULL;
    Normal = TRUE;
    Part = 0;
    Source = TRUE;
    DoHash = TRUE;

    /* Parse JCL. */
    while ((c = getopt(ac, av, "a:bf:i:I:l:np:s:v:X")) != EOF)
	switch (c) {
	default:
	    Usage();
	    /* NOTREACHED */
	case 'a':
	    (void)strcpy(Archname, optarg);
	    break;
	case 'b':
	    Background++;
	    break;
	case 'f':
	    File = optarg;
	    break;
	case 'i':
	    Issue = atoi(optarg);
	    Normal = FALSE;
	    break;
	case 'I':
	    Info = atoi(optarg);
	    Normal = FALSE;
	    Source = FALSE;
	    break;
	case 'l':
	    LastPart = atoi(optarg);
	    break;
	case 'n':
	    Source = FALSE;
	    break;
	case 'p':
	    Part = atoi(optarg);
	    break;
	case 's':
	    Mysubj = optarg;
	    break;
	case 'v':
	    Volume = atoi(optarg);
	    Normal = FALSE;
	    break;
	case 'X':
	    DoHash = FALSE;
	    break;
	}
    av += optind;
    if (av[0] == NULL || av[1])
	Usage();

    /* Update sequence numbers if not overridden. */
    if (Normal)
	if (Source)
	    Issue++;
	else
	    Info++;
    printf("Preparing %s volume %d, issue %d, Info %d.\n",
	NEWSGROUP, Volume, Issue, Info);

    /* Open input and temporary output files. */
    if ((F = fopen(*av, "r")) == NULL)
	GAG(*av);
    if ((Out = fopen(mktemp(strcpy(TMP, TEMPFILE)), "w")) == NULL)
	GAG(TMP);

    /* Parse the headers. */
    Saved = Header(F, Subject, From);

    /* Get the subject line, if not already specified. */
    if (Mysubj)
	(void)strcpy(Subject, Mysubj);
    else {
	printf("Original subject was '%s'.\n", Subject);
	printf("New Subject:   ");
	(void)fgets(Subject, sizeof Subject, stdin);
	if (p = strchr(Subject, '\n'))
	    *p = '\0';
    }

    /* Get the archive name, if not already specified. */
    if (Archname[0] == '\0') {
	printf("Archive Name:  ");
	(void)fgets(Archname, sizeof Archname, stdin);
	if (p = strchr(Archname, '\n'))
	    *p = '\0';
    }

    /* If it's source, check for multi-part posting. */
    if (Source) {
	if (Part == 0) {
	    printf("Part Number:   ");
	    (void)fgets(buff, sizeof buff, stdin);
	    Part = atoi(buff);
	}
	if (Part) {
	    /* Check for losing USG archivers. */
	    if (strlen(Archname) + sizeof ".CPIO.Z" - 1 > 14)
		printf("Warning:  Worst-case is %7.7s.CPIO.Z.\n", Archname);
	    if (Part > 0 && LastPart == 0) {
		printf("of how many:   ");
		(void)fgets(buff, sizeof buff, stdin);
		LastPart = atoi(buff);
	    }
	}
    }
    else if (strlen(Archname) > 14)
	printf("Warning:  Worst-case is %14.14s.\n", Archname);

    /* Write the main headers. */
    if (Source)
	fprintf(Out, "Subject:  v%2.2di%3.3d:  %s", Volume, Issue, Subject);
    else
	fprintf(Out, "Subject:  v%2.2dINF%1.1d:  %s", Volume, Info, Subject);
    if (Part < 0)
	fprintf(Out, ", Patch%d", -Part);
    else if (Part)
	fprintf(Out, ", Part%2.2d/%2.2d", Part, LastPart);
    fprintf(Out, "\n");
    fprintf(Out, "Newsgroups: %s\n", NEWSGROUP);
#ifdef	SENDER
    fprintf(Out, "Sender: %s\n", SENDER);
#endif	/* SENDER */
    fprintf(Out, "Approved: %s\n\n", APPROVED);

    /* Write the auxiliary headers. */
    fprintf(Out, "Submitted-by: %s\n", From);
    if (Source)
	fprintf(Out, "Posting-number: Volume %d, Issue %d\n", Volume, Issue);
    else
	fprintf(Out, "Posting-number: Volume %d, Info %d\n", Volume, Info);
    if (Part < 0)
	(void)sprintf(archbuff, "%s/patch%d", Archname, -Part);
    else if (Part)
	(void)sprintf(archbuff, "%s/part%2.2d", Archname, Part);
    else
	(void)strcpy(archbuff, Archname);
    fprintf(Out, "Archive-name: %s\n\n", archbuff);

    /* Print the saved first line of the message, copy the rest. */
    if (Saved && *Saved && *Saved != '\n')
	fprintf(Out, "%s\n", Saved);
    while (fgets(buff, sizeof buff, F))
	fputs(buff, Out);
    (void)fclose(F);
    (void)fprintf(Out, "exit 0 # Just in case...\n");
    (void)fclose(Out);

    /* Edit the temp file. */
    Edit(TMP);
    printf("Proceed [y]?  ");
    if (fgets(buff, sizeof buff, stdin) == NULL
     || (buff[0] != '\n' && buff[0] != 'y' && buff[0] != 'Y'))
	GAG("Cancelled -- tmp file still there");

    if (DoHash) {
	printf("Hashing...\n");
	(void)sprintf(buff, "exec %s %s", HASHNEWS, TMP);
	(void)system(buff);
    }

    /* Overwrite the input file, update our sequence number. */
    (void)sprintf(buff, "exec /bin/cp %s %s", TMP, File ? File : *av);
    (void)system(buff);
    (void)sprintf(buff, "%s/%s/.ISSUE", HOME, Q);
    if ((F = fopen(buff, "w")) == NULL)
	perror(buff);
    else {
	fprintf(F, "%d %d %d\n", Volume, Issue, Info);
	(void)fclose(F);
    }

    if (File) {
#ifdef	SEQFILE
	N = 0;
#endif	/* SEQFILE */
    }
    else {
	printf("Original file overwritten, .ISSUE updated.\n");

	/* Free up the terminal? */
	if (Background) {
	    printf("Moving into the background.\n");
	    (void)fflush(stdout);
	    (void)fflush(stderr);
	    if (fork() > 0)
		exit(0);
	}

	/* Post it. */
	printf("Posting...\n");
	(void)sprintf(buff, "exec %s -h <%s", INEWS, TMP);
	(void)system(buff);

#ifdef	SEQFILE
	/* Get the Message-ID.  Race condition... */
	if ((F = fopen(SEQFILE, "r")) == NULL) {
	    perror(SEQFILE);
	    N = 0;
	}
	else {
	    (void)fgets(buff, sizeof buff, F);
	    (void)fclose(F);
	    N = atol(buff);
	}
#endif	/* SEQFILE */
    }

    /* Update the log. */
    if (Q[0] == '/')
	(void)sprintf(buff, "%s/.LOGFILE", Q);
    else
	(void)sprintf(buff, "%s/%s/.LOGFILE", HOME, Q);
    if ((F = fopen(buff, "a")) == NULL)
	perror(buff);
    else {
	fprintf(F, "%s%s\t",
	    archbuff, strlen(archbuff) < 8 ? "\t" : "");
	if (Source)
	    fprintf(F, "v%2.2di%3.3d:  %s", Volume, Issue, Subject);
	else
	    fprintf(F, "v%2.2dINF%1.1d:  %s", Volume, Info, Subject);
	if (Part < 0)
	    fprintf(F, ", Patch%d", -Part);
	else if (Part)
	    fprintf(F, ", Part%2.2d/%2.2d", Part, LastPart);
	fprintf(F, "\n");
#ifdef	SEQFILE
	if (N) {
	    fprintf(F, "\tMessage-ID: %ld", N);
	    if (!DoHash)
		fprintf(F, "\n");
	}
#endif	/* SEQFILE */
	if (DoHash)
	    if (GetChecksum(TMP, buff))
		fprintf(F, "\t%s%s\n", CHECKSUMHDR, buff);
	    else
		fprintf(F, "\tNo checksum\n");
	(void)fclose(F);
    }

    /* Mail it.  Would be nice to be able to do Bcc's, but that's
     * too much work (for me) -- inews just leaves that header in,
     * which is not good. */
#ifdef	TO
    if (File)
	printf("Reminder:  mail it to %s when you post!\n", TO);
    else {
	printf("Mailing...\n");
	(void)sprintf(buff, "exec %s -f \"%s-request\" %s <%s",
		      SENDMAIL, TO, TO, TMP);
	(void)system(buff);
    }
#endif	/* TO */

    /* That's all she wrote. */
    printf("Done\n");
    (void)unlink(TMP);
    exit(0);
}
