/* 
**  @(#)postit.h	1.4 4/5/92 - Kent Landfield
*/

#define BUFLEN    128    /* standard buffer size        */
#define BIGLEN   1024    /* big buffer size             */

#define TRUE        1    
#define FALSE       0    

/*
** Line type defines -  index uses
*/

#define DATE              1
#define FROM              2
#define SUBJECT           3
#define SENDER            4
#define REPLY_TO          5
#define TO                6
#define CC                7
#define BCC               8
#define COMMENTS          9
#define IN_REPLY_TO      10
#define MESSAGEID        11
#define RETURNPATH       12
#define RECEIVEDFROM     13
#define RECEIVEDBY       14
#define RECEIVEDVIA      15
#define RECEIVEDWITH     16
#define RECEIVEDID       17
#define RECEIVEDFOR      18
#define RESENTREPLYTO    19
#define RESENTFROM       20
#define RESENTSENDER     21
#define RESENTDATE       22
#define RESENTTO         23
#define RESENTMESSAGEID  24
#define RESENTCC         25
#define RESENTBCC        26
#define REFERENCES       27
#define KEYWORDS         28
#define ENCRYPTED        29
#define FOLLOWUP_TO      30

#define SUMMARY          31
#define SUPERSEDES       32
#define XREF             33
#define SUBMITTED_BY     34
#define ARCH_NAME        35
#define PATCH_TO         36
#define ORGANIZATION     37
#define ENVIRONMENT      38
#define POSTING_NUMBER   40
#define LAST_MODIFIED    41

#define OTHER            99

/* 
** header storage structure
** Uses standard and big buffer sizes for now.  In future
** should malloc the buffers and free after each message.
*/

struct    header {
    char    date[BUFLEN];            /* Date:                 */
    char    from[BUFLEN];            /* From:                 */
    char    subject[BIGLEN];         /* Subject:              */
    char    sender[BUFLEN];          /* Sender:               */
    char    replyto[BUFLEN];         /* Reply-To:             */
    char    to[BIGLEN];              /* To:                   */
    char    cc[BIGLEN];              /* Cc:                   */
    char    bcc[BUFLEN];             /* Bcc:                  */
    char    comments[BIGLEN];        /* Comments:             */
    char    inreplyto[BIGLEN];       /* In-Reply-To:          */
    char    messageid[BUFLEN];       /* Message-Id:           */
    char    returnpath[BIGLEN];      /* Return-path:          */
    char    receivedfrom[BIGLEN];    /* Received from:        */
    char    receivedby[BIGLEN];      /* Received by:          */
    char    receivedvia[BIGLEN];     /* Received via:         */
    char    receivedwith[BIGLEN];    /* Received with:        */
    char    receivedid[BIGLEN];      /* Received id:          */
    char    receivedfor[BIGLEN];     /* Received for:         */
    char    resentreplyto[BIGLEN];   /* Resent-Reply-To:      */
    char    resentfrom[BIGLEN];      /* Resent-From:          */
    char    resentsender[BIGLEN];    /* Resent-Sender:        */
    char    resentdate[BIGLEN];      /* Resent-Date:          */
    char    resentto[BIGLEN];        /* Resent-To:            */
    char    resentmessageid[BIGLEN]; /* Resent-Message-ID:    */
    char    resentcc[BIGLEN];        /* Resent-cc:            */
    char    resentbcc[BIGLEN];       /* Resent-bcc:           */
    char    references[BIGLEN];      /* References:           */
    char    keywords[BIGLEN];        /* Keywords:             */
    char    encrypted[BIGLEN];       /* Encrypted:            */
    char    followupto[BIGLEN];      /* Followup-To:          */
    char    summary[BUFLEN];         /* Summary:              */
    char    supersedes[BUFLEN];      /* Supersedes:           */
    char    xref[BUFLEN];            /* Xref:                 */
    char    submitted_by[BUFLEN];    /* Submitted_by:         */
    char    archive_name[BUFLEN];    /* Archive-name:         */
    char    patch_to[BUFLEN];        /* Patch-To:             */
    char    organization[BUFLEN];    /* Organization:         */
    char    environment[BUFLEN];     /* Environment:          */
    char    posting_number[BUFLEN];  /* Posting-number:       */
    char    last_modified[BUFLEN];   /* Last-modified:        */
};

