#
# SID[] = "@(#)postit.mk	1.5 8/17/91"
#
#*********************************************************************#
#                                                                      
#  MAKE FILE NAME: postit.mk
#  AUTHOR:         Kent Landfield
#  ABSTRACT:       This makefile is used to generate the postit process.
#                                                                      
#*********************************************************************#
#
#######################################################################
#
#  Define variables and Macros
#
#######################################################################

#CC=gcc
#CFLAGS = -g $(DEFAULT_CFLAGS) -Wall
#CFLAGS = -g $(DEFAULT_CFLAGS) -DTEST
CFLAGS = -g $(DEFAULT_CFLAGS) 

SOURCE = postit.c 
INCLUDE = postit.h
OBJS = postit.o 
BIN =../bin

#######################################################################
#
#  Build the executable images
#
#######################################################################

all: $(BIN)/imdpost $(BIN)/postit
#all: postit imdpost
#all: $(BIN)/postit

postit:  postit.c postit.h 
	$(CC) $(CFLAGS) -o postit postit.c $(LDFLAGS)

$(BIN)/postit:	postit.c postit.h makefile
	$(CC) $(CFLAGS) -o postit postit.c $(LDFLAGS)
	install -s -m 0750 -o kent -g kent postit $(BIN)

imdpost: postit.c postit.h 
	$(CC) $(CFLAGS) -DTEST -o imdpost postit.c $(LDFLAGS)

$(BIN)/imdpost:	postit.c postit.h makefile
	$(CC) $(CFLAGS) -DTEST -o imdpost postit.c $(LDFLAGS)
	install -s -m 0750 -o kent -g kent imdpost $(BIN)

########################################
#
#       Commands
#
########################################

print: 
	cprint postit.h | lpr  -Plw
	cprint postit.c | lpr  -Plw
	cprint postit.mk | lpr -Plw

lint:
	lint $(LINT_FLAGS) $(SOURCE) | tee Lint.out

inspect:
	inspect -vab $(SOURCE) | tee Inspect.out

xref:
	 cxref $(SOURCE) > Xref.out

install: all
	strip postit > /dev/null 2>&1
	cp postit $(INSTALLDIR)

clean: 
	rm -f $(OBJS) Lint.out Inspect.out Xref.out

clobber: clean
	rm -f postit imdpost

################################
#           SABER
################################

saber:
	#load $(CFLAGS) $(SOURCE)

#######################################################################
#
#    Object file include dependencies.
#    The object file include dependencies are required.
#
#######################################################################

depend:
	makedepend -- $(CFLAGS) -- $(SOURCE)

# DO NOT DELETE THIS LINE -- make depend depends on it.
