/* $Header: /u/rhg/src/shar/who@where.c,v 3.49 90/09/12 15:15:33 rhg Exp $ */

/*+-------------------------------------------------------------------------
	who@where.c - find out who i am & where i am
	...!gatech!kd4nc!n4hgf!wht (wht%n4hgf@gatech.edu)
--------------------------------------------------------------------------*/
/*+:EDITS:*/
/*:09-12-1990-01:04-rhg@cps.com-added declarations of strcpy and strcat */
/*:09-09-1990-19:49-rhg@cps.com-added explicit return statement to who_where */
/*:04-03-1990-19:55-wht@n4hgf-get rid of complicated who_am_i */
/*:04-01-1990-13:30-pat@rwing-use utsname.nodename instead of sysname */
/*:04-02-1990-12:12-wht@n4hgf-sigh... some pwd.h dont declare functions */
/*:03-29-1990-18:23-wht@n4hgf-add automatic sequent support */
/*:03-28-1990-15:24-wht@n4hgf-creation */

#include <stdio.h>
#include <sys/types.h>
#include <pwd.h>

/* assume system v unless otherwise fixed */
#if (defined(pyr) || defined(vax) || defined(sequent)) && !defined(BSD42) && !defined(SYS5)
#define BSD42
#endif
#if defined(sun)	/* this miscreant doesn't exactly fit BSD or SYSV */
#undef BSD42
#undef SYS5
#endif
#if !defined(BSD42) && !defined(sun) && !defined(SYS5)
#define SYS5
#endif

#if defined(sun) || defined(BSD42)
#define strchr	index
#define strrchr	rindex
#endif

#if !defined(SYS5) || defined(sun)
#include <sys/time.h>
extern int errno;
#else
#include <sys/utsname.h>
#include <time.h>
#endif	/* system dependencies */

char *strcpy();
char *strcat();
struct passwd *getpwuid();

/*+-------------------------------------------------------------------------
	who_am_i() - get user name
--------------------------------------------------------------------------*/
char *
who_am_i()
{
	char *getenv();

        char *g;
	struct passwd *passwd;

	if (g = getenv("USER"))
		return g;
	if (g = getenv("LOGNAME"))
		return g;
	if (g = getenv("NAME"))
		return g;

	passwd = getpwuid(getuid());
	(void)endpwent();
	if(passwd == (struct passwd *)0)
		return("???");
	return(passwd->pw_name);

}	/* end of who_am_i */

/*+-------------------------------------------------------------------------
	where_am_i() - do uname, gethostname, or read file (/etc/systemid)
--------------------------------------------------------------------------*/
char *
where_am_i()
{
#if defined(M_SYS5)	/* SCO UNIX or XENIX */
FILE *fpsid = fopen("/etc/systemid","r");
static char s20[20];
	if(!fpsid)
		return("???");
	fgets(s20,sizeof(s20),fpsid);
	fclose(fpsid);
	s20[strlen(s20) - 1] = 0;
	return(s20);
#else /* M_SYS5 */
#if defined(SYS5)
static struct utsname where_i_am;
	uname(&where_i_am);
	return(where_i_am.nodename);
#else /* SYS5 */
static char full_name[128];
static char where_i_am[64];
static char what_domain[64];
	gethostname(where_i_am,sizeof(where_i_am));
	getdomainname(what_domain,sizeof(what_domain));
	sprintf(full_name,"%s.%s",where_i_am, what_domain);
	return(full_name);
#endif /* SYS5 */
#endif /* M_SYS5 */
}	/* end of where_am_i */

/*+-------------------------------------------------------------------------
	who_where(buf)
--------------------------------------------------------------------------*/
char *
who_where(buf)
char *buf;
{
static char ww[128];

	if(!buf)
		buf = ww;
	strcpy(buf,who_am_i());
	strcat(buf,"@");
	return(strcat(buf,where_am_i()));
}	/* end of who_where */

/* vi: set tabstop=4 shiftwidth=4: */
/* end of who@where.c */
