/*-
********************************************************************************
Copyright (C) 2015 Annapurna Labs Ltd.

This file may be licensed under the terms of the Annapurna Labs Commercial
License Agreement.

Alternatively, this file can be distributed under the terms of the GNU General
Public License V2 as published by the Free Software Foundation and can be
found at http://www.gnu.org/licenses/gpl-2.0.html

Alternatively, redistribution and use in source and binary forms, with or
without modification, are permitted provided that the following conditions are
met:

    *     Redistributions of source code must retain the above copyright notice,
this list of conditions and the following disclaimer.

    *     Redistributions in binary form must reproduce the above copyright
notice, this list of conditions and the following disclaimer in
the documentation and/or other materials provided with the
distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

*******************************************************************************/

/**
 * @defgroup group_services Platform Services API
 *  @{
 * @file   plat_api/sample/al_hal_plat_types.h
 *
 */

#ifndef __PLAT_TYPES_H__
#define __PLAT_TYPES_H__

#include <sys/cdefs.h>
#include <sys/param.h>
#include <machine/bus.h>
#include <sys/bus.h>

/* *INDENT-OFF* */
#ifdef __cplusplus
extern "C" {
#endif
/* *INDENT-ON* */

/* Basic data types */
typedef int al_bool;		/** boolean */
#define AL_TRUE			1
#define AL_FALSE		0


/* define types */
#ifndef AL_HAVE_TYPES
typedef unsigned char uint8_t;	/** unsigned 8 bits */
typedef unsigned short uint16_t;	/** unsigned 16 bits */
typedef unsigned int uint32_t;	/** unsigned 32 bits */
typedef unsigned long long uint64_t;	/** unsigned 64 bits */

typedef signed char int8_t;	/** signed 8 bits */
typedef short int int16_t;	/** signed 16 bits */
typedef signed int int32_t;	/** signed 32 bits */

/** An unsigned int that is guaranteed to be the same size as a pointer */
/** C99 standard */
typedef unsigned long uintptr_t;
#endif


/** in LPAE mode, the address address is 40 bit, we extend it to 64 bit */
typedef uint64_t al_phys_addr_t;

/** this defines the cpu endiancess. */
#define PLAT_ARCH_IS_LITTLE()	AL_TRUE

/* *INDENT-OFF* */
#ifdef __cplusplus
}
#endif
/* *INDENT-ON* */
/** @} end of Platform Services API group */

#endif				/* __PLAT_TYPES_H__ */
