/*-
 * Copyright 2007 Advanced Micro Devices, Inc.
 * All Rights Reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the next
 * paragraph) shall be included in all copies or substantial portions of the
 * Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * IN NO EVENT SHALL THE COPYRIGHT OWNER(S) AND/OR ITS SUPPLIERS BE
 * LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
 * OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
 * WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 */

#include <sys/cdefs.h>
__FBSDID("$FreeBSD: stable/11/sys/dev/drm/radeon_microcode.h 182080 2008-08-23 20:59:12Z rnoland $");

#ifndef RADEON_MICROCODE_H
#define RADEON_MICROCODE_H

/* production radeon ucode r1xx-r6xx */
static const u32 R100_cp_microcode[][2]={
    { 0x21007000, 0000000000 },
    { 0x20007000, 0000000000 },
    { 0x000000b4, 0x00000004 },
    { 0x000000b8, 0x00000004 },
    { 0x6f5b4d4c, 0000000000 },
    { 0x4c4c427f, 0000000000 },
    { 0x5b568a92, 0000000000 },
    { 0x4ca09c6d, 0000000000 },
    { 0xad4c4c4c, 0000000000 },
    { 0x4ce1af3d, 0000000000 },
    { 0xd8afafaf, 0000000000 },
    { 0xd64c4cdc, 0000000000 },
    { 0x4cd10d10, 0000000000 },
    { 0x000f0000, 0x00000016 },
    { 0x362f242d, 0000000000 },
    { 0x00000012, 0x00000004 },
    { 0x000f0000, 0x00000016 },
    { 0x362f282d, 0000000000 },
    { 0x000380e7, 0x00000002 },
    { 0x04002c97, 0x00000002 },
    { 0x000f0001, 0x00000016 },
    { 0x333a3730, 0000000000 },
    { 0x000077ef, 0x00000002 },
    { 0x00061000, 0x00000002 },
    { 0x00000021, 0x0000001a },
    { 0x00004000, 0x0000001e },
    { 0x00061000, 0x00000002 },
    { 0x00000021, 0x0000001a },
    { 0x00004000, 0x0000001e },
    { 0x00061000, 0x00000002 },
    { 0x00000021, 0x0000001a },
    { 0x00004000, 0x0000001e },
    { 0x00000017, 0x00000004 },
    { 0x0003802b, 0x00000002 },
    { 0x040067e0, 0x00000002 },
    { 0x00000017, 0x00000004 },
    { 0x000077e0, 0x00000002 },
    { 0x00065000, 0x00000002 },
    { 0x000037e1, 0x00000002 },
    { 0x040067e1, 0x00000006 },
    { 0x000077e0, 0x00000002 },
    { 0x000077e1, 0x00000002 },
    { 0x000077e1, 0x00000006 },
    { 0xffffffff, 0000000000 },
    { 0x10000000, 0000000000 },
    { 0x0003802b, 0x00000002 },
    { 0x040067e0, 0x00000006 },
    { 0x00007675, 0x00000002 },
    { 0x00007676, 0x00000002 },
    { 0x00007677, 0x00000002 },
    { 0x00007678, 0x00000006 },
    { 0x0003802c, 0x00000002 },
    { 0x04002676, 0x00000002 },
    { 0x00007677, 0x00000002 },
    { 0x00007678, 0x00000006 },
    { 0x0000002f, 0x00000018 },
    { 0x0000002f, 0x00000018 },
    { 0000000000, 0x00000006 },
    { 0x00000030, 0x00000018 },
    { 0x00000030, 0x00000018 },
    { 0000000000, 0x00000006 },
    { 0x01605000, 0x00000002 },
    { 0x00065000, 0x00000002 },
    { 0x00098000, 0x00000002 },
    { 0x00061000, 0x00000002 },
    { 0x64c0603e, 0x00000004 },
    { 0x000380e6, 0x00000002 },
    { 0x040025c5, 0x00000002 },
    { 0x00080000, 0x00000016 },
    { 0000000000, 0000000000 },
    { 0x0400251d, 0x00000002 },
    { 0x00007580, 0x00000002 },
    { 0x00067581, 0x00000002 },
    { 0x04002580, 0x00000002 },
    { 0x00067581, 0x00000002 },
    { 0x00000049, 0x00000004 },
    { 0x00005000, 0000000000 },
    { 0x000380e6, 0x00000002 },
    { 0x040025c5, 0x00000002 },
    { 0x00061000, 0x00000002 },
    { 0x0000750e, 0x00000002 },
    { 0x00019000, 0x00000002 },
    { 0x00011055, 0x00000014 },
    { 0x00000055, 0x00000012 },
    { 0x0400250f, 0x00000002 },
    { 0x0000504f, 0x00000004 },
    { 0x000380e6, 0x00000002 },
    { 0x040025c5, 0x00000002 },
    { 0x00007565, 0x00000002 },
    { 0x00007566, 0x00000002 },
    { 0x00000058, 0x00000004 },
    { 0x000380e6, 0x00000002 },
    { 0x040025c5, 0x00000002 },
    { 0x01e655b4, 0x00000002 },
    { 0x4401b0e4, 0x00000002 },
    { 0x01c110e4, 0x00000002 },
    { 0x26667066, 0x00000018 },
    { 0x040c2565, 0x00000002 },
    { 0x00000066, 0x00000018 },
    { 0x04002564, 0x00000002 },
    { 0x00007566, 0x00000002 },
    { 0x0000005d, 0x00000004 },
    { 0x00401069, 0x00000008 },
    { 0x00101000, 0x00000002 },
    { 0x000d80ff, 0x00000002 },
    { 0x0080006c, 0x00000008 },
    { 0x000f9000, 0x00000002 },
    { 0x000e00ff, 0x00000002 },
    { 0000000000, 0x00000006 },
    { 0x0000008f, 0x00000018 },
    { 0x0000005b, 0x00000004 },
    { 0x000380e6, 0x00000002 },
    { 0x040025c5, 0x00000002 },
    { 0x00007576, 0x00000002 },
    { 0x00065000, 0x00000002 },
    { 0x00009000, 0x00000002 },
    { 0x00041000, 0x00000002 },
    { 0x0c00350e, 0x00000002 },
    { 0x00049000, 0x00000002 },
    { 0x00051000, 0x00000002 },
    { 0x01e785f8, 0x00000002 },
    { 0x00200000, 0x00000002 },
    { 0x0060007e, 0x0000000c },
    { 0x00007563, 0x00000002 },
    { 0x006075f0, 0x00000021 },
    { 0x20007073, 0x00000004 },
    { 0x00005073, 0x00000004 },
    { 0x000380e6, 0x00000002 },
    { 0x040025c5, 0x00000002 },
    { 0x00007576, 0x00000002 },
    { 0x00007577, 0x00000002 },
    { 0x0000750e, 0x00000002 },
    { 0x0000750f, 0x00000002 },
    { 0x00a05000, 0x00000002 },
    { 0x00600083, 0x0000000c },
    { 0x006075f0, 0x00000021 },
    { 0x000075f8, 0x00000002 },
    { 0x00000083, 0x00000004 },
    { 0x000a750e, 0x00000002 },
    { 0x000380e6, 0x00000002 },
    { 0x040025c5, 0x00000002 },
    { 0x0020750f, 0x00000002 },
    { 0x00600086, 0x00000004 },
    { 0x00007570, 0x00000002 },
    { 0x00007571, 0x00000002 },
    { 0x00007572, 0x00000006 },
    { 0x000380e6, 0x00000002 },
    { 0x040025c5, 0x00000002 },
    { 0x00005000, 0x00000002 },
    { 0x00a05000, 0x00000002 },
    { 0x00007568, 0x00000002 },
    { 0x00061000, 0x00000002 },
    { 0x00000095, 0x0000000c },
    { 0x00058000, 0x00000002 },
    { 0x0c607562, 0x00000002 },
    { 0x00000097, 0x00000004 },
    { 0x000380e6, 0x00000002 },
    { 0x040025c5, 0x00000002 },
    { 0x00600096, 0x00000004 },
    { 0x400070e5, 0000000000 },
    { 0x000380e6, 0x00000002 },
    { 0x040025c5, 0x00000002 },
    { 0x000380e5, 0x00000002 },
    { 0x000000a8, 0x0000001c },
    { 0x000650aa, 0x00000018 },
    { 0x040025bb, 0x00000002 },
    { 0x000610ab, 0x00000018 },
    { 0x040075bc, 0000000000 },
    { 0x000075bb, 0x00000002 },
    { 0x000075bc, 0000000000 },
    { 0x00090000, 0x00000006 },
    { 0x00090000, 0x00000002 },
    { 0x000d8002, 0x00000006 },
    { 0x00007832, 0x00000002 },
    { 0x00005000, 0x00000002 },
    { 0x000380e7, 0x00000002 },
    { 0x04002c97, 0x00000002 },
    { 0x00007820, 0x00000002 },
    { 0x00007821, 0x00000002 },
    { 0x00007800, 0000000000 },
    { 0x01200000, 0x00000002 },
    { 0x20077000, 0x00000002 },
    { 0x01200000, 0x00000002 },
    { 0x20007000, 0x00000002 },
    { 0x00061000, 0x00000002 },
    { 0x0120751b, 0x00000002 },
    { 0x8040750a, 0x00000002 },
    { 0x8040750b, 0x00000002 },
    { 0x00110000, 0x00000002 },
    { 0x000380e5, 0x00000002 },
    { 0x000000c6, 0x0000001c },
    { 0x000610ab, 0x00000018 },
    { 0x844075bd, 0x00000002 },
    { 0x000610aa, 0x00000018 },
    { 0x840075bb, 0x00000002 },
    { 0x000610ab, 0x00000018 },
    { 0x844075bc, 0x00000002 },
    { 0x000000c9, 0x00000004 },
    { 0x804075bd, 0x00000002 },
    { 0x800075bb, 0x00000002 },
    { 0x804075bc, 0x00000002 },
    { 0x00108000, 0x00000002 },
    { 0x01400000, 0x00000002 },
    { 0x006000cd, 0x0000000c },
    { 0x20c07000, 0x00000020 },
    { 0x000000cf, 0x00000012 },
    { 0x00800000, 0x00000006 },
    { 0x0080751d, 0x00000006 },
    { 0000000000, 0000000000 },
    { 0x0000775c, 0x00000002 },
    { 0x00a05000, 0x00000002 },
    { 0x00661000, 0x00000002 },
    { 0x0460275d, 0x00000020 },
    { 0x00004000, 0000000000 },
    { 0x01e00830, 0x00000002 },
    { 0x21007000, 0000000000 },
    { 0x6464614d, 0000000000 },
    { 0x69687420, 0000000000 },
    { 0x00000073, 0000000000 },
    { 0000000000, 0000000000 },
    { 0x00005000, 0x00000002 },
    { 0x000380d0, 0x00000002 },
    { 0x040025e0, 0x00000002 },
    { 0x000075e1, 0000000000 },
    { 0x00000001, 0000000000 },
    { 0x000380e0, 0x00000002 },
    { 0x04002394, 0x00000002 },
    { 0x00005000, 0000000000 },
    { 0000000000, 0000000000 },
    { 0000000000, 0000000000 },
    { 0x00000008, 0000000000 },
    { 0x00000004, 0000000000 },
    { 0000000000, 0000000000 },
    { 0000000000, 0000000000 },
    { 0000000000, 0000000000 },
    { 0000000000, 0000000000 },
    { 0000000000, 0000000000 },
    { 0000000000, 0000000000 },
    { 0000000000, 0000000000 },
    { 0000000000, 0000000000 },
    { 0000000000, 0000000000 },
    { 0000000000, 0000000000 },
    { 0000000000, 0000000000 },
    { 0000000000, 0000000000 },
    { 0000000000, 0000000000 },
    { 0000000000, 0000000000 },
    { 0000000000, 0000000000 },
    { 0000000000, 0000000000 },
    { 0000000000, 0000000000 },
    { 0000000000, 0000000000 },
    { 0000000000, 0000000000 },
    { 0000000000, 0000000000 },
    { 0000000000, 0000000000 },
    { 0000000000, 0000000000 },
    { 0000000000, 0000000000 },
    { 0000000000, 0000000000 },
};

static const u32 R200_cp_microcode[][2]={
    { 0x21007000, 0000000000 },
    { 0x20007000, 0000000000 },
    { 0x000000bf, 0x00000004 },
    { 0x000000c3, 0x00000004 },
    { 0x7a685e5d, 0000000000 },
    { 0x5d5d5588, 0000000000 },
    { 0x68659197, 0000000000 },
    { 0x5da19f78, 0000000000 },
    { 0x5d5d5d5d, 0000000000 },
    { 0x5dee5d50, 0000000000 },
    { 0xf2acacac, 0000000000 },
    { 0xe75df9e9, 0000000000 },
    { 0xb1dd0e11, 0000000000 },
    { 0xe2afafaf, 0000000000 },
    { 0x000f0000, 0x00000016 },
    { 0x452f232d, 0000000000 },
    { 0x00000013, 0x00000004 },
    { 0x000f0000, 0x00000016 },
    { 0x452f272d, 0000000000 },
    { 0x000f0001, 0x00000016 },
    { 0x3e4d4a37, 0000000000 },
    { 0x000077ef, 0x00000002 },
    { 0x00061000, 0x00000002 },
    { 0x00000020, 0x0000001a },
    { 0x00004000, 0x0000001e },
    { 0x00061000, 0x00000002 },
    { 0x00000020, 0x0000001a },
    { 0x00004000, 0x0000001e },
    { 0x00061000, 0x00000002 },
    { 0x00000020, 0x0000001a },
    { 0x00004000, 0x0000001e },
    { 0x00000016, 0x00000004 },
    { 0x0003802a, 0x00000002 },
    { 0x040067e0, 0x00000002 },
    { 0x00000016, 0x00000004 },
    { 0x000077e0, 0x00000002 },
    { 0x00065000, 0x00000002 },
    { 0x000037e1, 0x00000002 },
    { 0x040067e1, 0x00000006 },
    { 0x000077e0, 0x00000002 },
    { 0x000077e1, 0x00000002 },
    { 0x000077e1, 0x00000006 },
    { 0xffffffff, 0000000000 },
    { 0x10000000, 0000000000 },
    { 0x07f007f0, 0000000000 },
    { 0x0003802a, 0x00000002 },
    { 0x040067e0, 0x00000006 },
    { 0x0003802c, 0x00000002 },
    { 0x04002741, 0x00000002 },
    { 0x04002741, 0x00000002 },
    { 0x04002743, 0x00000002 },
    { 0x00007675, 0x00000002 },
    { 0x00007676, 0x00000002 },
    { 0x00007677, 0x00000002 },
    { 0x00007678, 0x00000006 },
    { 0x0003802c, 0x00000002 },
    { 0x04002741, 0x00000002 },
    { 0x04002741, 0x00000002 },
    { 0x04002743, 0x00000002 },
    { 0x00007676, 0x00000002 },
    { 0x00007677, 0x00000002 },
    { 0x00007678, 0x00000006 },
    { 0x0003802b, 0x00000002 },
    { 0x04002676, 0x00000002 },
    { 0x00007677, 0x00000002 },
    { 0x0003802c, 0x00000002 },
    { 0x04002741, 0x00000002 },
    { 0x04002743, 0x00000002 },
    { 0x00007678, 0x00000006 },
    { 0x0003802c, 0x00000002 },
    { 0x04002741, 0x00000002 },
    { 0x04002741, 0x00000002 },
    { 0x04002743, 0x00000002 },
    { 0x00007678, 0x00000006 },
    { 0x0000002f, 0x00000018 },
    { 0x0000002f, 0x00000018 },
    { 0000000000, 0x00000006 },
    { 0x00000037, 0x00000018 },
    { 0x00000037, 0x00000018 },
    { 0000000000, 0x00000006 },
    { 0x01605000, 0x00000002 },
    { 0x00065000, 0x00000002 },
    { 0x00098000, 0x00000002 },
    { 0x00061000, 0x00000002 },
    { 0x64c06051, 0x00000004 },
    { 0x00080000, 0x00000016 },
    { 0000000000, 0000000000 },
    { 0x0400251d, 0x00000002 },
    { 0x00007580, 0x00000002 },
    { 0x00067581, 0x00000002 },
    { 0x04002580, 0x00000002 },
    { 0x00067581, 0x00000002 },
    { 0x0000005a, 0x00000004 },
    { 0x00005000, 0000000000 },
    { 0x00061000, 0x00000002 },
    { 0x0000750e, 0x00000002 },
    { 0x00019000, 0x00000002 },
    { 0x00011064, 0x00000014 },
    { 0x00000064, 0x00000012 },
    { 0x0400250f, 0x00000002 },
    { 0x0000505e, 0x00000004 },
    { 0x00007565, 0x00000002 },
    { 0x00007566, 0x00000002 },
    { 0x00000065, 0x00000004 },
    { 0x01e655b4, 0x00000002 },
    { 0x4401b0f0, 0x00000002 },
    { 0x01c110f0, 0x00000002 },
    { 0x26667071, 0x00000018 },
    { 0x040c2565, 0x00000002 },
    { 0x00000071, 0x00000018 },
    { 0x04002564, 0x00000002 },
    { 0x00007566, 0x00000002 },
    { 0x00000068, 0x00000004 },
    { 0x00401074, 0x00000008 },
    { 0x00101000, 0x00000002 },
    { 0x000d80ff, 0x00000002 },
    { 0x00800077, 0x00000008 },
    { 0x000f9000, 0x00000002 },
    { 0x000e00ff, 0x00000002 },
    { 0000000000, 0x00000006 },
    { 0x00000094, 0x00000018 },
    { 0x00000068, 0x00000004 },
    { 0x00007576, 0x00000002 },
    { 0x00065000, 0x00000002 },
    { 0x00009000, 0x00000002 },
    { 0x00041000, 0x00000002 },
    { 0x0c00350e, 0x00000002 },
    { 0x00049000, 0x00000002 },
    { 0x00051000, 0x00000002 },
    { 0x01e785f8, 0x00000002 },
    { 0x00200000, 0x00000002 },
    { 0x00600087, 0x0000000c },
    { 0x00007563, 0x00000002 },
    { 0x006075f0, 0x00000021 },
    { 0x2000707c, 0x00000004 },
    { 0x0000507c, 0x00000004 },
    { 0x00007576, 0x00000002 },
    { 0x00007577, 0x00000002 },
    { 0x0000750e, 0x00000002 },
    { 0x0000750f, 0x00000002 },
    { 0x00a05000, 0x00000002 },
    { 0x0060008a, 0x0000000c },
    { 0x006075f0, 0x00000021 },
    { 0x000075f8, 0x00000002 },
    { 0x0000008a, 0x00000004 },
    { 0x000a750e, 0x00000002 },
    { 0x0020750f, 0x00000002 },
    { 0x0060008d, 0x00000004 },
    { 0x00007570, 0x00000002 },
    { 0x00007571, 0x00000002 },
    { 0x00007572, 0x00000006 },
    { 0x00005000, 0x00000002 },
    { 0x00a05000, 0x00000002 },
    { 0x00007568, 0x00000002 },
    { 0x00061000, 0x00000002 },
    { 0x00000098, 0x0000000c },
    { 0x00058000, 0x00000002 },
    { 0x0c607562, 0x00000002 },
    { 0x0000009a, 0x00000004 },
    { 0x00600099, 0x00000004 },
    { 0x400070f1, 0000000000 },
    { 0x000380f1, 0x00000002 },
    { 0x000000a7, 0x0000001c },
    { 0x000650a9, 0x00000018 },
    { 0x040025bb, 0x00000002 },
    { 0x000610aa, 0x00000018 },
    { 0x040075bc, 0000000000 },
    { 0x000075bb, 0x00000002 },
    { 0x000075bc, 0000000000 },
    { 0x00090000, 0x00000006 },
    { 0x00090000, 0x00000002 },
    { 0x000d8002, 0x00000006 },
    { 0x00005000, 0x00000002 },
    { 0x00007821, 0x00000002 },
    { 0x00007800, 0000000000 },
    { 0x00007821, 0x00000002 },
    { 0x00007800, 0000000000 },
    { 0x01665000, 0x00000002 },
    { 0x000a0000, 0x00000002 },
    { 0x000671cc, 0x00000002 },
    { 0x0286f1cd, 0x00000002 },
    { 0x000000b7, 0x00000010 },
    { 0x21007000, 0000000000 },
    { 0x000000be, 0x0000001c },
    { 0x00065000, 0x00000002 },
    { 0x000a0000, 0x00000002 },
    { 0x00061000, 0x00000002 },
    { 0x000b0000, 0x00000002 },
    { 0x38067000, 0x00000002 },
    { 0x000a00ba, 0x00000004 },
    { 0x20007000, 0000000000 },
    { 0x01200000, 0x00000002 },
    { 0x20077000, 0x00000002 },
    { 0x01200000, 0x00000002 },
    { 0x20007000, 0000000000 },
    { 0x00061000, 0x00000002 },
    { 0x0120751b, 0x00000002 },
    { 0x8040750a, 0x00000002 },
    { 0x8040750b, 0x00000002 },
    { 0x00110000, 0x00000002 },
    { 0x000380f1, 0x00000002 },
    { 0x000000d1, 0x0000001c },
    { 0x000610aa, 0x00000018 },
    { 0x844075bd, 0x00000002 },
    { 0x000610a9, 0x00000018 },
    { 0x840075bb, 0x00000002 },
    { 0x000610aa, 0x00000018 },
    { 0x844075bc, 0x00000002 },
    { 0x000000d4, 0x00000004 },
    { 0x804075bd, 0x00000002 },
    { 0x800075bb, 0x00000002 },
    { 0x804075bc, 0x00000002 },
    { 0x00108000, 0x00000002 },
    { 0x01400000, 0x00000002 },
    { 0x006000d8, 0x0000000c },
    { 0x20c07000, 0x00000020 },
    { 0x000000da, 0x00000012 },
    { 0x00800000, 0x00000006 },
    { 0x0080751d, 0x00000006 },
    { 0x000025bb, 0x00000002 },
    { 0x000040d4, 0x00000004 },
    { 0x0000775c, 0x00000002 },
    { 0x00a05000, 0x00000002 },
    { 0x00661000, 0x00000002 },
    { 0x0460275d, 0x00000020 },
    { 0x00004000, 0000000000 },
    { 0x00007999, 0x00000002 },
    { 0x00a05000, 0x00000002 },
    { 0x00661000, 0x00000002 },
    { 0x0460299b, 0x00000020 },
    { 0x00004000, 0000000000 },
    { 0x01e00830, 0x00000002 },
    { 0x21007000, 0000000000 },
    { 0x00005000, 0x00000002 },
    { 0x00038056, 0x00000002 },
    { 0x040025e0, 0x00000002 },
    { 0x000075e1, 0000000000 },
    { 0x00000001, 0000000000 },
    { 0x000380ed, 0x00000002 },
    { 0x04007394, 0000000000 },
    { 0000000000, 0000000000 },
    { 0000000000, 0000000000 },
    { 0x000078c4, 0x00000002 },
    { 0x000078c5, 0x00000002 },
    { 0x000078c6, 0x00000002 },
    { 0x00007924, 0x00000002 },
    { 0x00007925, 0x00000002 },
    { 0x00007926, 0x00000002 },
    { 0x000000f2, 0x00000004 },
    { 0x00007924, 0x00000002 },
    { 0x00007925, 0x00000002 },
    { 0x00007926, 0x00000002 },
    { 0x000000f9, 0x00000004 },
    { 0000000000, 0000000000 },
    { 0000000000, 0000000000 },
    { 0000000000, 0000000000 },
};

static const u32 R300_cp_microcode[][2]={
    { 0x4200e000, 0000000000 },
    { 0x4000e000, 0000000000 },
    { 0x000000ae, 0x00000008 },
    { 0x000000b2, 0x00000008 },
    { 0x67554b4a, 0000000000 },
    { 0x4a4a4475, 0000000000 },
    { 0x55527d83, 0000000000 },
    { 0x4a8c8b65, 0000000000 },
    { 0x4aef4af6, 0000000000 },
    { 0x4ae14a4a, 0000000000 },
    { 0xe4979797, 0000000000 },
    { 0xdb4aebdd, 0000000000 },
    { 0x9ccc4a4a, 0000000000 },
    { 0xd1989898, 0000000000 },
    { 0x4a0f9ad6, 0000000000 },
    { 0x000ca000, 0x00000004 },
    { 0x000d0012, 0x00000038 },
    { 0x0000e8b4, 0x00000004 },
    { 0x000d0014, 0x00000038 },
    { 0x0000e8b6, 0x00000004 },
    { 0x000d0016, 0x00000038 },
    { 0x0000e854, 0x00000004 },
    { 0x000d0018, 0x00000038 },
    { 0x0000e855, 0x00000004 },
    { 0x000d001a, 0x00000038 },
    { 0x0000e856, 0x00000004 },
    { 0x000d001c, 0x00000038 },
    { 0x0000e857, 0x00000004 },
    { 0x000d001e, 0x00000038 },
    { 0x0000e824, 0x00000004 },
    { 0x000d0020, 0x00000038 },
    { 0x0000e825, 0x00000004 },
    { 0x000d0022, 0x00000038 },
    { 0x0000e830, 0x00000004 },
    { 0x000d0024, 0x00000038 },
    { 0x0000f0c0, 0x00000004 },
    { 0x000d0026, 0x00000038 },
    { 0x0000f0c1, 0x00000004 },
    { 0x000d0028, 0x00000038 },
    { 0x0000f041, 0x00000004 },
    { 0x000d002a, 0x00000038 },
    { 0x0000f184, 0x00000004 },
    { 0x000d002c, 0x00000038 },
    { 0x0000f185, 0x00000004 },
    { 0x000d002e, 0x00000038 },
    { 0x0000f186, 0x00000004 },
    { 0x000d0030, 0x00000038 },
    { 0x0000f187, 0x00000004 },
    { 0x000d0032, 0x00000038 },
    { 0x0000f180, 0x00000004 },
    { 0x000d0034, 0x00000038 },
    { 0x0000f393, 0x00000004 },
    { 0x000d0036, 0x00000038 },
    { 0x0000f38a, 0x00000004 },
    { 0x000d0038, 0x00000038 },
    { 0x0000f38e, 0x00000004 },
    { 0x0000e821, 0x00000004 },
    { 0x0140a000, 0x00000004 },
    { 0x00000043, 0x00000018 },
    { 0x00cce800, 0x00000004 },
    { 0x001b0001, 0x00000004 },
    { 0x08004800, 0x00000004 },
    { 0x001b0001, 0x00000004 },
    { 0x08004800, 0x00000004 },
    { 0x001b0001, 0x00000004 },
    { 0x08004800, 0x00000004 },
    { 0x0000003a, 0x00000008 },
    { 0x0000a000, 0000000000 },
    { 0x2000451d, 0x00000004 },
    { 0x0000e580, 0x00000004 },
    { 0x000ce581, 0x00000004 },
    { 0x08004580, 0x00000004 },
    { 0x000ce581, 0x00000004 },
    { 0x00000047, 0x00000008 },
    { 0x0000a000, 0000000000 },
    { 0x000c2000, 0x00000004 },
    { 0x0000e50e, 0x00000004 },
    { 0x00032000, 0x00000004 },
    { 0x00022051, 0x00000028 },
    { 0x00000051, 0x00000024 },
    { 0x0800450f, 0x00000004 },
    { 0x0000a04b, 0x00000008 },
    { 0x0000e565, 0x00000004 },
    { 0x0000e566, 0x00000004 },
    { 0x00000052, 0x00000008 },
    { 0x03cca5b4, 0x00000004 },
    { 0x05432000, 0x00000004 },
    { 0x00022000, 0x00000004 },
    { 0x4ccce05e, 0x00000030 },
    { 0x08274565, 0x00000004 },
    { 0x0000005e, 0x00000030 },
    { 0x08004564, 0x00000004 },
    { 0x0000e566, 0x00000004 },
    { 0x00000055, 0x00000008 },
    { 0x00802061, 0x00000010 },
    { 0x00202000, 0x00000004 },
    { 0x001b00ff, 0x00000004 },
    { 0x01000064, 0x00000010 },
    { 0x001f2000, 0x00000004 },
    { 0x001c00ff, 0x00000004 },
    { 0000000000, 0x0000000c },
    { 0x00000080, 0x00000030 },
    { 0x00000055, 0x00000008 },
    { 0x0000e576, 0x00000004 },
    { 0x000ca000, 0x00000004 },
    { 0x00012000, 0x00000004 },
    { 0x00082000, 0x00000004 },
    { 0x1800650e, 0x00000004 },
    { 0x00092000, 0x00000004 },
    { 0x000a2000, 0x00000004 },
    { 0x000f0000, 0x00000004 },
    { 0x00400000, 0x00000004 },
    { 0x00000074, 0x00000018 },
    { 0x0000e563, 0x00000004 },
    { 0x00c0e5f9, 0x000000c2 },
    { 0x00000069, 0x00000008 },
    { 0x0000a069, 0x00000008 },
    { 0x0000e576, 0x00000004 },
    { 0x0000e577, 0x00000004 },
    { 0x0000e50e, 0x00000004 },
    { 0x0000e50f, 0x00000004 },
    { 0x0140a000, 0x00000004 },
    { 0x00000077, 0x00000018 },
    { 0x00c0e5f9, 0x000000c2 },
    { 0x00000077, 0x00000008 },
    { 0x0014e50e, 0x00000004 },
    { 0x0040e50f, 0x00000004 },
    { 0x00c0007a, 0x00000008 },
    { 0x0000e570, 0x00000004 },
    { 0x0000e571, 0x00000004 },
    { 0x0000e572, 0x0000000c },
    { 0x0000a000, 0x00000004 },
    { 0x0140a000, 0x00000004 },
    { 0x0000e568, 0x00000004 },
    { 0x000c2000, 0x00000004 },
    { 0x00000084, 0x00000018 },
    { 0x000b0000, 0x00000004 },
    { 0x18c0e562, 0x00000004 },
    { 0x00000086, 0x00000008 },
    { 0x00c00085, 0x00000008 },
    { 0x000700e3, 0x00000004 },
    { 0x00000092, 0x00000038 },
    { 0x000ca094, 0x00000030 },
    { 0x080045bb, 0x00000004 },
    { 0x000c2095, 0x00000030 },
    { 0x0800e5bc, 0000000000 },
    { 0x0000e5bb, 0x00000004 },
    { 0x0000e5bc, 0000000000 },
    { 0x00120000, 0x0000000c },
    { 0x00120000, 0x00000004 },
    { 0x001b0002, 0x0000000c },
    { 0x0000a000, 0x00000004 },
    { 0x0000e821, 0x00000004 },
    { 0x0000e800, 0000000000 },
    { 0x0000e821, 0x00000004 },
    { 0x0000e82e, 0000000000 },
    { 0x02cca000, 0x00000004 },
    { 0x00140000, 0x00000004 },
    { 0x000ce1cc, 0x00000004 },
    { 0x050de1cd, 0x00000004 },
    { 0x00400000, 0x00000004 },
    { 0x000000a4, 0x00000018 },
    { 0x00c0a000, 0x00000004 },
    { 0x000000a1, 0x00000008 },
    { 0x000000a6, 0x00000020 },
    { 0x4200e000, 0000000000 },
    { 0x000000ad, 0x00000038 },
    { 0x000ca000, 0x00000004 },
    { 0x00140000, 0x00000004 },
    { 0x000c2000, 0x00000004 },
    { 0x00160000, 0x00000004 },
    { 0x700ce000, 0x00000004 },
    { 0x001400a9, 0x00000008 },
    { 0x4000e000, 0000000000 },
    { 0x02400000, 0x00000004 },
    { 0x400ee000, 0x00000004 },
    { 0x02400000, 0x00000004 },
    { 0x4000e000, 0000000000 },
    { 0x000c2000, 0x00000004 },
    { 0x0240e51b, 0x00000004 },
    { 0x0080e50a, 0x00000005 },
    { 0x0080e50b, 0x00000005 },
    { 0x00220000, 0x00000004 },
    { 0x000700e3, 0x00000004 },
    { 0x000000c0, 0x00000038 },
    { 0x000c2095, 0x00000030 },
    { 0x0880e5bd, 0x00000005 },
    { 0x000c2094, 0x00000030 },
    { 0x0800e5bb, 0x00000005 },
    { 0x000c2095, 0x00000030 },
    { 0x0880e5bc, 0x00000005 },
    { 0x000000c3, 0x00000008 },
    { 0x0080e5bd, 0x00000005 },
    { 0x0000e5bb, 0x00000005 },
    { 0x0080e5bc, 0x00000005 },
    { 0x00210000, 0x00000004 },
    { 0x02800000, 0x00000004 },
    { 0x00c000c7, 0x00000018 },
    { 0x4180e000, 0x00000040 },
    { 0x000000c9, 0x00000024 },
    { 0x01000000, 0x0000000c },
    { 0x0100e51d, 0x0000000c },
    { 0x000045bb, 0x00000004 },
    { 0x000080c3, 0x00000008 },
    { 0x0000f3ce, 0x00000004 },
    { 0x0140a000, 0x00000004 },
    { 0x00cc2000, 0x00000004 },
    { 0x08c053cf, 0x00000040 },
    { 0x00008000, 0000000000 },
    { 0x0000f3d2, 0x00000004 },
    { 0x0140a000, 0x00000004 },
    { 0x00cc2000, 0x00000004 },
    { 0x08c053d3, 0x00000040 },
    { 0x00008000, 0000000000 },
    { 0x0000f39d, 0x00000004 },
    { 0x0140a000, 0x00000004 },
    { 0x00cc2000, 0x00000004 },
    { 0x08c0539e, 0x00000040 },
    { 0x00008000, 0000000000 },
    { 0x03c00830, 0x00000004 },
    { 0x4200e000, 0000000000 },
    { 0x0000a000, 0x00000004 },
    { 0x200045e0, 0x00000004 },
    { 0x0000e5e1, 0000000000 },
    { 0x00000001, 0000000000 },
    { 0x000700e0, 0x00000004 },
    { 0x0800e394, 0000000000 },
    { 0000000000, 0000000000 },
    { 0x0000e8c4, 0x00000004 },
    { 0x0000e8c5, 0x00000004 },
    { 0x0000e8c6, 0x00000004 },
    { 0x0000e928, 0x00000004 },
    { 0x0000e929, 0x00000004 },
    { 0x0000e92a, 0x00000004 },
    { 0x000000e4, 0x00000008 },
    { 0x0000e928, 0x00000004 },
    { 0x0000e929, 0x00000004 },
    { 0x0000e92a, 0x00000004 },
    { 0x000000eb, 0x00000008 },
    { 0x02c02000, 0x00000004 },
    { 0x00060000, 0x00000004 },
    { 0x000000f3, 0x00000034 },
    { 0x000000f0, 0x00000008 },
    { 0x00008000, 0x00000004 },
    { 0xc000e000, 0000000000 },
    { 0000000000, 0000000000 },
    { 0x000c2000, 0x00000004 },
    { 0x001d0018, 0x00000004 },
    { 0x001a0001, 0x00000004 },
    { 0x000000fb, 0x00000034 },
    { 0x0000004a, 0x00000008 },
    { 0x0500a04a, 0x00000008 },
    { 0000000000, 0000000000 },
    { 0000000000, 0000000000 },
    { 0000000000, 0000000000 },
    { 0000000000, 0000000000 },
};

static const u32 R420_cp_microcode[][2]={
    { 0x4200e000, 0000000000 },
    { 0x4000e000, 0000000000 },
    { 0x00000099, 0x00000008 },
    { 0x0000009d, 0x00000008 },
    { 0x4a554b4a, 0000000000 },
    { 0x4a4a4467, 0000000000 },
    { 0x55526f75, 0000000000 },
    { 0x4a7e7d65, 0000000000 },
    { 0xd9d3dff6, 0000000000 },
    { 0x4ac54a4a, 0000000000 },
    { 0xc8828282, 0000000000 },
    { 0xbf4acfc1, 0000000000 },
    { 0x87b04a4a, 0000000000 },
    { 0xb5838383, 0000000000 },
    { 0x4a0f85ba, 0000000000 },
    { 0x000ca000, 0x00000004 },
    { 0x000d0012, 0x00000038 },
    { 0x0000e8b4, 0x00000004 },
    { 0x000d0014, 0x00000038 },
    { 0x0000e8b6, 0x00000004 },
    { 0x000d0016, 0x00000038 },
    { 0x0000e854, 0x00000004 },
    { 0x000d0018, 0x00000038 },
    { 0x0000e855, 0x00000004 },
    { 0x000d001a, 0x00000038 },
    { 0x0000e856, 0x00000004 },
    { 0x000d001c, 0x00000038 },
    { 0x0000e857, 0x00000004 },
    { 0x000d001e, 0x00000038 },
    { 0x0000e824, 0x00000004 },
    { 0x000d0020, 0x00000038 },
    { 0x0000e825, 0x00000004 },
    { 0x000d0022, 0x00000038 },
    { 0x0000e830, 0x00000004 },
    { 0x000d0024, 0x00000038 },
    { 0x0000f0c0, 0x00000004 },
    { 0x000d0026, 0x00000038 },
    { 0x0000f0c1, 0x00000004 },
    { 0x000d0028, 0x00000038 },
    { 0x0000f041, 0x00000004 },
    { 0x000d002a, 0x00000038 },
    { 0x0000f184, 0x00000004 },
    { 0x000d002c, 0x00000038 },
    { 0x0000f185, 0x00000004 },
    { 0x000d002e, 0x00000038 },
    { 0x0000f186, 0x00000004 },
    { 0x000d0030, 0x00000038 },
    { 0x0000f187, 0x00000004 },
    { 0x000d0032, 0x00000038 },
    { 0x0000f180, 0x00000004 },
    { 0x000d0034, 0x00000038 },
    { 0x0000f393, 0x00000004 },
    { 0x000d0036, 0x00000038 },
    { 0x0000f38a, 0x00000004 },
    { 0x000d0038, 0x00000038 },
    { 0x0000f38e, 0x00000004 },
    { 0x0000e821, 0x00000004 },
    { 0x0140a000, 0x00000004 },
    { 0x00000043, 0x00000018 },
    { 0x00cce800, 0x00000004 },
    { 0x001b0001, 0x00000004 },
    { 0x08004800, 0x00000004 },
    { 0x001b0001, 0x00000004 },
    { 0x08004800, 0x00000004 },
    { 0x001b0001, 0x00000004 },
    { 0x08004800, 0x00000004 },
    { 0x0000003a, 0x00000008 },
    { 0x0000a000, 0000000000 },
    { 0x2000451d, 0x00000004 },
    { 0x0000e580, 0x00000004 },
    { 0x000ce581, 0x00000004 },
    { 0x08004580, 0x00000004 },
    { 0x000ce581, 0x00000004 },
    { 0x00000047, 0x00000008 },
    { 0x0000a000, 0000000000 },
    { 0x000c2000, 0x00000004 },
    { 0x0000e50e, 0x00000004 },
    { 0x00032000, 0x00000004 },
    { 0x00022051, 0x00000028 },
    { 0x00000051, 0x00000024 },
    { 0x0800450f, 0x00000004 },
    { 0x0000a04b, 0x00000008 },
    { 0x0000e565, 0x00000004 },
    { 0x0000e566, 0x00000004 },
    { 0x00000052, 0x00000008 },
    { 0x03cca5b4, 0x00000004 },
    { 0x05432000, 0x00000004 },
    { 0x00022000, 0x00000004 },
    { 0x4ccce05e, 0x00000030 },
    { 0x08274565, 0x00000004 },
    { 0x0000005e, 0x00000030 },
    { 0x08004564, 0x00000004 },
    { 0x0000e566, 0x00000004 },
    { 0x00000055, 0x00000008 },
    { 0x00802061, 0x00000010 },
    { 0x00202000, 0x00000004 },
    { 0x001b00ff, 0x00000004 },
    { 0x01000064, 0x00000010 },
    { 0x001f2000, 0x00000004 },
    { 0x001c00ff, 0x00000004 },
    { 0000000000, 0x0000000c },
    { 0x00000072, 0x00000030 },
    { 0x00000055, 0x00000008 },
    { 0x0000e576, 0x00000004 },
    { 0x0000e577, 0x00000004 },
    { 0x0000e50e, 0x00000004 },
    { 0x0000e50f, 0x00000004 },
    { 0x0140a000, 0x00000004 },
    { 0x00000069, 0x00000018 },
    { 0x00c0e5f9, 0x000000c2 },
    { 0x00000069, 0x00000008 },
    { 0x0014e50e, 0x00000004 },
    { 0x0040e50f, 0x00000004 },
    { 0x00c0006c, 0x00000008 },
    { 0x0000e570, 0x00000004 },
    { 0x0000e571, 0x00000004 },
    { 0x0000e572, 0x0000000c },
    { 0x0000a000, 0x00000004 },
    { 0x0140a000, 0x00000004 },
    { 0x0000e568, 0x00000004 },
    { 0x000c2000, 0x00000004 },
    { 0x00000076, 0x00000018 },
    { 0x000b0000, 0x00000004 },
    { 0x18c0e562, 0x00000004 },
    { 0x00000078, 0x00000008 },
    { 0x00c00077, 0x00000008 },
    { 0x000700c7, 0x00000004 },
    { 0x00000080, 0x00000038 },
    { 0x0000e5bb, 0x00000004 },
    { 0x0000e5bc, 0000000000 },
    { 0x0000a000, 0x00000004 },
    { 0x0000e821, 0x00000004 },
    { 0x0000e800, 0000000000 },
    { 0x0000e821, 0x00000004 },
    { 0x0000e82e, 0000000000 },
    { 0x02cca000, 0x00000004 },
    { 0x00140000, 0x00000004 },
    { 0x000ce1cc, 0x00000004 },
    { 0x050de1cd, 0x00000004 },
    { 0x00400000, 0x00000004 },
    { 0x0000008f, 0x00000018 },
    { 0x00c0a000, 0x00000004 },
    { 0x0000008c, 0x00000008 },
    { 0x00000091, 0x00000020 },
    { 0x4200e000, 0000000000 },
    { 0x00000098, 0x00000038 },
    { 0x000ca000, 0x00000004 },
    { 0x00140000, 0x00000004 },
    { 0x000c2000, 0x00000004 },
    { 0x00160000, 0x00000004 },
    { 0x700ce000, 0x00000004 },
    { 0x00140094, 0x00000008 },
    { 0x4000e000, 0000000000 },
    { 0x02400000, 0x00000004 },
    { 0x400ee000, 0x00000004 },
    { 0x02400000, 0x00000004 },
    { 0x4000e000, 0000000000 },
    { 0x000c2000, 0x00000004 },
    { 0x0240e51b, 0x00000004 },
    { 0x0080e50a, 0x00000005 },
    { 0x0080e50b, 0x00000005 },
    { 0x00220000, 0x00000004 },
    { 0x000700c7, 0x00000004 },
    { 0x000000a4, 0x00000038 },
    { 0x0080e5bd, 0x00000005 },
    { 0x0000e5bb, 0x00000005 },
    { 0x0080e5bc, 0x00000005 },
    { 0x00210000, 0x00000004 },
    { 0x02800000, 0x00000004 },
    { 0x00c000ab, 0x00000018 },
    { 0x4180e000, 0x00000040 },
    { 0x000000ad, 0x00000024 },
    { 0x01000000, 0x0000000c },
    { 0x0100e51d, 0x0000000c },
    { 0x000045bb, 0x00000004 },
    { 0x000080a7, 0x00000008 },
    { 0x0000f3ce, 0x00000004 },
    { 0x0140a000, 0x00000004 },
    { 0x00cc2000, 0x00000004 },
    { 0x08c053cf, 0x00000040 },
    { 0x00008000, 0000000000 },
    { 0x0000f3d2, 0x00000004 },
    { 0x0140a000, 0x00000004 },
    { 0x00cc2000, 0x00000004 },
    { 0x08c053d3, 0x00000040 },
    { 0x00008000, 0000000000 },
    { 0x0000f39d, 0x00000004 },
    { 0x0140a000, 0x00000004 },
    { 0x00cc2000, 0x00000004 },
    { 0x08c0539e, 0x00000040 },
    { 0x00008000, 0000000000 },
    { 0x03c00830, 0x00000004 },
    { 0x4200e000, 0000000000 },
    { 0x0000a000, 0x00000004 },
    { 0x200045e0, 0x00000004 },
    { 0x0000e5e1, 0000000000 },
    { 0x00000001, 0000000000 },
    { 0x000700c4, 0x00000004 },
    { 0x0800e394, 0000000000 },
    { 0000000000, 0000000000 },
    { 0x0000e8c4, 0x00000004 },
    { 0x0000e8c5, 0x00000004 },
    { 0x0000e8c6, 0x00000004 },
    { 0x0000e928, 0x00000004 },
    { 0x0000e929, 0x00000004 },
    { 0x0000e92a, 0x00000004 },
    { 0x000000c8, 0x00000008 },
    { 0x0000e928, 0x00000004 },
    { 0x0000e929, 0x00000004 },
    { 0x0000e92a, 0x00000004 },
    { 0x000000cf, 0x00000008 },
    { 0x02c02000, 0x00000004 },
    { 0x00060000, 0x00000004 },
    { 0x000000d7, 0x00000034 },
    { 0x000000d4, 0x00000008 },
    { 0x00008000, 0x00000004 },
    { 0xc000e000, 0000000000 },
    { 0x0000e1cc, 0x00000004 },
    { 0x0500e1cd, 0x00000004 },
    { 0x000ca000, 0x00000004 },
    { 0x000000de, 0x00000034 },
    { 0x000000da, 0x00000008 },
    { 0x0000a000, 0000000000 },
    { 0x0019e1cc, 0x00000004 },
    { 0x001b0001, 0x00000004 },
    { 0x0500a000, 0x00000004 },
    { 0x080041cd, 0x00000004 },
    { 0x000ca000, 0x00000004 },
    { 0x000000fb, 0x00000034 },
    { 0x0000004a, 0x00000008 },
    { 0000000000, 0000000000 },
    { 0000000000, 0000000000 },
    { 0000000000, 0000000000 },
    { 0000000000, 0000000000 },
    { 0000000000, 0000000000 },
    { 0000000000, 0000000000 },
    { 0000000000, 0000000000 },
    { 0000000000, 0000000000 },
    { 0000000000, 0000000000 },
    { 0000000000, 0000000000 },
    { 0000000000, 0000000000 },
    { 0000000000, 0000000000 },
    { 0000000000, 0000000000 },
    { 0000000000, 0000000000 },
    { 0000000000, 0000000000 },
    { 0000000000, 0000000000 },
    { 0x000c2000, 0x00000004 },
    { 0x001d0018, 0x00000004 },
    { 0x001a0001, 0x00000004 },
    { 0x000000fb, 0x00000034 },
    { 0x0000004a, 0x00000008 },
    { 0x0500a04a, 0x00000008 },
    { 0000000000, 0000000000 },
    { 0000000000, 0000000000 },
    { 0000000000, 0000000000 },
    { 0000000000, 0000000000 },
};

static const u32 RS600_cp_microcode[][2]={
    { 0x4200e000, 0000000000 },
    { 0x4000e000, 0000000000 },
    { 0x000000a0, 0x00000008 },
    { 0x000000a4, 0x00000008 },
    { 0x4a554b4a, 0000000000 },
    { 0x4a4a4467, 0000000000 },
    { 0x55526f75, 0000000000 },
    { 0x4a7e7d65, 0000000000 },
    { 0x4ae74af6, 0000000000 },
    { 0x4ad34a4a, 0000000000 },
    { 0xd6898989, 0000000000 },
    { 0xcd4addcf, 0000000000 },
    { 0x8ebe4ae2, 0000000000 },
    { 0xc38a8a8a, 0000000000 },
    { 0x4a0f8cc8, 0000000000 },
    { 0x000ca000, 0x00000004 },
    { 0x000d0012, 0x00000038 },
    { 0x0000e8b4, 0x00000004 },
    { 0x000d0014, 0x00000038 },
    { 0x0000e8b6, 0x00000004 },
    { 0x000d0016, 0x00000038 },
    { 0x0000e854, 0x00000004 },
    { 0x000d0018, 0x00000038 },
    { 0x0000e855, 0x00000004 },
    { 0x000d001a, 0x00000038 },
    { 0x0000e856, 0x00000004 },
    { 0x000d001c, 0x00000038 },
    { 0x0000e857, 0x00000004 },
    { 0x000d001e, 0x00000038 },
    { 0x0000e824, 0x00000004 },
    { 0x000d0020, 0x00000038 },
    { 0x0000e825, 0x00000004 },
    { 0x000d0022, 0x00000038 },
    { 0x0000e830, 0x00000004 },
    { 0x000d0024, 0x00000038 },
    { 0x0000f0c0, 0x00000004 },
    { 0x000d0026, 0x00000038 },
    { 0x0000f0c1, 0x00000004 },
    { 0x000d0028, 0x00000038 },
    { 0x0000f041, 0x00000004 },
    { 0x000d002a, 0x00000038 },
    { 0x0000f184, 0x00000004 },
    { 0x000d002c, 0x00000038 },
    { 0x0000f185, 0x00000004 },
    { 0x000d002e, 0x00000038 },
    { 0x0000f186, 0x00000004 },
    { 0x000d0030, 0x00000038 },
    { 0x0000f187, 0x00000004 },
    { 0x000d0032, 0x00000038 },
    { 0x0000f180, 0x00000004 },
    { 0x000d0034, 0x00000038 },
    { 0x0000f393, 0x00000004 },
    { 0x000d0036, 0x00000038 },
    { 0x0000f38a, 0x00000004 },
    { 0x000d0038, 0x00000038 },
    { 0x0000f38e, 0x00000004 },
    { 0x0000e821, 0x00000004 },
    { 0x0140a000, 0x00000004 },
    { 0x00000043, 0x00000018 },
    { 0x00cce800, 0x00000004 },
    { 0x001b0001, 0x00000004 },
    { 0x08004800, 0x00000004 },
    { 0x001b0001, 0x00000004 },
    { 0x08004800, 0x00000004 },
    { 0x001b0001, 0x00000004 },
    { 0x08004800, 0x00000004 },
    { 0x0000003a, 0x00000008 },
    { 0x0000a000, 0000000000 },
    { 0x2000451d, 0x00000004 },
    { 0x0000e580, 0x00000004 },
    { 0x000ce581, 0x00000004 },
    { 0x08004580, 0x00000004 },
    { 0x000ce581, 0x00000004 },
    { 0x00000047, 0x00000008 },
    { 0x0000a000, 0000000000 },
    { 0x000c2000, 0x00000004 },
    { 0x0000e50e, 0x00000004 },
    { 0x00032000, 0x00000004 },
    { 0x00022051, 0x00000028 },
    { 0x00000051, 0x00000024 },
    { 0x0800450f, 0x00000004 },
    { 0x0000a04b, 0x00000008 },
    { 0x0000e565, 0x00000004 },
    { 0x0000e566, 0x00000004 },
    { 0x00000052, 0x00000008 },
    { 0x03cca5b4, 0x00000004 },
    { 0x05432000, 0x00000004 },
    { 0x00022000, 0x00000004 },
    { 0x4ccce05e, 0x00000030 },
    { 0x08274565, 0x00000004 },
    { 0x0000005e, 0x00000030 },
    { 0x08004564, 0x00000004 },
    { 0x0000e566, 0x00000004 },
    { 0x00000055, 0x00000008 },
    { 0x00802061, 0x00000010 },
    { 0x00202000, 0x00000004 },
    { 0x001b00ff, 0x00000004 },
    { 0x01000064, 0x00000010 },
    { 0x001f2000, 0x00000004 },
    { 0x001c00ff, 0x00000004 },
    { 0000000000, 0x0000000c },
    { 0x00000072, 0x00000030 },
    { 0x00000055, 0x00000008 },
    { 0x0000e576, 0x00000004 },
    { 0x0000e577, 0x00000004 },
    { 0x0000e50e, 0x00000004 },
    { 0x0000e50f, 0x00000004 },
    { 0x0140a000, 0x00000004 },
    { 0x00000069, 0x00000018 },
    { 0x00c0e5f9, 0x000000c2 },
    { 0x00000069, 0x00000008 },
    { 0x0014e50e, 0x00000004 },
    { 0x0040e50f, 0x00000004 },
    { 0x00c0006c, 0x00000008 },
    { 0x0000e570, 0x00000004 },
    { 0x0000e571, 0x00000004 },
    { 0x0000e572, 0x0000000c },
    { 0x0000a000, 0x00000004 },
    { 0x0140a000, 0x00000004 },
    { 0x0000e568, 0x00000004 },
    { 0x000c2000, 0x00000004 },
    { 0x00000076, 0x00000018 },
    { 0x000b0000, 0x00000004 },
    { 0x18c0e562, 0x00000004 },
    { 0x00000078, 0x00000008 },
    { 0x00c00077, 0x00000008 },
    { 0x000700d5, 0x00000004 },
    { 0x00000084, 0x00000038 },
    { 0x000ca086, 0x00000030 },
    { 0x080045bb, 0x00000004 },
    { 0x000c2087, 0x00000030 },
    { 0x0800e5bc, 0000000000 },
    { 0x0000e5bb, 0x00000004 },
    { 0x0000e5bc, 0000000000 },
    { 0x00120000, 0x0000000c },
    { 0x00120000, 0x00000004 },
    { 0x001b0002, 0x0000000c },
    { 0x0000a000, 0x00000004 },
    { 0x0000e821, 0x00000004 },
    { 0x0000e800, 0000000000 },
    { 0x0000e821, 0x00000004 },
    { 0x0000e82e, 0000000000 },
    { 0x02cca000, 0x00000004 },
    { 0x00140000, 0x00000004 },
    { 0x000ce1cc, 0x00000004 },
    { 0x050de1cd, 0x00000004 },
    { 0x00400000, 0x00000004 },
    { 0x00000096, 0x00000018 },
    { 0x00c0a000, 0x00000004 },
    { 0x00000093, 0x00000008 },
    { 0x00000098, 0x00000020 },
    { 0x4200e000, 0000000000 },
    { 0x0000009f, 0x00000038 },
    { 0x000ca000, 0x00000004 },
    { 0x00140000, 0x00000004 },
    { 0x000c2000, 0x00000004 },
    { 0x00160000, 0x00000004 },
    { 0x700ce000, 0x00000004 },
    { 0x0014009b, 0x00000008 },
    { 0x4000e000, 0000000000 },
    { 0x02400000, 0x00000004 },
    { 0x400ee000, 0x00000004 },
    { 0x02400000, 0x00000004 },
    { 0x4000e000, 0000000000 },
    { 0x000c2000, 0x00000004 },
    { 0x0240e51b, 0x00000004 },
    { 0x0080e50a, 0x00000005 },
    { 0x0080e50b, 0x00000005 },
    { 0x00220000, 0x00000004 },
    { 0x000700d5, 0x00000004 },
    { 0x000000b2, 0x00000038 },
    { 0x000c2087, 0x00000030 },
    { 0x0880e5bd, 0x00000005 },
    { 0x000c2086, 0x00000030 },
    { 0x0800e5bb, 0x00000005 },
    { 0x000c2087, 0x00000030 },
    { 0x0880e5bc, 0x00000005 },
    { 0x000000b5, 0x00000008 },
    { 0x0080e5bd, 0x00000005 },
    { 0x0000e5bb, 0x00000005 },
    { 0x0080e5bc, 0x00000005 },
    { 0x00210000, 0x00000004 },
    { 0x02800000, 0x00000004 },
    { 0x00c000b9, 0x00000018 },
    { 0x4180e000, 0x00000040 },
    { 0x000000bb, 0x00000024 },
    { 0x01000000, 0x0000000c },
    { 0x0100e51d, 0x0000000c },
    { 0x000045bb, 0x00000004 },
    { 0x000080b5, 0x00000008 },
    { 0x0000f3ce, 0x00000004 },
    { 0x0140a000, 0x00000004 },
    { 0x00cc2000, 0x00000004 },
    { 0x08c053cf, 0x00000040 },
    { 0x00008000, 0000000000 },
    { 0x0000f3d2, 0x00000004 },
    { 0x0140a000, 0x00000004 },
    { 0x00cc2000, 0x00000004 },
    { 0x08c053d3, 0x00000040 },
    { 0x00008000, 0000000000 },
    { 0x0000f39d, 0x00000004 },
    { 0x0140a000, 0x00000004 },
    { 0x00cc2000, 0x00000004 },
    { 0x08c0539e, 0x00000040 },
    { 0x00008000, 0000000000 },
    { 0x03c00830, 0x00000004 },
    { 0x4200e000, 0000000000 },
    { 0x0000a000, 0x00000004 },
    { 0x200045e0, 0x00000004 },
    { 0x0000e5e1, 0000000000 },
    { 0x00000001, 0000000000 },
    { 0x000700d2, 0x00000004 },
    { 0x0800e394, 0000000000 },
    { 0000000000, 0000000000 },
    { 0x0000e8c4, 0x00000004 },
    { 0x0000e8c5, 0x00000004 },
    { 0x0000e8c6, 0x00000004 },
    { 0x0000e928, 0x00000004 },
    { 0x0000e929, 0x00000004 },
    { 0x0000e92a, 0x00000004 },
    { 0x000000d6, 0x00000008 },
    { 0x0000e928, 0x00000004 },
    { 0x0000e929, 0x00000004 },
    { 0x0000e92a, 0x00000004 },
    { 0x000000dd, 0x00000008 },
    { 0x00e00116, 0000000000 },
    { 0x000700e1, 0x00000004 },
    { 0x0800401c, 0x00000004 },
    { 0x200050e7, 0x00000004 },
    { 0x0000e01d, 0x00000004 },
    { 0x000000e4, 0x00000008 },
    { 0x02c02000, 0x00000004 },
    { 0x00060000, 0x00000004 },
    { 0x000000eb, 0x00000034 },
    { 0x000000e8, 0x00000008 },
    { 0x00008000, 0x00000004 },
    { 0xc000e000, 0000000000 },
    { 0000000000, 0000000000 },
    { 0000000000, 0000000000 },
    { 0000000000, 0000000000 },
    { 0000000000, 0000000000 },
    { 0000000000, 0000000000 },
    { 0000000000, 0000000000 },
    { 0000000000, 0000000000 },
    { 0000000000, 0000000000 },
    { 0000000000, 0000000000 },
    { 0x000c2000, 0x00000004 },
    { 0x001d0018, 0x00000004 },
    { 0x001a0001, 0x00000004 },
    { 0x000000fb, 0x00000034 },
    { 0x0000004a, 0x00000008 },
    { 0x0500a04a, 0x00000008 },
    { 0000000000, 0000000000 },
    { 0000000000, 0000000000 },
    { 0000000000, 0000000000 },
    { 0000000000, 0000000000 },
};

static const u32 RS690_cp_microcode[][2]={
    { 0x000000dd, 0x00000008 },
    { 0x000000df, 0x00000008 },
    { 0x000000a0, 0x00000008 },
    { 0x000000a4, 0x00000008 },
    { 0x4a554b4a, 0000000000 },
    { 0x4a4a4467, 0000000000 },
    { 0x55526f75, 0000000000 },
    { 0x4a7e7d65, 0000000000 },
    { 0x4ad74af6, 0000000000 },
    { 0x4ac94a4a, 0000000000 },
    { 0xcc898989, 0000000000 },
    { 0xc34ad3c5, 0000000000 },
    { 0x8e4a4a4a, 0000000000 },
    { 0x4a8a8a8a, 0000000000 },
    { 0x4a0f8c4a, 0000000000 },
    { 0x000ca000, 0x00000004 },
    { 0x000d0012, 0x00000038 },
    { 0x0000e8b4, 0x00000004 },
    { 0x000d0014, 0x00000038 },
    { 0x0000e8b6, 0x00000004 },
    { 0x000d0016, 0x00000038 },
    { 0x0000e854, 0x00000004 },
    { 0x000d0018, 0x00000038 },
    { 0x0000e855, 0x00000004 },
    { 0x000d001a, 0x00000038 },
    { 0x0000e856, 0x00000004 },
    { 0x000d001c, 0x00000038 },
    { 0x0000e857, 0x00000004 },
    { 0x000d001e, 0x00000038 },
    { 0x0000e824, 0x00000004 },
    { 0x000d0020, 0x00000038 },
    { 0x0000e825, 0x00000004 },
    { 0x000d0022, 0x00000038 },
    { 0x0000e830, 0x00000004 },
    { 0x000d0024, 0x00000038 },
    { 0x0000f0c0, 0x00000004 },
    { 0x000d0026, 0x00000038 },
    { 0x0000f0c1, 0x00000004 },
    { 0x000d0028, 0x00000038 },
    { 0x0000f041, 0x00000004 },
    { 0x000d002a, 0x00000038 },
    { 0x0000f184, 0x00000004 },
    { 0x000d002c, 0x00000038 },
    { 0x0000f185, 0x00000004 },
    { 0x000d002e, 0x00000038 },
    { 0x0000f186, 0x00000004 },
    { 0x000d0030, 0x00000038 },
    { 0x0000f187, 0x00000004 },
    { 0x000d0032, 0x00000038 },
    { 0x0000f180, 0x00000004 },
    { 0x000d0034, 0x00000038 },
    { 0x0000f393, 0x00000004 },
    { 0x000d0036, 0x00000038 },
    { 0x0000f38a, 0x00000004 },
    { 0x000d0038, 0x00000038 },
    { 0x0000f38e, 0x00000004 },
    { 0x0000e821, 0x00000004 },
    { 0x0140a000, 0x00000004 },
    { 0x00000043, 0x00000018 },
    { 0x00cce800, 0x00000004 },
    { 0x001b0001, 0x00000004 },
    { 0x08004800, 0x00000004 },
    { 0x001b0001, 0x00000004 },
    { 0x08004800, 0x00000004 },
    { 0x001b0001, 0x00000004 },
    { 0x08004800, 0x00000004 },
    { 0x0000003a, 0x00000008 },
    { 0x0000a000, 0000000000 },
    { 0x2000451d, 0x00000004 },
    { 0x0000e580, 0x00000004 },
    { 0x000ce581, 0x00000004 },
    { 0x08004580, 0x00000004 },
    { 0x000ce581, 0x00000004 },
    { 0x00000047, 0x00000008 },
    { 0x0000a000, 0000000000 },
    { 0x000c2000, 0x00000004 },
    { 0x0000e50e, 0x00000004 },
    { 0x00032000, 0x00000004 },
    { 0x00022051, 0x00000028 },
    { 0x00000051, 0x00000024 },
    { 0x0800450f, 0x00000004 },
    { 0x0000a04b, 0x00000008 },
    { 0x0000e565, 0x00000004 },
    { 0x0000e566, 0x00000004 },
    { 0x00000052, 0x00000008 },
    { 0x03cca5b4, 0x00000004 },
    { 0x05432000, 0x00000004 },
    { 0x00022000, 0x00000004 },
    { 0x4ccce05e, 0x00000030 },
    { 0x08274565, 0x00000004 },
    { 0x0000005e, 0x00000030 },
    { 0x08004564, 0x00000004 },
    { 0x0000e566, 0x00000004 },
    { 0x00000055, 0x00000008 },
    { 0x00802061, 0x00000010 },
    { 0x00202000, 0x00000004 },
    { 0x001b00ff, 0x00000004 },
    { 0x01000064, 0x00000010 },
    { 0x001f2000, 0x00000004 },
    { 0x001c00ff, 0x00000004 },
    { 0000000000, 0x0000000c },
    { 0x00000072, 0x00000030 },
    { 0x00000055, 0x00000008 },
    { 0x0000e576, 0x00000004 },
    { 0x0000e577, 0x00000004 },
    { 0x0000e50e, 0x00000004 },
    { 0x0000e50f, 0x00000004 },
    { 0x0140a000, 0x00000004 },
    { 0x00000069, 0x00000018 },
    { 0x00c0e5f9, 0x000000c2 },
    { 0x00000069, 0x00000008 },
    { 0x0014e50e, 0x00000004 },
    { 0x0040e50f, 0x00000004 },
    { 0x00c0006c, 0x00000008 },
    { 0x0000e570, 0x00000004 },
    { 0x0000e571, 0x00000004 },
    { 0x0000e572, 0x0000000c },
    { 0x0000a000, 0x00000004 },
    { 0x0140a000, 0x00000004 },
    { 0x0000e568, 0x00000004 },
    { 0x000c2000, 0x00000004 },
    { 0x00000076, 0x00000018 },
    { 0x000b0000, 0x00000004 },
    { 0x18c0e562, 0x00000004 },
    { 0x00000078, 0x00000008 },
    { 0x00c00077, 0x00000008 },
    { 0x000700cb, 0x00000004 },
    { 0x00000084, 0x00000038 },
    { 0x000ca086, 0x00000030 },
    { 0x080045bb, 0x00000004 },
    { 0x000c2087, 0x00000030 },
    { 0x0800e5bc, 0000000000 },
    { 0x0000e5bb, 0x00000004 },
    { 0x0000e5bc, 0000000000 },
    { 0x00120000, 0x0000000c },
    { 0x00120000, 0x00000004 },
    { 0x001b0002, 0x0000000c },
    { 0x0000a000, 0x00000004 },
    { 0x0000e821, 0x00000004 },
    { 0x0000e800, 0000000000 },
    { 0x0000e821, 0x00000004 },
    { 0x0000e82e, 0000000000 },
    { 0x02cca000, 0x00000004 },
    { 0x00140000, 0x00000004 },
    { 0x000ce1cc, 0x00000004 },
    { 0x050de1cd, 0x00000004 },
    { 0x00400000, 0x00000004 },
    { 0x00000096, 0x00000018 },
    { 0x00c0a000, 0x00000004 },
    { 0x00000093, 0x00000008 },
    { 0x00000098, 0x00000020 },
    { 0x4200e000, 0000000000 },
    { 0x0000009f, 0x00000038 },
    { 0x000ca000, 0x00000004 },
    { 0x00140000, 0x00000004 },
    { 0x000c2000, 0x00000004 },
    { 0x00160000, 0x00000004 },
    { 0x700ce000, 0x00000004 },
    { 0x0014009b, 0x00000008 },
    { 0x4000e000, 0000000000 },
    { 0x02400000, 0x00000004 },
    { 0x400ee000, 0x00000004 },
    { 0x02400000, 0x00000004 },
    { 0x4000e000, 0000000000 },
    { 0x00100000, 0x0000002c },
    { 0x00004000, 0000000000 },
    { 0x080045c8, 0x00000004 },
    { 0x00240005, 0x00000004 },
    { 0x08004d0b, 0x00000004 },
    { 0x000c2000, 0x00000004 },
    { 0x0240e51b, 0x00000004 },
    { 0x0080e50a, 0x00000005 },
    { 0x0080e50b, 0x00000005 },
    { 0x00220000, 0x00000004 },
    { 0x000700cb, 0x00000004 },
    { 0x000000b7, 0x00000038 },
    { 0x000c2087, 0x00000030 },
    { 0x0880e5bd, 0x00000005 },
    { 0x000c2086, 0x00000030 },
    { 0x0800e5bb, 0x00000005 },
    { 0x000c2087, 0x00000030 },
    { 0x0880e5bc, 0x00000005 },
    { 0x000000ba, 0x00000008 },
    { 0x0080e5bd, 0x00000005 },
    { 0x0000e5bb, 0x00000005 },
    { 0x0080e5bc, 0x00000005 },
    { 0x00210000, 0x00000004 },
    { 0x02800000, 0x00000004 },
    { 0x00c000be, 0x00000018 },
    { 0x4180e000, 0x00000040 },
    { 0x000000c0, 0x00000024 },
    { 0x01000000, 0x0000000c },
    { 0x0100e51d, 0x0000000c },
    { 0x000045bb, 0x00000004 },
    { 0x000080ba, 0x00000008 },
    { 0x03c00830, 0x00000004 },
    { 0x4200e000, 0000000000 },
    { 0x0000a000, 0x00000004 },
    { 0x200045e0, 0x00000004 },
    { 0x0000e5e1, 0000000000 },
    { 0x00000001, 0000000000 },
    { 0x000700c8, 0x00000004 },
    { 0x0800e394, 0000000000 },
    { 0000000000, 0000000000 },
    { 0x0000e8c4, 0x00000004 },
    { 0x0000e8c5, 0x00000004 },
    { 0x0000e8c6, 0x00000004 },
    { 0x0000e928, 0x00000004 },
    { 0x0000e929, 0x00000004 },
    { 0x0000e92a, 0x00000004 },
    { 0x000000cc, 0x00000008 },
    { 0x0000e928, 0x00000004 },
    { 0x0000e929, 0x00000004 },
    { 0x0000e92a, 0x00000004 },
    { 0x000000d3, 0x00000008 },
    { 0x02c02000, 0x00000004 },
    { 0x00060000, 0x00000004 },
    { 0x000000db, 0x00000034 },
    { 0x000000d8, 0x00000008 },
    { 0x00008000, 0x00000004 },
    { 0xc000e000, 0000000000 },
    { 0x000000e1, 0x00000030 },
    { 0x4200e000, 0000000000 },
    { 0x000000e1, 0x00000030 },
    { 0x4000e000, 0000000000 },
    { 0x0025001b, 0x00000004 },
    { 0x00230000, 0x00000004 },
    { 0x00250005, 0x00000004 },
    { 0x000000e6, 0x00000034 },
    { 0000000000, 0x0000000c },
    { 0x00244000, 0x00000004 },
    { 0x080045c8, 0x00000004 },
    { 0x00240005, 0x00000004 },
    { 0x08004d0b, 0x0000000c },
    { 0000000000, 0000000000 },
    { 0000000000, 0000000000 },
    { 0000000000, 0000000000 },
    { 0000000000, 0000000000 },
    { 0000000000, 0000000000 },
    { 0000000000, 0000000000 },
    { 0000000000, 0000000000 },
    { 0000000000, 0000000000 },
    { 0000000000, 0000000000 },
    { 0000000000, 0000000000 },
    { 0000000000, 0000000000 },
    { 0000000000, 0000000000 },
    { 0x000c2000, 0x00000004 },
    { 0x001d0018, 0x00000004 },
    { 0x001a0001, 0x00000004 },
    { 0x000000fb, 0x00000034 },
    { 0x0000004a, 0x00000008 },
    { 0x0500a04a, 0x00000008 },
    { 0000000000, 0000000000 },
    { 0000000000, 0000000000 },
    { 0000000000, 0000000000 },
    { 0000000000, 0000000000 },
};

static const u32 R520_cp_microcode[][2]={
    { 0x4200e000, 0000000000 },
    { 0x4000e000, 0000000000 },
    { 0x00000099, 0x00000008 },
    { 0x0000009d, 0x00000008 },
    { 0x4a554b4a, 0000000000 },
    { 0x4a4a4467, 0000000000 },
    { 0x55526f75, 0000000000 },
    { 0x4a7e7d65, 0000000000 },
    { 0xe0dae6f6, 0000000000 },
    { 0x4ac54a4a, 0000000000 },
    { 0xc8828282, 0000000000 },
    { 0xbf4acfc1, 0000000000 },
    { 0x87b04ad5, 0000000000 },
    { 0xb5838383, 0000000000 },
    { 0x4a0f85ba, 0000000000 },
    { 0x000ca000, 0x00000004 },
    { 0x000d0012, 0x00000038 },
    { 0x0000e8b4, 0x00000004 },
    { 0x000d0014, 0x00000038 },
    { 0x0000e8b6, 0x00000004 },
    { 0x000d0016, 0x00000038 },
    { 0x0000e854, 0x00000004 },
    { 0x000d0018, 0x00000038 },
    { 0x0000e855, 0x00000004 },
    { 0x000d001a, 0x00000038 },
    { 0x0000e856, 0x00000004 },
    { 0x000d001c, 0x00000038 },
    { 0x0000e857, 0x00000004 },
    { 0x000d001e, 0x00000038 },
    { 0x0000e824, 0x00000004 },
    { 0x000d0020, 0x00000038 },
    { 0x0000e825, 0x00000004 },
    { 0x000d0022, 0x00000038 },
    { 0x0000e830, 0x00000004 },
    { 0x000d0024, 0x00000038 },
    { 0x0000f0c0, 0x00000004 },
    { 0x000d0026, 0x00000038 },
    { 0x0000f0c1, 0x00000004 },
    { 0x000d0028, 0x00000038 },
    { 0x0000e000, 0x00000004 },
    { 0x000d002a, 0x00000038 },
    { 0x0000e000, 0x00000004 },
    { 0x000d002c, 0x00000038 },
    { 0x0000e000, 0x00000004 },
    { 0x000d002e, 0x00000038 },
    { 0x0000e000, 0x00000004 },
    { 0x000d0030, 0x00000038 },
    { 0x0000e000, 0x00000004 },
    { 0x000d0032, 0x00000038 },
    { 0x0000f180, 0x00000004 },
    { 0x000d0034, 0x00000038 },
    { 0x0000f393, 0x00000004 },
    { 0x000d0036, 0x00000038 },
    { 0x0000f38a, 0x00000004 },
    { 0x000d0038, 0x00000038 },
    { 0x0000f38e, 0x00000004 },
    { 0x0000e821, 0x00000004 },
    { 0x0140a000, 0x00000004 },
    { 0x00000043, 0x00000018 },
    { 0x00cce800, 0x00000004 },
    { 0x001b0001, 0x00000004 },
    { 0x08004800, 0x00000004 },
    { 0x001b0001, 0x00000004 },
    { 0x08004800, 0x00000004 },
    { 0x001b0001, 0x00000004 },
    { 0x08004800, 0x00000004 },
    { 0x0000003a, 0x00000008 },
    { 0x0000a000, 0000000000 },
    { 0x2000451d, 0x00000004 },
    { 0x0000e580, 0x00000004 },
    { 0x000ce581, 0x00000004 },
    { 0x08004580, 0x00000004 },
    { 0x000ce581, 0x00000004 },
    { 0x00000047, 0x00000008 },
    { 0x0000a000, 0000000000 },
    { 0x000c2000, 0x00000004 },
    { 0x0000e50e, 0x00000004 },
    { 0x00032000, 0x00000004 },
    { 0x00022051, 0x00000028 },
    { 0x00000051, 0x00000024 },
    { 0x0800450f, 0x00000004 },
    { 0x0000a04b, 0x00000008 },
    { 0x0000e565, 0x00000004 },
    { 0x0000e566, 0x00000004 },
    { 0x00000052, 0x00000008 },
    { 0x03cca5b4, 0x00000004 },
    { 0x05432000, 0x00000004 },
    { 0x00022000, 0x00000004 },
    { 0x4ccce05e, 0x00000030 },
    { 0x08274565, 0x00000004 },
    { 0x0000005e, 0x00000030 },
    { 0x08004564, 0x00000004 },
    { 0x0000e566, 0x00000004 },
    { 0x00000055, 0x00000008 },
    { 0x00802061, 0x00000010 },
    { 0x00202000, 0x00000004 },
    { 0x001b00ff, 0x00000004 },
    { 0x01000064, 0x00000010 },
    { 0x001f2000, 0x00000004 },
    { 0x001c00ff, 0x00000004 },
    { 0000000000, 0x0000000c },
    { 0x00000072, 0x00000030 },
    { 0x00000055, 0x00000008 },
    { 0x0000e576, 0x00000004 },
    { 0x0000e577, 0x00000004 },
    { 0x0000e50e, 0x00000004 },
    { 0x0000e50f, 0x00000004 },
    { 0x0140a000, 0x00000004 },
    { 0x00000069, 0x00000018 },
    { 0x00c0e5f9, 0x000000c2 },
    { 0x00000069, 0x00000008 },
    { 0x0014e50e, 0x00000004 },
    { 0x0040e50f, 0x00000004 },
    { 0x00c0006c, 0x00000008 },
    { 0x0000e570, 0x00000004 },
    { 0x0000e571, 0x00000004 },
    { 0x0000e572, 0x0000000c },
    { 0x0000a000, 0x00000004 },
    { 0x0140a000, 0x00000004 },
    { 0x0000e568, 0x00000004 },
    { 0x000c2000, 0x00000004 },
    { 0x00000076, 0x00000018 },
    { 0x000b0000, 0x00000004 },
    { 0x18c0e562, 0x00000004 },
    { 0x00000078, 0x00000008 },
    { 0x00c00077, 0x00000008 },
    { 0x000700c7, 0x00000004 },
    { 0x00000080, 0x00000038 },
    { 0x0000e5bb, 0x00000004 },
    { 0x0000e5bc, 0000000000 },
    { 0x0000a000, 0x00000004 },
    { 0x0000e821, 0x00000004 },
    { 0x0000e800, 0000000000 },
    { 0x0000e821, 0x00000004 },
    { 0x0000e82e, 0000000000 },
    { 0x02cca000, 0x00000004 },
    { 0x00140000, 0x00000004 },
    { 0x000ce1cc, 0x00000004 },
    { 0x050de1cd, 0x00000004 },
    { 0x00400000, 0x00000004 },
    { 0x0000008f, 0x00000018 },
    { 0x00c0a000, 0x00000004 },
    { 0x0000008c, 0x00000008 },
    { 0x00000091, 0x00000020 },
    { 0x4200e000, 0000000000 },
    { 0x00000098, 0x00000038 },
    { 0x000ca000, 0x00000004 },
    { 0x00140000, 0x00000004 },
    { 0x000c2000, 0x00000004 },
    { 0x00160000, 0x00000004 },
    { 0x700ce000, 0x00000004 },
    { 0x00140094, 0x00000008 },
    { 0x4000e000, 0000000000 },
    { 0x02400000, 0x00000004 },
    { 0x400ee000, 0x00000004 },
    { 0x02400000, 0x00000004 },
    { 0x4000e000, 0000000000 },
    { 0x000c2000, 0x00000004 },
    { 0x0240e51b, 0x00000004 },
    { 0x0080e50a, 0x00000005 },
    { 0x0080e50b, 0x00000005 },
    { 0x00220000, 0x00000004 },
    { 0x000700c7, 0x00000004 },
    { 0x000000a4, 0x00000038 },
    { 0x0080e5bd, 0x00000005 },
    { 0x0000e5bb, 0x00000005 },
    { 0x0080e5bc, 0x00000005 },
    { 0x00210000, 0x00000004 },
    { 0x02800000, 0x00000004 },
    { 0x00c000ab, 0x00000018 },
    { 0x4180e000, 0x00000040 },
    { 0x000000ad, 0x00000024 },
    { 0x01000000, 0x0000000c },
    { 0x0100e51d, 0x0000000c },
    { 0x000045bb, 0x00000004 },
    { 0x000080a7, 0x00000008 },
    { 0x0000f3ce, 0x00000004 },
    { 0x0140a000, 0x00000004 },
    { 0x00cc2000, 0x00000004 },
    { 0x08c053cf, 0x00000040 },
    { 0x00008000, 0000000000 },
    { 0x0000f3d2, 0x00000004 },
    { 0x0140a000, 0x00000004 },
    { 0x00cc2000, 0x00000004 },
    { 0x08c053d3, 0x00000040 },
    { 0x00008000, 0000000000 },
    { 0x0000f39d, 0x00000004 },
    { 0x0140a000, 0x00000004 },
    { 0x00cc2000, 0x00000004 },
    { 0x08c0539e, 0x00000040 },
    { 0x00008000, 0000000000 },
    { 0x03c00830, 0x00000004 },
    { 0x4200e000, 0000000000 },
    { 0x0000a000, 0x00000004 },
    { 0x200045e0, 0x00000004 },
    { 0x0000e5e1, 0000000000 },
    { 0x00000001, 0000000000 },
    { 0x000700c4, 0x00000004 },
    { 0x0800e394, 0000000000 },
    { 0000000000, 0000000000 },
    { 0x0000e8c4, 0x00000004 },
    { 0x0000e8c5, 0x00000004 },
    { 0x0000e8c6, 0x00000004 },
    { 0x0000e928, 0x00000004 },
    { 0x0000e929, 0x00000004 },
    { 0x0000e92a, 0x00000004 },
    { 0x000000c8, 0x00000008 },
    { 0x0000e928, 0x00000004 },
    { 0x0000e929, 0x00000004 },
    { 0x0000e92a, 0x00000004 },
    { 0x000000cf, 0x00000008 },
    { 0xdeadbeef, 0000000000 },
    { 0x00000116, 0000000000 },
    { 0x000700d3, 0x00000004 },
    { 0x080050e7, 0x00000004 },
    { 0x000700d4, 0x00000004 },
    { 0x0800401c, 0x00000004 },
    { 0x0000e01d, 0000000000 },
    { 0x02c02000, 0x00000004 },
    { 0x00060000, 0x00000004 },
    { 0x000000de, 0x00000034 },
    { 0x000000db, 0x00000008 },
    { 0x00008000, 0x00000004 },
    { 0xc000e000, 0000000000 },
    { 0x0000e1cc, 0x00000004 },
    { 0x0500e1cd, 0x00000004 },
    { 0x000ca000, 0x00000004 },
    { 0x000000e5, 0x00000034 },
    { 0x000000e1, 0x00000008 },
    { 0x0000a000, 0000000000 },
    { 0x0019e1cc, 0x00000004 },
    { 0x001b0001, 0x00000004 },
    { 0x0500a000, 0x00000004 },
    { 0x080041cd, 0x00000004 },
    { 0x000ca000, 0x00000004 },
    { 0x000000fb, 0x00000034 },
    { 0x0000004a, 0x00000008 },
    { 0000000000, 0000000000 },
    { 0000000000, 0000000000 },
    { 0000000000, 0000000000 },
    { 0000000000, 0000000000 },
    { 0000000000, 0000000000 },
    { 0000000000, 0000000000 },
    { 0000000000, 0000000000 },
    { 0000000000, 0000000000 },
    { 0000000000, 0000000000 },
    { 0x000c2000, 0x00000004 },
    { 0x001d0018, 0x00000004 },
    { 0x001a0001, 0x00000004 },
    { 0x000000fb, 0x00000034 },
    { 0x0000004a, 0x00000008 },
    { 0x0500a04a, 0x00000008 },
    { 0000000000, 0000000000 },
    { 0000000000, 0000000000 },
    { 0000000000, 0000000000 },
    { 0000000000, 0000000000 },
};


#endif
