#!/bin/sh

# Fatal trap 12: page fault while in kernel mode
# cpuid = 1; apic id = 01
# fault virtual address   = 0x20
# fault code              = supervisor read data, page not present
# instruction pointer     = 0x20:0xfa1a2c
# stack pointer           = 0x28:0x27a41a80
# frame pointer           = 0x28:0x27a41a98
# code segment            = base 0x0, limit 0xfffff, type 0x1b
#                         = DPL 0, pres 1, def32 1, gran 1
# processor eflags        = interrupt enabled, resume, IOPL = 0
# current process         = 804 (syzkaller63)
# trap number             = 12
# panic: page fault
# cpuid = 1
# time = 1675071979
# KDB: stack backtrace:
# db_trace_self_wrapper(d,2048e3a0,27a41a40,20,c,...) at db_trace_self_wrapper+0x28/frame 0x27a418d0
# vpanic(146c355,27a4190c,27a4190c,27a41938,141f1d6,...) at vpanic+0xf4/frame 0x27a418ec
# panic(146c355,15010e8,0,fffff,1dfc39b,...) at panic+0x14/frame 0x27a41900
# trap_fatal(2048e3a0,2048e3a0,27a4196c,1008e0a,18cd6638,...) at trap_fatal+0x346/frame 0x27a41938
# trap_pfault(20,0,0) at trap_pfault+0x6f/frame 0x27a4196c
# trap(27a41a40,8,28,28,0,...) at trap+0x31b/frame 0x27a41a34
# calltrap() at 0xffc0321f/frame 0x27a41a34
# --- trap 0xc, eip = 0xfa1a2c, esp = 0x27a41a80, ebp = 0x27a41a98 ---
# kern_cpuset_getid(141f60e,0,9,0,0,0) at kern_cpuset_getid+0x10c/frame 0x27a41a98
# sys_cpuset_getid(2048e3a0,2048e644,2048e3a0,2048e3a0,27a41b9c,...) at sys_cpuset_getid+0x32/frame 0x27a41ac0
# syscall(27a41ba8,3b,3b,3b,ffbfe9fc,...) at syscall+0x1ef/frame 0x27a41b9c
# Xint0x80_syscall() at 0xffc03479/frame 0x27a41b9c
# --- syscall (486, FreeBSD ELF32, cpuset_getid), eip = 0x2056317d, esp = 0xffbfe990, ebp = 0xffbfe9b0 ---
# KDB: enter: panic
# [ thread pid 804 tid 100092 ]
# Stopped at      kdb_enter+0x34: movl    $0,kdb_why
# db> x/s version
# version: FreeBSD 14.0-CURRENT #0 main-n260354-34b867ca30479: Mon Jan 30 07:26:30 CET 2023
# pho@mercat1.netperf.freebsd.org:/mnt25/obj/usr/src/i386.i386/sys/PHO
# db>

. ../default.cfg
prog=$(basename "$0" .sh)
[ `uname -p` = "i386" ] || exit 0

cat > /tmp/$prog.c <<EOF
// https://syzkaller.appspot.com/bug?id=69dd3c8d867306dd9f97e2dae6ab1557fd8d2679
// autogenerated by syzkaller (https://github.com/google/syzkaller)
// Reported-by: syzbot+331e8402e0f7347f0f2a@syzkaller.appspotmail.com

#define _GNU_SOURCE

#include <pwd.h>
#include <stdarg.h>
#include <stdbool.h>
#include <stdint.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/endian.h>
#include <sys/syscall.h>
#include <unistd.h>

int main(void)
{
  syscall(SYS_mmap, 0x10000000, 0x1000000, 7, 0x1012, -1, 0);
  syscall(SYS_cpuset_getid, 0, 9, 0ull, 0);
  return 0;
}
EOF
mycc -o /tmp/$prog -Wall -Wextra -O0 /tmp/$prog.c || exit 1

(cd /tmp; timeout -k 3s 2s ./$prog)

rm -rf /tmp/$prog /tmp/$prog.c /tmp/$prog.core \
    /tmp/syzkaller.??????
exit 0 
